/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.movement;

import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.animation.transformation.Translation;
import net.malisis.doors.door.DoorState;
import net.malisis.doors.door.movement.IDoorMovement;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.minecraft.util.AxisAlignedBB;

public class SlidingSplitDoorMovement
implements IDoorMovement {
    @Override
    public AxisAlignedBB getBoundingBox(DoorTileEntity tileEntity, boolean topBlock, boolean selBox) {
        if (tileEntity.isOpened() && !topBlock) {
            return null;
        }
        int dir = tileEntity.getDirection();
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        float X = 1.0f;
        float Y = 1.0f;
        float Z = 1.0f;
        if (dir == 1) {
            Z = 0.1875f;
        }
        if (dir == 3) {
            z = 0.8125f;
        }
        if (dir == 0) {
            X = 0.1875f;
        }
        if (dir == 2) {
            x = 0.8125f;
        }
        if (tileEntity.isOpened()) {
            y += 1.0f - 0.1875f * (float)(topBlock ? 1 : -1);
            Y += 1.0f - 0.1875f * (float)(topBlock ? 1 : -1);
        }
        if (selBox && !tileEntity.isOpened()) {
            if (topBlock) {
                y -= 1.0f;
            } else {
                Y += 1.0f;
            }
        }
        return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)X, (double)Y, (double)Z);
    }

    @Override
    public Transformation getTopTransformation(DoorTileEntity tileEntity) {
        return this.getTransformation(tileEntity, true);
    }

    @Override
    public Transformation getBottomTransformation(DoorTileEntity tileEntity) {
        return this.getTransformation(tileEntity, false);
    }

    private Transformation getTransformation(DoorTileEntity tileEntity, boolean top) {
        float fromY = 0.0f;
        float toY = 0.8125f;
        if (!top) {
            toY = -1.1f;
        }
        if (tileEntity.getState() == DoorState.CLOSING || tileEntity.getState() == DoorState.CLOSED) {
            float tmp = fromY;
            fromY = toY;
            toY = tmp;
        }
        return new Translation(0.0f, fromY, 0.0f, 0.0f, toY, 0.0f).forTicks(tileEntity.getDescriptor().getOpeningTime());
    }
}

