/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.movement;

import net.malisis.core.renderer.animation.transformation.Rotation;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.doors.door.DoorState;
import net.malisis.doors.door.movement.IDoorMovement;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.minecraft.util.AxisAlignedBB;

public class VaultDoorMovement
implements IDoorMovement {
    @Override
    public AxisAlignedBB getBoundingBox(DoorTileEntity tileEntity, boolean topBlock, boolean selBox) {
        int dir = tileEntity.getDirection();
        boolean opened = tileEntity.isOpened();
        boolean reversed = tileEntity.isReversed();
        float left = -0.8125f;
        float right = 0.8125f;
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        float X = 1.0f;
        float Y = 1.0f;
        float Z = 1.0f;
        if (dir == 1) {
            Z = 0.1875f;
            if (opened && topBlock == reversed) {
                x += reversed ? left : right;
                X += reversed ? left : right;
            }
        }
        if (dir == 3) {
            z = 0.8125f;
            if (opened && topBlock == reversed) {
                x += reversed ? right : left;
                X += reversed ? right : left;
            }
        }
        if (dir == 0) {
            X = 0.1875f;
            if (opened && topBlock == reversed) {
                z += reversed ? right : left;
                Z += reversed ? right : left;
            }
        }
        if (dir == 2) {
            x = 0.8125f;
            if (opened && topBlock == reversed) {
                z += reversed ? left : right;
                Z += reversed ? left : right;
            }
        }
        if (opened && topBlock == !reversed) {
            y += reversed ? left : right;
            Y = topBlock || selBox ? (Y += reversed ? left : right) : 0.0f;
        }
        if (selBox && !opened) {
            if (!topBlock) {
                Y += 1.0f;
            } else {
                y -= 1.0f;
            }
        }
        return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)X, (double)Y, (double)Z);
    }

    @Override
    public Transformation getTopTransformation(DoorTileEntity tileEntity) {
        return this.getTransformation(tileEntity, true);
    }

    @Override
    public Transformation getBottomTransformation(DoorTileEntity tileEntity) {
        return this.getTransformation(tileEntity, false);
    }

    private Transformation getTransformation(DoorTileEntity tileEntity, boolean topBlock) {
        float hinge;
        float angle = -90.0f;
        float offsetX = hinge = -0.40625f;
        float offsetY = hinge;
        if (topBlock) {
            offsetY = -offsetY;
        }
        if (!tileEntity.isReversed()) {
            offsetX = -offsetX;
        }
        Rotation transformation = new Rotation(angle).aroundAxis(0.0f, 0.0f, 1.0f).offset(offsetX, offsetY, 0.0f);
        if (tileEntity.getState() == DoorState.CLOSING || tileEntity.getState() == DoorState.CLOSED) {
            transformation.reversed(true);
        }
        return transformation.forTicks(tileEntity.getDescriptor().getOpeningTime());
    }
}

