/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.renderer;

import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.preset.ShapePreset;
import net.malisis.doors.door.renderer.DoorRenderer;
import net.malisis.doors.door.tileentity.CustomDoorTileEntity;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.client.IItemRenderer;

public class CustomDoorRenderer
extends DoorRenderer {
    private Shape baseFrameBottom;
    private Shape baseFrameTop;
    private Shape baseTopMaterial;
    private Shape baseBottomMaterial;
    private Shape frameBottom;
    private Shape frameTop;
    private Shape topMaterial;
    private Shape bottomMaterial;
    private Shape bottom;
    private Shape top;
    private Block frameBlock;
    private Block topMaterialBlock;
    private Block bottomMaterialBlock;
    private int frameMetadata;
    private int topMaterialMetadata;
    private int bottomMaterialMetadata;
    protected CustomDoorTileEntity tileEntity;
    private float width;

    @Override
    protected void initShape() {
        super.initShape();
        this.width = 0.125f;
        Shape frameBR = ShapePreset.Cube().setSize(this.width, 1.0f, 0.1875f);
        Shape frameBL = new Shape(frameBR).translate(1.0f - this.width, 0.0f, 0.0f);
        Shape frameB = ShapePreset.Cube().setSize(1.0f - 2.0f * this.width, this.width, 0.1875f).translate(this.width, 0.0f, 0.0f);
        this.baseFrameBottom = Shape.fromShapes((Shape[])new Shape[]{frameBR, frameBL, frameB}).scale(1.0f, 1.0f, 0.995f);
        Shape frameTR = new Shape(frameBR);
        Shape frameTL = new Shape(frameBL);
        Shape frameT = new Shape(frameB).translate(0.0f, 1.0f - this.width, 0.0f);
        this.baseFrameTop = Shape.fromShapes((Shape[])new Shape[]{frameTR, frameTL, frameT}).scale(1.0f, 1.0f, 0.995f);
        this.baseBottomMaterial = ShapePreset.Cube().setSize(1.0f - 2.0f * this.width, 1.0f - this.width, 0.112500004f).translate(this.width, this.width, 0.0375f);
        this.baseTopMaterial = new Shape(this.baseBottomMaterial).translate(0.0f, -this.width, 0.0f);
    }

    @Override
    protected void initRenderParameters() {
        this.rp = new RenderParameters();
        this.rp.renderAllFaces.set((Object)true);
        this.rp.calculateAOColor.set((Object)false);
        this.rp.useBlockBounds.set((Object)false);
        this.rp.useBlockBrightness.set((Object)false);
        this.rp.usePerVertexColor.set((Object)true);
        this.rp.interpolateUV.set((Object)true);
    }

    @Override
    public void render() {
        this.rp.applyTexture.set((Object)false);
        if (this.renderType == 3) {
            if (this.itemStack.field_77990_d == null) {
                return;
            }
            this.setup();
            this.renderInventory();
            return;
        }
        super.render();
        this.rp.applyTexture.set((Object)true);
    }

    @Override
    protected void setTileEntity() {
        super.setTileEntity();
        this.tileEntity = (CustomDoorTileEntity)((DoorRenderer)this).tileEntity;
    }

    private void setInfos(CustomDoorTileEntity te) {
        this.frameBlock = te.getFrame();
        this.topMaterialBlock = te.getTopMaterial();
        this.bottomMaterialBlock = te.getBottomMaterial();
        this.frameMetadata = te.getFrameMetadata();
        this.topMaterialMetadata = te.getTopMaterialMetadata();
        this.bottomMaterialMetadata = te.getBottomMaterialMetadata();
    }

    private void setInfos(NBTTagCompound nbt) {
        this.frameBlock = Block.func_149729_e((int)nbt.func_74762_e("frame"));
        this.topMaterialBlock = Block.func_149729_e((int)nbt.func_74762_e("topMaterial"));
        this.bottomMaterialBlock = Block.func_149729_e((int)nbt.func_74762_e("bottomMaterial"));
        this.frameMetadata = nbt.func_74762_e("frameMetadata");
        this.topMaterialMetadata = nbt.func_74762_e("topMaterialMetadata");
        this.bottomMaterialMetadata = nbt.func_74762_e("bottomMaterialMetadata");
    }

    @Override
    protected void setup() {
        super.setup();
        if (this.renderType == 4) {
            this.setInfos(this.tileEntity);
        } else {
            this.setInfos(this.itemStack.field_77990_d);
        }
        if (this.frameBlock == null) {
            return;
        }
        this.rp.interpolateUV.set((Object)true);
        this.rp.icon.set((Object)this.frameBlock.func_149691_a(2, this.frameMetadata));
        this.frameBottom = new Shape(this.baseFrameBottom);
        this.applyTexture(this.frameBottom, this.rp);
        this.frameBottom.setColor(this.getColor(this.frameBlock));
        this.frameTop = new Shape(this.baseFrameTop);
        this.applyTexture(this.frameTop, this.rp);
        this.frameTop.setColor(this.getColor(this.frameBlock));
        this.rp.interpolateUV.set((Object)false);
        this.rp.icon.set((Object)this.topMaterialBlock.func_149691_a(2, this.topMaterialMetadata));
        this.topMaterial = new Shape(this.baseTopMaterial);
        this.applyTexture(this.topMaterial, this.rp);
        this.topMaterial.setColor(this.getColor(this.topMaterialBlock));
        this.rp.icon.set((Object)this.bottomMaterialBlock.func_149691_a(2, this.bottomMaterialMetadata));
        this.bottomMaterial = new Shape(this.baseBottomMaterial);
        this.applyTexture(this.bottomMaterial, this.rp);
        this.bottomMaterial.setColor(this.getColor(this.bottomMaterialBlock));
        this.bottom = Shape.fromShapes((Shape[])new Shape[]{this.frameBottom, this.bottomMaterial});
        this.top = Shape.fromShapes((Shape[])new Shape[]{this.frameTop, this.topMaterial}).translate(0.0f, 1.0f, 0.0f);
        if (this.renderType == 4) {
            if (this.direction == 3) {
                this.bottom.rotate(180.0f, 0.0f, 1.0f, 0.0f);
                this.top.rotate(180.0f, 0.0f, 1.0f, 0.0f);
            }
            if (this.direction == 2) {
                this.bottom.rotate(-90.0f, 0.0f, 1.0f, 0.0f);
                this.top.rotate(-90.0f, 0.0f, 1.0f, 0.0f);
            }
            if (this.direction == 0) {
                this.bottom.rotate(90.0f, 0.0f, 1.0f, 0.0f);
                this.top.rotate(90.0f, 0.0f, 1.0f, 0.0f);
            }
        } else if (this.itemRenderType == IItemRenderer.ItemRenderType.INVENTORY) {
            this.bottom.rotate(45.0f, 0.0f, 1.0f, 0.0f).scale(0.9f, 0.8f, 1.0f).translate(0.0f, -1.0f, 0.0f);
            this.top.rotate(45.0f, 0.0f, 1.0f, 0.0f).scale(0.9f, 0.8f, 1.0f).translate(0.0f, -1.2f, 0.0f);
        } else if (this.itemRenderType == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            this.bottom.rotate(90.0f, 0.0f, 1.0f, 0.0f);
            this.top.rotate(90.0f, 0.0f, 1.0f, 0.0f);
        } else if (this.itemRenderType == IItemRenderer.ItemRenderType.ENTITY) {
            this.bottom.translate(-0.5f, -0.5f, -0.25f).scale(0.5f);
            this.top.translate(-0.5f, -1.0f, -0.25f).scale(0.5f);
        } else if (this.itemRenderType == IItemRenderer.ItemRenderType.EQUIPPED) {
            this.bottom.rotate(180.0f, 0.0f, 1.0f, 0.0f);
            this.top.rotate(180.0f, 0.0f, 1.0f, 0.0f);
        }
    }

    private int getColor(Block block) {
        if (block == Blocks.field_150349_c) {
            return 0xFFFFFF;
        }
        return this.renderType == 4 ? block.func_149720_d(this.world, this.x, this.y, this.z) : block.func_149635_D();
    }

    @Override
    protected void renderTileEntity() {
        this.ar.setStartTime(this.tileEntity.getStartTime());
        this.enableBlending();
        if (this.tileEntity.getMovement() != null) {
            this.ar.animate(this.bottom, this.tileEntity.getMovement().getBottomTransformation(this.tileEntity));
            this.ar.animate(this.s, this.tileEntity.getMovement().getBottomTransformation(this.tileEntity));
        }
        this.drawShape(this.bottom, this.rp);
        if (this.tileEntity.getMovement() != null) {
            this.ar.animate(this.top, this.tileEntity.getMovement().getTopTransformation(this.tileEntity));
        }
        this.drawShape(this.top, this.rp);
    }

    private void renderInventory() {
        this.func_147499_a(TextureMap.field_110575_b);
        this.enableBlending();
        this.drawShape(new Shape(this.top), this.rp);
        this.drawShape(new Shape(this.bottom), this.rp);
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }
}

