/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.renderer;

import net.malisis.core.renderer.BaseRenderer;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.AnimationRenderer;
import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.preset.ShapePreset;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.minecraft.client.renderer.DestroyBlockProgress;

public class DoorRenderer
extends BaseRenderer {
    protected DoorTileEntity tileEntity;
    protected int direction;
    protected boolean opened;
    protected boolean reversed;
    protected boolean topBlock;
    protected Shape baseShape;
    protected Shape s;
    protected RenderParameters rp;
    protected AnimationRenderer ar = new AnimationRenderer((BaseRenderer)this);

    public DoorRenderer() {
        this.initShape();
        this.initRenderParameters();
        this.getBlockDamage = true;
    }

    protected void initShape() {
        this.baseShape = ShapePreset.Cube();
        this.baseShape.setSize(1.0f, 1.0f, 0.1875f);
        this.baseShape.scale(1.0f, 1.0f, 0.995f);
        this.baseShape.applyMatrix();
    }

    protected void initRenderParameters() {
        this.rp = new RenderParameters();
        this.rp.renderAllFaces.set((Object)true);
        this.rp.calculateAOColor.set((Object)false);
        this.rp.useBlockBounds.set((Object)false);
        this.rp.useBlockBrightness.set((Object)false);
        this.rp.calculateBrightness.set((Object)false);
        this.rp.interpolateUV.set((Object)false);
    }

    public void render() {
        if (this.renderType == 1) {
            return;
        }
        this.setTileEntity();
        this.direction = this.tileEntity.getDirection();
        this.opened = this.tileEntity.isOpened();
        this.reversed = this.tileEntity.isReversed();
        this.topBlock = this.tileEntity.isTopBlock(this.x, this.y, this.z);
        this.rp.brightness.set((Object)this.world.func_72802_i(this.tileEntity.field_145851_c, this.tileEntity.field_145848_d, this.tileEntity.field_145849_e, 0));
        this.rp.icon.set(null);
        this.setup();
        this.renderTileEntity();
    }

    protected void setTileEntity() {
        this.tileEntity = (DoorTileEntity)((BaseRenderer)this).tileEntity;
    }

    protected void setup() {
        this.s = new Shape(this.baseShape);
        if (this.direction == 3) {
            this.s.rotate(180.0f, 0.0f, 1.0f, 0.0f);
        }
        if (this.direction == 2) {
            this.s.rotate(-90.0f, 0.0f, 1.0f, 0.0f);
        }
        if (this.direction == 0) {
            this.s.rotate(90.0f, 0.0f, 1.0f, 0.0f);
        }
    }

    protected void renderTileEntity() {
        this.ar.setStartTime(this.tileEntity.getStartTime());
        Shape tmp = new Shape(this.s).translate(0.0f, 1.0f, 0.0f);
        if (this.tileEntity.getMovement() != null) {
            this.ar.animate(this.s, this.tileEntity.getMovement().getBottomTransformation(this.tileEntity));
        }
        this.drawShape(new Shape(this.s), this.rp);
        this.blockMetadata |= 8;
        if (this.tileEntity.getMovement() != null) {
            this.ar.animate(tmp, this.tileEntity.getMovement().getTopTransformation(this.tileEntity));
        }
        this.drawShape(tmp, this.rp);
    }

    public void renderDestroyProgress() {
        this.rp.icon.set((Object)damagedIcons[this.destroyBlockProgress.func_73106_e()]);
        this.s.translate(0.0f, 0.5f, 0.005f);
        this.s.scale(1.011f);
        this.s.applyMatrix();
        this.drawShape(new Shape(new Face[]{this.s.getFaces()[0], this.s.getFaces()[1]}), this.rp);
    }

    protected boolean isCurrentBlockDestroyProgress(DestroyBlockProgress dbp) {
        return dbp.func_73110_b() == this.x && (dbp.func_73109_c() == this.y || dbp.func_73109_c() == this.y + 1) && dbp.func_73108_d() == this.z;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }
}

