/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.renderer;

import net.malisis.core.MalisisCore;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.preset.ShapePreset;
import net.malisis.doors.door.movement.IDoorMovement;
import net.malisis.doors.door.renderer.DoorRenderer;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.DestroyBlockProgress;
import net.minecraft.client.renderer.RenderBlocks;

public class FenceGateRenderer
extends DoorRenderer {
    protected Shape baseLeft;
    protected Shape baseRight;
    protected Shape left;
    protected Shape right;
    protected boolean reversedOpen;

    @Override
    protected void initShape() {
        float w = 0.125f;
        float w2 = 0.1875f;
        Shape hingeLeft = ShapePreset.Cube().setSize(w, 0.6875f, w).translate(0.0f, 0.3125f, 0.5f - w / 2.0f);
        Shape hingeRight = new Shape(hingeLeft).translate(1.0f - w, 0.0f, 0.0f);
        Shape gateHLeft = ShapePreset.Cube().setSize(w, w2 * 3.0f, w).translate(0.5f - w, 0.375f, 0.5f - w / 2.0f);
        Shape gateHRight = new Shape(gateHLeft).translate(w, 0.0f, 0.0f);
        Shape gateBottomLeft = ShapePreset.Cube().setSize(2.0f * w, w2, w).translate(w, 0.375f, 0.5f - w / 2.0f);
        Shape gateTopLeft = new Shape(gateBottomLeft).translate(0.0f, 2.0f * w2, 0.0f);
        Shape gateBottomRight = new Shape(gateBottomLeft).translate(4.0f * w, 0.0f, 0.0f);
        Shape gateTopRight = new Shape(gateTopLeft).translate(4.0f * w, 0.0f, 0.0f);
        this.baseLeft = Shape.fromShapes((Shape[])new Shape[]{hingeLeft, gateHLeft, gateBottomLeft, gateTopLeft});
        this.baseRight = Shape.fromShapes((Shape[])new Shape[]{hingeRight, gateHRight, gateBottomRight, gateTopRight});
    }

    @Override
    protected void setup() {
        this.left = new Shape(this.baseLeft);
        this.right = new Shape(this.baseRight);
        if (this.direction == 1 || this.direction == 3) {
            this.left.rotate(90.0f, 0.0f, 1.0f, 0.0f);
            this.right.rotate(90.0f, 0.0f, 1.0f, 0.0f);
        }
        this.rp.interpolateUV.set((Object)true);
        this.rp.applyTexture.set((Object)false);
        this.applyTexture(this.left, this.rp);
        this.applyTexture(this.right, this.rp);
        this.left.applyMatrix();
        this.right.applyMatrix();
    }

    @Override
    public void renderTileEntity() {
        IDoorMovement mvt = this.tileEntity.getDescriptor().getMovement();
        if (mvt != null) {
            this.ar.setStartTime(this.tileEntity.getStartTime());
            this.ar.animate(this.left, mvt.getTopTransformation(this.tileEntity));
            this.ar.animate(this.right, mvt.getBottomTransformation(this.tileEntity));
        }
        this.drawShape(this.left, this.rp);
        this.drawShape(this.right, this.rp);
    }

    @Override
    public void renderDestroyProgress() {
        this.rp.icon.set((Object)damagedIcons[this.destroyBlockProgress.func_73106_e()]);
        this.rp.applyTexture.set((Object)true);
        this.drawShape(this.left, this.rp);
        this.drawShape(this.right, this.rp);
    }

    @Override
    protected boolean isCurrentBlockDestroyProgress(DestroyBlockProgress dbp) {
        return dbp.func_73110_b() == this.x && (dbp.func_73109_c() == this.y || dbp.func_73109_c() == this.y + 1) && dbp.func_73108_d() == this.z;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        renderer.func_147800_a(MalisisCore.orignalBlock((Block)block), 0, 1.0f);
    }

    @Override
    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }
}

