/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.inventory.IInventoryProvider;
import net.malisis.core.inventory.MalisisInventory;
import net.malisis.core.inventory.MalisisInventoryContainer;
import net.malisis.core.inventory.MalisisSlot;
import net.malisis.doors.gui.BlockMixerGui;
import net.malisis.doors.item.MixedBlockBlockItem;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class BlockMixerTileEntity
extends TileEntity
implements IInventoryProvider {
    private MalisisInventory inventory;
    private int mixTimer = 0;
    private int mixTotalTime = 100;
    public MixerSlot firstInput = new MixerSlot(0, 0);
    public MixerSlot secondInput = new MixerSlot(1, 2);
    public MixerSlot output = new MixerSlot(2, 3);

    public BlockMixerTileEntity() {
        this.inventory = new MalisisInventory((IInventoryProvider)this, new MalisisSlot[]{this.firstInput, this.secondInput, this.output});
    }

    public void func_145845_h() {
        ItemStack firstItemStack = this.firstInput.getItemStack();
        ItemStack secondItemStack = this.secondInput.getItemStack();
        ItemStack outputItemStack = this.output.getItemStack();
        if (firstItemStack == null || secondItemStack == null) {
            this.mixTimer = 0;
            return;
        }
        ItemStack expected = MixedBlockBlockItem.fromItemStacks(firstItemStack, secondItemStack);
        if (expected == null) {
            this.mixTimer = 0;
            return;
        }
        if (!(outputItemStack == null || ItemStack.func_77970_a((ItemStack)outputItemStack, (ItemStack)expected) && outputItemStack.field_77994_a < outputItemStack.func_77976_d())) {
            this.mixTimer = 0;
            return;
        }
        ++this.mixTimer;
        if (this.mixTimer > this.mixTotalTime) {
            this.mixTimer = 0;
            this.firstInput.addItemStackSize(-1);
            this.secondInput.addItemStackSize(-1);
            if (outputItemStack == null) {
                this.output.setItemStack(expected);
            } else {
                this.output.addItemStackSize(1);
            }
        }
    }

    public float getMixTimer() {
        return (float)this.mixTimer / (float)this.mixTotalTime;
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74768_a("mixTimer", this.mixTimer);
        this.inventory.writeToNBT(tagCompound);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.mixTimer = tagCompound.func_74762_e("mixTimer");
        this.inventory.readFromNBT(tagCompound);
    }

    public MalisisInventory getInventory() {
        return this.inventory;
    }

    @SideOnly(value=Side.CLIENT)
    public MalisisGui getGui(MalisisInventoryContainer container) {
        return new BlockMixerGui(this, container);
    }

    public class MixerSlot
    extends MalisisSlot {
        public static final int FIRST = 0;
        public static final int SECOND = 2;
        public static final int OUTPUT = 3;
        int slotType;

        public MixerSlot(int index, int type) {
            super(index);
            this.slotType = type;
        }

        public boolean isItemValid(ItemStack itemStack) {
            if (this.slotType == 3) {
                return false;
            }
            Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
            return MixedBlockBlockItem.canBeMixed(block, this.slotType == 2);
        }
    }
}

