/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.entity;

import java.util.HashSet;
import java.util.Set;
import net.malisis.doors.block.GarageDoor;
import net.malisis.doors.door.DoorState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class GarageDoorTileEntity
extends TileEntity {
    public static final int maxOpenTime = 10;
    protected boolean removed = false;
    protected GarageDoorTileEntity topDoor;
    protected Set<GarageDoorTileEntity> childDoors = new HashSet<GarageDoorTileEntity>();
    protected DoorState state = DoorState.CLOSED;
    public boolean draw = false;
    public long startTime;

    public int getDirection() {
        return this.field_145847_g & 3;
    }

    public DoorState getState() {
        return this.state;
    }

    public boolean isOpened() {
        return (this.func_145832_p() & 4) != 0;
    }

    public boolean isReversed() {
        return (this.func_145832_p() & 0x10) != 0;
    }

    public boolean isTopDoor() {
        return this == this.getTopDoor();
    }

    public GarageDoorTileEntity getTopDoor() {
        if (this.topDoor == null) {
            this.add();
        }
        return this.topDoor;
    }

    public Set<GarageDoorTileEntity> getChildDoors() {
        return this.childDoors;
    }

    public GarageDoorTileEntity getGarageDoor(ForgeDirection dir) {
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
        if (te == null) {
            return null;
        }
        if (!(te instanceof GarageDoorTileEntity)) {
            return null;
        }
        GarageDoorTileEntity door = (GarageDoorTileEntity)te;
        if (door.getDirection() != this.getDirection()) {
            return null;
        }
        if (door.removed) {
            return null;
        }
        return (GarageDoorTileEntity)te;
    }

    public GarageDoorTileEntity findTopBlock() {
        GarageDoorTileEntity te = this;
        GarageDoorTileEntity ret = this;
        while ((te = te.getGarageDoor(ForgeDirection.UP)) != null) {
            ret = te;
        }
        return ret;
    }

    public void setTopBlock(GarageDoorTileEntity topDoor) {
        this.childDoors.clear();
        this.topDoor = topDoor;
        if (this.isTopDoor()) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145832_p() | 8, 2);
            GarageDoorTileEntity te = this;
            while ((te = te.getGarageDoor(ForgeDirection.DOWN)) != null) {
                te.setTopBlock(this);
                this.childDoors.add(te);
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        } else {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145832_p() & 0xFFFFFFF7, 2);
        }
    }

    public void add() {
        GarageDoorTileEntity te = this.findTopBlock();
        te.setTopBlock(te);
    }

    public void remove() {
        this.removed = true;
        GarageDoorTileEntity te = this.getGarageDoor(ForgeDirection.DOWN);
        if (te != null) {
            te.setTopBlock(te);
        }
        if ((te = this.getGarageDoor(ForgeDirection.UP)) != null) {
            te = te.findTopBlock();
            te.setTopBlock(te);
        }
    }

    public void changeState() {
        if (!this.isTopDoor()) {
            this.getTopDoor().changeState();
            return;
        }
        if (this.state == DoorState.OPENING || this.state == DoorState.CLOSING) {
            return;
        }
        this.startTime = this.field_145850_b.func_82737_E();
        if (this.state == DoorState.CLOSED) {
            this.setState(DoorState.OPENING);
        } else if (this.state == DoorState.OPENED) {
            this.setState(DoorState.CLOSING);
        }
        GarageDoorTileEntity te = this.getGarageDoor(GarageDoor.isEastOrWest(this.field_145847_g) ? ForgeDirection.NORTH : ForgeDirection.EAST);
        if (te != null) {
            te.changeState();
        }
        if ((te = this.getGarageDoor(GarageDoor.isEastOrWest(this.field_145847_g) ? ForgeDirection.SOUTH : ForgeDirection.WEST)) != null) {
            te.changeState();
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private void setState(DoorState newState) {
        if (this.state == newState) {
            return;
        }
        this.state = newState;
        if (this.func_145831_w() != null) {
            if (this.state == DoorState.CLOSED) {
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145847_g & 0xFFFFFFFB, 2);
            } else {
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145847_g | 4, 2);
            }
        }
        if (this.isTopDoor()) {
            for (GarageDoorTileEntity te : this.childDoors) {
                te.setState(newState);
            }
        }
    }

    public void func_145845_h() {
        if (!this.isTopDoor()) {
            return;
        }
        if (this.state == DoorState.CLOSED || this.state == DoorState.OPENED) {
            return;
        }
        if (this.startTime + (long)((this.childDoors.size() + 1) * 10) < this.field_145850_b.func_82737_E()) {
            if (this.state == DoorState.CLOSING) {
                this.setState(DoorState.CLOSED);
            } else if (this.state == DoorState.OPENING) {
                this.setState(DoorState.OPENED);
            }
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - this.childDoors.size()), (double)(this.field_145848_d - this.childDoors.size()), (double)(this.field_145849_e - this.childDoors.size()), (double)(this.field_145851_c + this.childDoors.size() + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + this.childDoors.size() + 1));
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("state", this.state.ordinal());
        tag.func_74772_a("startTime", this.startTime);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.state = DoorState.values()[tag.func_74762_e("state")];
        this.startTime = tag.func_74763_f("startTime");
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        this.add();
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
        this.add();
    }
}

