/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.entity;

import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.inventory.IInventoryProvider;
import net.malisis.core.inventory.InventoryEvent;
import net.malisis.core.inventory.MalisisInventory;
import net.malisis.core.inventory.MalisisInventoryContainer;
import net.malisis.core.inventory.MalisisSlot;
import net.malisis.core.util.TileEntityUtils;
import net.malisis.doors.block.VanishingBlock;
import net.malisis.doors.entity.VanishingTileEntity;
import net.malisis.doors.gui.VanishingDiamondGui;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class VanishingDiamondTileEntity
extends VanishingTileEntity
implements IInventoryProvider {
    protected MalisisInventory inventory;
    protected MalisisSlot slot;
    protected int changedPowerStateTimer;
    protected HashMap<ForgeDirection, DirectionState> directionStates = new HashMap();

    public VanishingDiamondTileEntity() {
        super(3);
        this.inventory = new MalisisInventory((IInventoryProvider)this, 1);
        this.inventory.setInventoryStackLimit(1);
        this.slot = this.inventory.getSlot(0);
        this.slot.register((Object)this);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            this.directionStates.put(dir, new DirectionState(dir));
        }
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    @Override
    public boolean setPowerState(boolean powered) {
        if (!super.setPowerState(powered)) {
            return false;
        }
        this.changedPowerStateTimer = 0;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            this.directionStates.get(dir).resetPropagationState();
            this.directionStates.get(dir).propagateState(this.changedPowerStateTimer);
        }
        return true;
    }

    public DirectionState getDirectionState(ForgeDirection dir) {
        return this.directionStates.get(dir);
    }

    @Override
    public void func_145845_h() {
        ++this.changedPowerStateTimer;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            this.directionStates.get(dir).propagateState(this.changedPowerStateTimer);
        }
        super.func_145845_h();
    }

    @Subscribe
    public void onSlotChanged(InventoryEvent.SlotChanged event) {
        this.setBlock(event.getSlot().getItemStack(), null, 0, 0.5f, 0.5f, 0.5f);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inventory.readFromNBT(nbt);
        NBTTagList dirList = nbt.func_150295_c("Directions", 10);
        for (int i = 0; i < dirList.func_74745_c(); ++i) {
            NBTTagCompound tag = dirList.func_150305_b(i);
            ForgeDirection dir = ForgeDirection.getOrientation((int)tag.func_74762_e("direction"));
            this.directionStates.get(dir).readFromNBT(tag);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.inventory.writeToNBT(nbt);
        NBTTagList dirList = new NBTTagList();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            dirList.func_74742_a((NBTBase)this.directionStates.get(dir).writeToNBT(new NBTTagCompound()));
        }
        nbt.func_74782_a("Directions", (NBTBase)dirList);
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        TileEntityUtils.updateGui((TileEntity)this);
    }

    public MalisisInventory getInventory() {
        return this.inventory;
    }

    @SideOnly(value=Side.CLIENT)
    public MalisisGui getGui(MalisisInventoryContainer container) {
        return new VanishingDiamondGui(this, container);
    }

    public class DirectionState {
        public ForgeDirection direction;
        public boolean shouldPropagate;
        public int delay;
        public boolean inversed;
        public boolean propagated;

        public DirectionState(ForgeDirection direction, boolean shouldPropagate, int delay, boolean inversed) {
            this.direction = direction;
            this.update(shouldPropagate, delay, inversed);
        }

        public DirectionState(ForgeDirection direction) {
            this(direction, false, 0, false);
        }

        public void update(boolean shouldPropagate, int delay, boolean inversed) {
            this.shouldPropagate = shouldPropagate;
            this.delay = delay;
            this.inversed = inversed;
        }

        public void resetPropagationState() {
            this.propagated = false;
        }

        public boolean propagateState(int timer) {
            if (!this.shouldPropagate || this.propagated || timer < this.delay) {
                return false;
            }
            Block block = VanishingDiamondTileEntity.this.field_145850_b.func_147439_a(VanishingDiamondTileEntity.this.field_145851_c + this.direction.offsetX, VanishingDiamondTileEntity.this.field_145848_d + this.direction.offsetY, VanishingDiamondTileEntity.this.field_145849_e + this.direction.offsetZ);
            if (block instanceof VanishingBlock) {
                ((VanishingBlock)block).setPowerState(VanishingDiamondTileEntity.this.field_145850_b, VanishingDiamondTileEntity.this.field_145851_c + this.direction.offsetX, VanishingDiamondTileEntity.this.field_145848_d + this.direction.offsetY, VanishingDiamondTileEntity.this.field_145849_e + this.direction.offsetZ, this.inversed ? !VanishingDiamondTileEntity.this.powered : VanishingDiamondTileEntity.this.powered);
            }
            this.propagated = true;
            return false;
        }

        public void readFromNBT(NBTTagCompound nbt) {
            this.update(nbt.func_74767_n("shouldPropagate"), nbt.func_74762_e("delay"), nbt.func_74767_n("inversed"));
        }

        public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
            nbt.func_74768_a("direction", this.direction.ordinal());
            nbt.func_74757_a("shouldPropagate", this.shouldPropagate);
            nbt.func_74768_a("delay", this.delay);
            nbt.func_74757_a("inversed", this.inversed);
            return nbt;
        }
    }
}

