/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.malisis.core.util.TileEntityUtils;
import net.malisis.doors.door.DoorRegistry;
import net.malisis.doors.entity.DoorFactoryTileEntity;
import net.malisis.doors.network.NetworkHandler;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class DoorFactoryMessage
implements IMessageHandler<Packet, IMessage> {
    public IMessage onMessage(Packet message, MessageContext ctx) {
        World world = ctx.getServerHandler().field_147369_b.field_70170_p;
        DoorFactoryTileEntity te = (DoorFactoryTileEntity)TileEntityUtils.getTileEntity(DoorFactoryTileEntity.class, (IBlockAccess)world, (int)message.x, (int)message.y, (int)message.z);
        if (te == null) {
            return null;
        }
        if (message.type == Packet.TYPE_DOORINFOS) {
            te.setDoorMovement(DoorRegistry.getMovement(message.movement));
            te.setDoorSound(DoorRegistry.getSound(message.sound));
            te.setOpeningTime(message.openTime);
            te.setRequireRedstone(message.redstone);
            te.setDoubleDoor(message.doubleDoor);
        } else {
            te.createDoor();
        }
        return null;
    }

    public static void sendDoorInformations(DoorFactoryTileEntity te) {
        Packet packet = new Packet(Packet.TYPE_DOORINFOS, te.field_145851_c, te.field_145848_d, te.field_145849_e);
        String mvt = DoorRegistry.getId(te.getDoorMovement());
        String snd = DoorRegistry.getId(te.getDoorSound());
        packet.setDoorInfos(mvt, snd, te.getOpeningTime(), te.requireRedstone(), te.isDoubleDoor());
        NetworkHandler.network.sendToServer((IMessage)packet);
    }

    public static void sendCreateDoor(DoorFactoryTileEntity te) {
        Packet packet = new Packet(Packet.TYPE_CREATEDOOR, te.field_145851_c, te.field_145848_d, te.field_145849_e);
        NetworkHandler.network.sendToServer((IMessage)packet);
    }

    public static class Packet
    implements IMessage {
        private static int TYPE_DOORINFOS = 0;
        private static int TYPE_CREATEDOOR = 1;
        private int x;
        private int y;
        private int z;
        private int type;
        private String movement;
        private String sound;
        private int openTime;
        private boolean redstone;
        private boolean doubleDoor;

        public Packet() {
        }

        public Packet(int type, int x, int y, int z) {
            this.type = type;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public void setDoorInfos(String movement, String sound, int openTime, boolean redstone, boolean doubleDoor) {
            this.movement = movement;
            this.sound = sound;
            this.openTime = openTime;
            this.redstone = redstone;
            this.doubleDoor = doubleDoor;
        }

        public void fromBytes(ByteBuf buf) {
            this.x = buf.readInt();
            this.y = buf.readInt();
            this.z = buf.readInt();
            this.type = buf.readInt();
            if (this.type == TYPE_DOORINFOS) {
                this.movement = ByteBufUtils.readUTF8String((ByteBuf)buf);
                if (this.movement.equals("")) {
                    this.movement = null;
                }
                this.sound = ByteBufUtils.readUTF8String((ByteBuf)buf);
                if (this.sound.equals("")) {
                    this.sound = null;
                }
                this.openTime = buf.readInt();
                this.redstone = buf.readBoolean();
                this.doubleDoor = buf.readBoolean();
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.x);
            buf.writeInt(this.y);
            buf.writeInt(this.z);
            buf.writeInt(this.type);
            if (this.type == TYPE_DOORINFOS) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)(this.movement != null ? this.movement : ""));
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)(this.sound != null ? this.sound : ""));
                buf.writeInt(this.openTime);
                buf.writeBoolean(this.redstone);
                buf.writeBoolean(this.doubleDoor);
            }
        }
    }
}

