/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.renderer;

import java.util.HashSet;
import net.malisis.core.renderer.BaseRenderer;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.AnimationRenderer;
import net.malisis.core.renderer.animation.transformation.ChainedTransformation;
import net.malisis.core.renderer.animation.transformation.ParallelTransformation;
import net.malisis.core.renderer.animation.transformation.Rotation;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.animation.transformation.Translation;
import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.preset.ShapePreset;
import net.malisis.core.util.TileEntityUtils;
import net.malisis.doors.door.DoorState;
import net.malisis.doors.entity.GarageDoorTileEntity;
import net.minecraft.client.renderer.DestroyBlockProgress;
import net.minecraft.world.IBlockAccess;

public class GarageDoorRenderer
extends BaseRenderer {
    private GarageDoorTileEntity tileEntity;
    protected int direction;
    protected boolean opened;
    protected boolean reversed;
    protected boolean topBlock;
    protected Shape baseShape;
    protected Shape s;
    protected RenderParameters rp;
    protected AnimationRenderer ar = new AnimationRenderer((BaseRenderer)this);

    public GarageDoorRenderer() {
        this.rp = new RenderParameters();
        this.rp.renderAllFaces.set((Object)true);
        this.rp.calculateAOColor.set((Object)false);
        this.rp.useBlockBounds.set((Object)false);
        this.rp.useBlockBrightness.set((Object)false);
        this.rp.calculateBrightness.set((Object)false);
        this.rp.interpolateUV.set((Object)false);
    }

    public void render() {
        if (this.renderType == 3) {
            this.enableBlending();
            this.s = ShapePreset.Cube().setSize(0.1875f, 1.0f, 1.0f);
            this.s.translate(0.40625f, 0.0f, 0.0f);
            this.rp.icon.set(null);
            this.blockMetadata = 8;
            this.drawShape(this.s, this.rp);
            return;
        }
        this.tileEntity = (GarageDoorTileEntity)TileEntityUtils.getTileEntity(GarageDoorTileEntity.class, (IBlockAccess)this.world, (int)this.x, (int)this.y, (int)this.z);
        if (this.tileEntity == null || !this.tileEntity.isTopDoor()) {
            this.getBlockDamage = false;
            return;
        }
        this.getBlockDamage = true;
        this.direction = this.tileEntity.getDirection();
        this.opened = this.tileEntity.isOpened();
        this.reversed = this.tileEntity.isReversed();
        this.rp.brightness.set((Object)this.world.func_72802_i(this.tileEntity.field_145851_c, this.tileEntity.field_145848_d, this.tileEntity.field_145849_e, 0));
        this.rp.icon.set(null);
        this.enableBlending();
        this.renderTileEntity();
    }

    protected void renderTileEntity() {
        this.s = ShapePreset.Cube().setSize(0.1875f, 1.0f, 1.0f);
        this.s.rotate((float)(-90 * this.tileEntity.getDirection()), 0.0f, 1.0f, 0.0f);
        this.s.translate(0.40625f, 0.0f, 0.0f);
        int t = 10;
        this.ar.setStartTime(this.tileEntity.startTime);
        HashSet<GarageDoorTileEntity> doors = new HashSet<GarageDoorTileEntity>(this.tileEntity.getChildDoors());
        doors.add(this.tileEntity);
        for (GarageDoorTileEntity te : doors) {
            this.blockMetadata = te.field_145847_g;
            int delta = this.tileEntity.field_145848_d - te.field_145848_d;
            int delta2 = doors.size() - (delta + 1);
            Transformation verticalAnim = new Translation(0.0f, (float)(-delta), 0.0f, 0.0f, 0.0f, 0.0f).forTicks(t * delta, 0);
            ParallelTransformation topRotate = new ParallelTransformation(new Transformation[]{new Translation(0.0f, 1.0f, 0.0f).forTicks(t, 0), new Rotation(0.0f, -90.0f).aroundAxis(0.0f, 0.0f, 1.0f).offset(-0.5f, -0.5f, 0.0f).forTicks(t, 0)});
            Transformation horizontalAnim = new Translation(0.0f, 0.0f, 0.0f, 0.0f, (float)delta2, 0.0f).forTicks(t * delta2, 0);
            ChainedTransformation chained = new ChainedTransformation(new Transformation[]{verticalAnim, topRotate, horizontalAnim});
            if (this.tileEntity.getState() == DoorState.CLOSING || this.tileEntity.getState() == DoorState.CLOSED) {
                chained.reversed(true);
            }
            Shape tempShape = new Shape(this.s);
            this.ar.animate(tempShape, (Transformation)chained);
            this.drawShape(tempShape, this.rp);
        }
    }

    public void renderDestroyProgress() {
        this.rp.icon.set((Object)damagedIcons[this.destroyBlockProgress.func_73106_e()]);
        int y = this.y - this.destroyBlockProgress.func_73109_c();
        this.s.translate(0.005f, (float)(-y), 0.0f);
        this.s.scale(1.011f);
        this.s.applyMatrix();
        Shape tempShape = new Shape(new Face[]{this.s.getFaces()[2], this.s.getFaces()[3]});
        this.drawShape(tempShape, this.rp);
    }

    protected boolean isCurrentBlockDestroyProgress(DestroyBlockProgress dbp) {
        if (dbp.func_73110_b() == this.x && dbp.func_73109_c() == this.y && dbp.func_73108_d() == this.z) {
            return true;
        }
        for (GarageDoorTileEntity te : this.tileEntity.getChildDoors()) {
            if (dbp.func_73110_b() != te.field_145851_c || dbp.func_73109_c() != te.field_145848_d || dbp.func_73108_d() != te.field_145849_e) continue;
            return true;
        }
        return false;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }
}

