/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.renderer;

import java.util.Random;
import net.malisis.core.renderer.BaseRenderer;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.preset.ShapePreset;
import net.malisis.doors.MalisisDoorsSettings;
import net.malisis.doors.ProxyAccess;
import net.malisis.doors.block.VanishingBlock;
import net.malisis.doors.entity.VanishingTileEntity;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

public class VanishingBlockRenderer
extends BaseRenderer {
    public Random rand = new Random();

    public void render() {
        if (this.renderType == 4) {
            this.renderVanishingTileEntity();
        } else if (this.renderType == 2) {
            RenderParameters rp = new RenderParameters();
            rp.useBlockBounds.set((Object)false);
            this.drawShape(ShapePreset.Cube(), rp);
        } else if (this.renderType == 1) {
            VanishingTileEntity te = (VanishingTileEntity)this.world.func_147438_o(this.x, this.y, this.z);
            if ((te.func_145832_p() & 0xC) != 0) {
                return;
            }
            if (te.copiedBlock != null) {
                this.tessellatorUnshift();
                this.renderBlocks.field_147845_a = ProxyAccess.get(this.world);
                this.renderBlocks.field_147837_f = true;
                try {
                    if (te.copiedBlock.canRenderInPass(((VanishingBlock)this.block).renderPass)) {
                        this.vertexDrawn = this.renderBlocks.func_147805_b(te.copiedBlock, this.x, this.y, this.z);
                    }
                }
                catch (Exception e) {
                    this.tessellatorShift();
                    this.drawShape(ShapePreset.Cube());
                }
                this.renderBlocks.field_147837_f = false;
                this.renderBlocks.field_147845_a = this.world;
            } else if (((VanishingBlock)this.block).renderPass == 0) {
                this.drawShape(ShapePreset.Cube());
            }
        }
    }

    private void renderVanishingTileEntity() {
        VanishingTileEntity te = (VanishingTileEntity)this.tileEntity;
        if (!te.inTransition && !te.vibrating) {
            if (!te.powered && te.copiedTileEntity != null) {
                this.clean();
                TileEntityRendererDispatcher.field_147556_a.func_147544_a(te.copiedTileEntity, this.partialTick);
            }
            return;
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glAlphaFunc((int)516, (float)0.0f);
        float fx = 0.0f;
        float fy = 0.0f;
        float fz = 0.0f;
        float scale = (float)(te.getDuration() - te.transitionTimer) / (float)te.getDuration();
        boolean rendered = te.copiedBlock != null;
        RenderParameters rp = new RenderParameters();
        rp.useBlockBounds.set((Object)false);
        rp.interpolateUV.set((Object)false);
        Shape shape = ShapePreset.Cube();
        if (!te.inTransition && !te.powered) {
            rp.alpha.set((Object)200);
            fx = this.rand.nextFloat() * 0.05f;
            fy = this.rand.nextFloat() * 0.05f;
            fz = this.rand.nextFloat() * 0.05f;
            if (this.rand.nextBoolean()) {
                GL11.glTranslated((double)fx, (double)fy, (double)fz);
            } else {
                GL11.glRotatef((float)this.rand.nextInt(5), (float)1.0f, (float)1.0f, (float)1.0f);
            }
        } else {
            int alpha = te.copiedBlock != null ? 255 - (int)(scale * 255.0f) : (int)(scale * 255.0f);
            rp.alpha.set((Object)alpha);
            shape.scale(scale - 0.001f);
        }
        if (te.copiedBlock != null) {
            RenderBlocks renderBlocks = new RenderBlocks(ProxyAccess.get(this.world));
            renderBlocks.field_147837_f = true;
            try {
                boolean smbr = (Boolean)MalisisDoorsSettings.simpleMixedBlockRendering.get();
                MalisisDoorsSettings.simpleMixedBlockRendering.set((Object)true);
                GL11.glPushMatrix();
                GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
                GL11.glScalef((float)scale, (float)scale, (float)scale);
                GL11.glTranslated((double)((float)(-this.x) - 0.5f), (double)((float)(-this.y) - 0.5f), (double)((float)(-this.z) - 0.5f));
                GL11.glBlendFunc((int)32771, (int)32772);
                GL14.glBlendColor((float)0.0f, (float)0.0f, (float)0.0f, (float)(1.0f - scale));
                renderBlocks.field_147840_d = this.block.func_149691_a(this.blockMetadata, 0);
                rendered = renderBlocks.func_147805_b(te.copiedBlock, this.x, this.y, this.z);
                renderBlocks.field_147840_d = null;
                this.next();
                if (te.copiedBlock.canRenderInPass(0)) {
                    GL14.glBlendColor((float)0.0f, (float)0.0f, (float)0.0f, (float)scale);
                    rendered |= renderBlocks.func_147805_b(te.copiedBlock, this.x, this.y, this.z);
                    this.next();
                }
                if (te.copiedBlock.canRenderInPass(1)) {
                    GL11.glBlendFunc((int)770, (int)771);
                    rendered |= renderBlocks.func_147805_b(te.copiedBlock, this.x, this.y, this.z);
                    this.next();
                }
                if (!rendered) {
                    this.drawShape(shape, rp);
                }
                GL11.glPopMatrix();
                if (te.copiedTileEntity != null) {
                    this.clean();
                    TileEntityRendererDispatcher.field_147556_a.func_147544_a(te.copiedTileEntity, this.partialTick);
                }
                MalisisDoorsSettings.simpleMixedBlockRendering.set((Object)smbr);
            }
            catch (Exception e) {
                this.drawShape(shape, rp);
            }
        } else {
            this.drawShape(shape, rp);
        }
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }
}

