/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.renderer.block;

import net.malisis.core.renderer.BaseRenderer;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.element.Vertex;
import net.malisis.core.renderer.preset.FacePreset;
import net.malisis.core.renderer.preset.ShapePreset;
import net.malisis.doors.MalisisDoorsSettings;
import net.malisis.doors.entity.MixedBlockTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class MixedBlockRenderer
extends BaseRenderer {
    private static int currentPass;
    private int mixedBlockMetadata;

    public void render() {
        if (this.renderType == 3) {
            this.renderItem();
        } else if (this.renderType == 1) {
            this.renderWorld();
        }
    }

    private void renderItem() {
        if (!this.itemStack.func_77942_o()) {
            return;
        }
        GL11.glEnable((int)2903);
        GL11.glShadeModel((int)7425);
        this.enableBlending();
        Block b1 = Block.func_149729_e((int)this.itemStack.func_77978_p().func_74762_e("block1"));
        Block b2 = Block.func_149729_e((int)this.itemStack.func_77978_p().func_74762_e("block2"));
        int metadata1 = this.itemStack.func_77978_p().func_74762_e("metadata1");
        int metadata2 = this.itemStack.func_77978_p().func_74762_e("metadata2");
        this.mixedBlockMetadata = 3;
        if (((Boolean)MalisisDoorsSettings.simpleMixedBlockRendering.get()).booleanValue()) {
            this.renderSimple(b1, metadata1, b2, metadata2);
        } else {
            this.set(b1, metadata1);
            this.drawPass(0);
            this.set(b2, metadata2);
            this.drawPass(1);
        }
    }

    private void renderWorld() {
        MixedBlockTileEntity te = (MixedBlockTileEntity)this.world.func_147438_o(this.x, this.y, this.z);
        if (te == null) {
            return;
        }
        this.mixedBlockMetadata = this.blockMetadata;
        if (((Boolean)MalisisDoorsSettings.simpleMixedBlockRendering.get()).booleanValue()) {
            this.renderSimple(te.block1, te.metadata1, te.block2, te.metadata2);
        } else {
            if (currentPass == 0) {
                this.set(te.block1, te.metadata1);
            } else {
                GL11.glAlphaFunc((int)516, (float)0.0f);
                this.set(te.block2, te.metadata2);
            }
            if (this.block instanceof Block) {
                this.drawPass(currentPass);
            }
        }
    }

    private void renderSimple(Block block1, int metadata1, Block block2, int metadata2) {
        int m;
        boolean reversed = false;
        float width = 1.0f;
        float height = 1.0f;
        float depth = 1.0f;
        float offsetX = 0.0f;
        float offestY = 0.0f;
        float offsetZ = 0.0f;
        if (this.mixedBlockMetadata == 0 || this.mixedBlockMetadata == 1) {
            height = 0.5f;
            offestY = 0.5f;
            if (this.mixedBlockMetadata == 1) {
                reversed = true;
            }
        }
        if (this.mixedBlockMetadata == 4 || this.mixedBlockMetadata == 5) {
            width = 0.5f;
            offsetX = 0.5f;
            if (this.mixedBlockMetadata == 5) {
                reversed = true;
            }
        }
        if (this.mixedBlockMetadata == 2 || this.mixedBlockMetadata == 3) {
            depth = 0.5f;
            offsetZ = 0.5f;
            if (this.mixedBlockMetadata == 3) {
                reversed = true;
            }
        }
        if (this.renderType == 1) {
            // empty if block
        }
        Shape shape = ShapePreset.Cube();
        shape.setSize(width, height, depth);
        RenderParameters rp = new RenderParameters();
        rp.renderAllFaces.set((Object)true);
        Block b = reversed ? block2 : block1;
        int n = m = reversed ? metadata2 : metadata1;
        if (b instanceof Block && b.canRenderInPass(currentPass) || this.renderType == 3) {
            this.set(b, m);
            this.drawShape(shape, rp);
        }
        b = reversed ? block1 : block2;
        int n2 = m = reversed ? metadata1 : metadata2;
        if (b instanceof Block && b.canRenderInPass(currentPass) || this.renderType == 3) {
            shape.translate(offsetX, offestY, offsetZ);
            this.set(b, m);
            this.drawShape(shape, rp);
        }
    }

    private void drawPass(int pass) {
        RenderParameters rp = new RenderParameters();
        rp.usePerVertexAlpha.set((Object)true);
        rp.useBlockBounds.set((Object)false);
        Shape cube = ShapePreset.Cube();
        int color = this.renderType == 1 ? this.block.func_149720_d(this.world, this.x, this.y, this.z) : this.block.func_149635_D();
        ForgeDirection dir = ForgeDirection.getOrientation((int)this.mixedBlockMetadata);
        String name = dir.name().toLowerCase();
        if (dir == ForgeDirection.UP) {
            name = "top";
        }
        if (dir == ForgeDirection.DOWN) {
            name = "bottom";
        }
        if (this.block instanceof BlockGrass) {
            RenderParameters rpGrass = new RenderParameters();
            rpGrass.colorMultiplier.set((Object)color);
            rpGrass.usePerVertexAlpha.set((Object)true);
            rpGrass.useBlockBounds.set((Object)false);
            cube.setParameters(FacePreset.Top(), rpGrass, true);
        } else {
            rp.colorMultiplier.set((Object)color);
        }
        if (pass == 1) {
            for (Face f : cube.getFaces()) {
                for (Vertex v : f.getVertexes()) {
                    if (!v.name().toLowerCase().contains(name)) continue;
                    v.setAlpha(0);
                }
            }
        }
        this.drawShape(cube, rp);
    }

    public static void setRenderPass(int pass) {
        currentPass = pass;
    }
}

