/*
 * Decompiled with CFR 0.152.
 */
package alexndr.SimpleOres.core;

import alexndr.SimpleOres.api.content.SimpleTab;
import alexndr.SimpleOres.api.helpers.LogHelper;
import alexndr.SimpleOres.api.helpers.StatTriggersHelper;
import alexndr.SimpleOres.api.helpers.UpdateCheckerHelper;
import alexndr.SimpleOres.core.Content;
import alexndr.SimpleOres.core.Recipes;
import alexndr.SimpleOres.core.Settings;
import alexndr.SimpleOres.core.content.MythrilFurnaceTileEntity;
import alexndr.SimpleOres.core.content.OnyxFurnaceTileEntity;
import alexndr.SimpleOres.core.helpers.EventHelper;
import alexndr.SimpleOres.core.helpers.Generator;
import alexndr.SimpleOres.core.helpers.ProxyCommon;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;

@Mod(modid="simpleores", name="SimpleOres 2", version="1.4.3")
public class SimpleOres {
    @SidedProxy(clientSide="alexndr.SimpleOres.core.helpers.ProxyClient", serverSide="alexndr.SimpleOres.core.helpers.ProxyCommon")
    public static ProxyCommon proxy;
    public static SimpleOres INSTANCE;
    public static Item.ToolMaterial toolCopper;
    public static Item.ToolMaterial toolTin;
    public static Item.ToolMaterial toolMythril;
    public static Item.ToolMaterial toolAdamantium;
    public static Item.ToolMaterial toolOnyx;
    public static ItemArmor.ArmorMaterial armorCopper;
    public static ItemArmor.ArmorMaterial armorTin;
    public static ItemArmor.ArmorMaterial armorMythril;
    public static ItemArmor.ArmorMaterial armorAdamantium;
    public static ItemArmor.ArmorMaterial armorOnyx;
    public static int rendererCopper;
    public static int rendererTin;
    public static int rendererMythril;
    public static int rendererAdamantium;
    public static int rendererOnyx;
    public static SimpleTab tabSimpleBlocks;
    public static SimpleTab tabSimpleDecorations;
    public static SimpleTab tabSimpleTools;
    public static SimpleTab tabSimpleCombat;
    public static SimpleTab tabSimpleMaterials;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new EventHelper());
        FMLCommonHandler.instance().bus().register((Object)new EventHelper());
        Settings.doSettings(event);
        this.tabPreInit();
        this.setToolAndArmorStats();
        Content.initialize();
        Recipes.preInitialize();
    }

    @Mod.EventHandler
    public void Init(FMLInitializationEvent event) {
        INSTANCE = this;
        proxy.registerClientTickHandler();
        proxy.setZoomAmounts();
        Recipes.initialize();
        this.tabInit();
        SimpleOres.setAchievementTriggers();
        if (Settings.enableUpdateChecker) {
            UpdateCheckerHelper.checkUpdates("http://dl.dropboxusercontent.com/u/66466201/SimpleOres/SimpleOres%20Core/SimpleOres%202%20Version.txt", "simpleores", "1.4.3", "http://bit.ly/SimpleOres");
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)INSTANCE, (IGuiHandler)proxy);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new Generator(), (int)1);
        GameRegistry.registerTileEntity(MythrilFurnaceTileEntity.class, (String)"mythrilFurnace");
        GameRegistry.registerTileEntity(OnyxFurnaceTileEntity.class, (String)"onyxFurnace");
        LogHelper.verboseInfo("Loaded " + Settings.numCustomGenerationRules + " custom generation rules!");
        rendererCopper = proxy.addArmor("copper");
        rendererMythril = proxy.addArmor("mythril");
        rendererTin = proxy.addArmor("tin");
        rendererAdamantium = proxy.addArmor("adamantium");
        rendererOnyx = proxy.addArmor("onyx");
        SimpleOres.toolCopper.customCraftingMaterial = Content.copper_ingot;
        SimpleOres.toolTin.customCraftingMaterial = Content.tin_ingot;
        SimpleOres.toolMythril.customCraftingMaterial = Content.mythril_ingot;
        SimpleOres.toolAdamantium.customCraftingMaterial = Content.adamantium_ingot;
        SimpleOres.toolOnyx.customCraftingMaterial = Content.onyx_gem;
        SimpleOres.armorCopper.customCraftingMaterial = Content.copper_ingot;
        SimpleOres.armorTin.customCraftingMaterial = Content.tin_ingot;
        SimpleOres.armorMythril.customCraftingMaterial = Content.mythril_ingot;
        SimpleOres.armorAdamantium.customCraftingMaterial = Content.adamantium_ingot;
        SimpleOres.armorOnyx.customCraftingMaterial = Content.onyx_gem;
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    public void tabPreInit() {
        if (Settings.enableSimpleOresTabs) {
            tabSimpleBlocks = new SimpleTab("tabSimpleBlocks");
            if (Settings.enableSeparateTabs) {
                tabSimpleDecorations = new SimpleTab("tabSimpleDecorations");
                tabSimpleTools = new SimpleTab("tabSimpleTools");
                tabSimpleCombat = new SimpleTab("tabSimpleCombat");
                tabSimpleMaterials = new SimpleTab("tabSimpleMaterials");
            }
        }
    }

    public void tabInit() {
        if (Settings.enableSimpleOresTabs) {
            tabSimpleBlocks.setIcon(new ItemStack(Content.copper_ore));
            if (Settings.enableSeparateTabs) {
                tabSimpleDecorations.setIcon(new ItemStack(Content.mythril_furnace_lit));
                tabSimpleTools.setIcon(new ItemStack(Content.onyx_pickaxe));
                tabSimpleCombat.setIcon(new ItemStack(Content.adamantium_helmet));
                tabSimpleMaterials.setIcon(new ItemStack(Content.tin_ingot));
            }
        }
    }

    public void setToolAndArmorStats() {
        toolCopper = EnumHelper.addToolMaterial((String)"COPPER", (int)Settings.copperMiningLevel, (int)Settings.copperUsesNum, (float)Settings.copperMiningSpeed, (float)Settings.copperDamageVsEntity, (int)Settings.copperEnchantability);
        toolTin = EnumHelper.addToolMaterial((String)"TIN", (int)Settings.tinMiningLevel, (int)Settings.tinUsesNum, (float)Settings.tinMiningSpeed, (float)Settings.tinDamageVsEntity, (int)Settings.tinEnchantability);
        toolMythril = EnumHelper.addToolMaterial((String)"MYTHRIL", (int)Settings.mythrilMiningLevel, (int)Settings.mythrilUsesNum, (float)Settings.mythrilMiningSpeed, (float)Settings.mythrilDamageVsEntity, (int)Settings.mythrilEnchantability);
        toolAdamantium = EnumHelper.addToolMaterial((String)"ADAMANTIUM", (int)Settings.adamantiumMiningLevel, (int)Settings.adamantiumUsesNum, (float)Settings.adamantiumMiningSpeed, (float)Settings.adamantiumDamageVsEntity, (int)Settings.adamantiumEnchantability);
        toolOnyx = EnumHelper.addToolMaterial((String)"ONYX", (int)Settings.onyxMiningLevel, (int)Settings.onyxUsesNum, (float)Settings.onyxMiningSpeed, (float)Settings.onyxDamageVsEntity, (int)Settings.onyxEnchantability);
        armorCopper = EnumHelper.addArmorMaterial((String)"COPPER", (int)Settings.copperArmorDurability, (int[])Settings.copperArmorDamageReduction, (int)Settings.copperArmorEnchantability);
        armorTin = EnumHelper.addArmorMaterial((String)"TIN", (int)Settings.tinArmorDurability, (int[])Settings.tinArmorDamageReduction, (int)Settings.tinArmorEnchantability);
        armorMythril = EnumHelper.addArmorMaterial((String)"MYTHRIL", (int)Settings.mythrilArmorDurability, (int[])Settings.mythrilArmorDamageReduction, (int)Settings.mythrilArmorEnchantability);
        armorAdamantium = EnumHelper.addArmorMaterial((String)"ADAMANTIUM", (int)Settings.adamantiumArmorDurability, (int[])Settings.adamantiumArmorDamageReduction, (int)Settings.adamantiumArmorEnchantability);
        armorOnyx = EnumHelper.addArmorMaterial((String)"ONYX", (int)Settings.onyxArmorDurability, (int[])Settings.onyxArmorDamageReduction, (int)Settings.onyxArmorEnchantability);
    }

    public static void setAchievementTriggers() {
        StatTriggersHelper.statTriggers().addCraftingTrigger(new ItemStack(Items.field_151035_b), Content.ironPickAch);
        StatTriggersHelper.statTriggers().addCraftingTrigger(new ItemStack(Content.adamantium_pickaxe), Content.adamantiumPickAch);
        StatTriggersHelper.statTriggers().addCraftingTrigger(new ItemStack(Content.onyx_pickaxe), Content.onyxPickAch);
        StatTriggersHelper.statTriggers().addCraftingTrigger(new ItemStack(Content.mythril_bow), Content.mythrilBowAch);
        StatTriggersHelper.statTriggers().addCraftingTrigger(new ItemStack(Content.onyx_bow), Content.onyxBowAch);
        StatTriggersHelper.statTriggers().addPickupTrigger(new ItemStack(Content.copper_ore), Content.simpleOresAch);
        StatTriggersHelper.statTriggers().addPickupTrigger(new ItemStack(Content.onyx_gem), Content.onyxAch);
        StatTriggersHelper.statTriggers().addPickupTrigger(new ItemStack(Content.adamantium_ore), Content.adamantiumAch);
        StatTriggersHelper.statTriggers().addSmeltingTrigger(new ItemStack(Content.onyx_gem), Content.onyxAch);
    }

    static {
        INSTANCE = new SimpleOres();
    }
}

