/*
 * Decompiled with CFR 0.152.
 */
package acs.tabbychat.core;

import acs.tabbychat.core.ChatChannel;
import acs.tabbychat.core.GuiChatTC;
import acs.tabbychat.core.TCChatLine;
import acs.tabbychat.core.TabbyChat;
import acs.tabbychat.gui.ChatBox;
import acs.tabbychat.gui.ChatScrollBar;
import acs.tabbychat.settings.TimeStampEnum;
import acs.tabbychat.util.ChatComponentUtils;
import acs.tabbychat.util.ComponentList;
import acs.tabbychat.util.TabbyChatUtils;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ChatLine;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiDisconnected;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StringUtils;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

public class GuiNewChatTC
extends GuiNewChat {
    private Minecraft mc;
    public ScaledResolution sr;
    protected int chatWidth = 320;
    public int chatHeight = 0;
    public List<String> field_146248_g;
    public List<TCChatLine> field_146252_h;
    public List<TCChatLine> backupLines;
    private static final ReentrantReadWriteLock chatListLock = new ReentrantReadWriteLock(true);
    private static final Lock chatReadLock = chatListLock.readLock();
    private static final Lock chatWriteLock = chatListLock.writeLock();
    private int scrollOffset = 0;
    public boolean chatScrolled = false;
    protected boolean saveNeeded = true;
    private static GuiNewChatTC instance = null;
    public static TabbyChat tc;
    public static Logger log;

    private GuiNewChatTC(Minecraft par1Minecraft) {
        super(par1Minecraft);
        this.mc = par1Minecraft;
        this.sr = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
        tc = TabbyChat.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChatLines(int _pos, List<TCChatLine> _add) {
        chatReadLock.lock();
        try {
            for (int i = 0; i < _add.size(); ++i) {
                this.field_146252_h.add(_pos, _add.get(i));
                this.backupLines.add(_pos, _add.get(i));
            }
        }
        finally {
            chatReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChatLines(ChatChannel _addChan) {
        chatReadLock.lock();
        try {
            for (int i = 0; i < _addChan.getChatLogSize(); ++i) {
                this.field_146252_h.add(_addChan.getChatLine(i));
                this.backupLines.add(_addChan.getChatLine(i));
            }
        }
        finally {
            chatReadLock.unlock();
        }
    }

    public void func_146239_a(String _msg) {
        if (this.field_146248_g.isEmpty() || !this.field_146248_g.get(this.field_146248_g.size() - 1).equals(_msg)) {
            this.field_146248_g.add(_msg);
        }
    }

    public int chatLinesTraveled() {
        return this.scrollOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearChatLines() {
        this.func_146240_d();
        chatWriteLock.lock();
        try {
            this.field_146252_h.clear();
        }
        finally {
            chatWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_146231_a() {
        if (this.field_146252_h == null || this.backupLines == null) {
            return;
        }
        chatWriteLock.lock();
        try {
            this.field_146252_h.clear();
            this.backupLines.clear();
        }
        finally {
            chatWriteLock.unlock();
        }
        this.field_146248_g.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_146242_c(int _id) {
        ChatLine chatLineRemove = null;
        ChatLine backupLineRemove = null;
        chatReadLock.lock();
        try {
            ChatLine _cl;
            Iterator<TCChatLine> _iter = this.field_146252_h.iterator();
            do {
                if (_iter.hasNext()) continue;
                _iter = this.backupLines.iterator();
                do {
                    if (_iter.hasNext()) continue;
                    return;
                } while ((_cl = (ChatLine)_iter.next()).func_74539_c() != _id);
                backupLineRemove = _cl;
                break;
            } while ((_cl = (ChatLine)_iter.next()).func_74539_c() != _id);
            chatLineRemove = _cl;
        }
        finally {
            chatReadLock.unlock();
        }
        chatWriteLock.lock();
        try {
            if (chatLineRemove != null && chatLineRemove.func_74539_c() == _id) {
                this.field_146252_h.remove(chatLineRemove);
            }
            if (backupLineRemove != null && backupLineRemove.func_74539_c() == _id) {
                this.backupLines.remove(backupLineRemove);
            }
        }
        finally {
            chatWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_146230_a(int currentTick) {
        if (!TabbyChat.liteLoaded && !TabbyChat.modLoaded) {
            TabbyChatUtils.chatGuiTick(this.mc);
        }
        if (this.mc.field_71462_r != null) {
            if (this.mc.field_71462_r instanceof GuiDisconnected || this.mc.field_71462_r instanceof GuiIngameMenu) {
                if (this.saveNeeded) {
                    tc.storeChannelData();
                    TabbyChat.advancedSettings.saveSettingsFile();
                }
                this.saveNeeded = false;
                return;
            }
            this.saveNeeded = true;
        }
        this.sr = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
        int lineCounter = 0;
        int visLineCounter = 0;
        if (this.mc.field_71474_y.field_74343_n != EntityPlayer.EnumChatVisibility.HIDDEN) {
            int maxDisplayedLines = 0;
            boolean chatOpen = false;
            float chatOpacity = this.mc.field_71474_y.field_74357_r * 0.9f + 0.1f;
            int timeStampOffset = 0;
            float chatScaling = this.func_146244_h();
            int fadeTicks = 200;
            int numLinesTotal = 0;
            chatReadLock.lock();
            try {
                numLinesTotal = this.field_146252_h.size();
            }
            finally {
                chatReadLock.unlock();
            }
            chatOpen = this.func_146241_e();
            if (numLinesTotal == 0 && !chatOpen) {
                this.mc.field_71466_p.func_78264_a(TabbyChat.defaultUnicode);
                return;
            }
            if (tc.enabled()) {
                if (TabbyChat.generalSettings.timeStampEnable.getValue().booleanValue()) {
                    timeStampOffset = this.mc.field_71466_p.func_78256_a(((TimeStampEnum)TabbyChat.generalSettings.timeStampStyle.getValue()).maxTime);
                }
                maxDisplayedLines = MathHelper.func_76141_d((float)((float)ChatBox.getChatHeight() / 9.0f));
                if (!chatOpen) {
                    maxDisplayedLines = MathHelper.func_76141_d((float)(TabbyChat.advancedSettings.chatBoxUnfocHeight.getValue().floatValue() * (float)ChatBox.getChatHeight() / 900.0f));
                }
                this.chatWidth = ChatBox.getChatWidth() - timeStampOffset;
                fadeTicks = TabbyChat.advancedSettings.chatFadeTicks.getValue().intValue();
            } else {
                maxDisplayedLines = this.func_146232_i();
                this.chatWidth = MathHelper.func_76123_f((float)((float)this.func_146228_f() / chatScaling));
            }
            GL11.glPushMatrix();
            if (tc.enabled()) {
                GL11.glTranslatef((float)ChatBox.current.x, (float)(48.0f + (float)ChatBox.current.y), (float)0.0f);
            } else {
                GL11.glTranslatef((float)2.0f, (float)29.0f, (float)0.0f);
            }
            GL11.glScalef((float)chatScaling, (float)chatScaling, (float)1.0f);
            int currentOpacity = 0;
            for (lineCounter = 0; lineCounter + this.scrollOffset < numLinesTotal && lineCounter < maxDisplayedLines; ++lineCounter) {
                ArrayList<TCChatLine> msgList;
                block34: {
                    msgList = new ArrayList<TCChatLine>();
                    chatReadLock.lock();
                    try {
                        msgList.add(this.field_146252_h.get(lineCounter + this.scrollOffset));
                        if (msgList.get(0) == null || !((TCChatLine)msgList.get(0)).getChatLineString().func_150254_d().startsWith(" ")) break block34;
                        int sameMsgCounter = 1;
                        while (lineCounter + sameMsgCounter + this.scrollOffset < numLinesTotal && lineCounter + sameMsgCounter < maxDisplayedLines) {
                            TCChatLine checkLine = this.field_146252_h.get(lineCounter + sameMsgCounter + this.scrollOffset);
                            if (checkLine.func_74540_b() != ((TCChatLine)msgList.get(0)).func_74540_b()) {
                                break;
                            }
                            msgList.add(checkLine);
                            if (!checkLine.getChatLineString().func_150254_d().startsWith(" ")) {
                                break;
                            }
                            ++sameMsgCounter;
                        }
                    }
                    finally {
                        chatReadLock.unlock();
                    }
                }
                if (msgList.isEmpty() || msgList.get(0) == null) continue;
                lineCounter += msgList.size() - 1;
                int lineAge = currentTick - ((TCChatLine)msgList.get(0)).func_74540_b();
                if (lineAge >= fadeTicks && !chatOpen) continue;
                if (!chatOpen) {
                    double agePercent = (double)lineAge / (double)fadeTicks;
                    if ((agePercent = 10.0 * (1.0 - agePercent)) < 0.0) {
                        agePercent = 0.0;
                    } else if (agePercent > 1.0) {
                        agePercent = 1.0;
                    }
                    agePercent *= agePercent;
                    currentOpacity = (int)(255.0 * agePercent);
                } else {
                    currentOpacity = 255;
                }
                currentOpacity = (int)((float)currentOpacity * chatOpacity);
                if (currentOpacity <= 3) continue;
                for (int i = 0; i < msgList.size(); ++i) {
                    int textOpacity;
                    int xOrigin = 0;
                    int yOrigin = ChatBox.anchoredTop && tc.enabled() ? -(visLineCounter * 9) + this.chatHeight : -(++visLineCounter) * 9;
                    GuiNewChatTC.func_73734_a((int)xOrigin, (int)yOrigin, (int)(xOrigin + this.chatWidth + timeStampOffset), (int)(yOrigin + 9), (int)(currentOpacity / 2 << 24));
                    GL11.glEnable((int)3042);
                    int idx = ChatBox.anchoredTop && tc.enabled() ? msgList.size() - i - 1 : i;
                    String _chat = tc.enabled() && TabbyChat.generalSettings.timeStampEnable.getValue() != false ? ((TCChatLine)msgList.get((int)idx)).timeStamp + ((TCChatLine)msgList.get(idx)).getChatLineString().func_150254_d() : ((TCChatLine)msgList.get(idx)).getChatLineString().func_150254_d();
                    if (!this.mc.field_71474_y.field_74344_o) {
                        _chat = StringUtils.func_76338_a((String)_chat);
                    }
                    int n = textOpacity = TabbyChat.advancedSettings.textIgnoreOpacity.getValue() != false ? 255 : currentOpacity;
                    if (((TCChatLine)msgList.get(i)).func_74540_b() < 0) {
                        this.mc.field_71466_p.func_78261_a(_chat, xOrigin, yOrigin + 1, 0x888888 + (textOpacity << 24));
                        continue;
                    }
                    this.mc.field_71466_p.func_78261_a(_chat, xOrigin, yOrigin + 1, 0xFFFFFF + (textOpacity << 24));
                }
            }
            this.chatHeight = visLineCounter * 9;
            if (tc.enabled()) {
                if (chatOpen) {
                    ChatBox.setChatSize(this.chatHeight);
                    ChatScrollBar.drawScrollBar();
                    ChatBox.drawChatBoxBorder((Gui)this, true, (int)(255.0f * chatOpacity));
                } else {
                    ChatBox.setUnfocusedHeight(this.chatHeight);
                    ChatBox.drawChatBoxBorder((Gui)this, false, currentOpacity);
                    tc.pollForUnread((Gui)this, currentTick);
                }
            }
            GL11.glPopMatrix();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IChatComponent func_146236_a(int clickX, int clickY) {
        if (!this.func_146241_e()) {
            return null;
        }
        IChatComponent returnMe2 = null;
        Point adjClick = ChatBox.scaleMouseCoords(clickX, clickY);
        int clickXRel = Math.abs(adjClick.x - ChatBox.current.x);
        int clickYRel = Math.abs(adjClick.y - ChatBox.current.y);
        if (clickXRel >= 0 && clickYRel >= 0 && clickXRel < this.chatWidth && clickYRel < this.chatHeight) {
            chatReadLock.lock();
            try {
                int lineIndex;
                int displayedLines = Math.min(this.getHeightSetting() / 9, this.field_146252_h.size());
                if (clickXRel <= ChatBox.getChatWidth() && clickYRel < this.mc.field_71466_p.field_78288_b * displayedLines + displayedLines && (lineIndex = clickYRel / this.mc.field_71466_p.field_78288_b + this.scrollOffset) < displayedLines + this.scrollOffset && this.field_146252_h.get(lineIndex) != null) {
                    TCChatLine chatline = this.field_146252_h.get(lineIndex);
                    clickYRel = 0;
                    for (IChatComponent returnMe2 : chatline.getChatLineString()) {
                        if (!(returnMe2 instanceof ChatComponentText) || (clickYRel += this.mc.field_71466_p.func_78256_a(this.func_146235_b(((ChatComponentText)returnMe2).func_150265_g()))) <= clickXRel) continue;
                        IChatComponent iChatComponent = returnMe2;
                        return iChatComponent;
                    }
                }
            }
            finally {
                chatReadLock.unlock();
            }
        }
        return returnMe2;
    }

    private String func_146235_b(String p_146235_1_) {
        return Minecraft.func_71410_x().field_71474_y.field_74344_o ? p_146235_1_ : EnumChatFormatting.func_110646_a((String)p_146235_1_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void func_146237_a(IChatComponent _msg, int id, int tick, boolean backupFlag) {
        boolean chatOpen = this.func_146241_e();
        boolean isLineOne = true;
        boolean optionalDeletion = false;
        ArrayList<TCChatLine> multiLineChat = new ArrayList<TCChatLine>();
        if (id != 0) {
            optionalDeletion = true;
            this.func_146242_c(id);
        }
        MathHelper.func_76141_d((float)((float)this.func_146228_f() / this.func_146244_h()));
        if (tc.enabled()) {
            if (!backupFlag) {
                tc.checkServer();
            }
            ChatBox.getMinChatWidth();
        }
        if (TabbyChat.generalSettings.timeStampEnable.getValue().booleanValue()) {
            this.mc.field_71466_p.func_78256_a(TabbyChat.generalSettings.timeStampStyle.getValue().toString());
        }
        ComponentList chat = ChatComponentUtils.split(_msg, this.chatWidth);
        for (IChatComponent ichat : chat) {
            if (chatOpen && this.scrollOffset > 0) {
                this.chatScrolled = true;
                this.func_146229_b(1);
            }
            if (!isLineOne) {
                ichat = new ChatComponentText(" ").func_150257_a(ichat);
            }
            multiLineChat.add(new TCChatLine(tick, ichat, id));
            isLineOne = false;
        }
        if (tc.enabled() && !optionalDeletion && !backupFlag) {
            tc.processChat(multiLineChat);
        } else {
            int _len = multiLineChat.size();
            chatWriteLock.lock();
            try {
                for (int i = 0; i < _len; ++i) {
                    this.field_146252_h.add(0, (TCChatLine)multiLineChat.get(i));
                    if (backupFlag) continue;
                    this.backupLines.add(0, (TCChatLine)multiLineChat.get(i));
                }
            }
            finally {
                chatWriteLock.unlock();
            }
        }
        if (GuiNewChatTC.tc.serverDataLock.availablePermits() < 1) {
            return;
        }
        int maxChats = tc.enabled() ? Integer.parseInt(TabbyChat.advancedSettings.chatScrollHistory.getValue()) : 100;
        int numChats = 0;
        chatReadLock.lock();
        try {
            numChats = this.field_146252_h.size();
        }
        finally {
            chatReadLock.unlock();
        }
        if (numChats <= maxChats) {
            return;
        }
        chatWriteLock.lock();
        try {
            while (this.field_146252_h.size() > maxChats) {
                this.field_146252_h.remove(this.field_146252_h.size() - 1);
            }
            if (!backupFlag) {
                while (this.backupLines.size() > maxChats) {
                    this.backupLines.remove(this.backupLines.size() - 1);
                }
            }
        }
        finally {
            chatWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_146245_b() {
        int backupChats = 0;
        chatWriteLock.lock();
        try {
            this.field_146252_h.clear();
            backupChats = this.backupLines.size();
        }
        finally {
            chatWriteLock.unlock();
        }
        this.func_146240_d();
        for (int i = backupChats - 1; i >= 0; --i) {
            chatReadLock.lock();
            ChatLine _cl = null;
            try {
                _cl = this.backupLines.get(i);
            }
            finally {
                chatReadLock.unlock();
            }
            if (_cl == null) continue;
            this.func_146237_a(_cl.func_151461_a(), _cl.func_74539_c(), _cl.func_74540_b(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int GetChatSize() {
        int theSize = 0;
        chatReadLock.lock();
        try {
            theSize = this.field_146252_h.size();
        }
        finally {
            chatReadLock.unlock();
        }
        return theSize;
    }

    public boolean func_146241_e() {
        return this.mc.field_71462_r instanceof GuiChat || this.mc.field_71462_r instanceof GuiChatTC;
    }

    public int getHeightSetting() {
        if (tc.enabled()) {
            return ChatBox.getChatHeight();
        }
        return GuiNewChatTC.func_146243_b((float)this.mc.field_71474_y.field_96694_H);
    }

    public static GuiNewChatTC getInstance() {
        if (instance == null) {
            instance = new GuiNewChatTC(Minecraft.func_71410_x());
            tc = TabbyChat.getInstance(instance);
            TabbyChatUtils.hookIntoChat(instance);
            if (!tc.enabled()) {
                tc.disable();
            } else {
                tc.enable();
            }
        }
        return instance;
    }

    public float getScaleSetting() {
        float theSetting = this.func_146244_h();
        return (float)Math.round(theSetting * 100.0f) / 100.0f;
    }

    public List func_146238_c() {
        return this.field_146248_g;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeChatLines(ChatChannel _new) {
        int newSize = _new.getChatLogSize();
        chatWriteLock.lock();
        try {
            List<TCChatLine> _current = this.field_146252_h;
            if (_new == null || newSize <= 0) {
                return;
            }
            int _c = 0;
            int _n = 0;
            int dt = 0;
            while (_n < newSize && _c < _current.size()) {
                dt = _new.getChatLine(_n).func_74540_b() - _current.get(_c).func_74540_b();
                if (dt > 0) {
                    _current.add(_c, _new.getChatLine(_n));
                    ++_n;
                    continue;
                }
                if (dt == 0) {
                    if (_current.get(_c).equals(_new.getChatLine(_n)) || _current.get(_c).getChatLineString().equals(_new.getChatLine(_n).getChatLineString())) {
                        ++_c;
                        ++_n;
                        continue;
                    }
                    ++_c;
                    continue;
                }
                ++_c;
            }
            while (_n < newSize) {
                _current.add(_current.size(), _new.getChatLine(_n));
                ++_n;
            }
        }
        finally {
            chatWriteLock.unlock();
        }
    }

    public void func_146227_a(IChatComponent _msg) {
        this.func_146234_a(_msg, 0);
    }

    public void func_146234_a(IChatComponent _msg, int flag) {
        this.func_146237_a(_msg, flag, this.mc.field_71456_v.func_73834_c(), false);
        log.info("[CHAT] " + _msg.func_150260_c());
    }

    public void func_146240_d() {
        this.scrollOffset = 0;
        this.chatScrolled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_146229_b(int _lines) {
        int maxLineDisplay;
        if (tc.enabled()) {
            maxLineDisplay = Math.round((float)ChatBox.getChatHeight() / 9.0f);
            if (!this.func_146241_e()) {
                maxLineDisplay = Math.round((float)maxLineDisplay * TabbyChat.advancedSettings.chatBoxUnfocHeight.getValue().floatValue() / 100.0f);
            }
        } else {
            maxLineDisplay = this.func_146232_i();
        }
        this.scrollOffset += _lines;
        int numLines = 0;
        chatReadLock.lock();
        try {
            numLines = this.field_146252_h.size();
        }
        finally {
            chatReadLock.unlock();
        }
        this.scrollOffset = Math.min(this.scrollOffset, numLines - maxLineDisplay);
        if (this.scrollOffset <= 0) {
            this.scrollOffset = 0;
            this.chatScrolled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChatLines(int _pos, List<TCChatLine> _add) {
        int clsize = 0;
        boolean addInstead = false;
        chatReadLock.lock();
        try {
            clsize = Math.min(this.field_146252_h.size(), this.backupLines.size());
        }
        finally {
            chatReadLock.unlock();
        }
        if (_pos + _add.size() > clsize) {
            addInstead = true;
        }
        chatWriteLock.lock();
        try {
            for (int i = _add.size() - 1; i >= 0; --i) {
                int j = _add.size() - i - 1;
                if (addInstead) {
                    this.field_146252_h.add(_add.get(i));
                    this.backupLines.add(_add.get(i));
                    continue;
                }
                this.field_146252_h.set(_pos + j, _add.get(i));
                this.backupLines.set(_pos + j, _add.get(i));
            }
        }
        finally {
            chatWriteLock.unlock();
        }
    }

    public void setVisChatLines(int _move) {
        this.scrollOffset = _move;
    }

    static {
        log = TabbyChatUtils.log;
    }
}

