/*
 * Decompiled with CFR 0.152.
 */
package acs.tabbychat.gui;

import acs.tabbychat.core.TabbyChat;
import acs.tabbychat.gui.ITCSettingsGUI;
import acs.tabbychat.gui.PrefsButton;
import acs.tabbychat.settings.ITCSetting;
import acs.tabbychat.settings.TCSettingSlider;
import acs.tabbychat.settings.TCSettingTextBox;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import org.lwjgl.input.Keyboard;

abstract class TCSettingsGUI
extends GuiScreen
implements ITCSettingsGUI {
    protected static TabbyChat tc;
    protected Minecraft field_146297_k = Minecraft.func_71410_x();
    protected int lastOpened = 0;
    protected String name;
    protected String propertyPrefix;
    protected int bgcolor = 1722148836;
    protected int id = 9000;
    protected static List<TCSettingsGUI> ScreenList;
    protected File settingsFile;

    private TCSettingsGUI() {
        ScreenList.add(this);
    }

    public TCSettingsGUI(TabbyChat _tc) {
        this();
        tc = _tc;
    }

    public void func_146284_a(GuiButton button) {
        if (button instanceof ITCSetting && ((ITCSetting)button).getType() != "textbox") {
            ((ITCSetting)button).actionPerformed();
        } else if (button.field_146127_k == 8901) {
            for (TCSettingsGUI screen : ScreenList) {
                screen.storeTempVars();
                screen.saveSettingsFile();
            }
            tc.reloadSettingsData(true);
            this.field_146297_k.func_147108_a((GuiScreen)null);
            if (TabbyChat.generalSettings.tabbyChatEnable.getValue().booleanValue()) {
                tc.resetDisplayedChat();
            }
        } else if (button.field_146127_k == 8902) {
            for (TCSettingsGUI screen : ScreenList) {
                screen.resetTempVars();
            }
            this.field_146297_k.func_147108_a((GuiScreen)null);
            if (TabbyChat.generalSettings.tabbyChatEnable.getValue().booleanValue()) {
                tc.resetDisplayedChat();
            }
        } else {
            for (int i = 0; i < ScreenList.size(); ++i) {
                if (button.field_146127_k != TCSettingsGUI.ScreenList.get((int)i).id) continue;
                this.field_146297_k.func_147108_a((GuiScreen)ScreenList.get(i));
            }
        }
        this.validateButtonStates();
    }

    @Override
    public void defineDrawableSettings() {
    }

    public void func_73863_a(int x, int y, float f) {
        int i;
        int effLeft = (this.field_146294_l - 300) / 2;
        int absLeft = effLeft - 4;
        int effTop = (this.field_146295_m - 180) / 2;
        int absTop = effTop - 4;
        TCSettingsGUI.func_73734_a((int)absLeft, (int)absTop, (int)(absLeft + 300 + 8), (int)(absTop + 180 + 8), (int)-2013265920);
        TCSettingsGUI.func_73734_a((int)(absLeft + 45), (int)absTop, (int)(absLeft + 46), (int)(absTop + 180), (int)0x66FFFFFF);
        for (i = 0; i < ScreenList.size(); ++i) {
            if (ScreenList.get(i) == this) {
                int curWidth;
                int tabDist = Math.max(this.field_146297_k.field_71466_p.func_78256_a(TCSettingsGUI.ScreenList.get((int)i).name) + 4 - 40, 25);
                if (0 <= this.lastOpened && this.lastOpened <= 5) {
                    curWidth = 45 + this.lastOpened * tabDist / 5;
                    ++this.lastOpened;
                } else {
                    curWidth = tabDist + 45;
                }
                TCSettingsGUI.func_73734_a((int)(absLeft - curWidth + 45), (int)(effTop + 30 * i), (int)(absLeft + 45), (int)(effTop + 30 * i + 20), (int)TCSettingsGUI.ScreenList.get((int)i).bgcolor);
                this.func_73731_b(this.field_146297_k.field_71466_p, this.field_146297_k.field_71466_p.func_78269_a(TCSettingsGUI.ScreenList.get((int)i).name, curWidth - 5), effLeft - curWidth + 45, effTop + 6 + 30 * i, 0xFFFFFF);
                continue;
            }
            TCSettingsGUI.func_73734_a((int)absLeft, (int)(effTop + 30 * i), (int)(absLeft + 45), (int)(effTop + 30 * i + 20), (int)TCSettingsGUI.ScreenList.get((int)i).bgcolor);
        }
        for (i = 0; i < this.field_146292_n.size(); ++i) {
            ((GuiButton)this.field_146292_n.get(i)).func_146112_a(this.field_146297_k, x, y);
        }
    }

    public void func_146274_d() {
        super.func_146274_d();
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            ITCSetting tmp;
            if (!(this.field_146292_n.get(i) instanceof ITCSetting) || (tmp = (ITCSetting)this.field_146292_n.get(i)).getType() != "slider") continue;
            ((TCSettingSlider)tmp).handleMouseInput();
        }
    }

    @Override
    public void initDrawableSettings() {
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.clear();
        int effLeft = (this.field_146294_l - 300) / 2;
        int effTop = (this.field_146295_m - 180) / 2;
        this.lastOpened = 0;
        int effRight = (this.field_146294_l + 300) / 2;
        int bW = 40;
        int bH = 14;
        PrefsButton savePrefs = new PrefsButton(8901, effRight + 10, (this.field_146295_m + 180) / 2 - bH, bW, bH, I18n.func_135052_a((String)"settings.save", (Object[])new Object[0]));
        this.field_146292_n.add(savePrefs);
        PrefsButton cancelPrefs = new PrefsButton(8902, effRight + 10, (this.field_146295_m + 180) / 2 - 2 * bH - 2, bW, bH, I18n.func_135052_a((String)"settings.cancel", (Object[])new Object[0]));
        this.field_146292_n.add(cancelPrefs);
        for (int i = 0; i < ScreenList.size(); ++i) {
            TCSettingsGUI.ScreenList.get((int)i).id = 9000 + i;
            TCSettingsGUI.ScreenList.get((int)i).name = I18n.func_135052_a((String)(TCSettingsGUI.ScreenList.get((int)i).propertyPrefix + ".name"), (Object[])new Object[0]);
            if (ScreenList.get(i) == this) continue;
            this.field_146292_n.add(new PrefsButton(TCSettingsGUI.ScreenList.get((int)i).id, effLeft, effTop + 30 * i, 45, 20, this.field_146297_k.field_71466_p.func_78269_a(TCSettingsGUI.ScreenList.get((int)i).name, 35) + "..."));
            ((PrefsButton)((Object)this.field_146292_n.get((int)(this.field_146292_n.size() - 1)))).bgcolor = 0;
        }
        this.defineDrawableSettings();
        this.initDrawableSettings();
        this.validateButtonStates();
        for (Object drawable : this.field_146292_n) {
            if (!(drawable instanceof ITCSetting)) continue;
            ((ITCSetting)drawable).resetDescription();
        }
    }

    public void func_73869_a(char par1, int par2) {
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            ITCSetting tmp;
            if (!ITCSetting.class.isInstance(this.field_146292_n.get(i)) || (tmp = (ITCSetting)this.field_146292_n.get(i)).getType() != "textbox") continue;
            ((TCSettingTextBox)tmp).keyTyped(par1, par2);
        }
        super.func_73869_a(par1, par2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties loadSettingsFile() {
        Properties settingsTable = new Properties();
        if (this.settingsFile == null) {
            return settingsTable;
        }
        if (!this.settingsFile.exists()) {
            return settingsTable;
        }
        FileInputStream fInStream = null;
        BufferedInputStream bInStream = null;
        try {
            fInStream = new FileInputStream(this.settingsFile);
            bInStream = new BufferedInputStream(fInStream);
            settingsTable.load(bInStream);
        }
        catch (Exception e) {
            TabbyChat.printException("Error while reading settings from file '" + this.settingsFile + "'", e);
        }
        finally {
            try {
                if (bInStream != null) {
                    bInStream.close();
                }
                if (fInStream != null) {
                    fInStream.close();
                }
            }
            catch (Exception ignored) {}
        }
        for (Object drawable : this.field_146292_n) {
            if (!(drawable instanceof ITCSetting)) continue;
            ((ITCSetting)drawable).loadSelfFromProps(settingsTable);
        }
        this.resetTempVars();
        return settingsTable;
    }

    public void func_73864_a(int par1, int par2, int par3) {
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            ITCSetting tmp;
            if (!(this.field_146292_n.get(i) instanceof ITCSetting) || (tmp = (ITCSetting)this.field_146292_n.get(i)).getType() != "textbox" && tmp.getType() != "enum" && tmp.getType() != "slider") continue;
            tmp.mouseClicked(par1, par2, par3);
        }
        super.func_73864_a(par1, par2, par3);
    }

    @Override
    public void resetTempVars() {
        for (Object drawable : this.field_146292_n) {
            if (!(drawable instanceof ITCSetting)) continue;
            ((ITCSetting)drawable).reset();
        }
    }

    @Override
    public int rowY(int rowNum) {
        return (this.field_146295_m - 180) / 2 + (rowNum - 1) * 18;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveSettingsFile(Properties settingsTable) {
        if (this.settingsFile == null) {
            return;
        }
        if (!this.settingsFile.getParentFile().exists()) {
            this.settingsFile.getParentFile().mkdirs();
        }
        for (Object drawable : this.field_146292_n) {
            if (!(drawable instanceof ITCSetting)) continue;
            ((ITCSetting)drawable).saveSelfToProps(settingsTable);
        }
        FileOutputStream fOutStream = null;
        FilterOutputStream bOutStream = null;
        try {
            fOutStream = new FileOutputStream(this.settingsFile);
            bOutStream = new BufferedOutputStream(fOutStream);
            settingsTable.store(bOutStream, this.propertyPrefix);
        }
        catch (Exception e) {
            TabbyChat.printException("Error while writing settings to file '" + this.settingsFile + "'", e);
        }
        finally {
            try {
                if (bOutStream != null) {
                    bOutStream.close();
                }
                if (fOutStream != null) {
                    fOutStream.close();
                }
            }
            catch (Exception ignored) {}
        }
    }

    @Override
    public void saveSettingsFile() {
        this.saveSettingsFile(new Properties());
    }

    @Override
    public void storeTempVars() {
        for (Object drawable : this.field_146292_n) {
            if (!(drawable instanceof ITCSetting)) continue;
            ((ITCSetting)drawable).save();
        }
    }

    @Override
    public void validateButtonStates() {
    }

    static {
        ScreenList = new ArrayList<TCSettingsGUI>();
    }
}

