/*
 * Decompiled with CFR 0.152.
 */
package acs.tabbychat.settings;

import acs.tabbychat.gui.PrefsButton;
import acs.tabbychat.jazzy.TCSpellCheckManager;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.MathHelper;
import org.apache.commons.io.IOUtils;

public class TCSettingList
extends Gui {
    private List<Entry> list = Lists.newArrayList();
    private List<Entry> selected = Lists.newArrayList();
    private final File dictionary;
    private int currentPage = 1;
    private int id = 0;
    private int xPosition;
    private int yPosition;
    private int width;
    private int height;

    public TCSettingList(File file) {
        this.dictionary = file;
    }

    public void drawList(Minecraft mc, int cursorX, int cursorY) {
        FontRenderer fr = mc.field_71466_p;
        Gui.func_73734_a((int)this.xPosition, (int)this.yPosition, (int)(this.xPosition + this.width), (int)(this.yPosition + this.height), (int)Integer.MIN_VALUE);
        Gui.func_73734_a((int)(this.xPosition - 1), (int)(this.yPosition - 1), (int)this.xPosition, (int)(this.yPosition + this.height), (int)-16777215);
        Gui.func_73734_a((int)(this.xPosition - 1), (int)(this.yPosition + this.height), (int)(this.xPosition + this.width + 1), (int)(this.yPosition + this.height + 1), (int)-16777215);
        Gui.func_73734_a((int)(this.xPosition + this.width), (int)(this.yPosition + this.height + 1), (int)(this.xPosition + this.width + 1), (int)(this.yPosition - 1), (int)-16777215);
        Gui.func_73734_a((int)(this.xPosition - 1), (int)(this.yPosition - 1), (int)(this.xPosition + this.width + 1), (int)this.yPosition, (int)-16777215);
        int i = 0;
        for (Entry entry : this.getVisible()) {
            entry.setPos(i);
            entry.func_146112_a(mc, cursorX, cursorY);
            ++i;
        }
    }

    public boolean contains(String srt) {
        for (Entry entry : this.list) {
            if (!srt.equals(entry.field_146126_j)) continue;
            return true;
        }
        return false;
    }

    public void addToList(String str) {
        if (str == null || str.isEmpty()) {
            return;
        }
        if (!this.contains(str)) {
            char[] chararray = str.toCharArray();
            int j = 0;
            block0: for (Entry entry : this.list) {
                char c1;
                char c;
                char[] chararray1 = entry.field_146126_j.toCharArray();
                for (int i = 0; i < Math.min(chararray.length, chararray1.length) && (c = chararray[i]) <= (c1 = chararray1[i]); ++i) {
                    if (c == c1 || c >= c1) continue;
                    this.list.add(j, new Entry(this.id, str));
                    break block0;
                }
                ++j;
            }
            if (!this.contains(str)) {
                this.list.add(new Entry(this.id, str));
            }
            ++this.id;
        }
    }

    public void removeFromList(String str) {
        for (Entry entry : this.list) {
            if (!str.equals(entry.field_146126_j)) continue;
            this.list.remove((Object)entry);
            this.deselectEntry(entry);
        }
    }

    public void clearList() {
        this.list.clear();
    }

    public List<Entry> getEntries() {
        return new ArrayList<Entry>(this.list);
    }

    public List<Entry> getVisible() {
        ArrayList list = Lists.newArrayList();
        int i1 = 0;
        for (int i = 0; i < this.currentPage; ++i) {
            list.clear();
            int i2 = 0;
            while (i1 < this.list.size() && list.size() < 8) {
                Entry entry = this.list.get(i1);
                entry.setPos(i2);
                list.add(entry);
                ++i1;
                ++i2;
            }
        }
        return list;
    }

    public List<Entry> getSelected() {
        return new ArrayList<Entry>(this.selected);
    }

    public void selectEntry(Entry entry) {
        if (!this.list.contains((Object)entry)) {
            this.list.add(entry);
        }
        if (!entry.isSelected()) {
            this.selected.add(entry);
        }
    }

    public void deselectEntry(Entry entry) {
        if (entry.isSelected()) {
            this.selected.remove((Object)entry);
        }
    }

    public void clearSelection() {
        this.selected.clear();
    }

    public int getTotalPages() {
        double pages = (double)this.list.size() / 8.0;
        return MathHelper.func_76143_f((double)pages);
    }

    public Object getPageNum() {
        return this.currentPage;
    }

    public void nextPage() {
        this.currentPage = Math.min(this.currentPage + 1, this.getTotalPages());
    }

    public void previousPage() {
        this.currentPage = Math.max(this.currentPage - 1, 1);
    }

    public void saveEntries(File file) throws IOException {
        FileWriter writer = new FileWriter(file);
        for (Entry entry : this.list) {
            writer.write(entry.field_146126_j);
            writer.write("\n");
        }
        writer.close();
        this.loadEntries(file);
    }

    public void loadEntries(File file) throws IOException {
        this.clearList();
        for (String val : IOUtils.readLines((Reader)new FileReader(file))) {
            TCSpellCheckManager.getInstance().addToIgnoredWords(val);
            this.addToList(val);
        }
    }

    public void mouseClicked(int x, int y, int button) {
        if (x > this.x() && x < this.x() + this.width() && y > this.y() && y < this.y() + this.height()) {
            for (Entry entry : this.getVisible()) {
                if (y <= entry.y() || y >= entry.y() + entry.height()) continue;
                entry.func_146113_a(Minecraft.func_71410_x().func_147118_V());
                this.actionPerformed(entry);
                return;
            }
        }
    }

    private void actionPerformed(Entry entry) {
        entry.setSelected(!entry.isSelected());
    }

    public int width() {
        return this.width;
    }

    public void width(int w) {
        this.width = w;
    }

    public int height() {
        return this.height;
    }

    public void height(int h) {
        this.height = h;
    }

    public int x() {
        return this.xPosition;
    }

    public void x(int x) {
        this.xPosition = x;
    }

    public int y() {
        return this.yPosition;
    }

    public void y(int y) {
        this.yPosition = y;
    }

    public class Entry
    extends PrefsButton {
        private TCSettingList list;
        private int pos;

        public Entry(int id, String value) {
            super(id, TCSettingList.this.x(), 0, TCSettingList.this.width(), 12, value);
            this.list = TCSettingList.this;
        }

        public void setPos(int y) {
            this.pos = y;
        }

        public boolean isSelected() {
            return this.list.getSelected().contains((Object)this);
        }

        public void setSelected(boolean value) {
            if (value) {
                this.list.selectEntry(this);
            } else {
                this.list.deselectEntry(this);
            }
        }

        @Override
        public void func_146112_a(Minecraft mc, int x, int y) {
            this.bgcolor = this.isSelected() ? -577136231 : -587202560;
            this.y(this.list.y() + this.pos * 12);
            super.func_146112_a(mc, x, y);
        }

        public void remove() {
            this.list.list.remove((Object)this);
        }

        public void keyClicked(int x, int y, int button) {
        }
    }
}

