/*
 * Decompiled with CFR 0.152.
 */
package acs.tabbychat.util;

import io.netty.util.NetUtil;

public class IPResolver {
    private String host;
    private int port;

    public IPResolver(String ipaddress) {
        EnumConnection type = IPResolver.getType(ipaddress);
        switch (type) {
            case DOMAIN: 
            case IPv4: {
                if (ipaddress.contains(":")) {
                    this.host = ipaddress.substring(0, ipaddress.lastIndexOf(58));
                    this.port = Integer.parseInt(ipaddress.substring(ipaddress.lastIndexOf(58) + 1));
                    break;
                }
                this.host = ipaddress;
                this.port = 25565;
                break;
            }
            case IPv6: {
                if (ipaddress.startsWith("[") && ipaddress.contains("]:")) {
                    this.host = ipaddress.substring(0, ipaddress.lastIndexOf(58));
                    this.port = Integer.parseInt(ipaddress.substring(ipaddress.lastIndexOf(58) + 1));
                    break;
                }
                this.host = ipaddress;
                this.port = 25565;
            }
        }
        if (this.host.isEmpty()) {
            this.host = "localhost";
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    private static EnumConnection getType(String ipaddress) {
        if (NetUtil.isValidIpV4Address((String)ipaddress)) {
            return EnumConnection.IPv4;
        }
        if (NetUtil.isValidIpV6Address((String)ipaddress)) {
            return EnumConnection.IPv6;
        }
        return EnumConnection.DOMAIN;
    }

    public boolean hasPort() {
        return this.port != 25565 || this.port != -1;
    }

    public String getAddress() {
        return this.host + (this.hasPort() ? "" : ":" + this.port);
    }

    public String getSafeAddress() {
        return this.host.replace(':', '_') + (this.port == 25565 ? "" : "(" + this.port + ")");
    }

    private static enum EnumConnection {
        IPv4,
        IPv6,
        DOMAIN;

    }
}

