/*
 * Decompiled with CFR 0.152.
 */
package acs.tabbychat.util;

import acs.tabbychat.api.TCExtensionManager;
import acs.tabbychat.compat.MacroKeybindCompat;
import acs.tabbychat.core.ChatChannel;
import acs.tabbychat.core.GuiChatTC;
import acs.tabbychat.core.GuiNewChatTC;
import acs.tabbychat.core.GuiSleepTC;
import acs.tabbychat.core.TCChatLine;
import acs.tabbychat.core.TabbyChat;
import acs.tabbychat.gui.ITCSettingsGUI;
import acs.tabbychat.gui.context.ChatContextMenu;
import acs.tabbychat.gui.context.ContextCopy;
import acs.tabbychat.gui.context.ContextCut;
import acs.tabbychat.gui.context.ContextPaste;
import acs.tabbychat.gui.context.ContextSpellingSuggestion;
import acs.tabbychat.settings.ChannelDelimEnum;
import acs.tabbychat.settings.ColorCodeEnum;
import acs.tabbychat.settings.FormatCodeEnum;
import acs.tabbychat.settings.NotificationSoundEnum;
import acs.tabbychat.settings.TimeStampEnum;
import acs.tabbychat.threads.BackgroundChatThread;
import acs.tabbychat.util.ComponentList;
import acs.tabbychat.util.IPResolver;
import com.google.common.collect.Lists;
import com.mumfrey.liteloader.core.LiteLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSleepMP;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import org.apache.commons.compress.compressors.gzip.GzipUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TabbyChatUtils {
    private static Calendar logDay = Calendar.getInstance();
    private static File logDir = new File(new File(Minecraft.func_71410_x().field_71412_D, "logs"), "TabbyChat");
    private static SimpleDateFormat logNameFormat = new SimpleDateFormat("'_'MM-dd-yyyy'.log'");
    public static final String version = "1.11.1.59";
    public static final String name = "TabbyChat";
    public static final String modid = "tabbychat";
    public static Logger log = LogManager.getLogger((String)"TabbyChat");

    public static void startup() {
        try {
            Class.forName("net.minecraftforge.common.MinecraftForge");
            TabbyChat.forgePresent = true;
            log.info("MinecraftForge detected.  Will check for client-commands.");
        }
        catch (ClassNotFoundException e) {
            TabbyChat.forgePresent = false;
        }
        TabbyChatUtils.compressLogs();
        ChatContextMenu.addContext(new ContextSpellingSuggestion());
        ChatContextMenu.addContext(new ContextCut());
        ChatContextMenu.addContext(new ContextCopy());
        ChatContextMenu.addContext(new ContextPaste());
        TCExtensionManager.INSTANCE.registerExtension(MacroKeybindCompat.class);
    }

    private static void compressLogs() {
        if (!logDir.exists()) {
            return;
        }
        Collection logs = FileUtils.listFiles((File)logDir, (String[])new String[]{"txt", "log"}, (boolean)true);
        for (File file : logs) {
            String name = file.getName();
            if (name.contains(logNameFormat.format(logDay.getTime()))) continue;
            try {
                TabbyChatUtils.gzipFile(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void gzipFile(File file) throws IOException {
        File dest = new File(file.getParentFile(), GzipUtils.getCompressedFilename((String)file.getName()));
        FileOutputStream os = new FileOutputStream(dest);
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new GZIPOutputStream(os), "UTF-8");
            try {
                writer.write(FileUtils.readFileToString((File)file));
            }
            finally {
                writer.close();
                file.delete();
            }
        }
        finally {
            os.close();
        }
    }

    public static void chatGuiTick(Minecraft mc) {
        GuiScreen screen = mc.field_71462_r;
        if (screen == null) {
            return;
        }
        if (!(screen instanceof GuiChat)) {
            return;
        }
        if (screen.getClass() == GuiChatTC.class) {
            return;
        }
        if (screen.getClass() == GuiSleepTC.class) {
            return;
        }
        String inputBuffer = "";
        try {
            int ind = 0;
            for (Field fields : GuiChat.class.getDeclaredFields()) {
                if (fields.getType() != String.class) continue;
                if (ind == 1) {
                    fields.setAccessible(true);
                    inputBuffer = (String)fields.get(mc.field_71462_r);
                    break;
                }
                ++ind;
            }
        }
        catch (Exception e) {
            TabbyChat.printException("Unable to display chat interface", e);
        }
        if (screen instanceof GuiSleepMP) {
            mc.func_147108_a((GuiScreen)new GuiSleepTC());
        } else {
            mc.func_147108_a((GuiScreen)new GuiChatTC(inputBuffer));
        }
    }

    public static ComponentList chatLinesToComponent(List<TCChatLine> lines) {
        ComponentList result = ComponentList.newInstance();
        for (TCChatLine line : lines) {
            result.add(line.getChatLineString());
        }
        return result;
    }

    public static ServerData getServerData() {
        Minecraft mc = Minecraft.func_71410_x();
        ServerData serverData = null;
        for (Field field : Minecraft.class.getDeclaredFields()) {
            if (field.getType() != ServerData.class) continue;
            field.setAccessible(true);
            try {
                serverData = (ServerData)field.get(mc);
            }
            catch (Exception e) {
                TabbyChat.printException("Unable to find server information", e);
            }
            break;
        }
        return serverData;
    }

    public static File getServerDir() {
        String ip = new IPResolver(TabbyChatUtils.getServerIp()).getSafeAddress();
        return new File(ITCSettingsGUI.tabbyChatDir, ip);
    }

    public static String getServerIp() {
        String ip = Minecraft.func_71410_x().func_71356_B() ? "singleplayer" : (TabbyChatUtils.getServerData() == null ? "unknown" : TabbyChatUtils.getServerData().field_78845_b);
        return ip;
    }

    public static File getTabbyChatDir() {
        if (TabbyChat.liteLoaded) {
            return new File(LiteLoader.getCommonConfigFolder(), modid);
        }
        return new File(new File(Minecraft.func_71410_x().field_71412_D, "config"), modid);
    }

    public static void hookIntoChat(GuiNewChatTC _gnc) {
        if (Minecraft.func_71410_x().field_71456_v.func_146158_b().getClass() != GuiNewChatTC.class) {
            try {
                Class<GuiIngame> IngameGui = GuiIngame.class;
                Field persistantGuiField = IngameGui.getDeclaredFields()[6];
                persistantGuiField.setAccessible(true);
                persistantGuiField.set(Minecraft.func_71410_x().field_71456_v, (Object)_gnc);
                int tmp = 0;
                for (Field fields : GuiNewChat.class.getDeclaredFields()) {
                    if (fields.getType() != List.class) continue;
                    fields.setAccessible(true);
                    if (tmp == 0) {
                        _gnc.field_146248_g = (List)fields.get((Object)_gnc);
                    } else if (tmp == 1) {
                        _gnc.backupLines = (List)fields.get((Object)_gnc);
                    } else if (tmp == 2) {
                        _gnc.field_146252_h = (List)fields.get((Object)_gnc);
                        break;
                    }
                    ++tmp;
                }
            }
            catch (Exception e) {
                TabbyChat.printException("Error loading chat hook.", e);
            }
        }
    }

    public static void logChat(String theChat, ChatChannel theChannel) {
        String basename;
        File fileDir;
        Calendar tmpcal = Calendar.getInstance();
        if (theChannel == null || theChannel.getTitle() == null) {
            theChannel = new ChatChannel("*");
        }
        if (TabbyChatUtils.getServerIp() == "singleplayer") {
            IntegratedServer ms = Minecraft.func_71410_x().func_71401_C();
            fileDir = new File(new File(logDir, "singleplayer"), ms.func_71221_J());
        } else {
            fileDir = new File(logDir, new IPResolver(TabbyChatUtils.getServerIp()).getSafeAddress());
        }
        if (!theChannel.getTitle().equals("*")) {
            fileDir = new File(fileDir, theChannel.getTitle());
            basename = theChannel.getTitle();
        } else {
            basename = "all";
        }
        if (theChannel.getLogFile() == null || tmpcal.get(6) != logDay.get(6)) {
            logDay = tmpcal;
            theChannel.setLogFile(new File(fileDir, basename + logNameFormat.format(logDay.getTime())));
        }
        if (!theChannel.getLogFile().exists()) {
            try {
                fileDir.mkdirs();
                theChannel.getLogFile().createNewFile();
            }
            catch (IOException e) {
                TabbyChat.printErr("Cannot create log file : '" + e.getLocalizedMessage() + "' : " + e.toString());
                return;
            }
        }
        try {
            FileUtils.writeLines((File)theChannel.getLogFile(), (String)"UTF-8", (Collection)Lists.newArrayList((Object[])new String[]{theChat.trim()}), (boolean)true);
        }
        catch (IOException e) {
            TabbyChat.printErr("Cannot write to log file : '" + e.getLocalizedMessage() + "' : " + e.toString());
            return;
        }
    }

    public static Float median(float val1, float val2, float val3) {
        if (val1 < val2 && val1 < val3) {
            return Float.valueOf(Math.min(val2, val3));
        }
        if (val1 > val2 && val1 > val3) {
            return Float.valueOf(Math.max(val2, val3));
        }
        return Float.valueOf(val1);
    }

    public static ColorCodeEnum parseColor(Object _input) {
        if (_input == null) {
            return null;
        }
        String input = _input.toString();
        try {
            return ColorCodeEnum.valueOf(input);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static ChannelDelimEnum parseDelimiters(Object _input) {
        if (_input == null) {
            return null;
        }
        String input = _input.toString();
        try {
            return ChannelDelimEnum.valueOf(input);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static FormatCodeEnum parseFormat(Object _input) {
        if (_input == null) {
            return null;
        }
        String input = _input.toString();
        try {
            return FormatCodeEnum.valueOf(input);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static Integer parseInteger(String _input, int min, int max, int fallback) {
        Integer result;
        try {
            result = Integer.parseInt(_input);
            result = Math.max(min, result);
            result = Math.min(max, result);
        }
        catch (NumberFormatException e) {
            result = fallback;
        }
        return result;
    }

    public static int parseInteger(String _input) {
        NumberFormat formatter = NumberFormat.getInstance();
        boolean state = formatter.isParseIntegerOnly();
        formatter.setParseIntegerOnly(true);
        ParsePosition pos = new ParsePosition(0);
        int result = formatter.parse(_input, pos).intValue();
        formatter.setParseIntegerOnly(state);
        if (_input.length() == pos.getIndex()) {
            return result;
        }
        return -1;
    }

    public static NotificationSoundEnum parseSound(Object _input) {
        if (_input == null) {
            return NotificationSoundEnum.ORB;
        }
        String input = _input.toString();
        try {
            return NotificationSoundEnum.valueOf(input);
        }
        catch (IllegalArgumentException e) {
            return NotificationSoundEnum.ORB;
        }
    }

    public static String parseString(Object _input) {
        if (_input == null) {
            return " ";
        }
        return _input.toString();
    }

    public static TimeStampEnum parseTimestamp(Object _input) {
        if (_input == null) {
            return null;
        }
        String input = _input.toString();
        try {
            return TimeStampEnum.valueOf(input);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static List<TCChatLine> componentToChatLines(int stamp, ComponentList filtered, int id, boolean status) {
        ArrayList result = Lists.newArrayList();
        boolean first = true;
        for (IChatComponent split : filtered) {
            if (first) {
                result.add(new TCChatLine(stamp, split, id, status));
                first = false;
                continue;
            }
            result.add(new TCChatLine(stamp, new ChatComponentText(" ").func_150257_a(split), id, status));
        }
        return result;
    }

    public static LinkedHashMap<String, ChatChannel> swapChannels(LinkedHashMap<String, ChatChannel> currentMap, int _left, int _right) {
        if (_left == _right) {
            return currentMap;
        }
        if (_left > _right) {
            int _tmp = _left;
            _left = _right;
            _right = _tmp;
        }
        if (_right >= currentMap.size()) {
            return currentMap;
        }
        String[] arrayCopy = new String[currentMap.size()];
        arrayCopy = currentMap.keySet().toArray(arrayCopy);
        String tmp = arrayCopy[_left];
        arrayCopy[_left] = arrayCopy[_right];
        arrayCopy[_right] = tmp;
        int n = arrayCopy.length;
        LinkedHashMap<String, ChatChannel> returnMap = new LinkedHashMap<String, ChatChannel>(n);
        for (int i = 0; i < n; ++i) {
            returnMap.put(arrayCopy[i], currentMap.get(arrayCopy[i]));
        }
        return returnMap;
    }

    public static void writeLargeChat(String toSend) {
        BackgroundChatThread sendProc;
        List<String> actives = TabbyChat.getInstance().getActive();
        if (!TabbyChat.getInstance().enabled() || actives.size() != 1) {
            sendProc = new BackgroundChatThread(toSend);
        } else {
            ChatChannel active = TabbyChat.getInstance().channelMap.get(actives.get(0));
            String tabPrefix = active.cmdPrefix;
            boolean hiddenPrefix = active.hidePrefix;
            if (TabbyChat.advancedSettings.convertUnicodeText.getValue().booleanValue()) {
                toSend = TabbyChatUtils.convertUnicode(toSend);
            }
            sendProc = tabPrefix != null && tabPrefix.length() > 0 ? (!hiddenPrefix ? new BackgroundChatThread(toSend, tabPrefix) : (!toSend.startsWith("/") ? new BackgroundChatThread(tabPrefix + " " + toSend, tabPrefix) : new BackgroundChatThread(toSend))) : new BackgroundChatThread(toSend);
        }
        sendProc.start();
    }

    public static String convertUnicode(String chat) {
        String newChat = "";
        for (String s : chat.split("\\\u0000")) {
            if (s.contains("u")) {
                try {
                    newChat = newChat + StringEscapeUtils.unescapeJava((String)s);
                }
                catch (IllegalArgumentException e) {
                    newChat = newChat + s;
                }
                continue;
            }
            newChat = newChat + s;
        }
        return newChat;
    }
}

