/*
 * Decompiled with CFR 0.152.
 */
package acs.tabbychat.core;

import acs.tabbychat.core.GuiNewChatTC;
import acs.tabbychat.core.TCChatLine;
import acs.tabbychat.core.TabbyChat;
import acs.tabbychat.gui.ChatBox;
import acs.tabbychat.gui.ChatButton;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import org.lwjgl.opengl.GL11;

public class ChatChannel
implements Serializable {
    protected static int nextID = 3600;
    private static final long serialVersionUID = 546162627943686174L;
    private String title;
    public transient ChatButton tab;
    private ArrayList<TCChatLine> chatLog;
    private final ReentrantReadWriteLock chatListLock = new ReentrantReadWriteLock(true);
    private final Lock chatReadLock = this.chatListLock.readLock();
    private final Lock chatWriteLock = this.chatListLock.writeLock();
    protected int chanID = nextID++;
    public boolean unread = false;
    public boolean active = false;
    protected boolean hasSpam = false;
    protected int spamCount = 1;
    public boolean notificationsOn = false;
    public boolean hidePrefix = false;
    private String alias;
    public String cmdPrefix = "";
    private File logFile;

    public ChatChannel() {
        this.chatLog = new ArrayList();
        this.notificationsOn = TabbyChat.generalSettings.unreadFlashing.getValue();
    }

    public ChatChannel(int _x, int _y, int _w, int _h, String _title) {
        this();
        this.tab = new ChatButton(this.chanID, _x, _y, _w, _h, _title);
        this.alias = this.title = _title;
        this.tab.channel = this;
        this.tab.width(TabbyChat.mc.field_71466_p.func_78256_a(this.alias + "<>") + 8);
    }

    public ChatChannel(String _title) {
        this(3, 3, Minecraft.func_71410_x().field_71466_p.func_78256_a("<" + _title + ">") + 8, 14, _title);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChat(TCChatLine newChat, boolean visible) {
        this.chatWriteLock.lock();
        try {
            this.chatLog.add(0, newChat);
        }
        finally {
            this.chatWriteLock.unlock();
        }
        if (!this.title.equals("*") && this.notificationsOn && !visible) {
            this.unread = true;
        }
    }

    public boolean doesButtonEqual(GuiButton btnObj) {
        return this.tab.field_146127_k == btnObj.field_146127_k;
    }

    public String getAlias() {
        return this.alias;
    }

    public int getButtonEnd() {
        return this.tab.x() + this.tab.width();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TCChatLine getChatLine(int index) {
        TCChatLine retVal = null;
        this.chatReadLock.lock();
        try {
            retVal = this.chatLog.get(index);
        }
        finally {
            this.chatReadLock.unlock();
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TCChatLine> getChatLogSublistCopy(int fromInd, int toInd) {
        ArrayList<TCChatLine> retVal = new ArrayList<TCChatLine>(toInd - fromInd);
        this.chatReadLock.lock();
        try {
            for (int i = toInd - 1; i >= fromInd; --i) {
                retVal.add(this.chatLog.get(i));
            }
        }
        finally {
            this.chatReadLock.unlock();
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChatLogSize() {
        int mySize = 0;
        this.chatReadLock.lock();
        try {
            mySize = this.chatLog.size();
        }
        finally {
            this.chatReadLock.unlock();
        }
        return mySize;
    }

    public int getID() {
        return this.chanID;
    }

    public String getDisplayTitle() {
        if (this.active) {
            return "[" + this.alias + "]";
        }
        if (this.unread) {
            return "<" + this.alias + ">";
        }
        return this.alias;
    }

    public String getTitle() {
        return this.title;
    }

    public File getLogFile() {
        return this.logFile;
    }

    public void setLogFile(File file) {
        this.logFile = file;
    }

    public void setButtonObj(ChatButton btnObj) {
        this.tab = btnObj;
        this.tab.channel = this;
    }

    public void setAlias(String _alias) {
        this.alias = _alias;
        this.tab.width(TabbyChat.mc.field_71466_p.func_78256_a(_alias + "<>") + 8);
    }

    public String toString() {
        return this.getDisplayTitle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.chatWriteLock.lock();
        try {
            this.chatLog.clear();
        }
        finally {
            this.chatWriteLock.unlock();
        }
        this.tab = null;
    }

    public void setButtonLoc(int _x, int _y) {
        this.tab.x(_x);
        this.tab.y(_y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setChatLogLine(int ind, TCChatLine newLine) {
        this.chatWriteLock.lock();
        try {
            if (ind < this.chatLog.size()) {
                this.chatLog.set(ind, newLine);
            } else {
                this.chatLog.add(newLine);
            }
        }
        finally {
            this.chatWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimLog() {
        GuiNewChatTC.getInstance();
        TabbyChat tc = GuiNewChatTC.tc;
        if (tc == null || tc.serverDataLock.availablePermits() < 1) {
            return;
        }
        int maxChats = tc.enabled() ? Integer.parseInt(TabbyChat.advancedSettings.chatScrollHistory.getValue()) : 100;
        this.chatWriteLock.lock();
        try {
            while (this.chatLog.size() > maxChats) {
                this.chatLog.remove(this.chatLog.size() - 1);
            }
        }
        finally {
            this.chatWriteLock.unlock();
        }
    }

    public void unreadNotify(Gui _gui, int _opacity) {
        Minecraft mc = Minecraft.func_71410_x();
        GuiNewChatTC gnc = GuiNewChatTC.getInstance();
        int tabY = this.tab.y() - gnc.sr.func_78328_b() - ChatBox.current.y;
        tabY = ChatBox.anchoredTop ? tabY - ChatBox.getChatHeight() + ChatBox.getUnfocusedHeight() : tabY + ChatBox.getChatHeight() - ChatBox.getUnfocusedHeight() + 1;
        mc.field_71456_v.func_146158_b();
        GuiNewChat.func_73734_a((int)this.tab.x(), (int)tabY, (int)(this.tab.x() + this.tab.width()), (int)(tabY + this.tab.height()), (int)(0x720000 + (_opacity / 2 << 24)));
        GL11.glEnable((int)3042);
        mc.field_71456_v.func_146158_b().func_73732_a(mc.field_71466_p, this.getDisplayTitle(), this.tab.x() + this.tab.width() / 2, tabY + 4, 0xFF0000 + (_opacity << 24));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importOldChat(ChatChannel oldChan) {
        if (oldChan == null || oldChan.chatLog.isEmpty()) {
            return;
        }
        this.chatWriteLock.lock();
        try {
            for (TCChatLine oldChat : oldChan.chatLog) {
                if (oldChat == null || oldChat.statusMsg) continue;
                this.chatLog.add(new TCChatLine(-1, (IChatComponent)new ChatComponentText(oldChat.getChatLineString().func_150261_e()), 0));
            }
        }
        finally {
            this.chatWriteLock.unlock();
        }
        this.trimLog();
    }
}

