/*
 * Decompiled with CFR 0.152.
 */
package acs.tabbychat.core;

import acs.tabbychat.core.GuiNewChatTC;
import acs.tabbychat.core.TabbyChat;
import acs.tabbychat.util.TabbyChatUtils;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import net.minecraft.client.Minecraft;

@Mod(name="TabbyChat", modid="tabbychat", version="1.11.1.59")
public class TabbyChatMod {
    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        if (this.willBeLiteLoaded()) {
            TabbyChatUtils.log.warn("LiteLoader version detected.  Will use that instead.");
            return;
        }
        TabbyChatUtils.startup();
        FMLCommonHandler.instance().bus().register((Object)this);
        TabbyChat.modLoaded = true;
    }

    @Mod.EventHandler
    public void postLoad(FMLServerStartedEvent event) {
        if (!TabbyChat.liteLoaded) {
            GuiNewChatTC.getInstance();
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.RenderTickEvent event) {
        if (!event.phase.equals((Object)TickEvent.Phase.START) && Minecraft.func_71410_x().field_71441_e != null) {
            this.onTickInGui(Minecraft.func_71410_x());
        }
    }

    private boolean onTickInGui(Minecraft minecraft) {
        TabbyChatUtils.chatGuiTick(minecraft);
        return true;
    }

    private boolean willBeLiteLoaded() {
        try {
            Class.forName("acs.tabbychat.core.LiteModTabbyChat");
            Class.forName("com.mumfrey.liteloader.core.LiteLoader");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

