/*
 * Decompiled with CFR 0.152.
 */
package acs.tabbychat.settings;

import acs.tabbychat.settings.FormatCodeEnum;
import acs.tabbychat.settings.ITCSetting;
import java.util.Properties;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;

abstract class TCSetting
extends GuiButton
implements ITCSetting {
    public int buttonColor = -1146755100;
    protected int labelX = 0;
    public String description;
    protected String type;
    public final String categoryName;
    public final String propertyName;
    protected Object value;
    protected Object tempValue;
    protected Object theDefault;
    protected static Minecraft mc = Minecraft.func_71410_x();

    public TCSetting(Object theSetting, String theProperty, String theCategory, int theID) {
        super(theID, 0, 0, "");
        this.value = theSetting;
        this.tempValue = theSetting;
        this.theDefault = theSetting;
        this.propertyName = theProperty;
        this.categoryName = theCategory;
        this.description = I18n.func_135052_a((String)(theCategory + "." + theProperty.toLowerCase()), (Object[])new Object[0]);
    }

    public TCSetting(Object theSetting, String theProperty, String theCategory, int theID, FormatCodeEnum theFormat) {
        this(theSetting, theProperty, theCategory, theID);
        this.description = theFormat.toCode() + this.description + "\u00a7r";
    }

    @Override
    public void actionPerformed() {
    }

    public int width() {
        return this.field_146120_f;
    }

    public void width(int _w) {
        this.field_146120_f = _w;
    }

    public int height() {
        return this.field_146121_g;
    }

    public void height(int _h) {
        this.field_146121_g = _h;
    }

    public int x() {
        return this.field_146128_h;
    }

    public void x(int _x) {
        this.field_146128_h = _x;
    }

    public int y() {
        return this.field_146129_i;
    }

    public void y(int _y) {
        this.field_146129_i = _y;
    }

    @Override
    public void clear() {
        this.value = this.theDefault;
        this.tempValue = this.theDefault;
    }

    @Override
    public void disable() {
        this.field_146124_l = false;
    }

    public void func_146112_a(Minecraft mc, int cursorX, int cursorY) {
    }

    @Override
    public void enable() {
        this.field_146124_l = true;
    }

    @Override
    public boolean enabled() {
        return this.field_146124_l;
    }

    @Override
    public Object getDefault() {
        return this.theDefault;
    }

    @Override
    public String getProperty() {
        return this.propertyName;
    }

    @Override
    public Object getTempValue() {
        return this.tempValue;
    }

    @Override
    public String getType() {
        return this.type;
    }

    protected Object getValue() {
        return this.value;
    }

    @Override
    public Boolean hovered(int cursorX, int cursorY) {
        return cursorX >= this.x() && cursorY >= this.y() && cursorX < this.x() + this.width() && cursorY < this.y() + this.height();
    }

    @Override
    public void loadSelfFromProps(Properties readProps) {
        this.setCleanValue(readProps.get(this.propertyName));
    }

    @Override
    public void mouseClicked(int par1, int par2, int par3) {
    }

    @Override
    public void reset() {
        this.tempValue = this.value;
    }

    @Override
    public void resetDescription() {
        this.description = this.categoryName.isEmpty() ? "" : I18n.func_135052_a((String)(this.categoryName + "." + this.propertyName.toLowerCase()), (Object[])new Object[0]);
    }

    @Override
    public void save() {
        this.value = this.tempValue;
    }

    @Override
    public void saveSelfToProps(Properties writeProps) {
        if (this.value instanceof Enum) {
            writeProps.put(this.propertyName, ((Enum)this.value).name());
        } else {
            writeProps.put(this.propertyName, this.value.toString());
        }
    }

    @Override
    public void setButtonDims(int wide, int tall) {
        this.width(wide);
        this.height(tall);
    }

    @Override
    public void setButtonLoc(int bx, int by) {
        this.x(bx);
        this.y(by);
    }

    @Override
    public void setLabelLoc(int _x) {
        this.labelX = _x;
    }

    @Override
    public void setTempValue(Object updateVal) {
        this.tempValue = updateVal;
    }

    @Override
    public void setCleanValue(Object updateVal) {
        if (updateVal == null) {
            this.clear();
        } else {
            this.value = updateVal;
        }
    }

    @Override
    public void setValue(Object updateVal) {
        this.value = updateVal;
    }
}

