/*
 * Decompiled with CFR 0.152.
 */
package acs.tabbychat.util;

import acs.tabbychat.api.IChatExtension;
import acs.tabbychat.util.TabbyChatUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class ChatExtensions {
    private List<IChatExtension> list = Lists.newArrayList();

    public ChatExtensions(List<Class<? extends IChatExtension>> list) {
        for (Class<? extends IChatExtension> ext : list) {
            try {
                IChatExtension exten = ext.newInstance();
                exten.load();
                this.list.add(exten);
            }
            catch (Exception e) {
                TabbyChatUtils.log.error("Unable to initialize " + ext.getName(), (Throwable)e);
            }
        }
    }

    public <T extends IChatExtension> List<T> getListOf(Class<T> extClass) {
        ArrayList t = Lists.newArrayList();
        for (IChatExtension ext : this.list) {
            if (!extClass.isInstance(ext)) continue;
            t.add(ext);
        }
        return t;
    }
}

