/*
 * Decompiled with CFR 0.152.
 */
package thebombzen.mods.thebombzenapi.configuration;

import thebombzen.mods.thebombzenapi.configuration.BooleanTester;

public class CompoundExpression<U>
implements BooleanTester<U> {
    public static final int PURE = 0;
    public static final int AND = 1;
    public static final int OR = 2;
    public static final int NOT = 3;
    public static final int XOR = 4;
    protected int type;
    protected BooleanTester<? super U> first = null;
    protected BooleanTester<? super U> second = null;

    public CompoundExpression(BooleanTester<? super U> value) {
        this.type = 0;
        this.first = value;
    }

    public CompoundExpression(int type, BooleanTester<? super U> first, BooleanTester<? super U> second) {
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.type = type;
        this.first = first;
        this.second = second;
    }

    @Override
    public boolean contains(U u) {
        switch (this.type) {
            case 0: {
                return this.first.contains(u);
            }
            case 1: {
                return this.first.contains(u) && this.second.contains(u);
            }
            case 2: {
                return this.first.contains(u) || this.second.contains(u);
            }
            case 3: {
                return !this.first.contains(u);
            }
            case 4: {
                return this.first.contains(u) ^ this.second.contains(u);
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompoundExpression other = (CompoundExpression)obj;
        if (this.first == null ? other.first != null : !this.first.equals(other.first)) {
            return false;
        }
        if (this.second == null ? other.second != null : !this.second.equals(other.second)) {
            return false;
        }
        return this.type == other.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.first == null ? 0 : this.first.hashCode());
        result = 31 * result + (this.second == null ? 0 : this.second.hashCode());
        result = 31 * result + this.type;
        return result;
    }

    public String toString() {
        switch (this.type) {
            case 1: {
                return "(" + this.first.toString() + ")&(" + this.second.toString() + ")";
            }
            case 2: {
                return "(" + this.first.toString() + ")|(" + this.second.toString() + ")";
            }
            case 4: {
                return "(" + this.first.toString() + ")^(" + this.second.toString() + ")";
            }
            case 3: {
                return "!(" + this.first.toString() + ")";
            }
            case 0: {
                return this.first.toString();
            }
        }
        return null;
    }
}

