/*
 * Decompiled with CFR 0.152.
 */
package thebombzen.mods.autoswitch.configuration;

import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import thebombzen.mods.autoswitch.configuration.SingleBlockItemIdentifier;
import thebombzen.mods.autoswitch.configuration.SingleValueIdentifier;
import thebombzen.mods.thebombzenapi.ThebombzenAPI;
import thebombzen.mods.thebombzenapi.configuration.BooleanTester;
import thebombzen.mods.thebombzenapi.configuration.CompoundExpression;
import thebombzen.mods.thebombzenapi.configuration.ConfigFormatException;

public class BlockItemIdentifier
extends CompoundExpression<SingleValueIdentifier> {
    public static BlockItemIdentifier parseBlockItemIdentifier(String info) throws ConfigFormatException {
        if (info.length() == 0) {
            throw new ConfigFormatException("Empty block/item identifier");
        }
        if (!(info.contains("&") || info.contains("|") || info.contains("^") || info.contains("!"))) {
            if (info.startsWith("(") && info.endsWith(")")) {
                return BlockItemIdentifier.parseBlockItemIdentifier(info.substring(1, info.length() - 1));
            }
            return new BlockItemIdentifier(SingleBlockItemIdentifier.parseSingleBlockItemIdentifier(info));
        }
        int index = info.indexOf(94);
        while (index >= 0) {
            if (index == 0) {
                throw new ConfigFormatException("^ requires something on both sides: " + info);
            }
            if (ThebombzenAPI.isSeparatorAtTopLevel((String)info, (int)index)) {
                String before = info.substring(0, index);
                String after = info.substring(index + 1);
                return new BlockItemIdentifier(4, BlockItemIdentifier.parseBlockItemIdentifier(before), BlockItemIdentifier.parseBlockItemIdentifier(after));
            }
            index = info.indexOf(94, index + 1);
        }
        index = info.indexOf(124);
        while (index >= 0) {
            if (index == 0) {
                throw new ConfigFormatException("| requires something on both sides: " + info);
            }
            if (ThebombzenAPI.isSeparatorAtTopLevel((String)info, (int)index)) {
                String before = info.substring(0, index);
                String after = info.substring(index + 1);
                return new BlockItemIdentifier(2, BlockItemIdentifier.parseBlockItemIdentifier(before), BlockItemIdentifier.parseBlockItemIdentifier(after));
            }
            index = info.indexOf(124, index + 1);
        }
        index = info.indexOf(38);
        while (index >= 0) {
            if (index == 0) {
                throw new ConfigFormatException("& requires something on both sides: " + info);
            }
            if (ThebombzenAPI.isSeparatorAtTopLevel((String)info, (int)index)) {
                String before = info.substring(0, index);
                String after = info.substring(index + 1);
                return new BlockItemIdentifier(1, BlockItemIdentifier.parseBlockItemIdentifier(before), BlockItemIdentifier.parseBlockItemIdentifier(after));
            }
            index = info.indexOf(38, index + 1);
        }
        if (info.startsWith("!")) {
            return new BlockItemIdentifier(3, BlockItemIdentifier.parseBlockItemIdentifier(info.substring(1)), null);
        }
        if (info.startsWith("(") && info.endsWith(")")) {
            return BlockItemIdentifier.parseBlockItemIdentifier(info.substring(1, info.length() - 1));
        }
        throw new ConfigFormatException("Malformed block/item identifier: " + info);
    }

    public BlockItemIdentifier(int type, BlockItemIdentifier first, BlockItemIdentifier second) {
        super(type, (BooleanTester)first, (BooleanTester)second);
    }

    public BlockItemIdentifier(SingleBlockItemIdentifier singleID) {
        super((BooleanTester)singleID);
    }

    public boolean contains(Block block, int metadata) {
        return this.contains(new SingleValueIdentifier(block, metadata));
    }

    public boolean contains(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        return this.contains(new SingleValueIdentifier(itemStack));
    }
}

