/*
 * Decompiled with CFR 0.152.
 */
package thebombzen.mods.thebombzenapi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ModResourceInputStream
extends FilterInputStream {
    private ZipFile zipFile;

    public ModResourceInputStream(File location, String resource) throws IOException {
        super(null);
        if (location.isDirectory()) {
            this.zipFile = null;
            this.in = new FileInputStream((location.getCanonicalPath() + File.separatorChar + resource).replace('/', File.separatorChar).replace(File.separator + File.separator, File.separator));
        } else {
            this.zipFile = new ZipFile(location);
            ZipEntry entry = this.zipFile.getEntry(resource);
            if (entry == null) {
                throw new IOException("Resource " + resource + " not found in " + location.getPath() + ".");
            }
            this.in = this.zipFile.getInputStream(entry);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.zipFile != null) {
            this.zipFile.close();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.zipFile.close();
    }
}

