/*
 * Decompiled with CFR 0.152.
 */
package thebombzen.mods.thebombzenapi;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.storage.SaveHandler;
import thebombzen.mods.thebombzenapi.ThebombzenAPI;
import thebombzen.mods.thebombzenapi.configuration.ThebombzenAPIConfiguration;

public abstract class ThebombzenAPIBaseMod
implements Comparable<ThebombzenAPIBaseMod> {
    @SideOnly(value=Side.CLIENT)
    protected int[] toggleKeyCodes;
    @SideOnly(value=Side.CLIENT)
    protected boolean[] toggles;
    @SideOnly(value=Side.CLIENT)
    protected boolean[] defaultToggles;
    protected File modFolder;
    protected PrintWriter debugLogger = null;
    protected StringBuilder debugBuilder = null;
    protected String prevDebugString = "";
    protected String prevImmediateDebugString = "";
    protected File debugFile;

    public ThebombzenAPIBaseMod() {
        if (!ThebombzenAPI.class.isAssignableFrom(this.getClass())) {
            this.initialize();
        }
    }

    @Override
    public int compareTo(ThebombzenAPIBaseMod mod) {
        if (this == mod) {
            return 0;
        }
        if (this instanceof ThebombzenAPI) {
            return -1;
        }
        if (mod instanceof ThebombzenAPI) {
            return 1;
        }
        return this.getLongName().compareTo(mod.getLongName());
    }

    protected void finalize() throws Throwable {
        this.debugLogger.close();
    }

    public void forceDebug(String string) {
        this.forceDebug("%s", string);
    }

    public void forceDebug(String format, Object ... args) {
        String s = String.format(format, args);
        if (s.equals(this.prevImmediateDebugString)) {
            return;
        }
        if (s.matches("^=+START=+$")) {
            this.debugBuilder = new StringBuilder(s).append(ThebombzenAPI.NEWLINE);
            return;
        }
        if (s.matches("^=+END=+$")) {
            this.debugBuilder.append(s).append(ThebombzenAPI.NEWLINE);
            s = this.debugBuilder.toString();
            this.debugBuilder = null;
            if (s.equals(this.prevDebugString)) {
                return;
            }
            this.prevDebugString = s;
        } else if (this.debugBuilder != null) {
            this.debugBuilder.append(s).append(ThebombzenAPI.NEWLINE);
            return;
        }
        if (s.equals(this.prevImmediateDebugString)) {
            return;
        }
        this.prevImmediateDebugString = s;
        System.err.println(s);
        if (this.debugLogger != null) {
            this.debugLogger.println(s);
            this.debugLogger.flush();
        }
    }

    public void forceDebugException(Throwable exception) {
        exception.printStackTrace();
        if (this.debugLogger != null) {
            exception.printStackTrace(this.debugLogger);
            this.debugLogger.flush();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public NBTTagCompound getCompoundFromCurrentData() {
        NBTTagCompound settings = new NBTTagCompound();
        byte[] togglesByte = new byte[this.getNumToggleKeys()];
        for (int i = 0; i < this.getNumToggleKeys(); ++i) {
            togglesByte[i] = this.isToggleEnabled(i) ? (byte)1 : 0;
        }
        settings.func_74773_a("toggles", togglesByte);
        NBTTagCompound data = new NBTTagCompound();
        data.func_74782_a("Settings", (NBTBase)settings);
        return data;
    }

    @SideOnly(value=Side.CLIENT)
    public NBTTagCompound getCompoundFromDefaultData() {
        NBTTagCompound settings = new NBTTagCompound();
        byte[] togglesByte = new byte[this.getNumToggleKeys()];
        for (int i = 0; i < this.getNumToggleKeys(); ++i) {
            togglesByte[i] = this.isToggleDefaultEnabled(i) ? (byte)1 : 0;
        }
        settings.func_74773_a("toggles", togglesByte);
        NBTTagCompound data = new NBTTagCompound();
        data.func_74782_a("Settings", (NBTBase)settings);
        return data;
    }

    public abstract <T extends ThebombzenAPIConfiguration> T getConfiguration();

    @SideOnly(value=Side.CLIENT)
    public File getCorrectMemoryFile() {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return null;
        }
        if (Minecraft.func_71410_x().func_71356_B()) {
            return new File(((SaveHandler)Minecraft.func_71410_x().func_71401_C().func_71218_a(Minecraft.func_71410_x().field_71439_g.field_71093_bK).func_72860_G()).func_75765_b(), this.getLongName().toUpperCase() + "_MEMORY.dat");
        }
        return new File(this.getModFolder(), this.getLongName().toUpperCase() + "_MEMORY_" + Minecraft.func_71410_x().func_147104_D().field_78845_b.toLowerCase() + ".dat");
    }

    public abstract String getDownloadLocationURLString();

    public String getLatestVersion() {
        String latestVersion = null;
        try {
            URL versionURL = this.getVersionFileURL();
            BufferedReader br = new BufferedReader(new InputStreamReader(versionURL.openStream()));
            latestVersion = br.readLine();
            br.close();
        }
        catch (Exception e) {
            latestVersion = this.getLongVersionString();
        }
        return latestVersion;
    }

    public abstract String getLongName();

    public abstract String getLongVersionString();

    public File getModFolder() {
        return this.modFolder;
    }

    @SideOnly(value=Side.CLIENT)
    public abstract int getNumToggleKeys();

    public abstract String getShortName();

    @SideOnly(value=Side.CLIENT)
    public int getToggleKeyCode(int index) {
        if (this.getNumToggleKeys() <= 0) {
            throw new UnsupportedOperationException();
        }
        if (index < 0 || index >= this.getNumToggleKeys()) {
            throw new IndexOutOfBoundsException();
        }
        return this.toggleKeyCodes[index];
    }

    @SideOnly(value=Side.CLIENT)
    protected abstract String getToggleMessageString(int var1, boolean var2);

    public URL getVersionFileURL() throws MalformedURLException {
        return new URL(this.getVersionFileURLString());
    }

    protected abstract String getVersionFileURLString();

    public void init1(FMLPreInitializationEvent event) {
    }

    public void init2(FMLInitializationEvent event) {
    }

    public void init3(FMLPostInitializationEvent event) {
    }

    void initialize() {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.toggleKeyCodes = new int[this.getNumToggleKeys()];
            this.toggles = new boolean[this.getNumToggleKeys()];
            this.defaultToggles = new boolean[this.getNumToggleKeys()];
        }
        ThebombzenAPI.registerMod(this);
        File mineFile = ThebombzenAPI.sideSpecificUtilities.getMinecraftDirectory();
        File modsFolder = new File(mineFile, "mods");
        this.modFolder = new File(modsFolder, this.getLongName());
        this.modFolder.mkdirs();
        this.debugFile = new File(this.modFolder, "DEBUG.txt");
        try {
            this.debugLogger = new PrintWriter(new FileWriter(this.debugFile));
        }
        catch (IOException ioe) {
            this.debugLogger = null;
            this.throwException("Unable to open debug output file.", ioe, false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isToggleDefaultEnabled(int index) {
        if (this.getNumToggleKeys() <= 0) {
            throw new UnsupportedOperationException();
        }
        if (index < 0 || index >= this.getNumToggleKeys()) {
            throw new IndexOutOfBoundsException();
        }
        return this.defaultToggles[index];
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isToggleEnabled(int index) {
        if (this.getNumToggleKeys() <= 0) {
            throw new UnsupportedOperationException();
        }
        if (index < 0 || index >= this.getNumToggleKeys()) {
            throw new IndexOutOfBoundsException();
        }
        return this.toggles[index];
    }

    @SideOnly(value=Side.CLIENT)
    public void readFromCorrectMemoryFile() {
        File file = this.getCorrectMemoryFile();
        if (file != null) {
            NBTTagCompound data = this.readFromMemoryFile(file);
            this.saveCompoundToCurrentData(data);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public NBTTagCompound readFromMemoryFile(File file) {
        try {
            if (!file.isFile()) {
                this.writeToMemoryFile(file, this.getCompoundFromDefaultData());
                return this.getCompoundFromDefaultData();
            }
            FileInputStream in = new FileInputStream(file);
            NBTTagCompound data = null;
            try {
                data = CompressedStreamTools.func_74796_a((InputStream)in);
            }
            catch (IOException ioe) {
                this.writeToMemoryFile(file, this.getCompoundFromCurrentData());
            }
            if (data != null) {
                return data;
            }
        }
        catch (IOException ioe) {
            this.throwException("Couldn't read from memory file.", ioe, false);
        }
        return this.getCompoundFromCurrentData();
    }

    @SideOnly(value=Side.CLIENT)
    public void saveCompoundToCurrentData(NBTTagCompound data) {
        NBTTagCompound settings = data.func_74775_l("Settings");
        if (settings == null) {
            return;
        }
        byte[] togglesByte = settings.func_74770_j("toggles");
        if (togglesByte.length == 0) {
            for (int i = 0; i < this.getNumToggleKeys(); ++i) {
                this.setToggleEnabled(i, this.isToggleDefaultEnabled(i), false);
            }
        } else {
            for (int i = 0; i < this.getNumToggleKeys(); ++i) {
                this.setToggleEnabled(i, togglesByte[i] != 0, false);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setToggleDefaultEnabled(int index, boolean enabled) {
        if (this.getNumToggleKeys() <= 0) {
            throw new UnsupportedOperationException();
        }
        if (index < 0 || index >= this.getNumToggleKeys()) {
            throw new IndexOutOfBoundsException();
        }
        this.defaultToggles[index] = enabled;
    }

    @SideOnly(value=Side.CLIENT)
    public void setToggleEnabled(int index, boolean enabled, boolean keyPress) {
        if (this.getNumToggleKeys() <= 0) {
            throw new UnsupportedOperationException();
        }
        if (index < 0 || index >= this.getNumToggleKeys()) {
            throw new IndexOutOfBoundsException();
        }
        this.toggles[index] = enabled;
        if (keyPress) {
            Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(this.getToggleMessageString(index, enabled)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setToggleKeyCode(int index, int keyCode) {
        if (this.getNumToggleKeys() <= 0) {
            throw new UnsupportedOperationException();
        }
        if (index < 0 || index >= this.getNumToggleKeys()) {
            throw new IndexOutOfBoundsException();
        }
        this.toggleKeyCodes[index] = keyCode;
    }

    public void throwException(String info, Throwable exception, boolean fatal) {
        this.forceDebug(info);
        this.forceDebugException(exception);
        if (fatal) {
            ThebombzenAPI.sideSpecificUtilities.crash(info, exception);
        }
    }

    public String toString() {
        return this.getLongName();
    }

    @SideOnly(value=Side.CLIENT)
    public void writeToCorrectMemoryFile() {
        File file = this.getCorrectMemoryFile();
        if (file != null) {
            NBTTagCompound data = this.getCompoundFromCurrentData();
            this.writeToMemoryFile(file, data);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void writeToMemoryFile(File file, NBTTagCompound config) {
        try {
            file.delete();
            file.createNewFile();
            FileOutputStream fos = new FileOutputStream(file);
            CompressedStreamTools.func_74799_a((NBTTagCompound)config, (OutputStream)fos);
        }
        catch (IOException ioe) {
            this.throwException("Couldn't write to memory file.", ioe, false);
        }
    }
}

