/*
 * Decompiled with CFR 0.152.
 */
package thebombzen.mods.thebombzenapi.configuration;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Arrays;
import java.util.Properties;
import net.minecraft.client.Minecraft;
import thebombzen.mods.thebombzenapi.ThebombzenAPI;
import thebombzen.mods.thebombzenapi.ThebombzenAPIBaseMod;
import thebombzen.mods.thebombzenapi.configuration.ConfigOption;

public abstract class ThebombzenAPIConfiguration {
    protected ThebombzenAPIBaseMod mod;
    protected Properties properties = new Properties();
    protected File propsFile;
    protected long lastCheckedConfigLastModified;

    public ThebombzenAPIConfiguration(ThebombzenAPIBaseMod baseMod) {
        this.mod = baseMod;
        this.propsFile = new File(ThebombzenAPI.sideSpecificUtilities.getMinecraftDirectory().getPath() + File.separator + "config" + File.separator + this.mod.getLongName() + ".txt");
    }

    public abstract ConfigOption[] getAllOptions();

    public boolean getBooleanProperty(ConfigOption option) {
        if (option.getOptionType() != 0) {
            throw new UnsupportedOperationException("Can only work on a BOOLEAN!");
        }
        return ThebombzenAPI.parseBoolean(this.getStringProperty(option));
    }

    @SideOnly(value=Side.CLIENT)
    public int getKeyCodeProperty(ConfigOption option) {
        if (option.getOptionType() != 1) {
            throw new UnsupportedOperationException("Can only work on a KEY!");
        }
        return ThebombzenAPI.getExtendedKeyIndex(this.getStringProperty(option));
    }

    public File getPropertyFile() {
        return this.propsFile;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean getSingleMultiProperty(ConfigOption option) {
        if (option.getOptionType() != 4) {
            throw new UnsupportedOperationException("Can only work on a SINGLE_MULTI_BOOLEAN!");
        }
        String value = this.getStringProperty(option);
        if (value.equalsIgnoreCase("always")) {
            return true;
        }
        if (value.equalsIgnoreCase("never")) {
            return false;
        }
        if (value.toLowerCase().contains("singleplayer")) {
            return Minecraft.func_71410_x().func_71356_B();
        }
        if (value.toLowerCase().contains("multiplayer")) {
            return !Minecraft.func_71410_x().func_71356_B();
        }
        this.setProperty(option, option.getDefaultValue());
        return this.getSingleMultiProperty(option);
    }

    public String getStringProperty(ConfigOption option) {
        String value = this.properties.getProperty(option.toString());
        return value != null ? value : "";
    }

    private void initializeDefaults() {
        for (ConfigOption option : this.getAllOptions()) {
            this.setPropertyWithoutSave(option, option.getDefaultValue());
        }
    }

    public void load() throws IOException {
        this.initializeDefaults();
        this.loadProperties();
        this.saveProperties();
    }

    protected void loadProperties() throws IOException {
        if (!this.propsFile.exists()) {
            this.propsFile.createNewFile();
        }
        BufferedReader reader = new BufferedReader(new FileReader(this.propsFile));
        this.properties.load(reader);
        ((Reader)reader).close();
        for (ConfigOption option : this.getAllOptions()) {
            if (option.getDefaultToggleIndex() >= 0) {
                this.mod.setToggleDefaultEnabled(option.getDefaultToggleIndex(), this.getBooleanProperty(option));
            }
            if (option.getOptionType() != 2 || Arrays.asList(option.getFiniteStringOptions()).contains(this.getStringProperty(option))) continue;
            this.setPropertyWithoutSave(option, option.getDefaultValue());
        }
        this.lastCheckedConfigLastModified = this.getPropertyFile().lastModified();
        File oldPropsFile = new File(ThebombzenAPI.sideSpecificUtilities.getMinecraftDirectory().getPath() + File.separator + "config" + File.separator + this.mod.getLongName() + ".cfg");
        if (oldPropsFile.exists()) {
            oldPropsFile.delete();
        }
    }

    public boolean reloadPropertiesFromFileIfChanged() throws IOException {
        if (this.shouldRefreshConfig()) {
            this.loadProperties();
            return true;
        }
        return false;
    }

    public void saveProperties() {
        try {
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(this.getPropertyFile())));
            this.properties.store(writer, this.mod.getLongName() + " basic properties");
            ConfigOption[] options = this.getAllOptions();
            StringBuilder builder = new StringBuilder();
            for (ConfigOption option : options) {
                builder.append("# ").append(option.toString()).append(ThebombzenAPI.NEWLINE);
                for (String info : option.getInfo()) {
                    builder.append("#     ").append(info).append(ThebombzenAPI.NEWLINE);
                }
            }
            writer.write(builder.toString());
            writer.flush();
            writer.close();
            this.lastCheckedConfigLastModified = this.getPropertyFile().lastModified();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setProperty(ConfigOption option, String value) {
        this.setPropertyWithoutSave(option, value);
        this.saveProperties();
    }

    protected void setPropertyWithoutSave(ConfigOption option, String value) {
        this.properties.setProperty(option.toString(), value);
    }

    protected boolean shouldRefreshConfig() {
        long configLastModified = this.getPropertyFile().lastModified();
        return this.lastCheckedConfigLastModified != configLastModified;
    }
}

