/*
 * Decompiled with CFR 0.152.
 */
package thebombzen.mods.thebombzenapi.installer;

import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.jar.JarFile;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class APIInstallerFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JTextField textField;
    private JRadioButton installClient;
    private JRadioButton installServer;
    private JButton install;
    private String clientDirectory = APIInstallerFrame.getMinecraftClientDirectory();
    private String serverDirectory = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        AbstractInterruptibleChannel source = null;
        AbstractInterruptibleChannel destination = null;
        FileInputStream inStream = null;
        FileOutputStream outStream = null;
        try {
            inStream = new FileInputStream(sourceFile);
            outStream = new FileOutputStream(destFile);
            source = inStream.getChannel();
            destination = outStream.getChannel();
            long count = 0L;
            long size = ((FileChannel)source).size();
            while ((count += ((FileChannel)destination).transferFrom((ReadableByteChannel)((Object)source), count, size - count)) < size) {
            }
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
            if (outStream != null) {
                outStream.close();
            }
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    public static String getMinecraftClientDirectory() throws IOException {
        String name = System.getProperty("os.name");
        if (name.toLowerCase().contains("windows")) {
            return new File(System.getenv("appdata") + "\\.minecraft").getCanonicalPath();
        }
        if (name.toLowerCase().contains("mac") || name.toLowerCase().contains("osx") || name.toLowerCase().contains("os x")) {
            return new File(System.getProperty("user.home") + "/Library/Application Support/minecraft").getCanonicalPath();
        }
        return new File(System.getProperty("user.home") + "/.minecraft").getCanonicalPath();
    }

    public static void main(String[] args) throws IOException {
        new APIInstallerFrame().setVisible(true);
    }

    public APIInstallerFrame() throws IOException {
        final APIInstallerFrame frame = this;
        Box superBox = Box.createHorizontalBox();
        superBox.add(Box.createHorizontalStrut(10));
        Box content = Box.createVerticalBox();
        content.add(Box.createVerticalStrut(10));
        this.installClient = new JRadioButton("Install Client");
        this.installClient.setSelected(true);
        this.installServer = new JRadioButton("Install Server");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.installClient);
        buttonGroup.add(this.installServer);
        Box selectBox = Box.createHorizontalBox();
        selectBox.add(this.installClient);
        selectBox.add(Box.createHorizontalStrut(10));
        selectBox.add(this.installServer);
        content.add(selectBox);
        content.add(Box.createVerticalStrut(10));
        JLabel label = new JLabel("Select minecraft folder:");
        Box labelBox = Box.createHorizontalBox();
        labelBox.add(label);
        labelBox.add(Box.createHorizontalGlue());
        content.add(labelBox);
        Box textBox = Box.createHorizontalBox();
        this.textField = new JTextField();
        this.textField.setText(this.clientDirectory);
        textBox.add(this.textField);
        textBox.add(Box.createHorizontalStrut(10));
        JButton browseButton = new JButton("Browse");
        textBox.add(browseButton);
        content.add(textBox);
        content.add(Box.createVerticalStrut(10));
        JLabel forgeLabel = new JLabel("Remember to also install Minecraft Forge.");
        Box forgeLabelBox = Box.createHorizontalBox();
        forgeLabelBox.add(forgeLabel);
        forgeLabelBox.add(Box.createHorizontalGlue());
        content.add(forgeLabelBox);
        Box forgeLinkBox = Box.createHorizontalBox();
        JLabel forgeLinkLabel = new JLabel("<html><a href=\"http://files.minecraftforge.net/\">Download Minecraft Forge Here</a></html>");
        forgeLinkBox.add(forgeLinkLabel);
        forgeLinkBox.add(Box.createHorizontalGlue());
        content.add(forgeLinkBox);
        content.add(Box.createVerticalStrut(10));
        this.install = new JButton("Install ThebombzenAPI");
        Box installBox = Box.createHorizontalBox();
        installBox.add(Box.createHorizontalGlue());
        installBox.add(this.install);
        installBox.add(Box.createHorizontalGlue());
        content.add(installBox);
        content.add(Box.createVerticalStrut(10));
        superBox.add(content);
        superBox.add(Box.createHorizontalStrut(10));
        this.installClient.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                APIInstallerFrame.this.clickedInstallClient();
            }
        });
        this.installServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                APIInstallerFrame.this.clickedInstallServer();
            }
        });
        this.install.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                APIInstallerFrame.this.install();
            }
        });
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JFileChooser jfc = new JFileChooser();
                jfc.setMultiSelectionEnabled(false);
                jfc.setFileSelectionMode(1);
                int result = jfc.showOpenDialog(frame);
                if (result == 0) {
                    APIInstallerFrame.this.textField.setText(jfc.getSelectedFile().getAbsolutePath());
                }
            }
        });
        forgeLinkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                try {
                    Desktop.getDesktop().browse(new URI("http://files.minecraftforge.net/"));
                }
                catch (IOException e) {
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        });
        this.add(superBox);
        this.setTitle("Install ThebombzenAPI");
        this.pack();
        this.setDefaultCloseOperation(3);
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((size.width - this.getWidth()) / 2, (size.height - this.getHeight()) / 2);
    }

    private void clickedInstallClient() {
        this.serverDirectory = this.textField.getText();
        this.textField.setText(this.clientDirectory);
    }

    private void clickedInstallServer() {
        this.clientDirectory = this.textField.getText();
        this.textField.setText(this.serverDirectory);
    }

    private void install() {
        try {
            this.install(this.textField.getText());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error installing. Install manually.", "Error Installing", 0);
        }
    }

    private void install(String directory) throws Exception {
        File[] mods;
        File dir = new File(directory);
        if (!dir.isDirectory()) {
            JOptionPane.showMessageDialog(this, "Something's wrong with the given folder. Check spelling and try again.", "Hmmm...", 0);
            return;
        }
        File modsFolder = new File(directory, "mods");
        modsFolder.mkdir();
        File file = new File(APIInstallerFrame.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        JarFile jarFile = new JarFile(file);
        if (jarFile.getEntry("thebombzen/mods/thebombzenapi/installer/APIInstallerFrame.class") == null) {
            jarFile.close();
            throw new Exception();
        }
        jarFile.close();
        for (File testMod : mods = modsFolder.listFiles()) {
            if (!testMod.getName().matches("^ThebombzenAPI-v\\d\\.\\d(\\.\\d)?-mc\\d\\.\\d(\\.\\d)?\\.(jar|zip)$")) continue;
            testMod.delete();
        }
        APIInstallerFrame.copyFile(file, new File(modsFolder, file.getName()));
        JOptionPane.showMessageDialog(this, "Successfully installed ThebombzenAPI!", "Success!", 1);
        System.exit(0);
    }
}

