/*
 * Decompiled with CFR 0.152.
 */
package thebombzen.mods.autoswitch.configuration;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Keyboard;
import thebombzen.mods.autoswitch.AutoSwitch;
import thebombzen.mods.autoswitch.configuration.BlockItemIdentifier;
import thebombzen.mods.autoswitch.configuration.BlockToolPair;
import thebombzen.mods.autoswitch.configuration.ToolSelectionMode;
import thebombzen.mods.thebombzenapi.ThebombzenAPI;
import thebombzen.mods.thebombzenapi.ThebombzenAPIBaseMod;
import thebombzen.mods.thebombzenapi.configuration.ConfigFormatException;
import thebombzen.mods.thebombzenapi.configuration.ConfigOption;
import thebombzen.mods.thebombzenapi.configuration.SingleMultiBoolean;
import thebombzen.mods.thebombzenapi.configuration.ThebombzenAPIConfiguration;

@SideOnly(value=Side.CLIENT)
public class Configuration
extends ThebombzenAPIConfiguration {
    public static final int CONFIG_VERSION = 3;
    public static final int OVERRIDDEN_YES = 1;
    public static final int OVERRIDDEN_NO = -1;
    public static final int NOT_OVERRIDDEN = 0;
    public static final ConfigOption TOGGLE_KEY = new ConfigOption(Keyboard.getKeyIndex((String)"F10"), "TOGGLE_KEY", "Toggle Key", new String[]{"This key toggles AutoSwitch."});
    public static final ConfigOption PULSE_KEY = new ConfigOption(Keyboard.getKeyIndex((String)"V"), "PULSE_KEY", "Pulse Key", new String[]{"This key temporarily toggles", "AutoSwitch while it's held down."});
    public static final ConfigOption DEFAULT_ENABLED = new ConfigOption(0, true, "DEFAULT_ENABED", "Enabled by default", new String[]{"This option determines whether to", "enable AutoSwitch on new worlds", "and on worlds AutoSwitch hasn't", "been used on before."});
    public static final ConfigOption TOOL_SELECTION_MODE = new ConfigOption("FAST STANDARD", new String[]{"Fast Standard", "Slow Standard", "Fast Nonstandard"}, "TOOL_SELECTION_MODE", "Tool Selection Mode", new String[]{"Fast Standard picks the best standard tool,", "    where faster is better.", "Slow Standard picks the best standard tool,", "    where slower is better.", "Fast Nonstandard picks the best tool,", "    ignoring what's standard."});
    public static final ConfigOption BLOCKS = new ConfigOption(SingleMultiBoolean.ALWAYS, "BLOCKS", "Use on blocks", new String[]{"Use AutoSwitch when digging blocks."});
    public static final ConfigOption MOBS = new ConfigOption(SingleMultiBoolean.ALWAYS, "MOBS", "Use on mobs", new String[]{"Use AutoSwitch when attacking mobs."});
    public static final ConfigOption SWITCHBACK_BLOCKS = new ConfigOption(SingleMultiBoolean.ALWAYS, "SWITCHBACK_BLOCKS", "Unswitch on blocks", new String[]{"Switch back after digging a block."});
    public static final ConfigOption SWITCHBACK_MOBS = new ConfigOption(SingleMultiBoolean.ALWAYS, "SWITCHBACK_MOBS", "Unswitch on mobs", new String[]{"Switch back after attacking a mob."});
    public static final ConfigOption DEBUG = new ConfigOption(false, "DEBUG", "Debug Logging", new String[]{"Log debug output to", ".minecraft/mods/AutoSwitch/DEBUG.txt"});
    public static final ConfigOption USE_IN_CREATIVE = new ConfigOption(true, "USE_IN_CREATIVE", "Use in creative", new String[]{"Use AutoSwitch when in creative mode"});
    public static final ConfigOption TREEFELLER_COMPAT = new ConfigOption(false, "TREEFELLER_COMPAT", "Detect Tree Feller", new String[]{"Automatically detect when", "mcMMO Tree Feller is activated", "and temporarily set the tool selection", "mode to SLOW STANDARD."});
    public static final ConfigOption TREEFELLER_READY_AXE = new ConfigOption("**YOU READY YOUR AXE**", "TREEFELLER_READY_AXE", "mcMMO Ready Axe", new String[]{"When detecting tree feller,", "this says you've readied your axe.", "Some servers might have this in a different language."});
    public static final ConfigOption TREEFELLER_READY_OTHER = new ConfigOption("^\\*\\*YOU READY YOUR [A-Z]+\\*\\*$", "TREEFELLER_READY_OTHER", "mcMMO Ready Other", new String[]{"When detecting tree feller,", "this says another tool is ready.", "This is a regular expression."});
    public static final ConfigOption TREEFELLER_LOWER_AXE = new ConfigOption("**YOU LOWER YOUR AXE**", "TREEFELLER_LOWER_AXE", "mcMMO Lower Axe", new String[]{"When detecting tree feller,", "this says you've lowered your axe."});
    public static final ConfigOption TREEFELLER_WORNOFF = new ConfigOption("**Tree Feller has worn off**", "TREEFELLER_WORNOFF", "mcMMO Treefeller Worn Off", new String[]{"When detecting tree feller,", "this says treefeller has worn off."});
    public static final ConfigOption TREEFELLER_AXE_SPLINTER = new ConfigOption("YOUR AXE SPLINTERS INTO DOZENS OF PIECES!", "TREEFELLER_AXE_SPLINTER", "mcMMO Axe Splinter", new String[]{"When detecting tree feller,", "this says your axe has splintered."});
    public static final ConfigOption TREEFELLER_TOO_TIRED = new ConfigOption("^You are too tired to use that ability again\\. \\(\\d+s\\)$", "TREEFELLER_TOO_TIRED", "mcMMO Too Tired", new String[]{"When detecting tree feller,", "this says you are too tired.", "This is a regular expression."});
    public static final ConfigOption TREEFELLER_SKULL_SPLITTER = new ConfigOption("**Skull Splitter ACTIVATED**", "TREEFELLER_SKULL_SPLITTER", "mcMMO Skull Splitter", new String[]{"When detecting tree feller,", "this says you have used skull splitter", "instead of treefeller."});
    private Map<BlockItemIdentifier, Integer> customWeapons = new HashMap<BlockItemIdentifier, Integer>();
    private final String defaultConfig;
    private File extraConfigFile;
    private long extraConfigLastModified;
    private Set<BlockItemIdentifier> fortuneNoWorks = new HashSet<BlockItemIdentifier>();
    private Set<BlockItemIdentifier> fortuneWorks = new HashSet<BlockItemIdentifier>();
    private Set<BlockToolPair> standardBlocksAndTools = new HashSet<BlockToolPair>();
    private Set<BlockToolPair> notStandardBlocksAndTools = new HashSet<BlockToolPair>();
    private Set<BlockItemIdentifier> silkTouchNoWorks = new HashSet<BlockItemIdentifier>();
    private Set<BlockItemIdentifier> silkTouchWorks = new HashSet<BlockItemIdentifier>();
    private Set<BlockItemIdentifier> ignoreFortune = new HashSet<BlockItemIdentifier>();
    private Set<BlockItemIdentifier> ignoreSilkTouch = new HashSet<BlockItemIdentifier>();
    private Set<BlockItemIdentifier> fastStandardOverrides = new HashSet<BlockItemIdentifier>();
    private Set<BlockItemIdentifier> slowStandardOverrides = new HashSet<BlockItemIdentifier>();
    private Set<BlockItemIdentifier> fastNonStandardOverrides = new HashSet<BlockItemIdentifier>();
    private Set<BlockToolPair> harvestWorks = new HashSet<BlockToolPair>();
    private Set<BlockToolPair> harvestNoWorks = new HashSet<BlockToolPair>();
    private Set<BlockToolPair> damageableYes = new HashSet<BlockToolPair>();
    private Set<BlockToolPair> damageableNo = new HashSet<BlockToolPair>();

    private static boolean doesSetContainBlock(Set<? extends BlockItemIdentifier> set, Block block, int metadata) {
        for (BlockItemIdentifier blockItemIdentifier : set) {
            if (!blockItemIdentifier.contains(block, metadata)) continue;
            return true;
        }
        return false;
    }

    private static boolean doesSetContainToolAndBlock(Set<? extends BlockToolPair> set, ItemStack tool, Block block, int metadata) {
        for (BlockToolPair blockToolPair : set) {
            if (!blockToolPair.getBlock().contains(block, metadata) || !blockToolPair.getTool().contains(tool)) continue;
            return true;
        }
        return false;
    }

    private static int doesYesNoSetContainBlock(Set<? extends BlockItemIdentifier> no, Set<? extends BlockItemIdentifier> yes, Block block, int metadata) {
        if (Configuration.doesSetContainBlock(no, block, metadata)) {
            return -1;
        }
        if (Configuration.doesSetContainBlock(yes, block, metadata)) {
            return 1;
        }
        return 0;
    }

    private static int doesYesNoSetContainToolAndBlock(Set<? extends BlockToolPair> no, Set<? extends BlockToolPair> yes, ItemStack tool, Block block, int metadata) {
        if (Configuration.doesSetContainToolAndBlock(no, tool, block, metadata)) {
            return -1;
        }
        if (Configuration.doesSetContainToolAndBlock(yes, tool, block, metadata)) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration(AutoSwitch autoSwitch) {
        super((ThebombzenAPIBaseMod)autoSwitch);
        this.extraConfigFile = new File(ThebombzenAPI.sideSpecificUtilities.getMinecraftDirectory() + File.separator + "config" + File.separator + "AutoSwitch_Overrides.txt");
        File oldExtraConfigFile = new File(this.extraConfigFile.getParentFile(), "AutoSwitch_Overrides.cfg");
        StringBuilder builder = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(ThebombzenAPI.getResourceAsStream((ThebombzenAPIBaseMod)autoSwitch, (String)"AutoSwitch_Overrides.txt")));
            while (null != (line = reader.readLine())) {
                builder.append(line).append(ThebombzenAPI.NEWLINE);
            }
            reader.close();
        }
        catch (IOException ioe) {
            autoSwitch.throwException("Could not read default config!", ioe, true);
        }
        finally {
            this.defaultConfig = builder.toString();
        }
        if (oldExtraConfigFile.exists()) {
            oldExtraConfigFile.delete();
        }
    }

    public ConfigOption[] getAllOptions() {
        return new ConfigOption[]{TOGGLE_KEY, PULSE_KEY, DEFAULT_ENABLED, TOOL_SELECTION_MODE, BLOCKS, MOBS, SWITCHBACK_BLOCKS, SWITCHBACK_MOBS, DEBUG, USE_IN_CREATIVE, TREEFELLER_COMPAT, TREEFELLER_READY_AXE, TREEFELLER_READY_OTHER, TREEFELLER_LOWER_AXE, TREEFELLER_WORNOFF, TREEFELLER_AXE_SPLINTER, TREEFELLER_TOO_TIRED, TREEFELLER_SKULL_SPLITTER};
    }

    public int getCustomWeaponDamage(ItemStack itemstack) {
        if (itemstack == null) {
            return -1;
        }
        for (BlockItemIdentifier itemID : this.customWeapons.keySet()) {
            if (!itemID.contains(itemstack)) continue;
            return this.customWeapons.get((Object)itemID);
        }
        return -1;
    }

    public int getDamageableOverrideState(ItemStack tool, Block block, int metadata) {
        return Configuration.doesYesNoSetContainToolAndBlock(this.damageableNo, this.damageableYes, tool, block, metadata);
    }

    public ToolSelectionMode getDefaultToolSelectionMode() {
        ToolSelectionMode mode = ToolSelectionMode.parse(this.getStringProperty(TOOL_SELECTION_MODE));
        if (mode == null) {
            mode = ToolSelectionMode.FAST_STANDARD;
            this.setToolSelectionMode(mode);
        }
        return mode;
    }

    public File getExtraConfigFile() {
        return this.extraConfigFile;
    }

    public int getFortuneOverrideState(Block block, int metadata) {
        return Configuration.doesYesNoSetContainBlock(this.fortuneNoWorks, this.fortuneWorks, block, metadata);
    }

    public int getHarvestOverrideState(ItemStack tool, Block block, int metadata) {
        return Configuration.doesYesNoSetContainToolAndBlock(this.harvestNoWorks, this.harvestWorks, tool, block, metadata);
    }

    public int getSilkTouchOverrideState(Block block, int metadata) {
        return Configuration.doesYesNoSetContainBlock(this.silkTouchNoWorks, this.silkTouchWorks, block, metadata);
    }

    public int getStandardToolOverrideState(ItemStack tool, Block block, int metadata) {
        return Configuration.doesYesNoSetContainToolAndBlock(this.notStandardBlocksAndTools, this.standardBlocksAndTools, tool, block, metadata);
    }

    public ToolSelectionMode getToolSelectionMode(Block block, int metadata) {
        if (AutoSwitch.instance.isTreefellerOn() && this.getBooleanProperty(TREEFELLER_COMPAT)) {
            return ToolSelectionMode.SLOW_STANDARD;
        }
        if (this.isSlowStandardOverridden(block, metadata)) {
            return ToolSelectionMode.SLOW_STANDARD;
        }
        if (this.isFastNonStandardOverridden(block, metadata)) {
            return ToolSelectionMode.FAST_NONSTANDARD;
        }
        if (this.isFastStandardOverridden(block, metadata)) {
            return ToolSelectionMode.FAST_STANDARD;
        }
        return this.getDefaultToolSelectionMode();
    }

    private boolean isFastNonStandardOverridden(Block block, int metadata) {
        return Configuration.doesSetContainBlock(this.fastNonStandardOverrides, block, metadata);
    }

    private boolean isFastStandardOverridden(Block block, int metadata) {
        return Configuration.doesSetContainBlock(this.fastStandardOverrides, block, metadata);
    }

    public boolean isSilkTouchOverriddenToWork(Block block, int metadata) {
        return Configuration.doesSetContainBlock(this.silkTouchWorks, block, metadata);
    }

    private boolean isSlowStandardOverridden(Block block, int metadata) {
        return Configuration.doesSetContainBlock(this.slowStandardOverrides, block, metadata);
    }

    protected void loadProperties() throws IOException {
        String s;
        super.loadProperties();
        AutoSwitch.instance.setToggleKeyCode(DEFAULT_ENABLED.getDefaultToggleIndex(), this.getKeyCodeProperty(TOGGLE_KEY));
        if (!this.extraConfigFile.exists()) {
            this.writeExtraConfig();
            this.parseConfig(this.defaultConfig);
            return;
        }
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = new BufferedReader(new FileReader(this.extraConfigFile));
        while (null != (s = reader.readLine())) {
            sb.append(s).append(ThebombzenAPI.NEWLINE);
        }
        reader.close();
        this.parseConfig(sb.toString());
        this.extraConfigLastModified = this.getExtraConfigFile().lastModified();
    }

    private void parseBlockToolPairOverride(String line, Set<BlockToolPair> no, Set<BlockToolPair> yes) {
        int indexGreaterThan = line.indexOf(62);
        int indexLessThan = line.indexOf(60);
        String toolSub = "";
        String blockSub = "";
        boolean plus = false;
        if (indexGreaterThan > 0 && indexLessThan < 0) {
            toolSub = line.substring(1, indexGreaterThan);
            blockSub = line.substring(indexGreaterThan + 1);
            plus = true;
        } else if (indexLessThan > 0 && indexGreaterThan < 0) {
            toolSub = line.substring(1, indexLessThan);
            blockSub = line.substring(indexLessThan + 1);
            plus = false;
        } else {
            AutoSwitch.instance.forceDebug("Error on line: %s", new Object[]{line});
            AutoSwitch.instance.forceDebug("Error caused by: Expected > or < but not both.");
            return;
        }
        try {
            BlockItemIdentifier block = BlockItemIdentifier.parseBlockItemIdentifier(blockSub);
            BlockItemIdentifier tool = BlockItemIdentifier.parseBlockItemIdentifier(toolSub);
            (plus ? yes : no).add(new BlockToolPair(block, tool));
        }
        catch (ConfigFormatException e) {
            AutoSwitch.instance.forceDebug("Error on line: %s", new Object[]{line});
            AutoSwitch.instance.forceDebug("Error caused by: %s", new Object[]{e.toString()});
            AutoSwitch.instance.debugException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseConfig(String config) {
        this.fortuneNoWorks.clear();
        this.fortuneWorks.clear();
        this.notStandardBlocksAndTools.clear();
        this.standardBlocksAndTools.clear();
        this.silkTouchNoWorks.clear();
        this.silkTouchWorks.clear();
        this.customWeapons.clear();
        this.ignoreFortune.clear();
        this.ignoreSilkTouch.clear();
        this.fastStandardOverrides.clear();
        this.fastNonStandardOverrides.clear();
        this.slowStandardOverrides.clear();
        this.harvestWorks.clear();
        this.harvestNoWorks.clear();
        this.damageableYes.clear();
        this.damageableNo.clear();
        Scanner s = new Scanner(config);
        s.useDelimiter(ThebombzenAPI.NEWLINE);
        int version = -1;
        block33: while (s.hasNext()) {
            String line = s.next();
            int index = line.indexOf(35);
            if (index >= 0) {
                line = line.substring(0, index);
            }
            if ((line = line.replaceAll("\\s", "")).length() == 0) continue;
            if (line.length() < 2) {
                AutoSwitch.instance.forceDebug("Error on line: %s", new Object[]{line});
                AutoSwitch.instance.forceDebug("Error caused by: Line is too short");
                continue;
            }
            char first = line.charAt(0);
            switch (first) {
                case 'R': 
                case 'r': {
                    String sub = line.substring(1);
                    try {
                        version = ThebombzenAPI.parseInteger((String)sub);
                    }
                    catch (NumberFormatException nfe) {
                        version = -1;
                    }
                    if (version == 3) continue block33;
                    try {
                        this.writeExtraConfig();
                    }
                    catch (IOException ioe) {
                        this.mod.throwException("Could not write config file!", (Throwable)ioe, true);
                    }
                    this.parseConfig(this.defaultConfig);
                    s.close();
                    return;
                }
                case 'T': 
                case 't': {
                    char second = line.charAt(1);
                    if (second == '>') {
                        try {
                            this.silkTouchWorks.add(BlockItemIdentifier.parseBlockItemIdentifier(line.substring(2)));
                        }
                        catch (ConfigFormatException e) {
                            AutoSwitch.instance.forceDebug("Error on line: %s", new Object[]{line});
                            AutoSwitch.instance.forceDebug("Error caused by: %s", new Object[]{e.toString()});
                            AutoSwitch.instance.debugException(e);
                        }
                        break;
                    }
                    if (second == '<') {
                        try {
                            if (line.length() < 3) {
                                throw new ConfigFormatException("Line is too short");
                            }
                            if (line.charAt(2) == '<') {
                                this.ignoreSilkTouch.add(BlockItemIdentifier.parseBlockItemIdentifier(line.substring(3)));
                                break;
                            }
                            this.silkTouchNoWorks.add(BlockItemIdentifier.parseBlockItemIdentifier(line.substring(2)));
                        }
                        catch (ConfigFormatException e) {
                            AutoSwitch.instance.forceDebug("Error on line: %s", new Object[]{line});
                            AutoSwitch.instance.forceDebug("Error caused by: %s", new Object[]{e.toString()});
                            AutoSwitch.instance.debugException(e);
                        }
                        break;
                    }
                    AutoSwitch.instance.forceDebug("Error on line: %s", new Object[]{line});
                    AutoSwitch.instance.forceDebug("Error caused by: Expected < or >. Found %c", new Object[]{Character.valueOf(second)});
                    continue block33;
                }
                case 'F': 
                case 'f': {
                    char second = line.charAt(1);
                    if (second == '>') {
                        try {
                            this.fortuneWorks.add(BlockItemIdentifier.parseBlockItemIdentifier(line.substring(2)));
                        }
                        catch (ConfigFormatException e) {
                            AutoSwitch.instance.forceDebug("Error on line: %s", new Object[]{line});
                            AutoSwitch.instance.forceDebug("Error caused by: %s", new Object[]{e.toString()});
                        }
                        break;
                    }
                    if (second == '<') {
                        try {
                            if (line.length() < 3) {
                                throw new ConfigFormatException("Line is too short");
                            }
                            if (line.charAt(2) == '<') {
                                this.ignoreFortune.add(BlockItemIdentifier.parseBlockItemIdentifier(line.substring(3)));
                                break;
                            }
                            this.fortuneNoWorks.add(BlockItemIdentifier.parseBlockItemIdentifier(line.substring(2)));
                        }
                        catch (ConfigFormatException e) {
                            AutoSwitch.instance.forceDebug("Error on line: %s", new Object[]{line});
                            AutoSwitch.instance.forceDebug("Error caused by: %s", new Object[]{e.toString()});
                            AutoSwitch.instance.debugException(e);
                        }
                        break;
                    }
                    AutoSwitch.instance.forceDebug("Error on line: %s", new Object[]{line});
                    AutoSwitch.instance.forceDebug("Error caused by: Expected < or >. Found %c", new Object[]{Character.valueOf(second)});
                    continue block33;
                }
                case 'S': 
                case 's': {
                    this.parseBlockToolPairOverride(line, this.notStandardBlocksAndTools, this.standardBlocksAndTools);
                    break;
                }
                case 'H': 
                case 'h': {
                    this.parseBlockToolPairOverride(line, this.harvestNoWorks, this.harvestWorks);
                    break;
                }
                case 'D': 
                case 'd': {
                    this.parseBlockToolPairOverride(line, this.damageableNo, this.damageableYes);
                    break;
                }
                case 'M': 
                case 'm': {
                    int indexE = line.indexOf(61);
                    if (indexE < 0 || indexE >= line.length() - 1) {
                        AutoSwitch.instance.forceDebug("Error on line: %s", new Object[]{line});
                        AutoSwitch.instance.forceDebug("Error caused by: Expected = in middle of line.");
                        continue block33;
                    }
                    String blockSub = line.substring(1, indexE);
                    String typeSub = line.substring(indexE + 1).toLowerCase();
                    try {
                        Set<BlockItemIdentifier> setToAdd;
                        BlockItemIdentifier block = BlockItemIdentifier.parseBlockItemIdentifier(blockSub);
                        if (typeSub.contains("fast")) {
                            setToAdd = typeSub.contains("non") ? this.fastNonStandardOverrides : this.fastStandardOverrides;
                        } else if (typeSub.contains("slow")) {
                            setToAdd = this.slowStandardOverrides;
                        } else {
                            throw new ConfigFormatException("Invalid Tool Selection Mode.");
                        }
                        setToAdd.add(block);
                        break;
                    }
                    catch (ConfigFormatException e) {
                        AutoSwitch.instance.forceDebug("Error on line: %s", new Object[]{line});
                        AutoSwitch.instance.forceDebug("Error caused by: %s", new Object[]{e.toString()});
                        AutoSwitch.instance.debugException(e);
                        continue block33;
                    }
                }
                case 'W': 
                case 'w': {
                    int indexE = line.lastIndexOf(61);
                    if (indexE < 0 || indexE >= line.length() - 1) {
                        AutoSwitch.instance.forceDebug("Error on line: %s", new Object[]{line});
                        AutoSwitch.instance.forceDebug("Error caused by: Expected = in middle of line.");
                        continue block33;
                    }
                    String sub = line.substring(1, indexE);
                    String damageString = line.substring(indexE + 1);
                    Integer damage = null;
                    try {
                        damage = ThebombzenAPI.parseInteger((String)damageString);
                    }
                    catch (NumberFormatException nfe) {
                        AutoSwitch.instance.forceDebug("Error on line: %s", new Object[]{line});
                        AutoSwitch.instance.forceDebug("Error caused by: Invalid Number: %s", new Object[]{nfe.toString()});
                        continue block33;
                    }
                    try {
                        BlockItemIdentifier tool = BlockItemIdentifier.parseBlockItemIdentifier(sub);
                        this.customWeapons.put(tool, damage);
                    }
                    catch (ConfigFormatException e) {
                        AutoSwitch.instance.forceDebug("Error on line: %s", new Object[]{line});
                        AutoSwitch.instance.forceDebug("Error caused by: %s", new Object[]{e.toString()});
                        AutoSwitch.instance.debugException(e);
                    }
                    break;
                }
                default: {
                    AutoSwitch.instance.forceDebug("Error on line: %s", new Object[]{line});
                    AutoSwitch.instance.forceDebug("Error caused by: Unrecognized first character.");
                }
            }
        }
        if (version != 3) {
            try {
                this.writeExtraConfig();
            }
            catch (IOException ioe) {
                this.mod.throwException("Could not write config file!", (Throwable)ioe, true);
            }
            finally {
                this.parseConfig(this.defaultConfig);
            }
        }
        s.close();
    }

    protected void setPropertyWithoutSave(ConfigOption option, String value) {
        super.setPropertyWithoutSave(option, value);
        if (option.equals(TOGGLE_KEY)) {
            this.mod.setToggleKeyCode(DEFAULT_ENABLED.getDefaultToggleIndex(), ThebombzenAPI.getExtendedKeyIndex((String)value));
        }
    }

    public void setToolSelectionMode(ToolSelectionMode mode) {
        this.setProperty(TOOL_SELECTION_MODE, mode.toString());
    }

    public boolean shouldIgnoreFortune(Block block, int metadata) {
        return Configuration.doesSetContainBlock(this.ignoreFortune, block, metadata);
    }

    public boolean shouldIgnoreSilkTouch(Block block, int metadata) {
        return Configuration.doesSetContainBlock(this.ignoreSilkTouch, block, metadata);
    }

    public boolean shouldRefreshConfig() {
        if (super.shouldRefreshConfig()) {
            return true;
        }
        return this.extraConfigLastModified != this.getExtraConfigFile().lastModified();
    }

    private void writeExtraConfig() throws IOException {
        FileWriter writer = new FileWriter(this.extraConfigFile);
        writer.write(this.defaultConfig);
        writer.flush();
        writer.close();
    }
}

