/*
 * Decompiled with CFR 0.152.
 */
package thebombzen.mods.autoswitch.configuration;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Scanner;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import thebombzen.mods.autoswitch.configuration.SingleValueIdentifier;
import thebombzen.mods.autoswitch.configuration.ValueSet;
import thebombzen.mods.thebombzenapi.ThebombzenAPI;
import thebombzen.mods.thebombzenapi.configuration.BooleanTester;
import thebombzen.mods.thebombzenapi.configuration.ConfigFormatException;

public class SingleBlockItemIdentifier
implements BooleanTester<SingleValueIdentifier> {
    public static final int ALL = 0;
    public static final int NAME = 1;
    public static final int CLASS = 2;
    public static final int MATERIAL = 3;
    private String modid;
    private String name;
    private ValueSet[] valueSets;
    private int type;
    private int superNum;

    public static SingleBlockItemIdentifier parseSingleBlockItemIdentifier(String info) throws ConfigFormatException {
        String name;
        String modid;
        boolean all;
        if (info.length() == 0) {
            throw new ConfigFormatException("Empty block/item identifier");
        }
        char type = info.charAt(0);
        int superNum = 0;
        if (type == '@' || type == '$') {
            info = info.substring(1);
        } else if (type == '[') {
            int lastIndex = info.indexOf(93);
            if (lastIndex < 0) {
                throw new ConfigFormatException("No closing ]: " + info);
            }
            String superNumS = info.substring(1, lastIndex);
            try {
                superNum = ThebombzenAPI.parseInteger((String)superNumS);
            }
            catch (NumberFormatException e) {
                throw new ConfigFormatException("Invalid broadening number: " + superNumS, (Throwable)e);
            }
            info = info.substring(lastIndex + 1);
        }
        boolean bl = all = info.startsWith("+") || info.startsWith("-");
        if (all) {
            info = "false_prefix" + info;
        }
        Scanner scanner = new Scanner(info);
        scanner.useDelimiter("(?<=[^\\+-])(?=[\\+-])");
        if (!scanner.hasNext()) {
            scanner.close();
            return new SingleBlockItemIdentifier(0, new ValueSet[0]);
        }
        String fullname = scanner.next();
        if (all) {
            modid = "";
            name = "";
        } else {
            int index = fullname.indexOf(58);
            if (index < 0) {
                modid = "minecraft";
                name = fullname;
            } else {
                modid = fullname.substring(0, index);
                name = fullname.substring(index + 1);
            }
        }
        ArrayList<ValueSet> valueSets = new ArrayList<ValueSet>();
        while (scanner.hasNext()) {
            String s = scanner.next();
            ValueSet valueSet = ValueSet.parseValueSet(s);
            valueSets.add(valueSet);
        }
        scanner.close();
        ValueSet[] sets = valueSets.toArray(new ValueSet[valueSets.size()]);
        if (all) {
            return new SingleBlockItemIdentifier(0, sets);
        }
        switch (type) {
            case '@': 
            case '[': {
                return new SingleBlockItemIdentifier(2, modid, name, superNum, sets);
            }
            case '$': {
                return new SingleBlockItemIdentifier(3, modid, name, 0, sets);
            }
        }
        return new SingleBlockItemIdentifier(1, modid, name, 0, sets);
    }

    public SingleBlockItemIdentifier(int type, String namespace, String name, int damageValue) {
        this(type, namespace, name, 0, new ValueSet(damageValue, Integer.MAX_VALUE, false));
    }

    public SingleBlockItemIdentifier(int type, String namespace, String name, int superNum, ValueSet ... damageValues) {
        if (type < 0 || type > 3) {
            throw new IllegalArgumentException();
        }
        this.superNum = superNum;
        this.type = type;
        this.modid = namespace;
        this.name = name;
        if (damageValues.length == 0 || damageValues.length > 0 && damageValues[0].doesSubtract()) {
            ValueSet[] temp = new ValueSet[damageValues.length + 1];
            System.arraycopy(damageValues, 0, temp, 1, damageValues.length);
            temp[0] = new ValueSet();
            damageValues = temp;
        }
        this.valueSets = damageValues;
    }

    public SingleBlockItemIdentifier(int type, ValueSet ... damageValues) {
        this(type, "", "", 0, damageValues);
    }

    public boolean contains(SingleValueIdentifier identifier) {
        String modid = identifier.getModId();
        String name = identifier.getName();
        switch (this.type) {
            case 0: {
                break;
            }
            case 1: {
                if (this.getName().equals(name) && this.getModId().equals(modid)) break;
                return false;
            }
            case 2: {
                Block block = identifier.getBlock();
                if (block != null && this.getBlock() != null) {
                    Class<?> clazz = this.getBlock().getClass();
                    for (int i = 0; i < this.superNum && clazz.getSuperclass() != null; ++i) {
                        clazz = clazz.getSuperclass();
                    }
                    if (clazz.isAssignableFrom(block.getClass())) break;
                    return false;
                }
                Item item = identifier.getItem();
                if (item != null && this.getItem() != null) {
                    Class<?> clazz = this.getItem().getClass();
                    for (int i = 0; i < this.superNum && clazz.getSuperclass() != null; ++i) {
                        clazz = clazz.getSuperclass();
                    }
                    if (clazz.isAssignableFrom(item.getClass())) break;
                    return false;
                }
                return false;
            }
            case 3: {
                Block block = identifier.getBlock();
                if (block == null || this.getBlock() == null) {
                    return false;
                }
                if (this.getBlock().func_149688_o().equals(block.func_149688_o())) break;
                return false;
            }
        }
        for (int i = this.valueSets.length - 1; i >= 0; --i) {
            ValueSet set = this.valueSets[i];
            SingleValueIdentifier id2 = identifier;
            if (set.getMask() < 0) {
                if (!identifier.isItem() || identifier.getItem().func_77612_l() < identifier.getDamageValue()) continue;
                id2 = new SingleValueIdentifier(identifier);
                id2.setDamageValue(id2.getItem().func_77612_l() - identifier.getDamageValue());
            }
            if (!set.contains(id2)) continue;
            return !set.doesSubtract();
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SingleBlockItemIdentifier other = (SingleBlockItemIdentifier)obj;
        if (this.modid == null ? other.modid != null : !this.modid.equals(other.modid)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.superNum != other.superNum) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return Arrays.equals(this.valueSets, other.valueSets);
    }

    public Block getBlock() {
        return GameRegistry.findBlock((String)this.modid, (String)this.name);
    }

    public ValueSet[] getDamageValues() {
        return this.valueSets;
    }

    public Item getItem() {
        return GameRegistry.findItem((String)this.modid, (String)this.name);
    }

    public String getModId() {
        return this.modid;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.modid == null ? 0 : this.modid.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.superNum;
        result = 31 * result + this.type;
        result = 31 * result + Arrays.hashCode(this.valueSets);
        return result;
    }

    public boolean isBlock() {
        return this.getBlock() != null;
    }

    public boolean isItem() {
        return this.getItem() != null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        switch (this.type) {
            case 0: {
                builder.append('@');
                break;
            }
            case 2: {
                builder.append("[").append(this.superNum).append("]");
                break;
            }
            case 3: {
                builder.append('$');
            }
        }
        if (this.modid.length() != 0) {
            builder.append(this.modid).append(":");
        }
        builder.append(this.name);
        for (int i = 0; i < this.valueSets.length; ++i) {
            builder.append(this.valueSets[i]);
        }
        return builder.toString();
    }
}

