/*
 * Decompiled with CFR 0.152.
 */
package thebombzen.mods.autoswitch.installer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Scanner;
import java.util.jar.JarFile;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class ASInstallerFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static ASInstallerFrame instance;
    private JTextField textField;
    private JDialog dialog;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        AbstractInterruptibleChannel source = null;
        AbstractInterruptibleChannel destination = null;
        FileInputStream inStream = null;
        FileOutputStream outStream = null;
        try {
            inStream = new FileInputStream(sourceFile);
            outStream = new FileOutputStream(destFile);
            source = inStream.getChannel();
            destination = outStream.getChannel();
            long count = 0L;
            long size = ((FileChannel)source).size();
            while ((count += ((FileChannel)destination).transferFrom((ReadableByteChannel)((Object)source), count, size - count)) < size) {
            }
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
            if (outStream != null) {
                outStream.close();
            }
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    public static String getMinecraftClientDirectory() throws IOException {
        String name = System.getProperty("os.name");
        if (name.toLowerCase().contains("windows")) {
            return new File(System.getenv("appdata") + "\\.minecraft").getCanonicalPath();
        }
        if (name.toLowerCase().contains("mac") || name.toLowerCase().contains("osx") || name.toLowerCase().contains("os x")) {
            return new File(System.getProperty("user.home") + "/Library/Application Support/minecraft").getCanonicalPath();
        }
        return new File(System.getProperty("user.home") + "/.minecraft").getCanonicalPath();
    }

    public static void main(String[] args) throws IOException {
        new ASInstallerFrame().setVisible(true);
    }

    public ASInstallerFrame() throws IOException {
        instance = this;
        Box superBox = Box.createHorizontalBox();
        superBox.add(Box.createHorizontalStrut(10));
        Box content = Box.createVerticalBox();
        content.add(Box.createVerticalStrut(10));
        JLabel label = new JLabel("Select minecraft folder:");
        Box labelBox = Box.createHorizontalBox();
        labelBox.add(label);
        labelBox.add(Box.createHorizontalGlue());
        content.add(labelBox);
        Box textBox = Box.createHorizontalBox();
        this.textField = new JTextField();
        this.textField.setText(ASInstallerFrame.getMinecraftClientDirectory());
        textBox.add(this.textField);
        textBox.add(Box.createHorizontalStrut(10));
        JButton browseButton = new JButton("Browse");
        textBox.add(browseButton);
        content.add(textBox);
        content.add(Box.createVerticalStrut(10));
        JLabel forgeLabel = new JLabel("Remember to also install Minecraft Forge.");
        Box forgeLabelBox = Box.createHorizontalBox();
        forgeLabelBox.add(forgeLabel);
        forgeLabelBox.add(Box.createHorizontalGlue());
        content.add(forgeLabelBox);
        Box forgeLinkBox = Box.createHorizontalBox();
        JLabel forgeLinkLabel = new JLabel("<html><a href=\"http://files.minecraftforge.net/\">Download Minecraft Forge Here</a></html>");
        forgeLinkBox.add(forgeLinkLabel);
        forgeLinkBox.add(Box.createHorizontalGlue());
        content.add(forgeLinkBox);
        content.add(Box.createVerticalStrut(10));
        JButton install = new JButton("Install AutoSwitch");
        Box installBox = Box.createHorizontalBox();
        installBox.add(Box.createHorizontalGlue());
        installBox.add(install);
        installBox.add(Box.createHorizontalGlue());
        content.add(installBox);
        content.add(Box.createVerticalStrut(10));
        superBox.add(content);
        superBox.add(Box.createHorizontalStrut(10));
        install.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ASInstallerFrame.this.install();
                    }
                }).start();
            }
        });
        forgeLinkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                try {
                    Desktop.getDesktop().browse(new URI("http://files.minecraftforge.net/"));
                }
                catch (IOException e) {
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        });
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JFileChooser jfc = new JFileChooser();
                jfc.setMultiSelectionEnabled(false);
                jfc.setFileSelectionMode(1);
                int result = jfc.showOpenDialog(instance);
                if (result == 0) {
                    ASInstallerFrame.this.textField.setText(jfc.getSelectedFile().getAbsolutePath());
                }
            }
        });
        this.add(superBox);
        this.setTitle("Install AutoSwitch");
        this.pack();
        this.setDefaultCloseOperation(3);
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((size.width - this.getWidth()) / 2, (size.height - this.getHeight()) / 2);
        this.dialog = new JDialog(this);
        this.dialog.setLayout(new BorderLayout());
        this.dialog.add(Box.createVerticalStrut(15), "North");
        this.dialog.add(Box.createVerticalStrut(15), "South");
        this.dialog.add(Box.createHorizontalStrut(25), "West");
        this.dialog.add(Box.createHorizontalStrut(25), "East");
        this.dialog.add((Component)new JLabel("Installing..."), "Center");
        this.dialog.setTitle("Installing");
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.pack();
        this.dialog.setLocation(this.getX() + (this.getWidth() - this.dialog.getWidth()) / 2, this.getY() + (this.getHeight() - this.dialog.getHeight()) / 2);
    }

    public String getThebombzenAPILatestVersion() throws IOException {
        String latestVersion = null;
        BufferedReader br = null;
        try {
            URL versionURL = new URL("https://dl.dropboxusercontent.com/u/51080973/mods/ThebombzenAPI/Latest.txt");
            br = new BufferedReader(new InputStreamReader(versionURL.openStream()));
            latestVersion = br.readLine();
            latestVersion = latestVersion + String.format("%n%s%n", br.readLine());
        }
        catch (MalformedURLException e) {
            throw new Error();
        }
        finally {
            br.close();
        }
        return latestVersion;
    }

    private void install() {
        try {
            this.install(this.textField.getText());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dialog.dispose();
            JOptionPane.showMessageDialog(this, "Error installing. Install manually.", "Error Installing", 0);
        }
        System.exit(0);
    }

    private void install(String directory) throws Exception {
        File[] mods;
        File dir = new File(directory);
        if (!dir.isDirectory()) {
            JOptionPane.showMessageDialog(this, "Something's wrong with the given folder. Check spelling and try again.", "Hmmm...", 0);
            return;
        }
        this.dialog.setVisible(true);
        File modsFolder = new File(directory, "mods");
        modsFolder.mkdir();
        File file = new File(ASInstallerFrame.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        JarFile jarFile = new JarFile(file);
        if (jarFile.getEntry("thebombzen/mods/autoswitch/installer/ASInstallerFrame.class") == null) {
            jarFile.close();
            throw new Exception("Unable to open jar file!");
        }
        jarFile.close();
        this.installThebombzenAPI(directory);
        for (File testMod : mods = modsFolder.listFiles()) {
            if (!testMod.getName().matches("^AutoSwitch(Mod)?-v\\d\\.\\d(\\.\\d)?-mc(beta)?\\d\\.\\d(\\.\\d)?\\.(jar|zip)$")) continue;
            testMod.delete();
        }
        ASInstallerFrame.copyFile(file, new File(modsFolder, file.getName()));
        this.dialog.dispose();
        JOptionPane.showMessageDialog(this, "Successfully installed AutoSwitch!", "Success!", 1);
    }

    public void installThebombzenAPI(String directory) throws Exception {
        File[] subFiles;
        File thebombzenAPI;
        String latest = this.getThebombzenAPILatestVersion();
        Scanner scanner = new Scanner(latest);
        scanner.useDelimiter(String.format("%n", new Object[0]));
        String fileName = scanner.next();
        String url = scanner.next();
        scanner.close();
        File modsFolder = new File(directory, "mods");
        if (!modsFolder.exists()) {
            modsFolder.mkdir();
        }
        if ((thebombzenAPI = new File(modsFolder, fileName)).exists()) {
            return;
        }
        URL downloadURL = new URL(url);
        for (File file : subFiles = modsFolder.listFiles()) {
            if (!file.getName().matches("^ThebombzenAPI-v\\d+\\.\\d+(\\.\\d+)?-mc\\d+\\.\\d+(\\.\\d+)?\\.(zip|jar)$")) continue;
            file.delete();
        }
        FileOutputStream fos = new FileOutputStream(thebombzenAPI);
        ReadableByteChannel channel = Channels.newChannel(downloadURL.openStream());
        fos.getChannel().transferFrom(channel, 0L, Long.MAX_VALUE);
        channel.close();
        fos.close();
    }
}

