/*
 * Decompiled with CFR 0.152.
 */
package thebombzen.mods.autoswitch;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import thebombzen.mods.autoswitch.Tests;
import thebombzen.mods.autoswitch.configuration.Configuration;
import thebombzen.mods.autoswitch.configuration.ToolSelectionMode;
import thebombzen.mods.thebombzenapi.ThebombzenAPI;
import thebombzen.mods.thebombzenapi.ThebombzenAPIBaseMod;

@SideOnly(value=Side.CLIENT)
@Mod(modid="autoswitch", name="AutoSwitch", version="5.1.0", dependencies="required-after:thebombzenapi", guiFactory="thebombzen.mods.autoswitch.configuration.ConfigGuiFactory")
public class AutoSwitch
extends ThebombzenAPIBaseMod {
    public static final int STAGE_H0 = 0;
    public static final int STAGE_SWITCHED = 1;
    public static final int STAGE_CANCELED = 2;
    public static final Minecraft mc = Minecraft.func_71410_x();
    private int entityAttackStage = 0;
    private EntityLivingBase entitySwitchedOn = null;
    private Configuration configuration;
    private boolean prevMouseDown = false;
    private boolean prevPulse = false;
    private int prevtool = 0;
    private boolean pulseOn = false;
    private boolean switchback = false;
    private boolean treefellerOn = false;
    @Mod.Instance(value="autoswitch")
    public static AutoSwitch instance;

    @SubscribeEvent
    public void clientChat(ClientChatReceivedEvent event) {
        String text = event.message.func_150260_c();
        if (text.equals(this.configuration.getStringProperty(Configuration.TREEFELLER_READY_AXE))) {
            this.treefellerOn = true;
        } else if (text.matches(this.configuration.getStringProperty(Configuration.TREEFELLER_READY_OTHER))) {
            this.treefellerOn = false;
        } else if (text.equals(this.configuration.getStringProperty(Configuration.TREEFELLER_LOWER_AXE))) {
            this.treefellerOn = false;
        } else if (text.equals(this.configuration.getStringProperty(Configuration.TREEFELLER_WORNOFF))) {
            this.treefellerOn = false;
        } else if (text.equals(this.configuration.getStringProperty(Configuration.TREEFELLER_AXE_SPLINTER))) {
            this.treefellerOn = false;
        } else if (text.matches(this.configuration.getStringProperty(Configuration.TREEFELLER_TOO_TIRED))) {
            this.treefellerOn = false;
        } else if (text.equals(this.configuration.getStringProperty(Configuration.TREEFELLER_SKULL_SPLITTER))) {
            this.treefellerOn = false;
        }
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (!event.phase.equals((Object)TickEvent.Phase.START)) {
            return;
        }
        if (AutoSwitch.mc.field_71441_e == null) {
            return;
        }
        if (ThebombzenAPI.hasWorldChanged()) {
            this.treefellerOn = false;
        }
        if (this.entityAttackStage == 2) {
            AutoSwitch.mc.field_71439_g.func_71038_i();
            AutoSwitch.mc.field_71442_b.func_78764_a((EntityPlayer)AutoSwitch.mc.field_71439_g, (Entity)this.entitySwitchedOn);
            this.entityAttackStage = 0;
            this.entitySwitchedOn = null;
            return;
        }
        this.pulseOn = ThebombzenAPI.isExtendedKeyDown((int)this.configuration.getKeyCodeProperty(Configuration.PULSE_KEY));
        int keyCode = AutoSwitch.mc.field_71474_y.field_74312_F.func_151463_i();
        boolean mouseDown = ThebombzenAPI.isExtendedKeyDown((int)keyCode);
        if (!mouseDown && this.prevMouseDown || mouseDown && this.pulseOn ^ this.prevPulse) {
            this.switchBack();
        }
        if (mouseDown && !this.prevMouseDown || mouseDown && this.pulseOn ^ this.prevPulse) {
            this.prevtool = AutoSwitch.mc.field_71439_g.field_71071_by.field_70461_c;
        }
        if (mouseDown) {
            if (AutoSwitch.mc.field_71476_x != null && AutoSwitch.mc.field_71476_x.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                this.potentiallySwitchTools((World)AutoSwitch.mc.field_71441_e, AutoSwitch.mc.field_71476_x.field_72311_b, AutoSwitch.mc.field_71476_x.field_72312_c, AutoSwitch.mc.field_71476_x.field_72309_d);
            } else if (AutoSwitch.mc.field_71476_x != null && AutoSwitch.mc.field_71476_x.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && AutoSwitch.mc.field_71476_x.field_72308_g instanceof EntityLivingBase) {
                this.potentiallySwitchWeapons((EntityLivingBase)AutoSwitch.mc.field_71476_x.field_72308_g);
            }
        }
        this.prevMouseDown = mouseDown;
        this.prevPulse = this.pulseOn;
    }

    public void debug(String string) {
        this.debug("%s", string);
    }

    public void debug(String format, Object ... args) {
        if (this.configuration.getBooleanProperty(Configuration.DEBUG)) {
            this.forceDebug(format, args);
        }
    }

    public void debugException(Throwable exception) {
        if (this.configuration.getBooleanProperty(Configuration.DEBUG)) {
            this.forceDebugException(exception);
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public String getDownloadLocationURLString() {
        return "http://is.gd/ThebombzensMods#AutoSwitch";
    }

    public String getLongName() {
        return "AutoSwitch";
    }

    public String getLongVersionString() {
        return "AutoSwitch, version 5.1.0, Minecraft 1.7.10";
    }

    public int getNumToggleKeys() {
        return 1;
    }

    public String getShortName() {
        return "AS";
    }

    protected String getToggleMessageString(int index, boolean enabled) {
        if (enabled) {
            return "AutoSwitch is now enabled.";
        }
        return "AutoSwitch is now disabled.";
    }

    protected String getVersionFileURLString() {
        return "https://dl.dropboxusercontent.com/u/51080973/Mods/AutoSwitch/ASVersion.txt";
    }

    public void init1(FMLPreInitializationEvent event) {
        FMLCommonHandler.instance().bus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.configuration = new Configuration(this);
        FMLCommonHandler.instance().findContainerFor((Object)((Object)this)).getMetadata().authorList = Arrays.asList("Thebombzen");
    }

    public boolean isToolBetter(ItemStack newItemStack, ItemStack oldItemStack, World world, int x, int y, int z) {
        boolean oldHasSilk;
        Block block = world.func_147439_a(x, y, z);
        if (block == null || block.isAir((IBlockAccess)world, x, y, z)) {
            return false;
        }
        int metadata = world.func_72805_g(x, y, z);
        float newStr = Tests.getDigSpeed(newItemStack, block, metadata);
        float oldStr = Tests.getDigSpeed(oldItemStack, block, metadata);
        float newBlockStr = Tests.getBlockStrength(newItemStack, world, x, y, z);
        float oldBlockStr = Tests.getBlockStrength(oldItemStack, world, x, y, z);
        int newAdjustedBlockStr = Tests.getAdjustedBlockStr(newBlockStr);
        int oldAdjustedBlockStr = Tests.getAdjustedBlockStr(oldBlockStr);
        if (newBlockStr <= 0.0f && oldBlockStr <= 0.0f) {
            this.debug("Not switching because block is unbreakable by either item.");
            return false;
        }
        int newHarvest = Tests.getHarvestLevel(newItemStack, block, metadata);
        int oldHarvest = Tests.getHarvestLevel(oldItemStack, block, metadata);
        this.debug("newBlockStr: %.10f, oldBlockStr %.10f", Float.valueOf(newBlockStr), Float.valueOf(oldBlockStr));
        this.debug("newHarvest: %d, oldHarvest: %d", newHarvest, oldHarvest);
        this.debug("newStrength: %f, oldStrength: %f", Float.valueOf(newStr), Float.valueOf(oldStr));
        this.debug("newAdjustedBlockStr: %d, oldAdjustedBlockStr: %d", newAdjustedBlockStr, oldAdjustedBlockStr);
        float newEff = Tests.getEff(newStr, newItemStack);
        float oldEff = Tests.getEff(oldStr, oldItemStack);
        this.debug("newEff: %f, oldEff: %f", Float.valueOf(newEff), Float.valueOf(oldEff));
        ToolSelectionMode toolSelectionMode = this.configuration.getToolSelectionMode(block, metadata);
        this.debug("Tool Selection Mode: %s", toolSelectionMode.toString());
        int newStandard = Tests.getToolStandardness(newItemStack, world, x, y, z);
        int oldStandard = Tests.getToolStandardness(oldItemStack, world, x, y, z);
        this.debug("newStandard: %d, oldStandard: %d", newStandard, oldStandard);
        boolean newDamageable = Tests.isItemStackDamageableOnBlock(newItemStack, world, x, y, z);
        boolean oldDamageable = Tests.isItemStackDamageableOnBlock(oldItemStack, world, x, y, z);
        this.debug("newDamageable: %b, oldDamageable: %b", newDamageable, oldDamageable);
        int adjustedBlockStrComparison = new Integer(newAdjustedBlockStr).compareTo(oldAdjustedBlockStr);
        int blockStrComparison = Float.compare(newBlockStr, oldBlockStr);
        if (toolSelectionMode.isStandard() || this.configuration.getStandardToolOverrideState(newItemStack, block, metadata) != this.configuration.getStandardToolOverrideState(oldItemStack, block, metadata)) {
            if (newStandard > oldStandard) {
                this.debug("Switching because new item is more standard than old.");
                return true;
            }
            if (oldStandard > newStandard) {
                this.debug("Not switching because old item is more standard than new.");
                return false;
            }
            if (newStandard <= 0 && oldStandard <= 0) {
                if (newDamageable && !oldDamageable) {
                    this.debug("Not switching because new tool is damageable and old isn't, and neither are standard.");
                    return false;
                }
                if (oldDamageable && !newDamageable) {
                    this.debug("Switching because old tool is damageable and new isn't, and neither are standard.");
                    return true;
                }
            }
        } else if (toolSelectionMode.isFast()) {
            if (adjustedBlockStrComparison > 0) {
                this.debug("Switching because new tool is stronger.");
                return true;
            }
            if (adjustedBlockStrComparison < 0) {
                this.debug("Not switching because old tool is stronger.");
                return false;
            }
        } else {
            if (adjustedBlockStrComparison < 0) {
                this.debug("Switching because new item is worse than old item and SLOW STANDARD is on.");
                return true;
            }
            if (adjustedBlockStrComparison > 0) {
                this.debug("Not switching because new item is better than old item and SLOW STANDARD is on.");
                return false;
            }
        }
        boolean silkWorks = Tests.doesSilkTouchWorkOnBlock(world, x, y, z);
        boolean newHasSilk = EnchantmentHelper.func_77506_a((int)Enchantment.field_77348_q.field_77352_x, (ItemStack)newItemStack) > 0;
        boolean bl = oldHasSilk = EnchantmentHelper.func_77506_a((int)Enchantment.field_77348_q.field_77352_x, (ItemStack)oldItemStack) > 0;
        if (this.configuration.shouldIgnoreSilkTouch(block, metadata)) {
            this.debug("Ignoring Silk Touch.");
        } else {
            this.debug("silkWorks: %b, newHasSilk: %b, oldHasSilk: %b", silkWorks, newHasSilk, oldHasSilk);
            if (newHasSilk && !oldHasSilk) {
                if (silkWorks) {
                    this.debug("Switching because new has silk touch and old doesn't, and new works.");
                    return true;
                }
                if (oldStandard > 0) {
                    this.debug("Not switching because new has silk touch and old doesn't, and old replaces new.");
                    return false;
                }
                if (newStandard <= 0) {
                    this.debug("Not switching because new has silk touch and old doesn't, and new is weak.");
                    return false;
                }
            } else if (oldHasSilk && !newHasSilk) {
                if (silkWorks) {
                    this.debug("Not switching because old has silk touch and new doesn't, and old works.");
                    return false;
                }
                if (newStandard > 0) {
                    this.debug("Switching because old has silk touch and new doesn't, and new replaces old.");
                    return true;
                }
                if (oldStandard <= 0) {
                    this.debug("Switching because old has silk touch and new doesn't, and old is weak.");
                    return true;
                }
            }
        }
        boolean fortuneWorks = Tests.doesFortuneWorkOnBlock(world, x, y, z);
        int newFortuneLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)newItemStack);
        int oldFortuneLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)oldItemStack);
        if (this.configuration.shouldIgnoreFortune(block, metadata)) {
            this.debug("Ignoring Fortune.");
        } else {
            this.debug("fortuneWorks: %b, newFortuneLevel: %d, oldFortuneLevel: %d", fortuneWorks, newFortuneLevel, oldFortuneLevel);
            if (newFortuneLevel > oldFortuneLevel) {
                if (fortuneWorks) {
                    this.debug("Switching because new fortune is more than old, and new works.");
                    return true;
                }
                if (oldStandard > 0) {
                    this.debug("Not switching because new fortune is more than old, and old replaces new.");
                    return false;
                }
                if (newStandard <= 0) {
                    this.debug("Not switching because new fortune is more than old, and new is weak.");
                    return false;
                }
            } else if (oldFortuneLevel > newFortuneLevel) {
                if (fortuneWorks) {
                    this.debug("Not switching because old fortune is more than new, and old works.");
                    return false;
                }
                if (newStandard > 0) {
                    this.debug("Switching because old fortune is more than new, and new replaces old.");
                    return true;
                }
                if (oldStandard <= 0) {
                    this.debug("Switching because old fortune is more than new, and old is weak.");
                    return true;
                }
            }
        }
        if (toolSelectionMode.isFast()) {
            if (adjustedBlockStrComparison > 0) {
                this.debug("Switching because new tool is stronger.");
                return true;
            }
            if (adjustedBlockStrComparison < 0) {
                this.debug("Not switching because old tool is stronger.");
                return false;
            }
        } else {
            if (adjustedBlockStrComparison < 0) {
                this.debug("Switching because new item is worse than old item and SLOW STANDARD is on.");
                return true;
            }
            if (adjustedBlockStrComparison > 0) {
                this.debug("Not switching because new item is better than old item and SLOW STANDARD is on.");
                return false;
            }
        }
        Set<Enchantment> bothItemsEnchantments = Tests.getNonstandardNondamageEnchantmentsOnBothStacks(newItemStack, oldItemStack);
        for (Enchantment enchantment : bothItemsEnchantments) {
            int oldLevel = EnchantmentHelper.func_77506_a((int)enchantment.field_77352_x, (ItemStack)oldItemStack);
            int newLevel = EnchantmentHelper.func_77506_a((int)enchantment.field_77352_x, (ItemStack)newItemStack);
            if (newLevel > oldLevel) {
                this.debug("Switching because new %s level, %d, is more than old, %d.", enchantment.func_77320_a(), newLevel, oldLevel);
                return true;
            }
            if (newLevel >= oldLevel) continue;
            this.debug("Switching because old %s level, %d, is more than new, %d.", enchantment.func_77320_a(), oldLevel, newLevel);
            return false;
        }
        if (newDamageable && !oldDamageable) {
            this.debug("Not switching because new tool is damageable and old isn't.");
            return false;
        }
        if (oldDamageable && !newDamageable) {
            this.debug("Switching because old tool is damageable and new isn't.");
            return true;
        }
        if (newDamageable && oldDamageable) {
            int oldUnbreakingLevel;
            if (newFortuneLevel > oldFortuneLevel) {
                this.debug("Not switching because new fortune is bad and items are damageable.");
                return false;
            }
            if (oldFortuneLevel > newFortuneLevel) {
                this.debug("Switching because old fortune is bad and items are damageable.");
                return true;
            }
            int newUnbreakingLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)newItemStack);
            if (newUnbreakingLevel > (oldUnbreakingLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)oldItemStack))) {
                this.debug("Switching because new unbreaking is more than old unbreaking.");
                return true;
            }
            if (oldUnbreakingLevel > newUnbreakingLevel) {
                this.debug("Not switching because old unbreaking is more than new unbreaking.");
                return false;
            }
        }
        if (!(!toolSelectionMode.isFast() || newDamageable && oldDamageable)) {
            if (blockStrComparison > 0) {
                this.debug("Switching because new tool is stronger.");
                return true;
            }
            if (blockStrComparison < 0) {
                this.debug("Not switching because old tool is stronger.");
                return false;
            }
        } else {
            if (blockStrComparison < 0) {
                this.debug("Switching because new item is worse than old item and SLOW STANDARD is on.");
                return true;
            }
            if (blockStrComparison > 0) {
                this.debug("Not switching because new item is better than old item and SLOW STANDARD is on.");
                return false;
            }
        }
        this.debug("Not switching because tools are equal.");
        return false;
    }

    public boolean isTreefellerOn() {
        return this.treefellerOn;
    }

    public boolean isWeaponBetter(ItemStack newItemStack, ItemStack oldItemStack, EntityLivingBase entityover) {
        boolean isPlayer = entityover instanceof EntityPlayer;
        double oldDamage = Tests.getFullItemStackDamage(oldItemStack, entityover);
        double newDamage = Tests.getFullItemStackDamage(newItemStack, entityover);
        this.debug("Old damage is %f, new damage is %f.", oldDamage, newDamage);
        if (isPlayer) {
            if (newDamage > oldDamage) {
                this.debug("Switching because new damage is more.");
                return true;
            }
            if (newDamage < oldDamage) {
                this.debug("Not switching because old damage is more.");
                return false;
            }
        } else {
            int oldHits = oldDamage == 0.0 ? Integer.MAX_VALUE : MathHelper.func_76143_f((double)((double)entityover.func_110138_aP() / oldDamage));
            int newHits = newDamage == 0.0 ? Integer.MAX_VALUE : MathHelper.func_76143_f((double)((double)entityover.func_110138_aP() / newDamage));
            this.debug("Old hits are %d, new hits are %d", oldHits, newHits);
            if (newHits < oldHits) {
                this.debug("Switching because new hits are fewer.");
                return true;
            }
            if (newHits > oldHits) {
                this.debug("Not switching because old hits are fewer.");
                return false;
            }
        }
        int newLootingLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77335_o.field_77352_x, (ItemStack)newItemStack);
        int newFireAspectLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77334_n.field_77352_x, (ItemStack)newItemStack);
        int newKnockbackLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77337_m.field_77352_x, (ItemStack)newItemStack);
        int newUnbreakingLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)newItemStack);
        int oldLootingLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77335_o.field_77352_x, (ItemStack)oldItemStack);
        int oldFireAspectLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77334_n.field_77352_x, (ItemStack)oldItemStack);
        int oldKnockbackLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77337_m.field_77352_x, (ItemStack)oldItemStack);
        int oldUnbreakingLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)oldItemStack);
        if (!isPlayer) {
            if (newLootingLevel > oldLootingLevel) {
                this.debug("Switching because new looting, %d, is more than old, %d.", newLootingLevel, oldLootingLevel);
                return true;
            }
            if (oldLootingLevel > newLootingLevel) {
                this.debug("Not switching because old looting, %d, is more than new, %d.", oldLootingLevel, newLootingLevel);
                return false;
            }
        }
        if (newFireAspectLevel > oldFireAspectLevel) {
            this.debug("Switching because new fire aspect, %d, is more than old, %d.", newFireAspectLevel, oldFireAspectLevel);
            return true;
        }
        if (oldFireAspectLevel > newFireAspectLevel) {
            this.debug("Not switching because old fire aspect, %d, is more than new, %d.", oldFireAspectLevel, newFireAspectLevel);
            return false;
        }
        if (newKnockbackLevel > oldKnockbackLevel) {
            this.debug("Switching because new knockback, %d, is more than old, %d.", newKnockbackLevel, oldKnockbackLevel);
            return true;
        }
        if (oldKnockbackLevel > newKnockbackLevel) {
            this.debug("Not switching because old knockback, %d, is more than new, %d.", oldKnockbackLevel, newKnockbackLevel);
            return false;
        }
        Set<Enchantment> bothItemsEnchantments = Tests.getNonstandardNondamageEnchantmentsOnBothStacks(newItemStack, oldItemStack);
        for (Enchantment enchantment : bothItemsEnchantments) {
            int oldLevel = EnchantmentHelper.func_77506_a((int)enchantment.field_77352_x, (ItemStack)oldItemStack);
            int newLevel = EnchantmentHelper.func_77506_a((int)enchantment.field_77352_x, (ItemStack)newItemStack);
            if (newLevel > oldLevel) {
                this.debug("Switching because new %s level, %d, is more than old, %d.", enchantment.func_77320_a(), newLevel, oldLevel);
                return true;
            }
            if (newLevel >= oldLevel) continue;
            this.debug("Switching because old %s level, %d, is more than new, %d.", enchantment.func_77320_a(), oldLevel, newLevel);
            return false;
        }
        if (Tests.isSword(newItemStack) && !Tests.isSword(oldItemStack)) {
            this.debug("Switching because new weapon is sword and old isn't.");
            return true;
        }
        if (Tests.isSword(oldItemStack) && !Tests.isSword(newItemStack)) {
            this.debug("Not switching because old weapon is sword and new isn't.");
            return false;
        }
        if (newDamage > oldDamage) {
            this.debug("Switching because new damage is more and all else is equal.");
            return true;
        }
        if (newDamage < oldDamage) {
            this.debug("Not switching because old damage is more and all else is equal.");
            return false;
        }
        boolean newDamageable = Tests.isItemStackDamageable(newItemStack);
        boolean oldDamageable = Tests.isItemStackDamageable(oldItemStack);
        this.debug("newDamageable: %b, oldDamageable: %b", newDamageable, oldDamageable);
        if (newDamageable && !oldDamageable) {
            this.debug("Not switching because new weapon is damageable and old isn't.");
            return false;
        }
        if (oldDamageable && !newDamageable) {
            this.debug("Switching because new weapon is not damageable and old is.");
            return true;
        }
        if (newDamageable && oldDamageable && newUnbreakingLevel > oldUnbreakingLevel) {
            this.debug("Switching because new unbreaking, %d, is more than old, %d.", newUnbreakingLevel, oldUnbreakingLevel);
            return true;
        }
        if (newDamageable && oldDamageable && oldUnbreakingLevel > newUnbreakingLevel) {
            this.debug("Not switching because old unbreaking, %d, is more than new, %d.", oldUnbreakingLevel, newUnbreakingLevel);
            return false;
        }
        if (newItemStack == null && oldItemStack != null) {
            this.debug("Switching because new tool is fist and old is useless.");
            return true;
        }
        if (oldItemStack == null && newItemStack != null) {
            this.debug("Not switching because old tool is fist and new is useless.");
            return false;
        }
        this.debug("Not switching because weapons are equal.");
        return false;
    }

    @SubscribeEvent
    public void onEntityAttack(AttackEntityEvent event) {
        if (!event.entity.field_70170_p.field_72995_K) {
            return;
        }
        if (this.entityAttackStage == 1 && this.entitySwitchedOn == event.target) {
            this.entityAttackStage = 2;
            event.setCanceled(true);
        } else if (this.entityAttackStage != 2) {
            this.entitySwitchedOn = null;
            this.entityAttackStage = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean potentiallySwitchTools(World world, int x, int y, int z) {
        if (this.pulseOn == this.isToggleEnabled(Configuration.DEFAULT_ENABLED.getDefaultToggleIndex()) || AutoSwitch.mc.field_71442_b.func_78758_h() && !this.configuration.getBooleanProperty(Configuration.USE_IN_CREATIVE) || AutoSwitch.mc.field_71462_r != null || !this.configuration.getSingleMultiProperty(Configuration.BLOCKS)) {
            return false;
        }
        this.debug("====START====");
        this.debug(this.getLongVersionString());
        try {
            this.switchToBestTool((World)AutoSwitch.mc.field_71441_e, x, y, z);
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            this.throwException("Error switching tools", e, false);
            boolean bl = false;
            return bl;
        }
        finally {
            this.debug("====END====");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean potentiallySwitchWeapons(EntityLivingBase entity) {
        if (this.pulseOn == this.isToggleEnabled(Configuration.DEFAULT_ENABLED.getDefaultToggleIndex()) || AutoSwitch.mc.field_71442_b.func_78758_h() && !this.configuration.getBooleanProperty(Configuration.USE_IN_CREATIVE) || AutoSwitch.mc.field_71462_r != null || !this.configuration.getSingleMultiProperty(Configuration.MOBS)) {
            return false;
        }
        this.debug("====START====");
        this.debug(this.getLongVersionString());
        this.debug("Switching on an entity, %s", entity.toString());
        try {
            this.entitySwitchedOn = entity;
            this.entityAttackStage = 1;
            this.switchToBestWeapon((EntityPlayer)AutoSwitch.mc.field_71439_g, entity);
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            this.throwException("Error switching weapons", e, false);
            boolean bl = false;
            return bl;
        }
        finally {
            this.debug("====END====");
        }
    }

    private void switchBack() {
        if (this.switchback) {
            AutoSwitch.mc.field_71439_g.field_71071_by.field_70461_c = this.prevtool;
            this.switchback = false;
            this.debug("Switching tools back to %d", this.prevtool);
        }
    }

    private void switchToBestTool(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        GameRegistry.UniqueIdentifier id = GameRegistry.findUniqueIdentifierFor((Block)block);
        String name = String.format("%s:%s", id.modId, id.name);
        this.debug("Testing vs block %s", name);
        String[] names = new String[9];
        for (int i = 0; i < 9; ++i) {
            if (AutoSwitch.mc.field_71439_g.field_71071_by.field_70462_a[i] == null) {
                names[i] = "null";
            } else {
                GameRegistry.UniqueIdentifier itemID = GameRegistry.findUniqueIdentifierFor((Item)AutoSwitch.mc.field_71439_g.field_71071_by.field_70462_a[i].func_77973_b());
                names[i] = String.format("%s:%s", itemID.modId, itemID.name);
            }
            this.debug("Hotbar slot %d contains item %s", i, names[i]);
        }
        int currentBest = this.prevtool;
        this.debug("Block hardness is %f", Float.valueOf(Tests.getBlockHardness(world, x, y, z)));
        for (int i = 0; i < 9; ++i) {
            if (i == currentBest) continue;
            this.debug("Checking if tool %d, which is %s, is better than %d, which is %s", i, names[i], currentBest, names[currentBest]);
            if (!this.isToolBetter(AutoSwitch.mc.field_71439_g.field_71071_by.field_70462_a[i], AutoSwitch.mc.field_71439_g.field_71071_by.field_70462_a[currentBest], world, x, y, z)) continue;
            this.debug("Changing possible best tool.");
            currentBest = i;
        }
        this.debug("Current best is %d, which is %s", currentBest, names[currentBest]);
        this.switchToolsToN(currentBest);
        if (this.configuration.getSingleMultiProperty(Configuration.SWITCHBACK_BLOCKS)) {
            this.switchback = true;
        } else {
            this.prevtool = currentBest;
        }
    }

    private void switchToBestWeapon(EntityPlayer entityplayer, EntityLivingBase entityover) {
        ItemStack[] inventory = entityplayer.field_71071_by.field_70462_a;
        String[] names = new String[9];
        for (int i = 0; i < 9; ++i) {
            if (AutoSwitch.mc.field_71439_g.field_71071_by.field_70462_a[i] == null) {
                names[i] = "null";
            } else {
                GameRegistry.UniqueIdentifier itemID = GameRegistry.findUniqueIdentifierFor((Item)AutoSwitch.mc.field_71439_g.field_71071_by.field_70462_a[i].func_77973_b());
                names[i] = String.format("%s:%s", itemID.modId, itemID.name);
            }
            this.debug("Hotbar slot %d contains item %s", i, names[i]);
        }
        int currentBest = this.prevtool;
        this.debug("Current item is %d", entityplayer.field_71071_by.field_70461_c);
        this.debug("Setting possible best weapon to %d, which is %s", currentBest, names[currentBest]);
        for (int i = 0; i < 9; ++i) {
            this.debug("Checking if weapon %d, which is %s, is better than %d, which is %s", i, names[i], currentBest, names[currentBest]);
            if (!this.isWeaponBetter(inventory[i], inventory[currentBest], entityover)) continue;
            this.debug("Changing possible best weapon because weapon is better.");
            currentBest = i;
        }
        this.switchToolsToN(currentBest);
        if (this.configuration.getSingleMultiProperty(Configuration.SWITCHBACK_MOBS)) {
            this.switchback = true;
        } else {
            this.prevtool = currentBest;
        }
    }

    private void switchToolsToN(int n) {
        String name;
        EntityClientPlayerMP entityplayer = AutoSwitch.mc.field_71439_g;
        entityplayer.field_71071_by.field_70461_c = n;
        if (entityplayer.field_71071_by.field_70462_a[n] == null) {
            name = "Nothing";
        } else {
            GameRegistry.UniqueIdentifier id = GameRegistry.findUniqueIdentifierFor((Item)entityplayer.field_71071_by.field_70462_a[n].func_77973_b());
            name = id.modId + ":" + id.name;
        }
        this.debug("Switching tools to %d, which is %s", n, name);
    }
}

