/*
 * Decompiled with CFR 0.152.
 */
package thebombzen.mods.thebombzenapi;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.event.world.WorldEvent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import thebombzen.mods.thebombzenapi.FieldNotFoundException;
import thebombzen.mods.thebombzenapi.MetaConfiguration;
import thebombzen.mods.thebombzenapi.MethodNotFoundException;
import thebombzen.mods.thebombzenapi.ModResourceInputStream;
import thebombzen.mods.thebombzenapi.SideSpecificUtlities;
import thebombzen.mods.thebombzenapi.ThebombzenAPIBaseMod;
import thebombzen.mods.thebombzenapi.configuration.ThebombzenAPIConfiguration;

@Mod(modid="thebombzenapi", name="ThebombzenAPI", version="2.4.1")
public class ThebombzenAPI
extends ThebombzenAPIBaseMod {
    public static final String NEWLINE = String.format("%n", new Object[0]);
    @Mod.Instance(value="thebombzenapi")
    public static ThebombzenAPI instance;
    @SidedProxy(clientSide="thebombzen.mods.thebombzenapi.client.ClientSideSpecificUtilities", serverSide="thebombzen.mods.thebombzenapi.server.ServerSideSpecificUtilities")
    public static SideSpecificUtlities sideSpecificUtilities;
    private static Set<ThebombzenAPIBaseMod> mods;
    @SideOnly(value=Side.CLIENT)
    private static int prevWorld;
    @SideOnly(value=Side.CLIENT)
    private static boolean hasStart;
    private static MetaConfiguration dummyConfig;

    public static boolean areItemStackCollectionsEqual(Collection<? extends ItemStack> coll1, Collection<? extends ItemStack> coll2) {
        if (coll1.size() != coll2.size()) {
            return false;
        }
        ArrayList<? extends ItemStack> list1 = new ArrayList<ItemStack>(coll1);
        ArrayList<? extends ItemStack> list2 = new ArrayList<ItemStack>(coll2);
        Iterator iter1 = list1.iterator();
        block0: while (iter1.hasNext()) {
            ItemStack stack1 = (ItemStack)iter1.next();
            Iterator iter2 = list2.iterator();
            while (iter2.hasNext()) {
                ItemStack stack2 = (ItemStack)iter2.next();
                if (!ItemStack.func_77989_b((ItemStack)stack1, (ItemStack)stack2)) continue;
                iter2.remove();
                iter1.remove();
                continue block0;
            }
            return false;
        }
        return true;
    }

    public static int countOccurrences(String s, char c) {
        return s.length() - s.replace(Character.toString(c), "").length();
    }

    public static int getExtendedKeyIndex(String name) {
        int index = Mouse.getButtonIndex((String)name);
        if (index == -1) {
            return Keyboard.getKeyIndex((String)name);
        }
        return index - 100;
    }

    public static ThebombzenAPIBaseMod[] getMods() {
        return mods.toArray(new ThebombzenAPIBaseMod[mods.size()]);
    }

    public static <T, E> T getPrivateField(E instance, Class<? super E> declaringClass, String ... names) throws FieldNotFoundException {
        for (String name : names) {
            try {
                Field field = declaringClass.getDeclaredField(name);
                field.setAccessible(true);
                try {
                    return (T)field.get(instance);
                }
                catch (Exception e) {
                    throw new FieldNotFoundException("Cannot get value of field", e);
                }
            }
            catch (NoSuchFieldException nsfe) {
            }
        }
        throw new FieldNotFoundException("Names not found: " + Arrays.toString(names));
    }

    public static InputStream getResourceAsStream(ThebombzenAPIBaseMod mod, String resourceName) throws IOException {
        File source = FMLCommonHandler.instance().findContainerFor((Object)mod).getSource();
        return new ModResourceInputStream(source, resourceName);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean hasWorldChanged() {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return false;
        }
        int currWorld = System.identityHashCode(Minecraft.func_71410_x().field_71441_e);
        return currWorld != prevWorld;
    }

    public static int[] intArrayFromIntegerCollection(Collection<? extends Integer> coll) {
        int[] ret = new int[coll.size()];
        int i = 0;
        Iterator<? extends Integer> iter = coll.iterator();
        while (iter.hasNext()) {
            ret[i++] = iter.next();
        }
        return ret;
    }

    public static List<Integer> intArrayToIntegerList(int[] array) {
        ArrayList<Integer> ret = new ArrayList<Integer>(array.length);
        for (int i : array) {
            ret.add(i);
        }
        return ret;
    }

    public static <T, E> T invokePrivateMethod(E instance, Class<? super E> declaringClass, String name, Class<?>[] parameterTypes, Object ... args) throws MethodNotFoundException {
        return ThebombzenAPI.invokePrivateMethod(instance, declaringClass, new String[]{name}, parameterTypes, args);
    }

    public static <T, E> T invokePrivateMethod(E instance, Class<? super E> declaringClass, String[] names, Class<?>[] parameterTypes, Object ... args) throws MethodNotFoundException {
        for (String name : names) {
            try {
                Method method = declaringClass.getDeclaredMethod(name, parameterTypes);
                method.setAccessible(true);
                try {
                    return (T)method.invoke(instance, args);
                }
                catch (Exception e) {
                    throw new MethodNotFoundException("Error invoking private method", e);
                }
            }
            catch (NoSuchMethodException nsme) {
            }
        }
        throw new MethodNotFoundException("Cannot find method: " + Arrays.toString(names));
    }

    public static boolean isCurrentlyExecutingMethod(String classname, String methodName) {
        StackTraceElement[] trace;
        for (StackTraceElement element : trace = Thread.currentThread().getStackTrace()) {
            if (!element.getClassName().equals(classname) || !element.getMethodName().equals(methodName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCurrentlyExecutingMethodRepeatedly(String classname, String methodName, int n) {
        StackTraceElement[] trace;
        if (n < 0) {
            return false;
        }
        if (n == 0) {
            return true;
        }
        int found = 0;
        for (StackTraceElement element : trace = Thread.currentThread().getStackTrace()) {
            if (!element.getClassName().equals(classname) || !element.getMethodName().equals(methodName) || ++found < n) continue;
            return true;
        }
        return false;
    }

    public static boolean isExtendedKeyDown(String name) {
        return ThebombzenAPI.isExtendedKeyDown(ThebombzenAPI.getExtendedKeyIndex(name));
    }

    public static boolean isExtendedKeyDown(int index) {
        if (index < 0) {
            return Mouse.isButtonDown((int)(index + 100));
        }
        return Keyboard.isKeyDown((int)index);
    }

    public static boolean isSeparatorAtTopLevel(String info, int index) {
        String before = info.substring(0, index);
        String after = info.substring(index + 1);
        int beforeLeftCount = ThebombzenAPI.countOccurrences(before, '(');
        int beforeRightCount = ThebombzenAPI.countOccurrences(before, ')');
        int afterLeftCount = ThebombzenAPI.countOccurrences(after, '(');
        int afterRightCount = ThebombzenAPI.countOccurrences(after, ')');
        return beforeLeftCount == beforeRightCount && afterLeftCount == afterRightCount;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isWorldFirstLoadedWorld() {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return false;
        }
        return prevWorld == 0;
    }

    public static boolean parseBoolean(String s) {
        String c = s.toLowerCase().replaceAll("\\s", "");
        return c.equals("true") || c.equals("yes") || c.equals("on") || c.equals("y");
    }

    public static int parseInteger(String s) throws NumberFormatException {
        int i;
        boolean negative;
        s = s.replace("_", "");
        boolean onecomp = false;
        if (s.charAt(0) == '~') {
            onecomp = true;
            s = s.substring(1);
        }
        if (s.charAt(0) == '-') {
            negative = true;
            s = s.substring(1);
        } else {
            negative = false;
            if (s.charAt(0) == '+') {
                s = s.substring(1);
            }
        }
        if (s.length() == 0) {
            throw new NumberFormatException("Too short");
        }
        if (s.contains("-") || s.contains("+")) {
            throw new NumberFormatException("Number should not contain + or - inside");
        }
        if (s.charAt(0) != '0') {
            i = Integer.parseInt(s);
        } else if (s.length() == 1) {
            i = 0;
        } else {
            switch (s.charAt(1)) {
                case 'X': 
                case 'x': {
                    i = Integer.parseInt(s.substring(2), 16);
                    break;
                }
                case 'B': 
                case 'b': {
                    i = Integer.parseInt(s.substring(2), 2);
                    break;
                }
                default: {
                    i = Integer.parseInt(s, 8);
                }
            }
        }
        if (negative) {
            i = -i;
        }
        if (onecomp) {
            i ^= 0xFFFFFFFF;
        }
        return i;
    }

    public static void registerMod(ThebombzenAPIBaseMod mod) {
        mods.add(mod);
    }

    public static <E> void setPrivateField(E instance, Class<? super E> declaringClass, Object value, String ... names) {
        for (String name : names) {
            try {
                Field field = declaringClass.getDeclaredField(name);
                field.setAccessible(true);
                try {
                    field.set(instance, value);
                    return;
                }
                catch (Exception e) {
                    throw new FieldNotFoundException("Error setting field", e);
                }
            }
            catch (NoSuchFieldException nsfe) {
            }
        }
        throw new FieldNotFoundException("Names not found: " + Arrays.toString(names));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent tickEvent) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null) {
            return;
        }
        if (tickEvent.phase.equals((Object)TickEvent.Phase.END)) {
            if (hasStart) {
                prevWorld = System.identityHashCode(mc.field_71441_e);
            }
            hasStart = false;
            return;
        }
        hasStart = true;
        if (ThebombzenAPI.isWorldFirstLoadedWorld()) {
            for (ThebombzenAPIBaseMod mod : mods) {
                String latestVersion = mod.getLatestVersion();
                if (latestVersion.equals(mod.getLongVersionString())) continue;
                mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(latestVersion + " is available. "));
                mc.field_71439_g.func_145747_a(IChatComponent.Serializer.func_150699_a((String)("{\"text\": \"" + mod.getLongName() + ": " + mod.getDownloadLocationURLString() + "\",\"color\":\"gold\",\"clickEvent\":{\"action\":\"open_url\",value=\"" + mod.getDownloadLocationURLString() + "\"}}")));
            }
        }
        if (ThebombzenAPI.hasWorldChanged()) {
            for (ThebombzenAPIBaseMod mod : mods) {
                mod.readFromCorrectMemoryFile();
            }
        }
        for (ThebombzenAPIBaseMod mod : mods) {
            try {
                boolean did = ((ThebombzenAPIConfiguration)mod.getConfiguration()).reloadPropertiesFromFileIfChanged();
                if (!did) continue;
                mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("Reloaded " + mod.getLongName() + " configuration."));
            }
            catch (IOException ioe) {
                mod.throwException("Could not read properties!", ioe, false);
            }
        }
    }

    public MetaConfiguration getConfiguration() {
        return dummyConfig;
    }

    @Override
    public String getDownloadLocationURLString() {
        return "http://is.gd/ThebombzensMods#ThebombzenAPI";
    }

    @Override
    public String getLongName() {
        return "ThebombzenAPI";
    }

    @Override
    public String getLongVersionString() {
        return "ThebombzenAPI, version 2.4.1, Minecraft 1.7.2";
    }

    @Override
    public int getNumToggleKeys() {
        return 0;
    }

    @Override
    public String getShortName() {
        return "TBZAPI";
    }

    @Override
    protected String getToggleMessageString(int index, boolean enabled) {
        throw new UnsupportedOperationException("ThebombzenAPI has no toggles!");
    }

    @Override
    protected String getVersionFileURLString() {
        return "https://dl.dropboxusercontent.com/u/51080973/Mods/ThebombzenAPI/TBZAPIVersion.txt";
    }

    public static void handleToggles() {
        for (ThebombzenAPIBaseMod mod : mods) {
            int num = mod.getNumToggleKeys();
            for (int i = 0; i < num; ++i) {
                int toggleKeyCode = mod.getToggleKeyCode(i);
                if (!ThebombzenAPI.isExtendedKeyDown(toggleKeyCode) || (toggleKeyCode >= 0 || Mouse.getEventButton() == -1) && (toggleKeyCode < 0 || Keyboard.isRepeatEvent())) continue;
                boolean enabled = mod.isToggleEnabled(i);
                mod.setToggleEnabled(i, !enabled, true);
                mod.writeToCorrectMemoryFile();
            }
        }
    }

    @SubscribeEvent
    public void handleMouseClick(InputEvent.MouseInputEvent event) {
        ThebombzenAPI.handleToggles();
    }

    @SubscribeEvent
    public void handleKeyPress(InputEvent.KeyInputEvent event) {
        ThebombzenAPI.handleToggles();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        for (ThebombzenAPIBaseMod mod : mods) {
            try {
                ((ThebombzenAPIConfiguration)mod.getConfiguration()).load();
            }
            catch (IOException ioe) {
                mod.throwException("Unable to open configuration!", ioe, true);
            }
            mod.init2(event);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        for (ThebombzenAPIBaseMod mod : mods) {
            mod.init3(event);
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.initialize();
        FMLCommonHandler.instance().bus().register((Object)this);
        FMLCommonHandler.instance().findContainerFor((Object)this).getMetadata().authorList = Arrays.asList("Thebombzen");
        dummyConfig = new MetaConfiguration();
        for (ThebombzenAPIBaseMod mod : mods) {
            mod.init1(event);
        }
    }

    @SubscribeEvent
    public void worldLoaded(WorldEvent.Load event) {
        if (event.world.field_72995_K) {
            hasStart = false;
        }
    }

    static {
        mods = new TreeSet<ThebombzenAPIBaseMod>();
        dummyConfig = null;
    }
}

