/*
 * Decompiled with CFR 0.152.
 */
package morenature.client.renderer.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import morenature.client.model.ModelBird;
import morenature.entity.passive.EntityBird;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class RenderBird
extends RenderLiving {
    private static final ResourceLocation jayTextures = new ResourceLocation("morenature", "textures/entity/bird/jay.png");
    private static final ResourceLocation cardinalTextures = new ResourceLocation("morenature", "textures/entity/bird/cardinal.png");
    private static final ResourceLocation sparrowTextures = new ResourceLocation("morenature", "textures/entity/bird/sparrow.png");
    private static final ResourceLocation parrotTextures = new ResourceLocation("morenature", "textures/entity/bird/parrot.png");
    private static final ResourceLocation chickadeeTextures = new ResourceLocation("morenature", "textures/entity/bird/chickadee.png");
    private static final ResourceLocation crowTextures = new ResourceLocation("morenature", "textures/entity/bird/crow.png");

    public RenderBird() {
        super((ModelBase)new ModelBird(), 0.3f);
    }

    protected ResourceLocation getBirdTextures(EntityBird entitybird) {
        switch (entitybird.getBirdType()) {
            default: {
                return jayTextures;
            }
            case 1: {
                return cardinalTextures;
            }
            case 2: {
                return sparrowTextures;
            }
            case 3: {
                return chickadeeTextures;
            }
            case 4: {
                return crowTextures;
            }
            case 5: 
        }
        return parrotTextures;
    }

    protected float getWingRotation(EntityBird entitybird, float f) {
        float f1 = entitybird.prevWingRotation + (entitybird.wingRotation - entitybird.prevWingRotation) * f;
        float f2 = entitybird.prevFlapSpeed + (entitybird.flapSpeed - entitybird.prevFlapSpeed) * f;
        return (MathHelper.func_76126_a((float)f1) + 1.0f) * f2;
    }

    protected float func_77044_a(EntityLivingBase entitylivingbase, float f) {
        return this.getWingRotation((EntityBird)entitylivingbase, f);
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return this.getBirdTextures((EntityBird)entity);
    }
}

