/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.blocks;

import biomesoplenty.BiomesOPlenty;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockBOPLog
extends Block {
    private static final String[] types = new String[]{"sacredoak", "cherry", "dark", "fir", "holy", "magic", "mangrove", "palm", "redwood", "willow", "dead", "bigflowerstem", "pine", "hellbark", "jacaranda"};
    private IIcon[] textures;
    private IIcon[] logHearts;
    private final LogCategory category;

    public BlockBOPLog(LogCategory cat) {
        super(Material.field_151575_d);
        this.category = cat;
        this.func_149711_c(2.0f);
        this.setHarvestLevel("axe", 0);
        this.func_149752_b(5.0f);
        this.func_149672_a(Block.field_149766_f);
        this.func_149647_a(BiomesOPlenty.tabBiomesOPlenty);
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.textures = new IIcon[types.length];
        this.logHearts = new IIcon[types.length];
        for (int i = 0; i < types.length; ++i) {
            if (i == 11) continue;
            this.textures[i] = iconRegister.func_94245_a("biomesoplenty:log_" + types[i] + "_side");
            this.logHearts[i] = iconRegister.func_94245_a("biomesoplenty:log_" + types[i] + "_heart");
        }
        this.textures[11] = iconRegister.func_94245_a("biomesoplenty:bigflowerstem_side");
        this.logHearts[11] = iconRegister.func_94245_a("biomesoplenty:bigflowerstem_heart");
    }

    public IIcon func_149691_a(int side, int meta) {
        int pos = meta & 0xC;
        if (pos == 0 && (side == 1 || side == 0) || pos == 4 && (side == 5 || side == 4) || pos == 8 && (side == 2 || side == 3)) {
            return this.logHearts[BlockBOPLog.getTypeFromMeta(meta) + this.category.ordinal() * 4];
        }
        return this.textures[BlockBOPLog.getTypeFromMeta(meta) + this.category.ordinal() * 4];
    }

    public void func_149666_a(Item block, CreativeTabs creativeTabs, List list) {
        if (this.category != LogCategory.CAT4) {
            for (int i = 0; i < 4; ++i) {
                list.add(new ItemStack((Block)this, 1, i));
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                list.add(new ItemStack((Block)this, 1, i));
            }
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block par5, int par6) {
        int radius = 4;
        int bounds = radius + 1;
        if (world.func_72904_c(x - bounds, y - bounds, z - bounds, x + bounds, y + bounds, z + bounds)) {
            for (int i = -radius; i <= radius; ++i) {
                for (int j = -radius; j <= radius; ++j) {
                    for (int k = -radius; k <= radius; ++k) {
                        Block block = world.func_147439_a(x + i, y + j, z + k);
                        if (!block.isLeaves((IBlockAccess)world, x, y, z)) continue;
                        block.beginLeavesDecay(world, x + i, y + j, z + k);
                    }
                }
            }
        }
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int meta) {
        int type = BlockBOPLog.getTypeFromMeta(meta);
        int orientation = 0;
        switch (side) {
            case 0: 
            case 1: {
                orientation = 0;
                break;
            }
            case 2: 
            case 3: {
                orientation = 8;
                break;
            }
            case 4: 
            case 5: {
                orientation = 4;
            }
        }
        return type | orientation;
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        if (this.category == LogCategory.CAT4 && world.func_72805_g(x, y, z) == 1) {
            return 0;
        }
        return Blocks.field_150480_ab.getFlammability((Block)this);
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        if (this.category == LogCategory.CAT4 && world.func_72805_g(x, y, z) == 1) {
            return 0;
        }
        return Blocks.field_150480_ab.getEncouragement((Block)this);
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        if (this.category == LogCategory.CAT4 && world.func_72805_g(x, y, z) == 1) {
            return false;
        }
        return this.getFlammability(world, x, y, z, face) > 0;
    }

    public int func_149692_a(int meta) {
        return BlockBOPLog.getTypeFromMeta(meta);
    }

    protected ItemStack func_149644_j(int meta) {
        return new ItemStack((Block)this, 1, BlockBOPLog.getTypeFromMeta(meta));
    }

    public int func_149645_b() {
        return 31;
    }

    public boolean canSustainLeaves(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public boolean isWood(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public String getWoodType(int meta) {
        return types[BlockBOPLog.getTypeFromMeta(meta) + this.category.ordinal() * 4];
    }

    private static int getTypeFromMeta(int meta) {
        return meta & 3;
    }

    public static enum LogCategory {
        CAT1,
        CAT2,
        CAT3,
        CAT4;

    }
}

