/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.eventhandler.world;

import biomesoplenty.common.world.decoration.ForcedDecorators;
import biomesoplenty.common.world.decoration.IBOPDecoration;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;

public class DecorationModificationEventHandler {
    @SubscribeEvent
    public void modifyDecor(DecorateBiomeEvent.Decorate event) {
        World world = event.world;
        int chunkX = event.chunkX;
        int chunkZ = event.chunkZ;
        Random random = event.rand;
        int x = chunkX + 8;
        int z = chunkZ + 8;
        BiomeGenBase biome = world.getBiomeGenForCoordsBody(x, z);
        IBOPDecoration bopDecoration = null;
        if (biome instanceof IBOPDecoration) {
            bopDecoration = (IBOPDecoration)biome;
        } else if (ForcedDecorators.biomeHasForcedDecorator(biome.field_76756_M)) {
            bopDecoration = ForcedDecorators.getForcedDecorator(biome.field_76756_M);
        }
        if (bopDecoration != null) {
            if (event.type == DecorateBiomeEvent.Decorate.EventType.PUMPKIN) {
                if (!bopDecoration.getWorldFeatures().generatePumpkins) {
                    event.setResult(Event.Result.DENY);
                }
            } else if (event.type == DecorateBiomeEvent.Decorate.EventType.LAKE) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public void modifyPopulation(PopulateChunkEvent.Populate event) {
        World world = event.world;
        int chunkX = event.chunkX;
        int chunkZ = event.chunkZ;
        Random random = event.rand;
        int x = chunkX + 8;
        int z = chunkZ + 8;
        BiomeGenBase biome = world.getBiomeGenForCoordsBody(x, z);
        IBOPDecoration bopDecoration = null;
        if (biome instanceof IBOPDecoration) {
            bopDecoration = (IBOPDecoration)biome;
        } else if (ForcedDecorators.biomeHasForcedDecorator(biome.field_76756_M)) {
            bopDecoration = ForcedDecorators.getForcedDecorator(biome.field_76756_M);
        }
        if (bopDecoration != null) {
            // empty if block
        }
    }
}

