/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.generation;

import biomesoplenty.api.BOPBlockHelper;
import biomesoplenty.common.world.features.WorldGenBOPDoubleFlora;
import biomesoplenty.common.world.features.WorldGenBOPFlora;
import biomesoplenty.common.world.features.WorldGenBOPTallGrass;
import biomesoplenty.common.world.features.WorldGenMud;
import biomesoplenty.common.world.features.WorldGenRiverCane;
import biomesoplenty.common.world.features.WorldGenSplotches;
import biomesoplenty.common.world.features.WorldGenWaterReeds;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.feature.WorldGenDoublePlant;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.feature.WorldGenLiquids;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenFieldAssociation {
    public static HashMap<String, WorldGenerator> worldGeneratorMap = new HashMap();

    public static void init() {
        WorldGenFieldAssociation.associateFieldsWithGenerators();
    }

    private static void associateFieldsWithGenerators() {
        WorldGenFieldAssociation.associateField("generateQuicksand", new WorldGenSplotches(BOPBlockHelper.get("mud"), 1, 24));
        WorldGenFieldAssociation.associateField("generateCanyon", new WorldGenSplotches(BOPBlockHelper.get("redRock"), 0, 48));
        WorldGenFieldAssociation.associateField("waterPoolsPerChunk", (WorldGenerator)new WorldGenLiquids((Block)Blocks.field_150358_i));
        WorldGenFieldAssociation.associateField("lavaPoolsPerChunk", (WorldGenerator)new WorldGenLiquids((Block)Blocks.field_150356_k));
        WorldGenFieldAssociation.associateField("waterLakesPerChunk", (WorldGenerator)new WorldGenLakes(Blocks.field_150355_j));
        WorldGenFieldAssociation.associateField("lavaLakesPerChunk", (WorldGenerator)new WorldGenLakes(Blocks.field_150353_l));
        WorldGenFieldAssociation.associateField("mudPerChunk", new WorldGenMud(7));
        WorldGenFieldAssociation.associateField("riverCanePerChunk", new WorldGenRiverCane());
        WorldGenFieldAssociation.associateField("shrubsPerChunk", new WorldGenBOPFlora(BOPBlockHelper.get("foliage"), 9));
        WorldGenFieldAssociation.associateField("bushesPerChunk", new WorldGenBOPFlora(BOPBlockHelper.get("foliage"), 4));
        WorldGenFieldAssociation.associateField("cloverPatchesPerChunk", new WorldGenBOPFlora(BOPBlockHelper.get("foliage"), 13, 128));
        WorldGenFieldAssociation.associateField("lavenderPerChunk", new WorldGenBOPFlora(BOPBlockHelper.get("flowers2"), 3));
        WorldGenFieldAssociation.associateField("thornsPerChunk", new WorldGenBOPFlora(BOPBlockHelper.get("plants"), 5));
        WorldGenFieldAssociation.associateField("stalagmitesPerChunk", new WorldGenBOPTallGrass(BOPBlockHelper.get("stoneFormations"), 0));
        WorldGenFieldAssociation.associateField("stalactitesPerChunk", new WorldGenBOPTallGrass(BOPBlockHelper.get("stoneFormations"), 1));
        WorldGenFieldAssociation.associateField("desertSproutsPerChunk", new WorldGenBOPFlora(BOPBlockHelper.get("plants"), 2));
        WorldGenFieldAssociation.associateField("bromeliadsPerChunk", new WorldGenBOPFlora(BOPBlockHelper.get("flowers"), 12));
        WorldGenFieldAssociation.associateField("waterReedsPerChunk", new WorldGenWaterReeds());
        WorldGenFieldAssociation.associateField("wildCarrotsPerChunk", new WorldGenBOPFlora(BOPBlockHelper.get("plants"), 11));
        WorldGenFieldAssociation.associateField("poisonIvyPerChunk", new WorldGenBOPFlora(BOPBlockHelper.get("foliage"), 7));
        WorldGenFieldAssociation.associateField("berryBushesPerChunk", new WorldGenBOPFlora(BOPBlockHelper.get("foliage"), 8));
        WorldGenFieldAssociation.associateField("portobellosPerChunk", new WorldGenBOPFlora(BOPBlockHelper.get("mushrooms"), 1));
        WorldGenFieldAssociation.associateField("koruPerChunk", new WorldGenBOPFlora(BOPBlockHelper.get("foliage"), 12));
        WorldGenFieldAssociation.associateField("toadstoolsPerChunk", new WorldGenBOPFlora(BOPBlockHelper.get("mushrooms"), 0));
        WorldGenFieldAssociation.associateField("blueMilksPerChunk", new WorldGenBOPFlora(BOPBlockHelper.get("mushrooms"), 2));
        WorldGenFieldAssociation.associateField("cattailsPerChunk", new WorldGenBOPFlora(BOPBlockHelper.get("plants"), 7));
        WorldGenFieldAssociation.associateField("highCattailsPerChunk", new WorldGenBOPDoubleFlora(BOPBlockHelper.get("plants"), BOPBlockHelper.get("plants"), 10, 9));
        WorldGenFieldAssociation.associateField("algaePerChunk", new WorldGenBOPFlora(BOPBlockHelper.get("foliage"), 0));
        WorldGenDoublePlant doubleTallGrass = new WorldGenDoublePlant();
        doubleTallGrass.func_150548_a(2);
        WorldGenFieldAssociation.associateField("doubleTallGrassPerChunk", (WorldGenerator)doubleTallGrass);
    }

    public static void associateField(String fieldName, WorldGenerator generator) {
        worldGeneratorMap.put(fieldName, generator);
    }

    public static WorldGenerator getAssociatedWorldGenerator(String fieldName) {
        return worldGeneratorMap.get(fieldName);
    }
}

