/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.core;

import biomesoplenty.api.BOPBiomeHelper;
import biomesoplenty.common.biomes.BiomeGenAlps;
import biomesoplenty.common.biomes.BiomeGenArctic;
import biomesoplenty.common.biomes.BiomeGenBambooForest;
import biomesoplenty.common.biomes.BiomeGenBorealForest;
import biomesoplenty.common.biomes.BiomeGenBrushland;
import biomesoplenty.common.biomes.BiomeGenCanyon;
import biomesoplenty.common.biomes.BiomeGenCherryBlossomGrove;
import biomesoplenty.common.biomes.BiomeGenCrag;
import biomesoplenty.common.biomes.BiomeGenDeadForest;
import biomesoplenty.common.biomes.BiomeGenDeciduousForest;
import biomesoplenty.common.biomes.BiomeGenDunes;
import biomesoplenty.common.biomes.BiomeGenFen;
import biomesoplenty.common.biomes.BiomeGenFlowerField;
import biomesoplenty.common.biomes.BiomeGenFrostForest;
import biomesoplenty.common.biomes.BiomeGenGrassland;
import biomesoplenty.common.biomes.BiomeGenHighland;
import biomesoplenty.common.biomes.BiomeGenJadeCliffs;
import biomesoplenty.common.biomes.BiomeGenLavenderFields;
import biomesoplenty.common.biomes.BiomeGenMarsh;
import biomesoplenty.common.biomes.BiomeGenMountain;
import biomesoplenty.common.biomes.BiomeGenOminousWoods;
import biomesoplenty.common.biomes.BiomeGenPasture;
import biomesoplenty.common.biomes.BiomeGenRainforest;
import biomesoplenty.common.biomes.BiomeGenSacredSprings;
import biomesoplenty.common.biomes.BiomeGenShrubland;
import biomesoplenty.common.biomes.BiomeGenThicket;
import biomesoplenty.common.configuration.BOPConfigurationIDs;
import biomesoplenty.common.world.WorldTypeBOP;
import net.minecraft.world.biome.BiomeGenBase;

public class BOPBiomes {
    public static WorldTypeBOP worldTypeBOP;
    private static BiomeGenBase onlyBiome;

    public static void init() {
        BOPBiomes.registerBiomes();
        BOPBiomes.useOnlyBiome();
    }

    private static void registerBiomes() {
        BOPBiomes.addBiomeToList(new BOPBiomeHelper.BOPBiomeListEntry(BiomeGenBase.field_76769_d, BOPBiomeHelper.BOPBiomeTemperatureType.HOT));
        BOPBiomes.addBiomeToList(new BOPBiomeHelper.BOPBiomeListEntry(BiomeGenBase.field_76769_d, BOPBiomeHelper.BOPBiomeTemperatureType.HOT));
        BOPBiomes.addBiomeToList(new BOPBiomeHelper.BOPBiomeListEntry(BiomeGenBase.field_76769_d, BOPBiomeHelper.BOPBiomeTemperatureType.HOT));
        BOPBiomes.addBiomeToList(new BOPBiomeHelper.BOPBiomeListEntry(BiomeGenBase.field_150588_X, BOPBiomeHelper.BOPBiomeTemperatureType.HOT));
        BOPBiomes.addBiomeToList(new BOPBiomeHelper.BOPBiomeListEntry(BiomeGenBase.field_150588_X, BOPBiomeHelper.BOPBiomeTemperatureType.HOT));
        BOPBiomes.addBiomeToList(new BOPBiomeHelper.BOPBiomeListEntry(BiomeGenBase.field_76772_c, BOPBiomeHelper.BOPBiomeTemperatureType.HOT));
        BOPBiomes.addBiomeToList(new BOPBiomeHelper.BOPBiomeListEntry(BiomeGenBase.field_76767_f, BOPBiomeHelper.BOPBiomeTemperatureType.WARM));
        BOPBiomes.addBiomeToList(new BOPBiomeHelper.BOPBiomeListEntry(BiomeGenBase.field_150585_R, BOPBiomeHelper.BOPBiomeTemperatureType.WARM));
        BOPBiomes.addBiomeToList(new BOPBiomeHelper.BOPBiomeListEntry(BiomeGenBase.field_76770_e, BOPBiomeHelper.BOPBiomeTemperatureType.WARM));
        BOPBiomes.addBiomeToList(new BOPBiomeHelper.BOPBiomeListEntry(BiomeGenBase.field_76772_c, BOPBiomeHelper.BOPBiomeTemperatureType.WARM));
        BOPBiomes.addBiomeToList(new BOPBiomeHelper.BOPBiomeListEntry(BiomeGenBase.field_150583_P, BOPBiomeHelper.BOPBiomeTemperatureType.WARM));
        BOPBiomes.addBiomeToList(new BOPBiomeHelper.BOPBiomeListEntry(BiomeGenBase.field_76780_h, BOPBiomeHelper.BOPBiomeTemperatureType.WARM));
        BOPBiomes.addBiomeToList(new BOPBiomeHelper.BOPBiomeListEntry(BiomeGenBase.field_76767_f, BOPBiomeHelper.BOPBiomeTemperatureType.COOL));
        BOPBiomes.addBiomeToList(new BOPBiomeHelper.BOPBiomeListEntry(BiomeGenBase.field_76770_e, BOPBiomeHelper.BOPBiomeTemperatureType.COOL));
        BOPBiomes.addBiomeToList(new BOPBiomeHelper.BOPBiomeListEntry(BiomeGenBase.field_76768_g, BOPBiomeHelper.BOPBiomeTemperatureType.COOL));
        BOPBiomes.addBiomeToList(new BOPBiomeHelper.BOPBiomeListEntry(BiomeGenBase.field_76772_c, BOPBiomeHelper.BOPBiomeTemperatureType.COOL));
        BOPBiomes.addBiomeToList(new BOPBiomeHelper.BOPBiomeListEntry(BiomeGenBase.field_76774_n, BOPBiomeHelper.BOPBiomeTemperatureType.ICY));
        BOPBiomes.addBiomeToList(new BOPBiomeHelper.BOPBiomeListEntry(BiomeGenBase.field_76774_n, BOPBiomeHelper.BOPBiomeTemperatureType.ICY));
        BOPBiomes.addBiomeToList(new BOPBiomeHelper.BOPBiomeListEntry(BiomeGenBase.field_76774_n, BOPBiomeHelper.BOPBiomeTemperatureType.ICY));
        BOPBiomes.addBiomeToList(new BOPBiomeHelper.BOPBiomeListEntry(BiomeGenBase.field_150584_S, BOPBiomeHelper.BOPBiomeTemperatureType.ICY));
        BOPBiomes.registerBiome(new BOPBiomeHelper.BOPBiomeListEntry(new BiomeGenAlps(BOPConfigurationIDs.alpsID).func_76735_a("Alps"), BOPBiomeHelper.BOPBiomeTemperatureType.ICY));
        BOPBiomes.registerBiome(new BOPBiomeHelper.BOPBiomeListEntry(new BiomeGenArctic(BOPConfigurationIDs.arcticID).func_76735_a("Arctic"), BOPBiomeHelper.BOPBiomeTemperatureType.ICY));
        BOPBiomes.registerBiome(new BOPBiomeHelper.BOPBiomeListEntry(new BiomeGenBambooForest(BOPConfigurationIDs.bambooForestID).func_76735_a("Bamboo Forest"), BOPBiomeHelper.BOPBiomeTemperatureType.WARM));
        BOPBiomes.registerBiome(new BOPBiomeHelper.BOPBiomeListEntry(new BiomeGenBorealForest(BOPConfigurationIDs.borealForestID).func_76735_a("Boreal Forest"), BOPBiomeHelper.BOPBiomeTemperatureType.WARM));
        BOPBiomes.registerBiome(new BOPBiomeHelper.BOPBiomeListEntry(new BiomeGenBrushland(BOPConfigurationIDs.brushlandID).func_76735_a("Brushland"), BOPBiomeHelper.BOPBiomeTemperatureType.HOT));
        BOPBiomes.registerBiome(new BOPBiomeHelper.BOPBiomeListEntry(new BiomeGenCanyon(BOPConfigurationIDs.canyonID).func_76735_a("Canyon"), BOPBiomeHelper.BOPBiomeTemperatureType.HOT));
        BOPBiomes.registerBiome(new BOPBiomeHelper.BOPBiomeListEntry(new BiomeGenCherryBlossomGrove(BOPConfigurationIDs.cherryBlossomGroveID).func_76735_a("Cherry Blossom Grove"), BOPBiomeHelper.BOPBiomeTemperatureType.COOL));
        BOPBiomes.registerBiome(new BOPBiomeHelper.BOPBiomeListEntry(new BiomeGenCrag(BOPConfigurationIDs.cragID).func_76735_a("Crag"), BOPBiomeHelper.BOPBiomeTemperatureType.HOT));
        BOPBiomes.registerBiome(new BOPBiomeHelper.BOPBiomeListEntry(new BiomeGenDeadForest(BOPConfigurationIDs.deadForestID).func_76735_a("Dead Forest"), BOPBiomeHelper.BOPBiomeTemperatureType.COOL));
        BOPBiomes.registerBiome(new BOPBiomeHelper.BOPBiomeListEntry(new BiomeGenDeciduousForest(BOPConfigurationIDs.deciduousForestID).func_76735_a("Deciduous Forest"), BOPBiomeHelper.BOPBiomeTemperatureType.WARM));
        BOPBiomes.registerBiome(new BOPBiomeHelper.BOPBiomeListEntry(new BiomeGenDunes(BOPConfigurationIDs.dunesID).func_76735_a("Dunes"), BOPBiomeHelper.BOPBiomeTemperatureType.HOT));
        BOPBiomes.registerBiome(new BOPBiomeHelper.BOPBiomeListEntry(new BiomeGenFen(BOPConfigurationIDs.fenID).func_76735_a("Fen"), BOPBiomeHelper.BOPBiomeTemperatureType.WARM));
        BOPBiomes.registerBiome(new BOPBiomeHelper.BOPBiomeListEntry(new BiomeGenFlowerField(BOPConfigurationIDs.flowerFieldID).func_76735_a("Flower Field"), BOPBiomeHelper.BOPBiomeTemperatureType.WARM));
        BOPBiomes.registerBiome(new BOPBiomeHelper.BOPBiomeListEntry(new BiomeGenFrostForest(BOPConfigurationIDs.frostForestID).func_76735_a("Frost Forest"), BOPBiomeHelper.BOPBiomeTemperatureType.ICY));
        BOPBiomes.registerBiome(new BOPBiomeHelper.BOPBiomeListEntry(new BiomeGenGrassland(BOPConfigurationIDs.grasslandID).func_76735_a("Grassland"), BOPBiomeHelper.BOPBiomeTemperatureType.WARM));
        BOPBiomes.registerBiome(new BOPBiomeHelper.BOPBiomeListEntry(new BiomeGenHighland(BOPConfigurationIDs.highlandID).func_76735_a("Highland"), BOPBiomeHelper.BOPBiomeTemperatureType.WARM));
        BOPBiomes.registerBiome(new BOPBiomeHelper.BOPBiomeListEntry(new BiomeGenJadeCliffs(BOPConfigurationIDs.jadeCliffsID).func_76735_a("Jade Cliffs"), BOPBiomeHelper.BOPBiomeTemperatureType.WARM));
        BOPBiomes.registerBiome(new BOPBiomeHelper.BOPBiomeListEntry(new BiomeGenLavenderFields(BOPConfigurationIDs.lavenderFieldsID).func_76735_a("Lavender Fields"), BOPBiomeHelper.BOPBiomeTemperatureType.WARM));
        BOPBiomes.registerBiome(new BOPBiomeHelper.BOPBiomeListEntry(new BiomeGenMarsh(BOPConfigurationIDs.marshID).func_76735_a("Marsh"), BOPBiomeHelper.BOPBiomeTemperatureType.WARM));
        BOPBiomes.registerBiome(new BOPBiomeHelper.BOPBiomeListEntry(new BiomeGenMountain(BOPConfigurationIDs.mountainID).func_76735_a("Mountain"), BOPBiomeHelper.BOPBiomeTemperatureType.WARM));
        BOPBiomes.registerBiome(new BOPBiomeHelper.BOPBiomeListEntry(new BiomeGenOminousWoods(BOPConfigurationIDs.ominousWoodsID).func_76735_a("Ominous Woods"), BOPBiomeHelper.BOPBiomeTemperatureType.COOL));
        BOPBiomes.registerBiome(new BOPBiomeHelper.BOPBiomeListEntry(new BiomeGenPasture(BOPConfigurationIDs.pastureID).func_76735_a("Pasture"), BOPBiomeHelper.BOPBiomeTemperatureType.WARM));
        BOPBiomes.registerBiome(new BOPBiomeHelper.BOPBiomeListEntry(new BiomeGenRainforest(BOPConfigurationIDs.rainforestID).func_76735_a("Rainforest"), BOPBiomeHelper.BOPBiomeTemperatureType.HOT));
        BOPBiomes.registerBiome(new BOPBiomeHelper.BOPBiomeListEntry(new BiomeGenSacredSprings(BOPConfigurationIDs.sacredSpringsID).func_76735_a("Sacred Springs"), BOPBiomeHelper.BOPBiomeTemperatureType.WARM));
        BOPBiomes.registerBiome(new BOPBiomeHelper.BOPBiomeListEntry(new BiomeGenShrubland(BOPConfigurationIDs.shrublandID).func_76735_a("Shrubland"), BOPBiomeHelper.BOPBiomeTemperatureType.COOL));
        BOPBiomes.registerBiome(new BOPBiomeHelper.BOPBiomeListEntry(new BiomeGenThicket(BOPConfigurationIDs.thicketID).func_76735_a("Thicket"), BOPBiomeHelper.BOPBiomeTemperatureType.WARM));
    }

    private static void useOnlyBiome() {
        if (onlyBiome != null) {
            for (BOPBiomeHelper.BOPBiomeTemperatureType temperatureType : BOPBiomeHelper.BOPBiomeTemperatureType.values()) {
                BOPBiomeHelper.getCorrespondingTemperatureTypeList(temperatureType).clear();
                BOPBiomes.addBiomeToList(new BOPBiomeHelper.BOPBiomeListEntry(onlyBiome, temperatureType));
            }
        }
    }

    public static void registerOnlyBiome(BOPBiomeHelper.BOPBiomeListEntry biome) {
        onlyBiome = biome.biome;
    }

    public static void registerBiome(BOPBiomeHelper.BOPBiomeListEntry biome) {
        BOPBiomeHelper.registerBiome(biome.biome, biome.biome.field_76791_y);
        BOPBiomes.addBiomeToList(biome);
    }

    public static void addBiomeToList(BOPBiomeHelper.BOPBiomeListEntry biome) {
        BOPBiomeHelper.getCorrespondingTemperatureTypeList(biome.temperatureType).add(biome.biome);
    }
}

