/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.core;

import biomesoplenty.api.BOPPotionHelper;
import biomesoplenty.common.potions.PotionParalysis;
import biomesoplenty.common.potions.PotionPossession;
import cpw.mods.fml.common.FMLCommonHandler;
import java.lang.reflect.Field;
import net.minecraft.potion.Potion;
import org.apache.logging.log4j.Level;

public class BOPPotions {
    public static int potionOffset;
    private static final int MAXNEWPOTIONS = 8;

    public static void init() {
        BOPPotions.extendPotionsArray();
        BOPPotions.intializePotions();
    }

    private static void intializePotions() {
        BOPPotions.registerPotion(new PotionParalysis(BOPPotions.getNextID(), true, 16767262).func_76390_b("potion.paralysis"));
        BOPPotions.registerPotion(new PotionPossession(BOPPotions.getNextID(), true, 1280).func_76390_b("potion.possession"));
    }

    private static void extendPotionsArray() {
        Field[] fields;
        FMLCommonHandler.instance().getFMLLogger().log(Level.INFO, "[BiomesOPlenty] Extending Potions Array.");
        potionOffset = Potion.field_76425_a.length;
        Potion[] potionTypes = new Potion[potionOffset + 8];
        System.arraycopy(Potion.field_76425_a, 0, potionTypes, 0, potionOffset);
        Field field = null;
        for (Field f : fields = Potion.class.getDeclaredFields()) {
            if (!f.getName().equals("potionTypes") && !f.getName().equals("field_76425_a")) continue;
            field = f;
            break;
        }
        try {
            field.setAccessible(true);
            Field modfield = Field.class.getDeclaredField("modifiers");
            modfield.setAccessible(true);
            modfield.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.set(null, potionTypes);
        }
        catch (Exception e) {
            System.err.println("[BiomesOPlenty] Severe error, please report this to the mod author:");
            System.err.println(e);
        }
    }

    public static int getNextID() {
        return potionOffset++ - 1;
    }

    public static void registerPotion(Potion potion) {
        BOPPotionHelper.registerPotion(potion, potion.func_76393_a().replace("potion.", ""));
    }
}

