/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.soundscool.network.packet;

import com.dynious.soundscool.handler.NetworkHandler;
import com.dynious.soundscool.network.packet.IPacket;
import io.netty.buffer.ByteBuf;

public class SoundChunkPacket
implements IPacket {
    String soundName;
    byte[] soundChunk;

    public SoundChunkPacket() {
    }

    public SoundChunkPacket(String soundName, byte[] soundChunk) {
        this.soundName = soundName;
        this.soundChunk = soundChunk;
    }

    @Override
    public void readBytes(ByteBuf bytes) {
        int fileLength = bytes.readInt();
        char[] fileCars = new char[fileLength];
        for (int i = 0; i < fileLength; ++i) {
            fileCars[i] = bytes.readChar();
        }
        this.soundName = String.valueOf(fileCars);
        int soundByteLength = bytes.readInt();
        byte[] soundByteArr = new byte[soundByteLength];
        for (int i = 0; i < soundByteLength; ++i) {
            soundByteArr[i] = bytes.readByte();
        }
        NetworkHandler.addSoundChunk(this.soundName, soundByteArr);
    }

    @Override
    public void writeBytes(ByteBuf bytes) {
        bytes.writeInt(this.soundName.length());
        for (char c : this.soundName.toCharArray()) {
            bytes.writeChar((int)c);
        }
        bytes.writeInt(this.soundChunk.length);
        bytes.writeBytes(this.soundChunk);
    }
}

