/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelmap;

import com.thevoxelbox.voxelmap.VoxelColorManager;
import com.thevoxelbox.voxelmap.VoxelRadar;
import com.thevoxelbox.voxelmap.VoxelWaypointManager;
import com.thevoxelbox.voxelmap.gui.GuiMinimapOptions;
import com.thevoxelbox.voxelmap.gui.GuiScreenAddWaypoint;
import com.thevoxelbox.voxelmap.gui.overridden.EnumOptionsMinimap;
import com.thevoxelbox.voxelmap.util.CommandServerZanTp;
import com.thevoxelbox.voxelmap.util.DimensionManager;
import com.thevoxelbox.voxelmap.util.EntityWaypointContainer;
import com.thevoxelbox.voxelmap.util.GLBufferedImage;
import com.thevoxelbox.voxelmap.util.GLUtils;
import com.thevoxelbox.voxelmap.util.MapChunkCache;
import com.thevoxelbox.voxelmap.util.MapData;
import com.thevoxelbox.voxelmap.util.NetworkUtils;
import com.thevoxelbox.voxelmap.util.ReflectionUtils;
import com.thevoxelbox.voxelmap.util.RenderWaypointContainer;
import com.thevoxelbox.voxelmap.util.TranslateUtils;
import com.thevoxelbox.voxelmap.util.VoxelMapResourcePack;
import com.thevoxelbox.voxelmap.util.Waypoint;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import net.minecraft.server.MinecraftServer;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

public class VoxelMap
implements Runnable {
    public azd game;
    private afn world = null;
    private int worldHeight = 256;
    private boolean haveRenderManager = false;
    public boolean showUnderMenus;
    public VoxelRadar radar = null;
    public VoxelColorManager colorManager = null;
    public VoxelWaypointManager waypointManager = null;
    public DimensionManager dimensionManager = null;
    private MapData[] mapData = new MapData[4];
    private MapChunkCache[] chunkCache = new MapChunkCache[4];
    private GLBufferedImage[] map = new GLBufferedImage[4];
    private GLBufferedImage roundImage;
    private boolean imageChanged = true;
    private bpi lightmapTexture = null;
    private boolean needLight = true;
    private final float[] lastLightBrightnessTable = new float[16];
    private float lastGamma = 0.0f;
    private float lastSunBrightness = 0.0f;
    private float lastLightning = 0.0f;
    private float lastPotion = 0.0f;
    private int[] lastLightmapValues = new int[]{-16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216};
    private boolean lastBeneathRendering = false;
    boolean needSkyColor = false;
    private boolean lastAboveHorizon = true;
    private int lastBiome = 0;
    private int lastSkyColor = 0;
    public Random generator = new Random();
    public int iMenu = 1;
    private bcd guiScreen = null;
    private boolean enabled = true;
    public boolean fullscreenMap = false;
    public boolean active = false;
    private int zoom = 2;
    private int regularZoom = 2;
    public int sizeModifier = 0;
    public int mapCorner = 1;
    public int mapX = 37;
    public int mapY = 37;
    int scWidth;
    int scHeight;
    public String zmodver = "v1.0.22";
    private boolean rc = true;
    private String error = "";
    private String[] sMenu = new String[8];
    private int ztimer = 0;
    private int availableProcessors = Runtime.getRuntime().availableProcessors();
    public boolean multicore = this.availableProcessors > 0;
    private int heightMapFudge = 0;
    private int timer = 0;
    public boolean doFullRender = true;
    public int lastX = 0;
    public int lastZ = 0;
    private int lastY = 0;
    public double lastXDouble = 0.0;
    public double lastZDouble = 0.0;
    public int scScale = 0;
    public int lastZoom = 0;
    private float direction = 0.0f;
    public float percentX;
    public float percentY;
    public boolean lastPercentXOver = false;
    public boolean lastPercentYOver = false;
    private File settingsFile;
    MinecraftServer server;
    private String worldName = "";
    private String currentSubWorld = "";
    public aza keyBindZoom = new aza("key.minimap.zoom", 44, "key.categories.misc");
    public aza keyBindFullscreen = new aza("key.minimap.togglefullscreen", 45, "key.categories.misc");
    public aza keyBindMenu = new aza("key.minimap.voxelmapmenu", 50, "key.categories.misc");
    public aza keyBindWaypointMenu = new aza("key.minimap.waypointmenu", 0, "key.categories.misc");
    public aza keyBindWaypoint = new aza("key.minimap.waypointhotkey", 48, "key.categories.misc");
    public aza keyBindMobToggle = new aza("key.minimap.togglemobs", 0, "key.categories.misc");
    public aza[] keyBindings;
    Long newServerTime = 0L;
    boolean checkMOTD = false;
    ayz mostRecentLine = null;
    public boolean dlSafe = false;
    private boolean realTimeTorches = false;
    public Boolean radarAllowed = true;
    public Boolean cavesAllowed = true;
    public boolean hide = false;
    private boolean coords = true;
    private boolean showNether = true;
    private boolean showCaves = true;
    private boolean lightmap = true;
    private boolean heightmap = this.multicore;
    private int heightMapResetHeight = this.multicore ? 2 : 5;
    private int heightMapResetTime = this.multicore ? 300 : 3000;
    private boolean slopemap = true;
    boolean filtering = true;
    public boolean waterTransparency = this.multicore;
    public boolean blockTransparency = this.multicore;
    public boolean biomes = this.multicore;
    public int biomeOverlay = 0;
    public boolean chunkGrid = false;
    public boolean squareMap = false;
    public boolean lastSquareMap = false;
    public boolean oldNorth = false;
    public int northRotate = 0;
    public boolean showBeacons = true;
    public boolean showWaypoints = true;
    public int deathpoints = 1;
    public int maxWaypointDisplayDistance = 1000;
    private boolean welcome = true;
    public Thread zCalc = new Thread((Runnable)this, "Map Calculation");
    public boolean threading = this.multicore;
    private bag fontRenderer;
    private int[] lightmapColors = new int[256];
    private final int[] selfHash = new int[]{"minecraftxteria".toLowerCase().hashCode(), "jacoboom100".toLowerCase().hashCode(), "Laserpigofdoom".toLowerCase().hashCode(), "DesignVenomz".toLowerCase().hashCode(), "ElectronTowel".toLowerCase().hashCode(), "Fighterbear12".toLowerCase().hashCode(), "KillmurCS".toLowerCase().hashCode()};
    private boolean tf = false;
    public static VoxelMap instance;

    public VoxelMap(boolean showUnderMenus) {
        this.game = azd.A();
        instance = this;
        System.out.println("ID is " + ahu.c.a("stonebrick"));
        this.showUnderMenus = showUnderMenus;
        VoxelMapResourcePack voxelMapResourcePack = new VoxelMapResourcePack();
        List defaultResourcePacks = (List)ReflectionUtils.getPrivateFieldByType(this.game, azd.class, List.class, 1);
        if (!defaultResourcePacks.contains(voxelMapResourcePack)) {
            defaultResourcePacks.add(voxelMapResourcePack);
        }
        this.game.b();
        this.radar = new VoxelRadar(this);
        this.colorManager = new VoxelColorManager(this);
        this.waypointManager = new VoxelWaypointManager(this);
        this.dimensionManager = new DimensionManager(this);
        try {
            NetworkUtils.enumerateInterfaces();
        }
        catch (SocketException e) {
            System.out.println("could not get network interface addresses");
            e.printStackTrace();
        }
        this.keyBindings = new aza[]{this.keyBindMenu, this.keyBindWaypoint, this.keyBindZoom, this.keyBindFullscreen, this.keyBindMobToggle};
        ArrayList<aza> tempBindings = new ArrayList<aza>();
        tempBindings.addAll(Arrays.asList(this.game.u.ad));
        tempBindings.add(this.keyBindMenu);
        this.game.u.ad = tempBindings.toArray(new aza[tempBindings.size()]);
        this.zCalc.start();
        this.zCalc.setPriority(5);
        this.mapData[0] = new MapData(32, 32);
        this.mapData[1] = new MapData(64, 64);
        this.mapData[2] = new MapData(128, 128);
        this.mapData[3] = new MapData(256, 256);
        this.chunkCache[0] = new MapChunkCache(3, 3);
        this.chunkCache[1] = new MapChunkCache(5, 5);
        this.chunkCache[2] = new MapChunkCache(9, 9);
        this.chunkCache[3] = new MapChunkCache(17, 17);
        this.map[0] = new GLBufferedImage(32, 32, 6);
        this.map[1] = new GLBufferedImage(64, 64, 6);
        this.map[2] = new GLBufferedImage(128, 128, 6);
        this.map[3] = new GLBufferedImage(256, 256, 6);
        this.roundImage = new GLBufferedImage(128, 128, 6);
        this.sMenu[0] = "\u00a74VoxelMap\u00a7F! " + this.zmodver + " " + TranslateUtils.getString("minimap.ui.welcome1");
        this.sMenu[1] = TranslateUtils.getString("minimap.ui.welcome2");
        this.sMenu[2] = TranslateUtils.getString("minimap.ui.welcome3");
        this.sMenu[3] = TranslateUtils.getString("minimap.ui.welcome4");
        this.sMenu[4] = "\u00a7B" + VoxelMap.getKeyDisplayString(this.keyBindZoom.i()) + "\u00a7F: " + TranslateUtils.getString("minimap.ui.welcome5a") + ", \u00a7B: " + VoxelMap.getKeyDisplayString(this.keyBindMenu.i()) + "\u00a7F: " + TranslateUtils.getString("minimap.ui.welcome5b");
        this.sMenu[5] = "\u00a7B" + VoxelMap.getKeyDisplayString(this.keyBindFullscreen.i()) + "\u00a7F: " + TranslateUtils.getString("minimap.ui.welcome6");
        this.sMenu[6] = "\u00a7B" + VoxelMap.getKeyDisplayString(this.keyBindWaypoint.i()) + "\u00a7F: " + TranslateUtils.getString("minimap.ui.welcome7");
        this.sMenu[7] = "\u00a7F" + VoxelMap.getKeyDisplayString(this.keyBindZoom.i()) + "\u00a77: " + TranslateUtils.getString("minimap.ui.welcome8");
        if (GLUtils.fboEnabled) {
            GLUtils.setupFBO();
        }
        this.loadAll();
        bnf renderManager = bnf.a;
        if (renderManager != null) {
            Object entityRenderMap = ReflectionUtils.getPrivateFieldByType(renderManager, bnf.class, Map.class);
            if (entityRenderMap == null) {
                System.out.println("could not get entityRenderMap");
            } else {
                RenderWaypointContainer renderWaypoint = new RenderWaypointContainer();
                ((HashMap)entityRenderMap).put(EntityWaypointContainer.class, renderWaypoint);
                renderWaypoint.a(bnf.a);
                this.haveRenderManager = true;
            }
        }
    }

    public static VoxelMap getInstance() {
        return instance;
    }

    public void chatInfo(String s) {
        this.game.h.a((fa)new fh(s));
    }

    public int xCoord() {
        return (int)(this.game.h.t < 0.0 ? this.game.h.t - 1.0 : this.game.h.t);
    }

    public int zCoord() {
        return (int)(this.game.h.v < 0.0 ? this.game.h.v - 1.0 : this.game.h.v);
    }

    public int yCoord() {
        return (int)this.game.h.u;
    }

    public double xCoordDouble() {
        return this.game.h.t < 0.0 ? this.game.h.t - 1.0 : this.game.h.t;
    }

    public double zCoordDouble() {
        return this.game.h.v < 0.0 ? this.game.h.v - 1.0 : this.game.h.v;
    }

    private float rotationYaw() {
        return this.game.h.z;
    }

    public afn getWorld() {
        return this.game.f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.game == null) {
            return;
        }
        while (true) {
            if (this.threading) {
                this.active = true;
                while (this.game.h != null && this.active) {
                    if (!this.hide) {
                        try {
                            Object object = this.colorManager.tpLoadLock;
                            synchronized (object) {
                                this.mapCalc(this.doFullRender);
                                if (!this.doFullRender) {
                                    this.chunkCache[this.lastZoom].calculateChunks(this.oldNorth);
                                }
                            }
                        }
                        catch (Exception local) {
                            // empty catch block
                        }
                    }
                    this.doFullRender = false;
                    this.active = false;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exc) {
                    // empty catch block
                }
                try {
                    this.zCalc.wait(0L);
                }
                catch (Exception exc) {}
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exc) {
                // empty catch block
            }
            try {
                this.zCalc.wait(0L);
            }
            catch (Exception exception) {
            }
        }
    }

    public void onTickInGame(azd mc) {
        Object entityRenderMapObj;
        bnf renderManager;
        int n = this.northRotate = this.oldNorth ? 90 : 0;
        if (this.game == null) {
            this.game = mc;
        }
        if (this.fontRenderer == null) {
            this.fontRenderer = this.game.l;
        }
        if (GLUtils.textureManager == null) {
            GLUtils.textureManager = this.game.N();
        }
        if (this.lightmapTexture == null) {
            this.lightmapTexture = this.getLightmapTexture();
        }
        if (!this.haveRenderManager && (renderManager = bnf.a) != null && (entityRenderMapObj = ReflectionUtils.getPrivateFieldByType(renderManager, bnf.class, Map.class)) != null) {
            RenderWaypointContainer renderWaypoint = new RenderWaypointContainer();
            ((HashMap)entityRenderMapObj).put(EntityWaypointContainer.class, renderWaypoint);
            renderWaypoint.a(bnf.a);
            this.haveRenderManager = true;
        }
        if (this.game.n == null && this.keyBindMenu.f()) {
            this.iMenu = 0;
            if (this.welcome) {
                this.welcome = false;
                this.saveAll();
            }
            this.game.a((bcd)new GuiMinimapOptions(this));
        }
        if (this.game.n == null && this.keyBindWaypoint.f()) {
            float b;
            float g;
            float r;
            this.iMenu = 0;
            if (this.welcome) {
                this.welcome = false;
                this.saveAll();
            }
            if (this.waypointManager.wayPts.size() == 0) {
                r = 0.0f;
                g = 1.0f;
                b = 0.0f;
            } else {
                r = this.generator.nextFloat();
                g = this.generator.nextFloat();
                b = this.generator.nextFloat();
            }
            TreeSet<Integer> dimensions = new TreeSet<Integer>();
            dimensions.add(this.game.h.aq);
            Waypoint newWaypoint = new Waypoint("", this.game.h.aq != -1 ? this.xCoord() : this.xCoord() * 8, this.game.h.aq != -1 ? this.zCoord() : this.zCoord() * 8, this.yCoord() - 1, true, r, g, b, "", this.currentSubWorld, dimensions);
            this.game.a((bcd)new GuiScreenAddWaypoint(null, newWaypoint));
        }
        if (this.game.n == null && this.keyBindMobToggle.f()) {
            if (this.welcome) {
                this.welcome = false;
                this.saveAll();
            }
            this.radar.setOptionValue(EnumOptionsMinimap.SHOWRADAR, 0);
            this.saveAll();
        }
        if (this.game.n == null && this.keyBindZoom.f() && (this.showNether || this.game.h.aq != -1)) {
            if (this.welcome) {
                this.welcome = false;
                this.saveAll();
            }
            this.SetZoom();
        }
        if (this.game.n == null && this.keyBindFullscreen.f() && (this.showNether || this.game.h.aq != -1)) {
            if (this.welcome) {
                this.welcome = false;
                this.saveAll();
            }
            boolean bl = this.fullscreenMap = !this.fullscreenMap;
            this.error = this.zoom == 3 ? TranslateUtils.getString("minimap.ui.zoomlevel") + " (0.5x)" : (this.zoom == 2 ? TranslateUtils.getString("minimap.ui.zoomlevel") + " (1.0x)" : (this.zoom == 1 ? TranslateUtils.getString("minimap.ui.zoomlevel") + " (2.0x)" : TranslateUtils.getString("minimap.ui.zoomlevel") + " (4.0x)"));
        }
        this.checkForChanges();
        if (this.game.n instanceof bbj && !(this.guiScreen instanceof bbj)) {
            this.waypointManager.handleDeath();
        }
        this.waypointManager.moveWaypointEntityToBack();
        this.guiScreen = this.game.n;
        this.checkIfChunksChanged();
        this.getCurrentLightAndSkyColor();
        if (this.threading) {
            if (!this.zCalc.isAlive() && this.threading) {
                this.zCalc = new Thread((Runnable)this, "Map Calculation");
                this.zCalc.start();
            }
            if (!(this.game.n instanceof bbj) && !(this.game.n instanceof bbv) && this.game.n != null) {
                try {
                    this.zCalc.notify();
                }
                catch (Exception exception) {}
            }
        } else if (!this.threading) {
            if (!this.hide) {
                this.mapCalc(this.doFullRender);
                if (!this.doFullRender) {
                    this.chunkCache[this.lastZoom].calculateChunks(this.oldNorth);
                }
            }
            this.doFullRender = false;
        }
        if (this.iMenu == 1 && !this.welcome) {
            this.iMenu = 0;
        }
        this.enabled = !(mc.u.ag && this.game.n == null || !this.showUnderMenus && this.game.n != null && !(this.game.n instanceof bbb) || Keyboard.isKeyDown((int)61));
        this.direction = this.rotationYaw() + 180.0f + (float)this.northRotate;
        while (this.direction >= 360.0f) {
            this.direction -= 360.0f;
        }
        while (this.direction < 0.0f) {
            this.direction += 360.0f;
        }
        if (!this.error.equals("") && this.ztimer == 0) {
            this.ztimer = 500;
        }
        if (this.ztimer > 0) {
            --this.ztimer;
        }
        if (this.ztimer == 0 && !this.error.equals("")) {
            this.error = "";
        }
        if (this.enabled) {
            this.drawMinimap(mc);
        }
        int n2 = this.timer = this.timer > 5000 ? 0 : this.timer + 1;
        if (this.timer == 5000 && this.game.h.aq == 0) {
            this.waypointManager.check2dWaypoints();
        }
    }

    private bpi getLightmapTexture() {
        Object lightmapTextureObj = ReflectionUtils.getPrivateFieldByType(this.game.p, bll.class, bpi.class);
        if (lightmapTextureObj == null) {
            return null;
        }
        return (bpi)lightmapTextureObj;
    }

    public void getCurrentLightAndSkyColor() {
        int biomeID;
        boolean aboveHorizon;
        boolean scheduledUpdate;
        int lastLightningBolt;
        if (!this.haveRenderManager) {
            return;
        }
        if (this.game.u.ar != this.lastGamma) {
            this.needLight = true;
            this.lastGamma = this.game.u.ar;
        }
        for (int t = 0; t < 16; ++t) {
            if (this.world.t.h[t] == this.lastLightBrightnessTable[t]) continue;
            this.needLight = true;
            this.lastLightBrightnessTable[t] = this.world.t.h[t];
        }
        float sunBrightness = this.world.b(1.0f);
        if ((double)Math.abs(this.lastSunBrightness - sunBrightness) > 0.01 || (double)sunBrightness == 1.0 && sunBrightness != this.lastSunBrightness || (double)sunBrightness == 0.0 && sunBrightness != this.lastSunBrightness) {
            this.needLight = true;
            this.needSkyColor = true;
            this.lastSunBrightness = sunBrightness;
        }
        float potionEffect = 0.0f;
        if (this.game.h.a(qi.r)) {
            int duration = this.game.h.b(qi.r).b();
            float f = potionEffect = duration > 200 ? 1.0f : 0.7f + ou.a((float)(((float)duration - 1.0f) * (float)Math.PI * 0.2f)) * 0.3f;
        }
        if (this.lastPotion != potionEffect) {
            this.lastPotion = potionEffect;
            this.needLight = true;
        }
        if (this.lastLightning != (float)(lastLightningBolt = this.world.q)) {
            this.lastLightning = lastLightningBolt;
            this.needLight = true;
        }
        boolean bl = this.lastLightBrightnessTable[0] == 0.0f && (this.timer + 200) % 250 == 0 || this.timer % (this.game.h.aq == -1 ? 5000 : 500) == 0 ? true : (scheduledUpdate = false);
        if (this.lightmap && (this.needLight || scheduledUpdate || this.realTimeTorches)) {
            GLUtils.disp(this.lightmapTexture.b());
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1024).order(ByteOrder.nativeOrder());
            GL11.glGetTexImage((int)3553, (int)0, (int)6408, (int)5121, (ByteBuffer)byteBuffer);
            for (int i = 0; i < this.lightmapColors.length; ++i) {
                int index = i * 4;
                this.lightmapColors[i] = (byteBuffer.get(index + 3) << 24) + (byteBuffer.get(index) << 16) + (byteBuffer.get(index + 1) << 8) + (byteBuffer.get(index + 2) << 0);
            }
            int torchOffset = 0;
            if (this.realTimeTorches) {
                torchOffset = 8;
            }
            for (int t = 0; t < 16; ++t) {
                if (this.lightmapColors[t * 16 + torchOffset] == this.lastLightmapValues[t]) continue;
                this.needLight = false;
            }
        }
        boolean bl2 = aboveHorizon = this.game.h.l((float)0.0f).d >= this.world.T();
        if (aboveHorizon != this.lastAboveHorizon) {
            this.needSkyColor = true;
            this.lastAboveHorizon = aboveHorizon;
        }
        if ((biomeID = this.world.a((int)this.xCoord(), (int)this.zCoord()).ay) != this.lastBiome) {
            this.needSkyColor = true;
            this.lastBiome = biomeID;
        }
        if (this.needSkyColor || scheduledUpdate) {
            this.colorManager.setSkyColor(this.getSkyColor());
        }
    }

    private int getSkyColor() {
        this.needSkyColor = false;
        boolean aboveHorizon = this.game.h.l((float)0.0f).d >= this.world.T();
        float[] fogColors = new float[16];
        FloatBuffer temp = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloat((int)3106, (FloatBuffer)temp);
        temp.get(fogColors);
        double rFog = fogColors[0];
        double gFog = fogColors[1];
        double bFog = fogColors[2];
        int fogColor = (int)(rFog * 255.0) * 65536 + (int)(gFog * 255.0) * 256 + (int)(bFog * 255.0);
        if (this.game.f.t.d() && this.game.u.a(azz.f) >= 4.0f) {
            double rSky;
            double gSky;
            double bSky;
            if (!aboveHorizon) {
                bSky = 0.0;
                gSky = 0.0;
                rSky = 0.0;
            } else {
                ayk skyColorVec = this.world.a((qn)this.game.h, 0.0f);
                rSky = skyColorVec.c;
                gSky = skyColorVec.d;
                bSky = skyColorVec.e;
                if (this.world.t.g()) {
                    rSky = rSky * (double)0.2f + (double)0.04f;
                    gSky = gSky * (double)0.2f + (double)0.04f;
                    bSky = bSky * (double)0.6f + (double)0.1f;
                }
            }
            boolean showLocalFog = this.world.t.b(this.xCoord(), this.zCoord());
            float farPlaneDistance = this.game.u.a(azz.f) * 16.0f;
            float fogStart = 0.0f;
            float fogEnd = 0.0f;
            if (showLocalFog) {
                fogStart = farPlaneDistance * 0.05f;
                fogEnd = Math.min(farPlaneDistance, 192.0f) * 0.5f;
            } else {
                fogEnd = farPlaneDistance * 0.8f;
            }
            float fogDensity = Math.max(0.0f, Math.min(1.0f, (fogEnd - ((float)this.yCoord() - (float)this.game.f.T())) / (fogEnd - fogStart)));
            int skyColor = (int)(fogDensity * 255.0f) * 0x1000000 + (int)(rSky * 255.0) * 65536 + (int)(gSky * 255.0) * 256 + (int)(bSky * 255.0);
            return this.colorManager.colorAdder(skyColor, fogColor);
        }
        return -16777216 + fogColor;
    }

    public void drawMinimap(azd mc) {
        int scScale = 1;
        while (this.game.d / (scScale + 1) >= 320 && this.game.e / (scScale + 1) >= 240) {
            ++scScale;
        }
        double scaledWidthD = (double)this.game.d / (double)(scScale += this.fullscreenMap ? 0 : this.sizeModifier);
        double scaledHeightD = (double)this.game.e / (double)scScale;
        this.scWidth = ou.f((double)scaledWidthD);
        this.scHeight = ou.f((double)scaledHeightD);
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)scaledWidthD, (double)scaledHeightD, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        this.mapX = this.mapCorner == 0 || this.mapCorner == 3 ? 37 : this.scWidth - 37;
        this.mapY = this.mapCorner == 0 || this.mapCorner == 1 ? 37 : this.scHeight - 37;
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float multi = 2.0f / (float)Math.pow(2.0, this.lastZoom);
        this.percentX = (float)this.lastXDouble - (float)this.lastX;
        if (this.lastX < 0) {
            this.percentX += 1.0f;
        }
        this.percentX *= multi;
        this.percentY = (float)this.lastZDouble - (float)this.lastZ;
        if (this.lastZ < 0) {
            this.percentY += 1.0f;
        }
        this.percentY *= multi;
        if ((this.showNether || this.game.h.aq != -1) && !this.hide) {
            GL11.glEnable((int)2929);
            if (this.fullscreenMap) {
                this.renderMapFull(this.scWidth, this.scHeight);
            } else {
                this.renderMap(this.mapX, this.mapY, scScale);
            }
            GL11.glDisable((int)2929);
            if (this.radar != null && this.radarAllowed.booleanValue() && !this.fullscreenMap) {
                this.radar.OnTickInGame(mc);
            }
            if (!this.fullscreenMap) {
                this.drawDirections(this.mapX, this.mapY);
            }
            if ((this.squareMap || this.fullscreenMap) && !this.hide) {
                if (this.fullscreenMap) {
                    this.drawArrow(this.scWidth / 2, this.scHeight / 2);
                } else {
                    this.drawArrow(this.mapX, this.mapY);
                }
            }
            if (this.tf) {
                GLUtils.img(new bqo("voxelmap", "lang/i18n.txt"));
                GLUtils.drawPre();
                GLUtils.setMap(this.mapX, this.mapY);
                GLUtils.drawPost();
            }
        }
        if (this.coords) {
            this.showCoords(this.mapX, this.mapY);
        }
        if (this.iMenu > 0) {
            this.showMenu(this.scWidth, this.scHeight);
        }
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
    }

    private void checkForChanges() {
        boolean changed = false;
        MinecraftServer server = MinecraftServer.G();
        if (server != null && server != this.server) {
            this.server = server;
            ab commandManager = server.H();
            bk manager = (bk)commandManager;
            manager.a((aa)new CommandServerZanTp(this));
        }
        if (this.checkMOTD) {
            this.checkPermissionMessages();
        }
        if (this.getWorld() != null && !this.getWorld().equals(this.world)) {
            String mapName;
            if (this.game.E()) {
                mapName = this.getMapName();
            } else {
                mapName = this.getServerName();
                if (mapName != null) {
                    mapName = mapName.toLowerCase();
                }
            }
            if (!this.worldName.equals(mapName) && mapName != null && !mapName.equals("")) {
                this.lightmapTexture = this.getLightmapTexture();
                changed = true;
                this.worldName = mapName;
                this.waypointManager.loadWaypoints();
                this.radarAllowed = true;
                this.cavesAllowed = true;
                if (!this.game.E()) {
                    this.newServerTime = System.currentTimeMillis();
                    this.checkMOTD = true;
                }
                this.dimensionManager.populateDimensions();
                this.tf = false;
                if (this.game.h != null) {
                    for (int t = 0; t < this.selfHash.length; ++t) {
                        if (this.game.h.bH().getName().toLowerCase().hashCode() != this.selfHash[t]) continue;
                        this.tf = true;
                    }
                }
            }
            changed = true;
            this.world = this.getWorld();
            this.waypointManager.newWorld();
            this.dimensionManager.enteredDimension(this.world.t.i);
        }
        if (this.colorManager.checkForChanges()) {
            changed = true;
        }
        if (changed) {
            this.doFullRender = true;
        }
    }

    public String getMapName() {
        return this.game.G().N();
    }

    public String getServerName() {
        try {
            bjh serverData = null;
            Object serverDataObj = ReflectionUtils.getPrivateFieldByType(this.game, azd.class, bjh.class);
            if (serverDataObj != null) {
                serverData = (bjh)serverDataObj;
            }
            if (serverData != null) {
                String serverAddressString = serverData.b;
                int colonLoc = serverAddressString.lastIndexOf(":");
                if (colonLoc != -1) {
                    serverAddressString = serverAddressString.substring(0, colonLoc);
                }
                InetAddress serverAddress = InetAddress.getByName(serverAddressString);
                if (serverData.c == null && serverData.d == null && NetworkUtils.isOnLan(serverAddress)) {
                    System.out.println("on lan!");
                    return serverData.a;
                }
                return serverData.b;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public String getCurrentWorldName() {
        return this.worldName;
    }

    public String getCurrentSubWorldName() {
        return this.currentSubWorld;
    }

    public void newSubWorldName(String name) {
        this.currentSubWorld = name;
        this.waypointManager.newSubWorldName(this.currentSubWorld);
    }

    private void checkPermissionMessages() {
        if (System.currentTimeMillis() - this.newServerTime < 5000L) {
            bao guiNewChat = this.game.r.b();
            if (guiNewChat == null) {
                System.out.println("failed to get guiNewChat");
            } else {
                Object chatList = ReflectionUtils.getPrivateFieldByType(guiNewChat, bao.class, List.class, 1);
                if (chatList == null) {
                    System.out.println("could not get chatlist");
                } else {
                    ayz checkMe;
                    boolean killRadar = false;
                    boolean killCaves = false;
                    for (int t = 0; t < ((List)chatList).size() && !(checkMe = (ayz)((List)chatList).get(t)).equals(this.mostRecentLine); ++t) {
                        String msg = checkMe.a().e();
                        if (msg.contains("\u00a73 \u00a76 \u00a73 \u00a76 \u00a73 \u00a76 \u00a7e")) {
                            killRadar = true;
                            this.error = "Server disabled radar";
                        }
                        if (!msg.contains("\u00a73 \u00a76 \u00a73 \u00a76 \u00a73 \u00a76 \u00a7d")) continue;
                        killCaves = true;
                        this.error = "Server disabled cavemapping";
                    }
                    this.radarAllowed = this.radarAllowed != false && !killRadar;
                    this.cavesAllowed = this.cavesAllowed != false && !killCaves;
                    this.mostRecentLine = ((List)chatList).size() > 0 ? (ayz)((List)chatList).get(0) : null;
                }
            }
        } else {
            this.checkMOTD = false;
        }
    }

    public void setPermissions(boolean hasRadarPermission, boolean hasCavemodePermission) {
        this.radarAllowed = hasRadarPermission;
        this.cavesAllowed = hasCavemodePermission;
    }

    private void SetZoom() {
        if (this.iMenu != 0) {
            this.iMenu = 0;
            if (this.getMenu() != null) {
                this.setMenuNull();
            }
        } else {
            if (this.zoom == 0) {
                this.zoom = 3;
                this.error = TranslateUtils.getString("minimap.ui.zoomlevel") + " (0.5x)";
            } else if (this.zoom == 3) {
                this.zoom = 2;
                this.error = TranslateUtils.getString("minimap.ui.zoomlevel") + " (1.0x)";
            } else if (this.zoom == 2) {
                this.zoom = 1;
                this.error = TranslateUtils.getString("minimap.ui.zoomlevel") + " (2.0x)";
            } else {
                this.zoom = 0;
                this.error = TranslateUtils.getString("minimap.ui.zoomlevel") + " (4.0x)";
            }
            this.saveAll();
            this.doFullRender = true;
        }
        this.map[this.zoom].blank();
    }

    private void checkIfChunksChanged() {
        this.chunkCache[this.lastZoom].checkIfChunksChanged(this.xCoord(), this.zCoord());
    }

    private void mapCalc(boolean full) {
        int imageX;
        int imageY;
        long startTime = System.nanoTime();
        int startX = this.xCoord();
        int startZ = this.zCoord();
        int startY = this.yCoord();
        int offsetX = startX - this.lastX;
        int offsetZ = startZ - this.lastZ;
        int offsetY = startY - this.lastY;
        this.lastX = startX;
        this.lastZ = startZ;
        this.lastXDouble = this.xCoordDouble();
        this.lastZDouble = this.zCoordDouble();
        this.lastZoom = this.zoom;
        int multi = (int)Math.pow(2.0, this.lastZoom);
        afn world = this.getWorld();
        boolean needHeight = false;
        boolean needHeightMap = false;
        boolean needLight = false;
        boolean skyColorChanged = false;
        int skyColor = this.colorManager.getBlockColor(0, 0, 0);
        if (this.lastSkyColor != skyColor) {
            skyColorChanged = true;
            this.lastSkyColor = skyColor;
        }
        if (this.lightmap) {
            int torchOffset = 0;
            if (this.realTimeTorches) {
                torchOffset = 8;
            }
            for (int t = 0; t < 16; ++t) {
                if (this.lastLightmapValues[t] == this.lightmapColors[t * 16 + torchOffset]) continue;
                needLight = true;
                this.lastLightmapValues[t] = this.lightmapColors[t * 16 + torchOffset];
            }
        }
        if (offsetY != 0) {
            ++this.heightMapFudge;
        } else if (this.heightMapFudge != 0) {
            ++this.heightMapFudge;
        }
        if (full || Math.abs(offsetY) >= this.heightMapResetHeight || this.heightMapFudge > this.heightMapResetTime) {
            this.lastY = startY;
            needHeightMap = true;
            this.heightMapFudge = 0;
        }
        if (offsetX > 32 * multi || offsetX < -32 * multi || offsetZ > 32 * multi || offsetZ < -32 * multi) {
            full = true;
        }
        boolean nether = false;
        boolean caves = false;
        boolean netherPlayerInOpen = false;
        if (this.game.h.aq != -1) {
            caves = this.cavesAllowed.booleanValue() && this.showCaves && this.getWorld().d(this.lastX, this.lastZ).a(afz.a, this.lastX & 0xF, Math.max(Math.min(this.yCoord(), 255), 0), this.lastZ & 0xF) <= 0;
        } else if (this.showNether) {
            nether = true;
            netherPlayerInOpen = world.f(this.lastX, this.lastZ) < this.yCoord();
        } else {
            return;
        }
        if (this.lastBeneathRendering != (caves || nether)) {
            this.lastBeneathRendering = caves || nether;
            full = true;
        }
        if (!(full || offsetX != 0 || offsetZ != 0 || needHeightMap || needLight || skyColorChanged)) {
            return;
        }
        needHeight = needHeightMap && (nether || caves);
        startX -= 16 * multi;
        startZ -= 16 * multi;
        int color24 = -1;
        if (!full) {
            this.map[this.lastZoom].moveY(offsetZ);
            this.mapData[this.lastZoom].moveZ(offsetZ);
            this.map[this.lastZoom].moveX(offsetX);
            this.mapData[this.lastZoom].moveX(offsetX);
            for (imageY = offsetZ > 0 ? 32 * multi - 1 : -offsetZ - 1; imageY >= (offsetZ > 0 ? 32 * multi - offsetZ : 0); --imageY) {
                if (this.oldNorth) {
                    for (imageX = 32 * multi - 1; imageX >= 0; --imageX) {
                        color24 = this.getPixelColor(true, true, true, true, true, nether, netherPlayerInOpen, caves, world, multi, startX, startZ, imageX, imageY);
                        this.map[this.lastZoom].setRGB(imageX, imageY, color24);
                    }
                    continue;
                }
                for (imageX = 0; imageX < 32 * multi; ++imageX) {
                    color24 = this.getPixelColor(true, true, true, true, true, nether, netherPlayerInOpen, caves, world, multi, startX, startZ, imageX, imageY);
                    this.map[this.lastZoom].setRGB(imageX, imageY, color24);
                }
            }
            for (imageY = 32 * multi - 1; imageY >= 0; --imageY) {
                if (this.oldNorth) {
                    for (imageX = offsetX > 0 ? 32 * multi - 1 : -offsetX - 1; imageX >= (offsetX > 0 ? 32 * multi - offsetX : 0); --imageX) {
                        color24 = this.getPixelColor(true, true, true, true, true, nether, netherPlayerInOpen, caves, world, multi, startX, startZ, imageX, imageY);
                        this.map[this.lastZoom].setRGB(imageX, imageY, color24);
                    }
                    continue;
                }
                for (imageX = offsetX > 0 ? 32 * multi - offsetX : 0; imageX < (offsetX > 0 ? 32 * multi : -offsetX); ++imageX) {
                    color24 = this.getPixelColor(true, true, true, true, true, nether, netherPlayerInOpen, caves, world, multi, startX, startZ, imageX, imageY);
                    this.map[this.lastZoom].setRGB(imageX, imageY, color24);
                }
            }
            this.imageChanged = true;
        }
        if (full || this.heightmap && needHeightMap || needHeight || this.lightmap && needLight || skyColorChanged) {
            for (imageY = 32 * multi - 1; imageY >= 0; --imageY) {
                if (this.oldNorth) {
                    for (imageX = 32 * multi - 1; imageX >= 0; --imageX) {
                        color24 = this.getPixelColor(full, full || needHeight, full || needHeight, full, full || needLight || needHeight, nether, netherPlayerInOpen, caves, world, multi, startX, startZ, imageX, imageY);
                        this.map[this.lastZoom].setRGB(imageX, imageY, color24);
                    }
                    continue;
                }
                for (imageX = 0; imageX < 32 * multi; ++imageX) {
                    color24 = this.getPixelColor(full, full || needHeight, full || needHeight, full, full || needLight || needHeight, nether, netherPlayerInOpen, caves, world, multi, startX, startZ, imageX, imageY);
                    this.map[this.lastZoom].setRGB(imageX, imageY, color24);
                }
            }
            this.imageChanged = true;
        }
    }

    public void chunkCalc(int left, int top, int right, int bottom) {
        boolean nether = false;
        boolean caves = false;
        boolean netherPlayerInOpen = false;
        if (this.game.h.aq != -1) {
            caves = this.cavesAllowed.booleanValue() && this.showCaves && this.getWorld().d(this.lastX, this.lastZ).a(afz.a, this.lastX & 0xF, Math.max(Math.min(this.yCoord(), 255), 0), this.lastZ & 0xF) <= 0;
        } else if (this.showNether) {
            nether = true;
            netherPlayerInOpen = this.world.f(this.lastX, this.lastZ) < this.yCoord();
        } else {
            return;
        }
        int startX = this.lastX;
        int startZ = this.lastZ;
        int multi = (int)Math.pow(2.0, this.lastZoom);
        left = left - (startX -= 16 * multi) - 1;
        right = right - startX + 1;
        top = top - (startZ -= 16 * multi) - 1;
        bottom = bottom - startZ + 1;
        left = Math.max(0, left);
        right = Math.min(32 * multi - 1, right);
        top = Math.max(0, top);
        bottom = Math.min(32 * multi - 1, bottom);
        int color24 = 0;
        for (int imageY = bottom; imageY >= top; --imageY) {
            int imageX;
            if (this.oldNorth) {
                for (imageX = right; imageX >= left; --imageX) {
                    color24 = this.getPixelColor(true, true, true, true, true, nether, netherPlayerInOpen, caves, this.world, multi, startX, startZ, imageX, imageY);
                    this.map[this.lastZoom].setRGB(imageX, imageY, color24);
                }
                continue;
            }
            for (imageX = left; imageX <= right; ++imageX) {
                color24 = this.getPixelColor(true, true, true, true, true, nether, netherPlayerInOpen, caves, this.world, multi, startX, startZ, imageX, imageY);
                this.map[this.lastZoom].setRGB(imageX, imageY, color24);
            }
        }
        this.imageChanged = true;
    }

    private int getPixelColor(boolean needBiome, boolean needHeight, boolean needID, boolean needTint, boolean needLight, boolean nether, boolean netherPlayerInOpen, boolean caves, afn world, int multi, int startX, int startZ, int imageX, int imageY) {
        avf material;
        int light;
        int color24 = 0;
        int biomeID = 0;
        if (needBiome) {
            biomeID = world.a((int)(startX + imageX), (int)(startZ + imageY)).ay;
            this.mapData[this.lastZoom].setBiomeID(imageX, imageY, biomeID);
        } else {
            biomeID = this.mapData[this.lastZoom].getBiomeID(imageX, imageY);
        }
        if (this.biomeOverlay == 1) {
            color24 = agg.n()[biomeID].ag | 0xFF000000;
            if (this.chunkGrid && ((startX + imageX) % 16 == 0 || (startZ + imageY) % 16 == 0)) {
                color24 = this.colorManager.colorAdder(0x7D000000, color24);
            }
            return color24;
        }
        int height = 0;
        boolean blockChangeForcedTint = false;
        boolean solid = false;
        if (needHeight) {
            height = this.getBlockHeight(nether, netherPlayerInOpen, caves, world, startX + imageX, startZ + imageY, this.yCoord());
            this.mapData[this.lastZoom].setHeight(imageX, imageY, height);
        } else {
            height = this.mapData[this.lastZoom].getHeight(imageX, imageY);
        }
        if (height == -1) {
            height = this.lastY + 1;
            solid = true;
        }
        int blockID = -1;
        int metadata = 0;
        if (needID) {
            ahu blockAbove = world.a(startX + imageX, height, startZ + imageY);
            if (blockAbove.o() == avf.y) {
                blockID = ahu.c.b((Object)blockAbove);
                metadata = world.e(startX + imageX, height, startZ + imageY);
            } else {
                ahu block = world.a(startX + imageX, height - 1, startZ + imageY);
                blockID = ahu.c.b((Object)block);
                metadata = world.e(startX + imageX, height - 1, startZ + imageY);
            }
            if (this.biomes && blockID != this.mapData[this.lastZoom].getMaterial(imageX, imageY)) {
                blockChangeForcedTint = true;
            }
            this.mapData[this.lastZoom].setMaterial(imageX, imageY, blockID);
            this.mapData[this.lastZoom].setMetadata(imageX, imageY, metadata);
        } else {
            blockID = this.mapData[this.lastZoom].getMaterial(imageX, imageY);
            metadata = this.mapData[this.lastZoom].getMetadata(imageX, imageY);
        }
        if (blockID == ahu.c.b((Object)ahz.l)) {
            solid = false;
        }
        color24 = this.rc ? this.colorManager.getBlockColor(blockID, metadata, biomeID) : -1;
        if (color24 == VoxelColorManager.COLOR_FAILED_LOAD) {
            color24 = 0;
        }
        if (this.biomes && blockID != -1) {
            int tint = -1;
            if (needTint || blockChangeForcedTint) {
                tint = this.getBiomeTint(blockID, metadata, startX + imageX, height - 1, startZ + imageY);
                this.mapData[this.lastZoom].setBiomeTint(imageX, imageY, tint);
            } else {
                tint = this.mapData[this.lastZoom].getBiomeTint(imageX, imageY);
            }
            if (tint != -1) {
                color24 = this.colorManager.colorMultiplier(color24, tint);
            }
        }
        color24 = this.applyHeight(color24, nether, netherPlayerInOpen, caves, world, multi, startX, startZ, imageX, imageY, height, solid, 1);
        int n = light = solid ? 0 : 255;
        if (needLight) {
            light = this.getLight(color24, blockID, world, startX + imageX, startZ + imageY, height, solid);
            this.mapData[this.lastZoom].setLight(imageX, imageY, light);
        } else {
            light = this.mapData[this.lastZoom].getLight(imageX, imageY);
        }
        if (light == 0) {
            color24 = 0;
        } else if (light != 255) {
            color24 = this.colorManager.colorMultiplier(color24, light);
        }
        if (this.waterTransparency && ((material = world.a(startX + imageX, height - 1, startZ + imageY).o()) == avf.h || material == avf.w)) {
            int seafloorHeight;
            if (needHeight) {
                seafloorHeight = this.getSeafloorHeight(world, startX + imageX, startZ + imageY, height);
                this.mapData[this.lastZoom].setOceanFloorHeight(imageX, imageY, seafloorHeight);
            } else {
                seafloorHeight = this.mapData[this.lastZoom].getOceanFloorHeight(imageX, imageY);
            }
            int seafloorColor = 0;
            if (needID) {
                ahu block = world.a(startX + imageX, seafloorHeight - 1, startZ + imageY);
                blockID = ahu.c.b((Object)block);
                metadata = world.e(startX + imageX, seafloorHeight - 1, startZ + imageY);
                if (block.o() == avf.h) {
                    blockID = 0;
                    metadata = 0;
                }
                if (this.biomes && blockID != this.mapData[this.lastZoom].getOceanFloorMaterial(imageX, imageY)) {
                    blockChangeForcedTint = true;
                }
                this.mapData[this.lastZoom].setOceanFloorMaterial(imageX, imageY, blockID);
                this.mapData[this.lastZoom].setOceanFloorMetadata(imageX, imageY, metadata);
            } else {
                blockID = this.mapData[this.lastZoom].getOceanFloorMaterial(imageX, imageY);
                metadata = this.mapData[this.lastZoom].getOceanFloorMetadata(imageX, imageY);
            }
            seafloorColor = this.rc ? this.colorManager.getBlockColor(blockID, metadata, biomeID) : 0xFFFFFF;
            if (this.biomes && blockID != -1) {
                int tint = -1;
                if (needTint || blockChangeForcedTint) {
                    tint = this.getBiomeTint(blockID, metadata, startX + imageX, seafloorHeight - 1, startZ + imageY);
                    this.mapData[this.lastZoom].setOceanFloorBiomeTint(imageX, imageY, tint);
                } else {
                    tint = this.mapData[this.lastZoom].getOceanFloorBiomeTint(imageX, imageY);
                }
                if (tint != -1) {
                    seafloorColor = this.colorManager.colorMultiplier(seafloorColor, tint);
                }
            }
            seafloorColor = this.applyHeight(seafloorColor, nether, netherPlayerInOpen, caves, world, multi, startX, startZ, imageX, imageY, seafloorHeight, solid, 0);
            int seafloorLight = 255;
            if (needLight) {
                seafloorLight = this.getLight(seafloorColor, blockID, world, startX + imageX, startZ + imageY, seafloorHeight, solid);
                if (this.lightmap && material == avf.w && (seafloorHeight == height - 1 || world.a(startX + imageX, seafloorHeight, startZ + imageY).o() == avf.w)) {
                    seafloorLight = this.colorManager.colorMultiplier(seafloorLight, 0x555555);
                }
                this.mapData[this.lastZoom].setOceanFloorLight(imageX, imageY, seafloorLight);
            } else {
                seafloorLight = this.mapData[this.lastZoom].getOceanFloorLight(imageX, imageY);
            }
            if (seafloorLight == 0) {
                seafloorColor = 0;
            } else if (seafloorLight != 255) {
                seafloorColor = this.colorManager.colorMultiplier(seafloorColor, seafloorLight);
            }
            color24 = this.colorManager.colorAdder(color24, seafloorColor);
        }
        if (this.blockTransparency) {
            int transparentHeight = -1;
            if (needHeight) {
                transparentHeight = this.getTransparentHeight(nether, netherPlayerInOpen, caves, world, startX + imageX, startZ + imageY, height);
                this.mapData[this.lastZoom].setTransparentHeight(imageX, imageY, transparentHeight);
            } else {
                transparentHeight = this.mapData[this.lastZoom].getTransparentHeight(imageX, imageY);
            }
            if (needID) {
                if (transparentHeight != -1 && transparentHeight > height) {
                    ahu block = world.a(startX + imageX, transparentHeight - 1, startZ + imageY);
                    blockID = ahu.c.b((Object)block);
                    metadata = world.e(startX + imageX, transparentHeight - 1, startZ + imageY);
                } else {
                    blockID = 0;
                    metadata = 0;
                }
                if (this.biomes && blockID != this.mapData[this.lastZoom].getTransparentId(imageX, imageY)) {
                    blockChangeForcedTint = true;
                }
                this.mapData[this.lastZoom].setTransparentId(imageX, imageY, blockID);
                this.mapData[this.lastZoom].setTransparentMetadata(imageX, imageY, metadata);
            } else {
                blockID = this.mapData[this.lastZoom].getTransparentId(imageX, imageY);
                metadata = this.mapData[this.lastZoom].getTransparentMetadata(imageX, imageY);
            }
            if (blockID != 0) {
                int transparentColor = this.colorManager.getBlockColor(blockID, metadata, biomeID);
                if (this.biomes) {
                    int tint = -1;
                    if (needTint || blockChangeForcedTint) {
                        tint = this.getBiomeTint(blockID, metadata, startX + imageX, height, startZ + imageY);
                        this.mapData[this.lastZoom].setTransparentBiomeTint(imageX, imageY, tint);
                    } else {
                        tint = this.mapData[this.lastZoom].getTransparentBiomeTint(imageX, imageY);
                    }
                    if (tint != -1) {
                        transparentColor = this.colorManager.colorMultiplier(transparentColor, tint);
                    }
                }
                transparentColor = this.applyHeight(transparentColor, nether, netherPlayerInOpen, caves, world, multi, startX, startZ, imageX, imageY, transparentHeight, solid, 2);
                int transparentLight = 255;
                if (needLight) {
                    transparentLight = this.getLight(transparentColor, blockID, world, startX + imageX, startZ + imageY, transparentHeight, solid);
                    this.mapData[this.lastZoom].setTransparentLight(imageX, imageY, transparentLight);
                } else {
                    transparentLight = this.mapData[this.lastZoom].getTransparentLight(imageX, imageY);
                }
                if (transparentLight == 0) {
                    transparentColor = 0;
                } else if (transparentLight != 255) {
                    transparentColor = this.colorManager.colorMultiplier(transparentColor, transparentLight);
                }
                color24 = this.colorManager.colorAdder(transparentColor, color24);
            }
        }
        if (this.biomeOverlay == 2) {
            int bc = agg.n()[biomeID].ag;
            int red1 = bc >> 16 & 0xFF;
            int green1 = bc >> 8 & 0xFF;
            int blue1 = bc >> 0 & 0xFF;
            bc = 0x7F000000 | (red1 & 0xFF) << 16 | (green1 & 0xFF) << 8 | blue1 & 0xFF;
            color24 = this.colorManager.colorAdder(bc, color24);
        }
        if (this.chunkGrid && ((startX + imageX) % 16 == 0 || (startZ + imageY) % 16 == 0)) {
            color24 = this.colorManager.colorAdder(0x7D000000, color24);
        }
        return color24;
    }

    private int getBiomeTint(int id, int metadata, int x, int y2, int z) {
        int tint;
        block7: {
            tint = -1;
            if (this.colorManager.optifuck) {
                try {
                    Integer[] tints = this.colorManager.blockTintTables.get(this.colorManager.blockColorID(id, metadata));
                    if (tints != null) {
                        int r = 0;
                        int g = 0;
                        int b = 0;
                        for (int t = -1; t <= 1; ++t) {
                            for (int s = -1; s <= 1; ++s) {
                                int biomeTint = tints[this.world.a((int)(x + s), (int)(z + t)).ay];
                                r += (biomeTint & 0xFF0000) >> 16;
                                g += (biomeTint & 0xFF00) >> 8;
                                b += biomeTint & 0xFF;
                            }
                        }
                        tint = 0xFF000000 | (r / 9 & 0xFF) << 16 | (g / 9 & 0xFF) << 8 | b / 9 & 0xFF;
                        break block7;
                    }
                    tint = this.getBuiltInBiomeTint(id, metadata, x, y2, z);
                }
                catch (Exception e) {
                    tint = this.getBuiltInBiomeTint(id, metadata, x, y2, z);
                }
            } else {
                tint = this.getBuiltInBiomeTint(id, metadata, x, y2, z);
            }
        }
        return tint;
    }

    private int getBuiltInBiomeTint(int id, int metadata, int x, int y2, int z) {
        int tint = -1;
        if (id == 2 || id == 8 || id == 9 || id == 18 || id == 31 || id == 106 || this.colorManager.biomeTintsAvailable.contains(id)) {
            tint = ((ahu)ahu.c.a(id)).d((afx)this.world, x, y2, z) | 0xFF000000;
        }
        return tint;
    }

    private final int getBlockHeight(boolean nether, boolean netherPlayerInOpen, boolean caves, afn world, int x, int z, int starty) {
        int height = world.f(x, z);
        boolean blockID = false;
        if (!nether && !caves || height < starty || nether && starty > 125 && (!this.showCaves || netherPlayerInOpen)) {
            ahu block;
            int transHeight = world.h(x, z);
            if (transHeight != height && (block = world.a(x, transHeight - 1, z)).o() == avf.i) {
                height = transHeight;
            }
            for (int heightCheck = ((height >> 4) + 1) * 16 - 1; heightCheck < 256; heightCheck += 16) {
                ahu block2 = world.a(x, heightCheck, z);
                if (block2.k() <= 0) continue;
                height = heightCheck + 1;
            }
            return height;
        }
        int y2 = this.lastY;
        ahu block = world.a(x, y2, z);
        if (block.k() == 0 && block.o() != avf.i) {
            while (y2 > 0) {
                if ((block = world.a(x, --y2, z)).k() <= 0 && block.o() != avf.i) continue;
                return y2 + 1;
            }
            return y2;
        }
        while (y2 <= starty + 10 && y2 < (nether && starty < 126 ? 127 : 255)) {
            if ((block = world.a(x, ++y2, z)).k() != 0 || block.o() == avf.i) continue;
            return y2;
        }
        return -1;
    }

    private final int getSeafloorHeight(afn world, int x, int z, int height) {
        int seafloorHeight = height;
        ahu block = world.a(x, seafloorHeight - 1, z);
        while (block.k() < 5 && block.o() != avf.j && seafloorHeight > 1) {
            block = world.a(x, --seafloorHeight - 1, z);
        }
        return seafloorHeight;
    }

    private final int getTransparentHeight(boolean nether, boolean netherPlayerInOpen, boolean caves, afn world, int x, int z, int height) {
        avf material;
        int transHeight = world.h(x, z);
        if (transHeight == height) {
            transHeight = height + 1;
        }
        if ((caves || nether) && (!nether || height <= 125 || this.showCaves && !netherPlayerInOpen)) {
            transHeight = height + 1;
        }
        if ((material = world.a(x, transHeight - 1, z).o()) == avf.y || material == avf.a || material == avf.i) {
            transHeight = -1;
        }
        return transHeight;
    }

    private int applyHeight(int color24, boolean nether, boolean netherPlayerInOpen, boolean caves, afn world, int multi, int startX, int startZ, int imageX, int imageY, int height, boolean solid, int layer) {
        if (color24 != this.colorManager.blockColors[0] && color24 != 0) {
            int heightComp = 0;
            if ((this.heightmap || this.slopemap) && !solid) {
                int diff = 0;
                double sc = 0.0;
                if (this.slopemap) {
                    if ((this.oldNorth && imageX < 32 * multi - 1 || !this.oldNorth && imageX > 0) && imageY < 32 * multi - 1) {
                        ahu block;
                        if (layer == 0) {
                            heightComp = this.mapData[this.lastZoom].getOceanFloorHeight(imageX - (this.oldNorth ? -1 : 1), imageY + 1);
                        }
                        if (layer == 1) {
                            heightComp = this.mapData[this.lastZoom].getHeight(imageX - (this.oldNorth ? -1 : 1), imageY + 1);
                        }
                        if (layer == 2 && (heightComp = this.mapData[this.lastZoom].getTransparentHeight(imageX - (this.oldNorth ? -1 : 1), imageY + 1)) == -1 && ((block = ahu.e((int)this.mapData[this.lastZoom].getTransparentId(imageX, imageY))) instanceof ajr || block instanceof amc)) {
                            heightComp = this.mapData[this.lastZoom].getHeight(imageX - (this.oldNorth ? -1 : 1), imageY + 1);
                        }
                    } else {
                        ahu block;
                        int baseHeight;
                        if (layer == 0) {
                            baseHeight = this.getBlockHeight(nether, netherPlayerInOpen, caves, world, startX + imageX - (this.oldNorth ? -1 : 1), startZ + imageY + 1, this.lastY);
                            heightComp = this.getSeafloorHeight(world, startX + imageX - (this.oldNorth ? -1 : 1), startZ + imageY + 1, baseHeight);
                        }
                        if (layer == 1) {
                            heightComp = this.getBlockHeight(nether, netherPlayerInOpen, caves, world, startX + imageX - (this.oldNorth ? -1 : 1), startZ + imageY + 1, this.lastY);
                        }
                        if (layer == 2 && (heightComp = this.getTransparentHeight(nether, netherPlayerInOpen, caves, world, startX + imageX - (this.oldNorth ? -1 : 1), startZ + imageY + 1, baseHeight = this.getBlockHeight(nether, netherPlayerInOpen, caves, world, startX + imageX - (this.oldNorth ? -1 : 1), startZ + imageY + 1, this.lastY))) == -1 && ((block = world.a(startX + imageX, height - 1, startZ + imageY)) instanceof ajr || block instanceof amc)) {
                            heightComp = baseHeight;
                        }
                    }
                    if (heightComp == -1) {
                        heightComp = height;
                    }
                    if ((diff = heightComp - height) != 0) {
                        sc = diff > 0 ? 1.0 : (diff < 0 ? -1.0 : 0.0);
                        sc /= 8.0;
                    }
                    if (this.heightmap) {
                        diff = height - this.lastY;
                        double heightsc = Math.log10((double)Math.abs(diff) / 8.0 + 1.0) / 3.0;
                        sc = diff > 0 ? sc + heightsc : sc - heightsc;
                    }
                } else if (this.heightmap) {
                    diff = height - this.lastY;
                    sc = Math.log10((double)Math.abs(diff) / 8.0 + 1.0) / 1.8;
                    if (diff < 0) {
                        sc = 0.0 - sc;
                    }
                }
                int alpha = color24 >> 24 & 0xFF;
                int r = color24 >> 16 & 0xFF;
                int g = color24 >> 8 & 0xFF;
                int b = color24 >> 0 & 0xFF;
                if (sc > 0.0) {
                    r = (int)(sc * (double)(255 - r)) + r;
                    g = (int)(sc * (double)(255 - g)) + g;
                    b = (int)(sc * (double)(255 - b)) + b;
                } else if (sc < 0.0) {
                    sc = Math.abs(sc);
                    r -= (int)(sc * (double)r);
                    g -= (int)(sc * (double)g);
                    b -= (int)(sc * (double)b);
                }
                color24 = alpha * 0x1000000 + r * 65536 + g * 256 + b;
            }
        }
        return color24;
    }

    private int getLight(int color24, int blockID, afn world, int x, int z, int height, boolean solid) {
        int i3 = 255;
        if (solid) {
            i3 = 0;
        } else if (color24 != this.colorManager.blockColors[0] && color24 != 0 && this.lightmap) {
            aoj chunk = world.d(x, z);
            int blockLight = chunk.a(afz.b, x & 0xF, Math.max(Math.min(height, 255), 0), z & 0xF);
            int skyLight = chunk.a(afz.a, x & 0xF, Math.max(Math.min(height, 255), 0), z & 0xF);
            if (blockID == 11 && blockLight < 14) {
                blockLight = 14;
            }
            i3 = this.lightmapColors[blockLight + skyLight * 16];
        }
        return i3;
    }

    public void loadAll() {
        this.settingsFile = new File(this.game.w, "mods/VoxelMods/voxelmap.properties");
        try {
            if (this.settingsFile.exists()) {
                String sCurrentLine;
                BufferedReader in = new BufferedReader(new FileReader(this.settingsFile));
                while ((sCurrentLine = in.readLine()) != null) {
                    String[] curLine = sCurrentLine.split(":");
                    if (curLine[0].equals("Zoom Level")) {
                        this.zoom = Integer.parseInt(curLine[1]);
                    } else if (curLine[0].equals("Hide Minimap")) {
                        this.hide = Boolean.parseBoolean(curLine[1]);
                    } else if (curLine[0].equals("Show Coordinates")) {
                        this.coords = Boolean.parseBoolean(curLine[1]);
                    } else if (curLine[0].equals("Show Map in Nether")) {
                        this.showNether = Boolean.parseBoolean(curLine[1]);
                    } else if (curLine[0].equals("Enable Cave Mode")) {
                        this.showCaves = Boolean.parseBoolean(curLine[1]);
                    } else if (curLine[0].equals("Dynamic Lighting")) {
                        this.lightmap = Boolean.parseBoolean(curLine[1]);
                    } else if (curLine[0].equals("Height Map")) {
                        this.heightmap = Boolean.parseBoolean(curLine[1]);
                    } else if (curLine[0].equals("Slope Map")) {
                        this.slopemap = Boolean.parseBoolean(curLine[1]);
                    } else if (curLine[0].equals("Filtering")) {
                        this.filtering = Boolean.parseBoolean(curLine[1]);
                    } else if (curLine[0].equals("Water Transparency")) {
                        this.waterTransparency = Boolean.parseBoolean(curLine[1]);
                    } else if (curLine[0].equals("Block Transparency")) {
                        this.blockTransparency = Boolean.parseBoolean(curLine[1]);
                    } else if (curLine[0].equals("Biomes")) {
                        this.biomes = Boolean.parseBoolean(curLine[1]);
                    } else if (curLine[0].equals("Biome Overlay")) {
                        this.biomeOverlay = Integer.parseInt(curLine[1]);
                    } else if (curLine[0].equals("Chunk Grid")) {
                        this.chunkGrid = Boolean.parseBoolean(curLine[1]);
                    } else if (curLine[0].equals("Square Map")) {
                        this.squareMap = Boolean.parseBoolean(curLine[1]);
                    } else if (curLine[0].equals("Old North")) {
                        this.oldNorth = Boolean.parseBoolean(curLine[1]);
                    } else if (curLine[0].equals("Waypoint Beacons")) {
                        this.showBeacons = Boolean.parseBoolean(curLine[1]);
                    } else if (curLine[0].equals("Waypoint Signs")) {
                        this.showWaypoints = Boolean.parseBoolean(curLine[1]);
                    } else if (curLine[0].equals("Deathpoints")) {
                        this.deathpoints = Integer.parseInt(curLine[1]);
                    } else if (curLine[0].equals("Waypoint Max Distance")) {
                        this.maxWaypointDisplayDistance = Integer.parseInt(curLine[1]);
                    } else if (curLine[0].equals("Welcome Message")) {
                        this.welcome = Boolean.parseBoolean(curLine[1]);
                    } else if (curLine[0].equals("World Download Compatibility")) {
                        this.dlSafe = Boolean.parseBoolean(curLine[1]);
                    } else if (curLine[0].equals("Real Time Torch Flicker")) {
                        this.realTimeTorches = Boolean.parseBoolean(curLine[1]);
                    } else if (curLine[0].equals("Map Corner")) {
                        this.mapCorner = Integer.parseInt(curLine[1]);
                    } else if (curLine[0].equals("Map Size")) {
                        this.sizeModifier = Integer.parseInt(curLine[1]);
                    } else if (curLine[0].equals("Zoom Key")) {
                        this.keyBindZoom.b(Keyboard.getKeyIndex((String)curLine[1]));
                    } else if (curLine[0].equals("Fullscreen Key")) {
                        this.keyBindFullscreen.b(Keyboard.getKeyIndex((String)curLine[1]));
                    } else if (curLine[0].equals("Menu Key")) {
                        this.keyBindMenu.b(Keyboard.getKeyIndex((String)curLine[1]));
                    } else if (curLine[0].equals("Waypoint Key")) {
                        this.keyBindWaypoint.b(Keyboard.getKeyIndex((String)curLine[1]));
                    } else if (curLine[0].equals("Mob Key")) {
                        this.keyBindMobToggle.b(Keyboard.getKeyIndex((String)curLine[1]));
                    }
                    aza.b();
                }
                if (this.radar != null) {
                    this.radar.loadSettings(this.settingsFile);
                }
                in.close();
            }
            this.doFullRender = true;
            this.saveAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveAll() {
        File settingsFileDir = new File(this.game.w, "/mods/VoxelMods/");
        if (!settingsFileDir.exists()) {
            settingsFileDir.mkdirs();
        }
        this.settingsFile = new File(settingsFileDir, "voxelmap.properties");
        try {
            PrintWriter out = new PrintWriter(new FileWriter(this.settingsFile));
            out.println("Zoom Level:" + Integer.toString(this.zoom));
            out.println("Hide Minimap:" + Boolean.toString(this.hide));
            out.println("Show Coordinates:" + Boolean.toString(this.coords));
            out.println("Show Map in Nether:" + Boolean.toString(this.showNether));
            out.println("Enable Cave Mode:" + Boolean.toString(this.showCaves));
            out.println("Dynamic Lighting:" + Boolean.toString(this.lightmap));
            out.println("Height Map:" + Boolean.toString(this.heightmap));
            out.println("Slope Map:" + Boolean.toString(this.slopemap));
            out.println("Filtering:" + Boolean.toString(this.filtering));
            out.println("Water Transparency:" + Boolean.toString(this.waterTransparency));
            out.println("Block Transparency:" + Boolean.toString(this.blockTransparency));
            out.println("Biomes:" + Boolean.toString(this.biomes));
            out.println("Biome Overlay:" + Integer.toString(this.biomeOverlay));
            out.println("Chunk Grid:" + Boolean.toString(this.chunkGrid));
            out.println("Square Map:" + Boolean.toString(this.squareMap));
            out.println("Old North:" + Boolean.toString(this.oldNorth));
            out.println("Waypoint Beacons:" + Boolean.toString(this.showBeacons));
            out.println("Waypoint Signs:" + Boolean.toString(this.showWaypoints));
            out.println("Deathpoints:" + Integer.toString(this.deathpoints));
            out.println("Waypoint Max Distance:" + Integer.toString(this.maxWaypointDisplayDistance));
            out.println("Welcome Message:" + Boolean.toString(this.welcome));
            out.println("Map Corner:" + Integer.toString(this.mapCorner));
            out.println("Map Size:" + Integer.toString(this.sizeModifier));
            out.println("Zoom Key:" + VoxelMap.getKeyDisplayString(this.keyBindZoom.i()));
            out.println("Fullscreen Key:" + VoxelMap.getKeyDisplayString(this.keyBindFullscreen.i()));
            out.println("Menu Key:" + VoxelMap.getKeyDisplayString(this.keyBindMenu.i()));
            out.println("Waypoint Key:" + VoxelMap.getKeyDisplayString(this.keyBindWaypoint.i()));
            out.println("Mob Key:" + VoxelMap.getKeyDisplayString(this.keyBindMobToggle.i()));
            if (this.radar != null) {
                this.radar.saveAll(out);
            }
            out.close();
        }
        catch (Exception local) {
            this.chatInfo("\u00a7EError Saving Settings " + local.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderMap(int x, int y2, int scScale) {
        boolean scaleChanged = this.scScale != scScale || this.squareMap != this.lastSquareMap;
        this.scScale = scScale;
        this.lastSquareMap = this.squareMap;
        if (GLUtils.fboEnabled) {
            GL11.glBindTexture((int)3553, (int)0);
            GL11.glPushAttrib((int)22528);
            GL11.glViewport((int)0, (int)0, (int)256, (int)256);
            GL11.glMatrixMode((int)5889);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            GL11.glOrtho((double)0.0, (double)256.0, (double)256.0, (double)0.0, (double)1000.0, (double)3000.0);
            GL11.glMatrixMode((int)5888);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
            this.game.a().e();
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)GLUtils.fboID);
            GL11.glDepthMask((boolean)false);
            GL11.glDisable((int)2929);
            if (scaleChanged) {
                GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                GL11.glClear((int)16384);
            }
            GL11.glBlendFunc((int)770, (int)0);
            GLUtils.img(new bqo("voxelmap", this.squareMap ? "images/square.png" : "images/circle.png"));
            GLUtils.drawPre();
            GLUtils.ldrawthree(0.0, 256.0, 1.0, 0.0, 0.0);
            GLUtils.ldrawthree(256.0, 256.0, 1.0, 1.0, 0.0);
            GLUtils.ldrawthree(256.0, 0.0, 1.0, 1.0, 1.0);
            GLUtils.ldrawthree(0.0, 0.0, 1.0, 0.0, 1.0);
            GLUtils.drawPost();
            GL14.glBlendFuncSeparate((int)1, (int)0, (int)774, (int)0);
            if (this.imageChanged) {
                this.map[this.lastZoom].write();
                this.imageChanged = false;
            }
            if (this.zoom == 3) {
                GL11.glPushMatrix();
                GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
                GLUtils.disp(this.map[this.lastZoom].index);
                GL11.glPopMatrix();
            } else {
                GLUtils.disp(this.map[this.lastZoom].index);
            }
            if (this.filtering) {
                GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
                GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            }
            GL11.glTranslatef((float)128.0f, (float)128.0f, (float)0.0f);
            if (this.squareMap) {
                GL11.glRotatef((float)(-this.northRotate), (float)0.0f, (float)0.0f, (float)1.0f);
            } else {
                GL11.glRotatef((float)(this.direction - (float)this.northRotate), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            GL11.glTranslatef((float)-128.0f, (float)-128.0f, (float)0.0f);
            GL11.glTranslatef((float)(-this.percentX * 4.0f), (float)(this.percentY * 4.0f), (float)0.0f);
            GLUtils.drawPre();
            GLUtils.ldrawthree(0.0, 256.0, 1.0, 0.0, 0.0);
            GLUtils.ldrawthree(256.0, 256.0, 1.0, 1.0, 0.0);
            GLUtils.ldrawthree(256.0, 0.0, 1.0, 1.0, 1.0);
            GLUtils.ldrawthree(0.0, 0.0, 1.0, 0.0, 1.0);
            GLUtils.drawPost();
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)2929);
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
            this.game.a().a(true);
            GL11.glMatrixMode((int)5889);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
            GL11.glPopMatrix();
            GL11.glPopAttrib();
            GL11.glPushMatrix();
            GL11.glBlendFunc((int)770, (int)0);
            GLUtils.disp(GLUtils.fboTextureID);
        } else {
            if (this.squareMap) {
                if (this.filtering && this.lastZoom == 0 && this.lastPercentXOver != this.percentX > 1.0f) {
                    this.lastPercentXOver = this.percentX > 1.0f;
                    this.imageChanged = true;
                }
                if (this.filtering && this.lastZoom == 0 && this.lastPercentYOver != this.percentY > 1.0f) {
                    this.lastPercentYOver = this.percentY > 1.0f;
                    this.imageChanged = true;
                }
            }
            if (this.imageChanged) {
                if (this.squareMap) {
                    this.map[this.lastZoom].write();
                } else {
                    int diameter = this.map[this.lastZoom].getWidth();
                    if (this.roundImage != null) {
                        this.roundImage.baleet();
                    }
                    this.roundImage = new GLBufferedImage(diameter, diameter, 6);
                    Ellipse2D.Double ellipse = new Ellipse2D.Double(this.lastZoom * 10 / 6, this.lastZoom * 10 / 6, diameter - this.lastZoom * 2, diameter - this.lastZoom * 2);
                    Graphics2D gfx = this.roundImage.createGraphics();
                    gfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    gfx.setClip(ellipse);
                    gfx.setColor(new Color(0.1f, 0.0f, 0.0f, 0.1f));
                    gfx.fillRect(0, 0, diameter, diameter);
                    gfx.drawImage((Image)this.map[this.zoom], 0, 0, null);
                    gfx.dispose();
                    this.roundImage.write();
                }
                this.imageChanged = false;
            }
            GL11.glBlendFunc((int)770, (int)0);
            if (this.zoom == 3) {
                GL11.glPushMatrix();
                GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
                GLUtils.disp(this.squareMap ? this.map[this.lastZoom].index : this.roundImage.index);
                GL11.glPopMatrix();
            } else {
                GLUtils.disp(this.squareMap ? this.map[this.lastZoom].index : this.roundImage.index);
            }
            if (this.filtering) {
                GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
                GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)x, (float)y2, (float)0.0f);
            GL11.glRotatef((float)(this.squareMap ? (float)this.northRotate : -this.direction + (float)this.northRotate), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)(-x), (float)(-y2), (float)0.0f);
            GL11.glTranslatef((float)(-this.percentX), (float)(-this.percentY), (float)0.0f);
        }
        GLUtils.drawPre();
        GLUtils.setMap(x, y2);
        GLUtils.drawPost();
        GL11.glPopMatrix();
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.squareMap) {
            this.drawSquare(x, y2);
        } else {
            this.drawRound(x, y2);
        }
        for (Waypoint pt : this.waypointManager.wayPts) {
            if (!pt.isActive()) continue;
            double wayX = this.lastXDouble - (double)pt.getX() + (this.lastXDouble > 0.0 ? -0.5 : 0.5);
            double wayY = this.lastZDouble - (double)pt.getZ() + (this.lastZDouble > 0.0 ? -0.5 : 0.5);
            float locate = (float)Math.toDegrees(Math.atan2(wayX, wayY));
            double hypot = Math.sqrt(wayX * wayX + wayY * wayY);
            boolean far = false;
            if (this.squareMap) {
                boolean bl = far = Math.abs(wayX) / (Math.pow(2.0, this.zoom) / 2.0) > 28.5 || Math.abs(wayY) / (Math.pow(2.0, this.zoom) / 2.0) > 28.5;
                hypot = far ? hypot / Math.max(Math.abs(wayX), Math.abs(wayY)) * 30.0 : (hypot /= Math.pow(2.0, this.zoom) / 2.0);
            } else {
                locate += this.direction;
                boolean bl = far = (hypot /= Math.pow(2.0, this.zoom) / 2.0) >= 31.0;
                if (far) {
                    hypot = 34.0;
                }
            }
            if (far) {
                try {
                    GL11.glPushMatrix();
                    GL11.glColor3f((float)pt.red, (float)pt.green, (float)pt.blue);
                    if (scScale >= 3) {
                        GLUtils.img(new bqo("voxelmap", "images/marker" + pt.imageSuffix + ".png"));
                    } else {
                        GLUtils.img(new bqo("voxelmap", "images/marker" + pt.imageSuffix + "Small.png"));
                    }
                    GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
                    GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                    GL11.glTranslatef((float)x, (float)y2, (float)0.0f);
                    GL11.glRotatef((float)(-locate + (float)this.northRotate), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)(-x), (float)(-y2), (float)0.0f);
                    GL11.glTranslated((double)0.0, (double)(-hypot), (double)0.0);
                    GLUtils.drawPre();
                    GLUtils.setMap(x, y2, 16);
                    GLUtils.drawPost();
                    continue;
                }
                catch (Exception localException) {
                    this.error = "Error: marker overlay not found!";
                    continue;
                }
                finally {
                    GL11.glPopMatrix();
                    continue;
                }
            }
            try {
                GL11.glPushMatrix();
                GL11.glColor3f((float)pt.red, (float)pt.green, (float)pt.blue);
                if (scScale >= 3) {
                    GLUtils.img(new bqo("voxelmap", "images/waypoint" + pt.imageSuffix + ".png"));
                } else {
                    GLUtils.img(new bqo("voxelmap", "images/waypoint" + pt.imageSuffix + "Small.png"));
                }
                GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
                GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                GL11.glRotatef((float)(-locate + (float)this.northRotate), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslated((double)0.0, (double)(-hypot), (double)0.0);
                GL11.glRotatef((float)(-(-locate + (float)this.northRotate)), (float)0.0f, (float)0.0f, (float)1.0f);
                GLUtils.drawPre();
                GLUtils.setMap(x, y2, 16);
                GLUtils.drawPost();
            }
            catch (Exception localException) {
                this.error = "Error: waypoint overlay not found!";
            }
            finally {
                GL11.glPopMatrix();
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawArrow(int x, int y2) {
        try {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glPushMatrix();
            GLUtils.img(new bqo("voxelmap", "images/mmarrow.png"));
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTranslatef((float)x, (float)y2, (float)0.0f);
            GL11.glRotatef((float)this.direction, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)(-x), (float)(-y2), (float)0.0f);
            GLUtils.drawPre();
            GLUtils.setMap(x, y2, 16);
            GLUtils.drawPost();
        }
        catch (Exception localException) {
            this.error = "Error: minimap arrow not found!";
        }
        finally {
            GL11.glPopMatrix();
        }
    }

    private void renderMapFull(int scWidth, int scHeight) {
        if (this.imageChanged) {
            this.map[this.lastZoom].write();
            this.imageChanged = false;
        }
        GLUtils.disp(this.map[this.lastZoom].index);
        if (this.filtering) {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)scWidth / 2.0f), (float)((float)scHeight / 2.0f), (float)0.0f);
        GL11.glRotatef((float)this.northRotate, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)(-((float)scWidth / 2.0f)), (float)(-((float)scHeight / 2.0f)), (float)0.0f);
        GLUtils.drawPre();
        GLUtils.ldrawone(scWidth / 2 - 128, scHeight / 2 + 128, 20.0, 0.0, 1.0);
        GLUtils.ldrawone(scWidth / 2 + 128, scHeight / 2 + 128, 20.0, 1.0, 1.0);
        GLUtils.ldrawone(scWidth / 2 + 128, scHeight / 2 - 128, 20.0, 1.0, 0.0);
        GLUtils.ldrawone(scWidth / 2 - 128, scHeight / 2 - 128, 20.0, 0.0, 0.0);
        GLUtils.drawPost();
        GL11.glPopMatrix();
    }

    private void drawSquare(int x, int y2) {
        try {
            GLUtils.disp(this.colorManager.mapImageInt);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
            GLUtils.drawPre();
            GLUtils.setMap(x, y2);
            GLUtils.drawPost();
        }
        catch (Exception localException) {
            this.error = "error: minimap overlay not found!";
        }
    }

    private void drawRound(int x, int y2) {
        try {
            GLUtils.img(new bqo("voxelmap", "images/roundmap.png"));
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GLUtils.drawPre();
            GLUtils.setMap(x, y2);
            GLUtils.drawPost();
        }
        catch (Exception localException) {
            this.error = "Error: minimap overlay not found!";
        }
    }

    private void drawBox(double leftX, double rightX, double topY, double botY) {
        GLUtils.drawPre();
        GLUtils.ldrawtwo(leftX, botY, 0.0);
        GLUtils.ldrawtwo(rightX, botY, 0.0);
        GLUtils.ldrawtwo(rightX, topY, 0.0);
        GLUtils.ldrawtwo(leftX, topY, 0.0);
        GLUtils.drawPost();
    }

    public int getMouseX(int scWidth) {
        return Mouse.getX() * (scWidth + 5) / this.game.d;
    }

    public int getMouseY(int scHeight) {
        return scHeight + 5 - Mouse.getY() * (scHeight + 5) / this.game.e - 1;
    }

    private void drawDirections(int x, int y2) {
        float distance;
        float rotate;
        if (this.squareMap) {
            rotate = -90.0f;
            distance = 67.0f;
        } else {
            rotate = -this.direction - 90.0f;
            distance = 64.0f;
        }
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
        GL11.glTranslated((double)((double)distance * Math.sin(Math.toRadians(-((double)rotate - 90.0)))), (double)((double)distance * Math.cos(Math.toRadians(-((double)rotate - 90.0)))), (double)0.0);
        this.write("N", x * 2 - 2, y2 * 2 - 4, 0xFFFFFF);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
        GL11.glTranslated((double)((double)distance * Math.sin(Math.toRadians(-rotate))), (double)((double)distance * Math.cos(Math.toRadians(-rotate))), (double)0.0);
        this.write("E", x * 2 - 2, y2 * 2 - 4, 0xFFFFFF);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
        GL11.glTranslated((double)((double)distance * Math.sin(Math.toRadians(-((double)rotate + 90.0)))), (double)((double)distance * Math.cos(Math.toRadians(-((double)rotate + 90.0)))), (double)0.0);
        this.write("S", x * 2 - 2, y2 * 2 - 4, 0xFFFFFF);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
        GL11.glTranslated((double)((double)distance * Math.sin(Math.toRadians(-((double)rotate + 180.0)))), (double)((double)distance * Math.cos(Math.toRadians(-((double)rotate + 180.0)))), (double)0.0);
        this.write("W", x * 2 - 2, y2 * 2 - 4, 0xFFFFFF);
        GL11.glPopMatrix();
    }

    private void showCoords(int x, int y2) {
        int textStart = y2 > this.scHeight - 37 - 32 - 4 - 15 ? y2 - 32 - 4 - 9 : y2 + 32 + 4;
        if (!this.hide && !this.fullscreenMap) {
            GL11.glPushMatrix();
            GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
            String xy = "";
            xy = this.dCoord(this.xCoord()) + ", " + this.dCoord(this.zCoord());
            int m = this.chkLen(xy) / 2;
            this.write(xy, x * 2 - m, textStart * 2, 0xFFFFFF);
            xy = Integer.toString(this.yCoord());
            m = this.chkLen(xy) / 2;
            this.write(xy, x * 2 - m, textStart * 2 + 10, 0xFFFFFF);
            if (this.ztimer > 0) {
                m = this.chkLen(this.error) / 2;
                this.write(this.error, x * 2 - m, textStart * 2 + 19, 0xFFFFFF);
            }
            GL11.glPopMatrix();
        } else {
            String stats = "";
            stats = "(" + this.dCoord(this.xCoord()) + ", " + this.yCoord() + ", " + this.dCoord(this.zCoord()) + ") " + (int)this.direction + "'";
            int m = this.chkLen(stats) / 2;
            this.write(stats, this.scWidth / 2 - m, 5, 0xFFFFFF);
            if (this.ztimer > 0) {
                m = this.chkLen(this.error) / 2;
                this.write(this.error, this.scWidth / 2 - m, 15, 0xFFFFFF);
            }
        }
    }

    private String dCoord(int paramInt1) {
        if (paramInt1 < 0) {
            return "-" + Math.abs(paramInt1);
        }
        if (paramInt1 > 0) {
            return "+" + paramInt1;
        }
        return " " + paramInt1;
    }

    private int chkLen(String paramStr) {
        return this.fontRenderer.a(paramStr);
    }

    private void write(String paramStr, int paramInt1, int paramInt2, int paramInt3) {
        this.fontRenderer.a(paramStr, paramInt1, paramInt2, paramInt3);
    }

    public void setMenuNull() {
        this.game.n = null;
    }

    public Object getMenu() {
        return this.game.n;
    }

    private void showMenu(int scWidth, int scHeight) {
        int height;
        GL11.glBlendFunc((int)770, (int)771);
        int maxSize = 0;
        int border = 2;
        String head = this.sMenu[0];
        for (height = 1; height < this.sMenu.length - 1; ++height) {
            if (this.chkLen(this.sMenu[height]) <= maxSize) continue;
            maxSize = this.chkLen(this.sMenu[height]);
        }
        int title = this.chkLen(head);
        int centerX = (int)((double)(scWidth + 5) / 2.0);
        int centerY = (int)((double)(scHeight + 5) / 2.0);
        String hide = this.sMenu[this.sMenu.length - 1];
        int footer = this.chkLen(hide);
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7f);
        double leftX = (double)centerX - (double)title / 2.0 - (double)border;
        double rightX = (double)centerX + (double)title / 2.0 + (double)border;
        double topY = (double)centerY - (double)(height - 1) / 2.0 * 10.0 - (double)border - 20.0;
        double botY = (double)centerY - (double)(height - 1) / 2.0 * 10.0 + (double)border - 10.0;
        this.drawBox(leftX, rightX, topY, botY);
        leftX = (double)centerX - (double)maxSize / 2.0 - (double)border;
        rightX = (double)centerX + (double)maxSize / 2.0 + (double)border;
        topY = (double)centerY - (double)(height - 1) / 2.0 * 10.0 - (double)border;
        botY = (double)centerY + (double)(height - 1) / 2.0 * 10.0 + (double)border;
        this.drawBox(leftX, rightX, topY, botY);
        leftX = (double)centerX - (double)footer / 2.0 - (double)border;
        rightX = (double)centerX + (double)footer / 2.0 + (double)border;
        topY = (double)centerY + (double)(height - 1) / 2.0 * 10.0 - (double)border + 10.0;
        botY = (double)centerY + (double)(height - 1) / 2.0 * 10.0 + (double)border + 20.0;
        this.drawBox(leftX, rightX, topY, botY);
        GL11.glEnable((int)3553);
        this.write(head, centerX - title / 2, centerY - (height - 1) * 10 / 2 - 19, 0xFFFFFF);
        for (int n = 1; n < height; ++n) {
            this.write(this.sMenu[n], centerX - maxSize / 2, centerY - (height - 1) * 10 / 2 + n * 10 - 9, 0xFFFFFF);
        }
        this.write(hide, centerX - footer / 2, (scHeight + 5) / 2 + (height - 1) * 10 / 2 + 11, 0xFFFFFF);
    }

    public String getKeyText(EnumOptionsMinimap par1EnumOptions) {
        String s = TranslateUtils.getString(par1EnumOptions.getEnumString()) + ": ";
        if (par1EnumOptions.getEnumFloat()) {
            float f = this.getOptionFloatValue(par1EnumOptions);
            if (par1EnumOptions == EnumOptionsMinimap.ZOOM) {
                return s + (int)f;
            }
            if (par1EnumOptions == EnumOptionsMinimap.WAYPOINTDISTANCE) {
                if (f < 0.0f) {
                    return s + TranslateUtils.getString("options.minimap.waypoints.infinite");
                }
                return s + (int)f;
            }
            if (f == 0.0f) {
                return s + TranslateUtils.getString("options.off");
            }
            return s + (int)f + "%";
        }
        if (par1EnumOptions.getEnumBoolean()) {
            boolean flag = this.getOptionBooleanValue(par1EnumOptions);
            if (flag) {
                return s + TranslateUtils.getString("options.on");
            }
            return s + TranslateUtils.getString("options.off");
        }
        if (par1EnumOptions.getEnumList()) {
            String state = this.getOptionListValue(par1EnumOptions);
            return s + state;
        }
        return s;
    }

    public float getOptionFloatValue(EnumOptionsMinimap par1EnumOptions) {
        if (par1EnumOptions == EnumOptionsMinimap.ZOOM) {
            return this.lastZoom;
        }
        if (par1EnumOptions == EnumOptionsMinimap.WAYPOINTDISTANCE) {
            return this.maxWaypointDisplayDistance;
        }
        return 0.0f;
    }

    public boolean getOptionBooleanValue(EnumOptionsMinimap par1EnumOptions) {
        switch (par1EnumOptions) {
            case COORDS: {
                return this.coords;
            }
            case HIDE: {
                return this.hide;
            }
            case SHOWNETHER: {
                return this.showNether;
            }
            case CAVEMODE: {
                return this.cavesAllowed != false && this.showCaves;
            }
            case LIGHTING: {
                return this.lightmap;
            }
            case SQUARE: {
                return this.squareMap;
            }
            case OLDNORTH: {
                return this.oldNorth;
            }
            case WELCOME: {
                return this.welcome;
            }
            case THREADING: {
                return this.threading;
            }
            case FILTERING: {
                return this.filtering;
            }
            case WATERTRANSPARENCY: {
                return this.waterTransparency;
            }
            case BLOCKTRANSPARENCY: {
                return this.blockTransparency;
            }
            case BIOMES: {
                return this.biomes;
            }
            case CHUNKGRID: {
                return this.chunkGrid;
            }
        }
        return false;
    }

    public String getOptionListValue(EnumOptionsMinimap par1EnumOptions) {
        if (par1EnumOptions == EnumOptionsMinimap.TERRAIN) {
            if (this.slopemap && this.heightmap) {
                return TranslateUtils.getString("options.minimap.terrain.both");
            }
            if (this.heightmap) {
                return TranslateUtils.getString("options.minimap.terrain.height");
            }
            if (this.slopemap) {
                return TranslateUtils.getString("options.minimap.terrain.slope");
            }
            return TranslateUtils.getString("options.off");
        }
        if (par1EnumOptions == EnumOptionsMinimap.BEACONS) {
            if (this.showBeacons && this.showWaypoints) {
                return TranslateUtils.getString("options.minimap.ingamewaypoints.both");
            }
            if (this.showBeacons) {
                return TranslateUtils.getString("options.minimap.ingamewaypoints.beacons");
            }
            if (this.showWaypoints) {
                return TranslateUtils.getString("options.minimap.ingamewaypoints.signs");
            }
            return TranslateUtils.getString("options.off");
        }
        if (par1EnumOptions == EnumOptionsMinimap.LOCATION) {
            if (this.mapCorner == 0) {
                return TranslateUtils.getString("options.minimap.location.topleft");
            }
            if (this.mapCorner == 1) {
                return TranslateUtils.getString("options.minimap.location.topright");
            }
            if (this.mapCorner == 2) {
                return TranslateUtils.getString("options.minimap.location.bottomright");
            }
            if (this.mapCorner == 3) {
                return TranslateUtils.getString("options.minimap.location.bottomleft");
            }
            return "Error";
        }
        if (par1EnumOptions == EnumOptionsMinimap.SIZE) {
            if (this.sizeModifier == -1) {
                return TranslateUtils.getString("options.minimap.size.small");
            }
            if (this.sizeModifier == 0) {
                return TranslateUtils.getString("options.minimap.size.medium");
            }
            if (this.sizeModifier == 1) {
                return TranslateUtils.getString("options.minimap.size.large");
            }
            return "error";
        }
        if (par1EnumOptions == EnumOptionsMinimap.BIOMEOVERLAY) {
            if (this.biomeOverlay == 0) {
                return TranslateUtils.getString("options.off");
            }
            if (this.biomeOverlay == 1) {
                return TranslateUtils.getString("options.minimap.biomeoverlay.solid");
            }
            if (this.biomeOverlay == 2) {
                return TranslateUtils.getString("options.minimap.biomeoverlay.transparent");
            }
            return "error";
        }
        if (par1EnumOptions == EnumOptionsMinimap.DEATHPOINTS) {
            if (this.deathpoints == 0) {
                return TranslateUtils.getString("options.off");
            }
            if (this.deathpoints == 1) {
                return TranslateUtils.getString("options.minimap.waypoints.deathpoints.mostrecent");
            }
            if (this.deathpoints == 2) {
                return TranslateUtils.getString("options.minimap.waypoints.deathpoints.all");
            }
            return "error";
        }
        return "";
    }

    public void setOptionFloatValue(EnumOptionsMinimap par1EnumOptions, float par2) {
        if (par1EnumOptions == EnumOptionsMinimap.WAYPOINTDISTANCE) {
            float distance = par2 * 9951.0f + 50.0f;
            if (distance > 10000.0f) {
                distance = -1.0f;
            }
            this.maxWaypointDisplayDistance = (int)distance;
        }
    }

    public void setOptionValue(EnumOptionsMinimap par1EnumOptions, int i) {
        switch (par1EnumOptions.ordinal()) {
            case 0: {
                this.coords = !this.coords;
                break;
            }
            case 1: {
                this.hide = !this.hide;
                break;
            }
            case 2: {
                this.showNether = !this.showNether;
                break;
            }
            case 3: {
                this.showCaves = !this.showCaves;
                break;
            }
            case 4: {
                this.lightmap = !this.lightmap;
                break;
            }
            case 5: {
                if (this.slopemap && this.heightmap) {
                    this.slopemap = false;
                    this.heightmap = false;
                    break;
                }
                if (this.slopemap) {
                    this.slopemap = false;
                    this.heightmap = true;
                    break;
                }
                if (this.heightmap) {
                    this.slopemap = true;
                    this.heightmap = true;
                    break;
                }
                this.slopemap = true;
                this.heightmap = false;
                break;
            }
            case 6: {
                this.squareMap = !this.squareMap;
                break;
            }
            case 7: {
                this.oldNorth = !this.oldNorth;
                break;
            }
            case 8: {
                if (this.showBeacons && this.showWaypoints) {
                    this.showBeacons = false;
                    this.showWaypoints = false;
                    break;
                }
                if (this.showBeacons) {
                    this.showBeacons = false;
                    this.showWaypoints = true;
                    break;
                }
                if (this.showWaypoints) {
                    this.showWaypoints = true;
                    this.showBeacons = true;
                    break;
                }
                this.showBeacons = true;
                this.showWaypoints = false;
                break;
            }
            case 9: {
                this.welcome = !this.welcome;
                break;
            }
            case 10: {
                this.threading = !this.threading;
                break;
            }
            case 12: {
                this.mapCorner = this.mapCorner >= 3 ? 0 : this.mapCorner + 1;
                break;
            }
            case 13: {
                this.sizeModifier = this.sizeModifier >= 1 ? -1 : this.sizeModifier + 1;
                break;
            }
            case 14: {
                this.filtering = !this.filtering;
                break;
            }
            case 15: {
                this.waterTransparency = !this.waterTransparency;
                break;
            }
            case 16: {
                this.blockTransparency = !this.blockTransparency;
                break;
            }
            case 17: {
                this.biomes = !this.biomes;
                this.colorManager.loadBiomeColors(this.biomes);
                break;
            }
            case 18: {
                ++this.biomeOverlay;
                if (this.biomeOverlay <= 2) break;
                this.biomeOverlay = 0;
                break;
            }
            case 19: {
                this.chunkGrid = !this.chunkGrid;
                break;
            }
            case 31: {
                ++this.deathpoints;
                if (this.deathpoints <= 2) break;
                this.deathpoints = 0;
            }
        }
        this.doFullRender = true;
    }

    public String getKeyBindingDescription(int par1) {
        if (this.keyBindings[par1].g().equals("key.minimap.voxelmapmenu")) {
            return TranslateUtils.getString("key.minimap.menu");
        }
        return TranslateUtils.getString(this.keyBindings[par1].g());
    }

    public String getOptionDisplayString(int par1) {
        int var2 = this.keyBindings[par1].i();
        return VoxelMap.getKeyDisplayString(var2);
    }

    public static String getKeyDisplayString(int par0) {
        return par0 < 0 ? dc.a((String)"key.mouseButton", (Object[])new Object[]{par0 + 101}) : Keyboard.getKeyName((int)par0);
    }

    public void setKeyBinding(int par1, int par2) {
        this.keyBindings[par1].b(par2);
        this.saveAll();
    }
}

