/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.statuseffecthud;

import bspkrs.client.util.HUDUtils;
import bspkrs.util.BSConfiguration;
import bspkrs.util.CommonUtils;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class StatusEffectHUD {
    public static final String VERSION_NUMBER = "v1.20(1.7.2)";
    protected static float zLevel = -150.0f;
    private static ScaledResolution scaledResolution;
    public static String alignMode;
    public static boolean enableBackground;
    public static boolean enableEffectName;
    public static boolean enableIconBlink;
    public static int durationBlinkSeconds;
    public static String effectNameColor;
    public static String durationColor;
    public static int xOffset;
    public static int yOffset;
    public static int yOffsetBottomCenter;
    public static boolean applyXOffsetToCenter;
    public static boolean applyYOffsetToMiddle;
    public static boolean showInChat;
    private static Map<PotionEffect, Integer> potionMaxDurationMap;
    private static BSConfiguration config;

    public static void loadConfig(File file) {
        String ctgyGen = "general";
        if (!CommonUtils.isObfuscatedEnv()) {
            // empty if block
        }
        config = new BSConfiguration(file);
        config.load();
        alignMode = config.getString("alignMode", ctgyGen, alignMode, "Valid alignment strings are topleft, topcenter, topright, middleleft, middlecenter, middleright, bottomleft, bottomcenter, bottomright");
        enableBackground = config.getBoolean("enableBackground", ctgyGen, enableBackground, "Set to true to see the effect background box, false to disable.");
        enableEffectName = config.getBoolean("enableEffectName", ctgyGen, enableEffectName, "Set to true to show effect names, false to disable.");
        enableIconBlink = config.getBoolean("enableIconBlink", ctgyGen, enableIconBlink, "Set to true to enable blinking for the icon when a potion/effect is nearly gone, false to disable.");
        durationBlinkSeconds = config.getInt("durationBlinkSeconds", ctgyGen, durationBlinkSeconds, -1, 60, "When a potion/effect has this many seconds remaining the timer will begin to blink. Set to -1 to disable blinking.");
        effectNameColor = config.getString("effectNameColor", ctgyGen, effectNameColor, "Valid color values are 0-9, a-f (color values can be found here: http://www.minecraftwiki.net/wiki/File:Colors.png).");
        durationColor = config.getString("durationColor", ctgyGen, durationColor, "Valid color values are 0-9, a-f (color values can be found here: http://www.minecraftwiki.net/wiki/File:Colors.png).");
        xOffset = config.getInt("xOffset", ctgyGen, xOffset, Integer.MIN_VALUE, Integer.MAX_VALUE, "Horizontal offset from the edge of the screen (when using right alignments the x offset is relative to the right edge of the screen)");
        yOffset = config.getInt("yOffset", ctgyGen, yOffset, Integer.MIN_VALUE, Integer.MAX_VALUE, "Vertical offset from the edge of the screen (when using bottom alignments the y offset is relative to the bottom edge of the screen)");
        yOffsetBottomCenter = config.getInt("yOffsetBottomCenter", ctgyGen, yOffsetBottomCenter, 0, Integer.MAX_VALUE, "Vertical offset used only for the bottomcenter alignment to avoid the vanilla HUD");
        applyXOffsetToCenter = config.getBoolean("applyXOffsetToCenter", ctgyGen, applyXOffsetToCenter, "Set to true if you want the xOffset value to be applied when using a center alignment");
        applyYOffsetToMiddle = config.getBoolean("applyYOffsetToMiddle", ctgyGen, applyYOffsetToMiddle, "Set to true if you want the yOffset value to be applied when using a middle alignment");
        showInChat = config.getBoolean("showInChat", ctgyGen, showInChat, "Set to true to show info when chat is open, false to disable info when chat is open");
        config.save();
    }

    public static boolean onTickInGame(Minecraft mc) {
        if ((mc.field_71415_G || mc.field_71462_r == null || mc.field_71462_r instanceof GuiChat && showInChat) && !mc.field_71474_y.field_74330_P && !mc.field_71474_y.field_74321_H.func_151470_d()) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            scaledResolution = new ScaledResolution(mc.field_71474_y, mc.field_71443_c, mc.field_71440_d);
            StatusEffectHUD.displayStatusEffects(mc);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        return true;
    }

    private static int getX(int width) {
        if (alignMode.equalsIgnoreCase("topcenter") || alignMode.equalsIgnoreCase("middlecenter") || alignMode.equalsIgnoreCase("bottomcenter")) {
            return scaledResolution.func_78326_a() / 2 - width / 2 + (applyXOffsetToCenter ? xOffset : 0);
        }
        if (alignMode.equalsIgnoreCase("topright") || alignMode.equalsIgnoreCase("middleright") || alignMode.equalsIgnoreCase("bottomright")) {
            return scaledResolution.func_78326_a() - width - xOffset;
        }
        return xOffset;
    }

    private static int getY(int rowCount, int height) {
        if (alignMode.equalsIgnoreCase("middleleft") || alignMode.equalsIgnoreCase("middlecenter") || alignMode.equalsIgnoreCase("middleright")) {
            return scaledResolution.func_78328_b() / 2 - rowCount * height / 2 + (applyYOffsetToMiddle ? yOffset : 0);
        }
        if (alignMode.equalsIgnoreCase("bottomleft") || alignMode.equalsIgnoreCase("bottomright")) {
            return scaledResolution.func_78328_b() - rowCount * height - yOffset;
        }
        if (alignMode.equalsIgnoreCase("bottomcenter")) {
            return scaledResolution.func_78328_b() - rowCount * height - yOffsetBottomCenter;
        }
        return yOffset;
    }

    private static boolean shouldRender(PotionEffect pe, int ticksLeft, int thresholdSeconds) {
        if (potionMaxDurationMap.get(pe) > 400 && ticksLeft / 20 <= thresholdSeconds) {
            return ticksLeft % 20 < 10;
        }
        return true;
    }

    private static void displayStatusEffects(Minecraft mc) {
        Collection activeEffects = mc.field_71439_g.func_70651_bq();
        if (!activeEffects.isEmpty()) {
            int yOffset;
            int n = enableBackground ? 33 : (yOffset = enableEffectName ? 20 : 18);
            if (activeEffects.size() > 5 && enableBackground) {
                yOffset = 132 / (activeEffects.size() - 1);
            }
            int yBase = StatusEffectHUD.getY(activeEffects.size(), yOffset);
            for (PotionEffect potionEffect : activeEffects) {
                int potionStatusIcon;
                if (!potionMaxDurationMap.containsKey(potionEffect) || potionMaxDurationMap.get(potionEffect) < potionEffect.func_76459_b()) {
                    potionMaxDurationMap.put(potionEffect, new Integer(potionEffect.func_76459_b()));
                }
                Potion potion = Potion.field_76425_a[potionEffect.func_76456_a()];
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(new ResourceLocation("textures/gui/container/inventory.png"));
                int xBase = StatusEffectHUD.getX(enableBackground ? 120 : 22 + mc.field_71466_p.func_78256_a("0:00"));
                String potionName = "";
                if (enableEffectName) {
                    potionName = StatCollector.func_74838_a((String)potion.func_76393_a());
                    if (potionEffect.func_76458_c() == 1) {
                        potionName = potionName + " II";
                    } else if (potionEffect.func_76458_c() == 2) {
                        potionName = potionName + " III";
                    } else if (potionEffect.func_76458_c() == 3) {
                        potionName = potionName + " IV";
                    }
                    xBase = StatusEffectHUD.getX(enableBackground ? 120 : 22 + mc.field_71466_p.func_78256_a(potionName));
                }
                String effectDuration = Potion.func_76389_a((PotionEffect)potionEffect);
                if (enableBackground) {
                    HUDUtils.drawTexturedModalRect((int)xBase, (int)yBase, (int)0, (int)166, (int)140, (int)32, (float)zLevel);
                }
                if (alignMode.toLowerCase().contains("right")) {
                    xBase = StatusEffectHUD.getX(0);
                    if (potion.func_76400_d()) {
                        potionStatusIcon = potion.func_76392_e();
                        if (!enableIconBlink || enableIconBlink && StatusEffectHUD.shouldRender(potionEffect, potionEffect.func_76459_b(), durationBlinkSeconds)) {
                            HUDUtils.drawTexturedModalRect((int)(xBase + (enableBackground ? -24 : -18)), (int)(yBase + (enableBackground ? 7 : 0)), (int)(0 + potionStatusIcon % 8 * 18), (int)(198 + potionStatusIcon / 8 * 18), (int)18, (int)18, (float)zLevel);
                        }
                    }
                    int stringWidth = mc.field_71466_p.func_78256_a(potionName);
                    mc.field_71466_p.func_78261_a("\u00a7" + effectNameColor + potionName + "\u00a7r", xBase + (enableBackground ? -10 : -4) - 18 - stringWidth, yBase + (enableBackground ? 6 : 0), 0xFFFFFF);
                    stringWidth = mc.field_71466_p.func_78256_a(effectDuration);
                    if (StatusEffectHUD.shouldRender(potionEffect, potionEffect.func_76459_b(), durationBlinkSeconds)) {
                        mc.field_71466_p.func_78261_a("\u00a7" + durationColor + effectDuration + "\u00a7r", xBase + (enableBackground ? -10 : -4) - 18 - stringWidth, yBase + (enableBackground ? 6 : 0) + (enableEffectName ? 10 : 5), 0xFFFFFF);
                    }
                } else {
                    if (potion.func_76400_d()) {
                        potionStatusIcon = potion.func_76392_e();
                        HUDUtils.drawTexturedModalRect((int)(xBase + (enableBackground ? 6 : 0)), (int)(yBase + (enableBackground ? 7 : 0)), (int)(0 + potionStatusIcon % 8 * 18), (int)(198 + potionStatusIcon / 8 * 18), (int)18, (int)18, (float)zLevel);
                    }
                    mc.field_71466_p.func_78261_a("\u00a7" + effectNameColor + potionName + "\u00a7r", xBase + (enableBackground ? 10 : 4) + 18, yBase + (enableBackground ? 6 : 0), 0xFFFFFF);
                    if (StatusEffectHUD.shouldRender(potionEffect, potionEffect.func_76459_b(), durationBlinkSeconds)) {
                        mc.field_71466_p.func_78261_a("\u00a7" + durationColor + effectDuration + "\u00a7r", xBase + (enableBackground ? 10 : 4) + 18, yBase + (enableBackground ? 6 : 0) + (enableEffectName ? 10 : 5), 0xFFFFFF);
                    }
                }
                yBase += yOffset;
            }
            LinkedList<PotionEffect> toRemove = new LinkedList<PotionEffect>();
            for (PotionEffect pe : potionMaxDurationMap.keySet()) {
                if (activeEffects.contains(pe)) continue;
                toRemove.add(pe);
            }
            for (PotionEffect pe : toRemove) {
                potionMaxDurationMap.remove(pe);
            }
        }
    }

    static {
        alignMode = "middleright";
        enableBackground = false;
        enableEffectName = true;
        enableIconBlink = true;
        durationBlinkSeconds = 10;
        effectNameColor = "f";
        durationColor = "f";
        xOffset = 2;
        yOffset = 2;
        yOffsetBottomCenter = 41;
        applyXOffsetToCenter = false;
        applyYOffsetToMiddle = false;
        showInChat = true;
        potionMaxDurationMap = new HashMap<PotionEffect, Integer>();
    }
}

