/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.worldstatecheckpoints;

import bspkrs.helpers.client.MinecraftHelper;
import bspkrs.helpers.client.gui.GuiScreenWrapper;
import bspkrs.helpers.client.gui.GuiTextFieldWrapper;
import bspkrs.worldstatecheckpoints.CheckpointManager;
import bspkrs.worldstatecheckpoints.GuiCheckpointsMenu;
import bspkrs.worldstatecheckpoints.WSCSettings;
import java.util.Properties;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.StatCollector;

public class GuiConfigureAutoSave
extends GuiScreenWrapper {
    String guiTitle = StatCollector.func_74838_a((String)"wsc.configureAutoSave.title");
    String[] maxAutoSaves = new String[]{StatCollector.func_74838_a((String)"wsc.configureAutoSave.maxAutoSavesToKeep"), StatCollector.func_74838_a((String)"wsc.configureAutoSave.use0ForNoLimit")};
    String enableAutosaveText = StatCollector.func_74838_a((String)"wsc.configureAutosave.enableAutoSave") + ": ";
    private final CheckpointManager cpm;
    private GuiButton back;
    private GuiButton save;
    private GuiButton enable;
    private GuiButton periodUnit;
    private GuiTextFieldWrapper periodValue;
    private GuiTextFieldWrapper maxToKeep;
    private final Properties localConfig;

    public GuiConfigureAutoSave(CheckpointManager cpm) {
        this.cpm = cpm;
        this.localConfig = new Properties();
        this.localConfig.setProperty("enabled", cpm.autoSaveConfig.getProperty("enabled"));
        this.localConfig.setProperty("maxAutoSavesToKeep", cpm.autoSaveConfig.getProperty("maxAutoSavesToKeep"));
        this.localConfig.setProperty("autoSavePeriod", cpm.autoSaveConfig.getProperty("autoSavePeriod"));
        this.localConfig.setProperty("periodUnit", cpm.autoSaveConfig.getProperty("periodUnit"));
    }

    public void func_73866_w_() {
        this.buttonList().clear();
        int byte0 = -16;
        int row1 = this.height() / 4 + 24 + byte0;
        int row2 = this.height() / 4 + 48 + byte0;
        int row3 = this.height() / 4 + 72 + byte0;
        int row5 = this.height() / 4 + 120 + byte0;
        this.enable = new GuiButton(-1, this.width() / 2 - 100, row1, this.enableAutosaveText + (this.cpm.autoSaveEnabled ? StatCollector.func_74838_a((String)"options.on") : StatCollector.func_74838_a((String)"options.off")));
        this.periodValue = new GuiTextFieldWrapper(this.field_146289_q, this.width() / 2 - 62, row2, 60, 20);
        this.periodValue.setText(this.localConfig.getProperty("autoSavePeriod"));
        this.maxToKeep = new GuiTextFieldWrapper(this.field_146289_q, this.width() / 2 + 2, row3, 60, 20);
        this.maxToKeep.setText(this.localConfig.getProperty("maxAutoSavesToKeep"));
        this.periodUnit = new GuiButton(-2, this.width() / 2 + 2, row2, 60, 20, StatCollector.func_74838_a((String)("wsc.configureAutosave.period." + this.localConfig.getProperty("periodUnit"))));
        this.periodUnit.field_146124_l = this.cpm.autoSaveEnabled;
        this.save = new GuiButton(-3, this.width() / 2 - 62, row5, 60, 20, StatCollector.func_74838_a((String)"wsc.saveCheckpoint.save"));
        this.back = new GuiButton(-4, this.width() / 2 + 2, row5, 60, 20, StatCollector.func_74838_a((String)"gui.cancel"));
        this.buttonList().add(this.enable);
        this.buttonList().add(this.periodUnit);
        this.buttonList().add(this.save);
        this.buttonList().add(this.back);
    }

    protected void func_146284_a(GuiButton par1GuiButton) {
        switch (par1GuiButton.field_146127_k) {
            case -1: {
                if (this.localConfig.getProperty("enabled").equalsIgnoreCase("on")) {
                    this.localConfig.setProperty("enabled", "off");
                    this.enable.field_146126_j = this.enableAutosaveText + StatCollector.func_74838_a((String)"options.off");
                    this.periodUnit.field_146124_l = false;
                    break;
                }
                this.localConfig.setProperty("enabled", "on");
                this.enable.field_146126_j = this.enableAutosaveText + StatCollector.func_74838_a((String)"options.on");
                this.periodUnit.field_146124_l = true;
                break;
            }
            case -2: {
                if (this.localConfig.getProperty("periodUnit").equalsIgnoreCase("hours")) {
                    this.localConfig.setProperty("periodUnit", "minutes");
                } else if (this.localConfig.getProperty("periodUnit").equalsIgnoreCase("minutes")) {
                    this.localConfig.setProperty("periodUnit", "seconds");
                } else if (this.localConfig.getProperty("periodUnit").equalsIgnoreCase("seconds")) {
                    this.localConfig.setProperty("periodUnit", "hours");
                }
                this.periodUnit.field_146126_j = StatCollector.func_74838_a((String)("wsc.configureAutosave.period." + this.localConfig.getProperty("periodUnit")));
                break;
            }
            case -3: {
                this.cpm.autoSaveConfig.setProperty("enabled", this.localConfig.getProperty("enabled"));
                this.cpm.autoSaveConfig.setProperty("autoSavePeriod", this.localConfig.getProperty("autoSavePeriod"));
                this.cpm.autoSaveConfig.setProperty("periodUnit", this.localConfig.getProperty("periodUnit"));
                this.cpm.autoSaveConfig.setProperty("maxAutoSavesToKeep", this.localConfig.getProperty("maxAutoSavesToKeep"));
                this.cpm.saveAutoConfig(this.cpm.autoSaveConfig);
                this.cpm.loadAutoConfig();
                MinecraftHelper.displayGuiScreen((Minecraft)WSCSettings.mc, (GuiScreen)new GuiCheckpointsMenu(this.cpm));
                break;
            }
            case -4: {
                MinecraftHelper.displayGuiScreen((Minecraft)WSCSettings.mc, (GuiScreen)new GuiCheckpointsMenu(this.cpm));
            }
        }
    }

    protected void func_73869_a(char c, int i) {
        String validChars = "0123456789";
        if (validChars.contains(String.valueOf(c)) || i == 14 || i == 211 || i == 203 || i == 205 || i == 199 || i == 207) {
            if (this.maxToKeep.isFocused()) {
                this.maxToKeep.textboxKeyTyped(c, i);
            } else if (this.periodValue.isFocused()) {
                this.periodValue.textboxKeyTyped(c, i);
            }
        }
        this.save.field_146124_l = this.periodValue.getText().trim().length() > 0 && Integer.valueOf(this.periodValue.getText().trim()) > 0 && this.maxToKeep.getText().trim().length() > 0 && Integer.valueOf(this.maxToKeep.getText().trim()) >= 0;
        this.localConfig.setProperty("autoSavePeriod", this.periodValue.getText().trim());
        this.localConfig.setProperty("maxAutoSavesToKeep", this.maxToKeep.getText().trim());
        if (c == '\r' && this.save.field_146124_l) {
            this.actionPerformed(this.save);
        }
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        super.func_73864_a(par1, par2, par3);
        this.periodValue.mouseClicked(par1, par2, par3);
        this.maxToKeep.mouseClicked(par1, par2, par3);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.periodValue.updateCursorCounter();
        this.maxToKeep.updateCursorCounter();
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.drawDefaultBackground();
        this.periodValue.drawTextBox();
        this.maxToKeep.drawTextBox();
        this.func_73732_a(this.field_146289_q, this.guiTitle, this.width() / 2, 80, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, this.maxAutoSaves[0], this.width() / 2 - 3 - this.field_146289_q.func_78256_a(this.maxAutoSaves[0]), this.height() / 4 + 72 - 16 + 1, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, this.maxAutoSaves[1], this.width() / 2 - 3 - this.field_146289_q.func_78256_a(this.maxAutoSaves[1]), this.height() / 4 + 72 - 16 + 11, 0xFFFFFF);
        super.func_73863_a(par1, par2, par3);
    }
}

