/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.worldstatecheckpoints;

import bspkrs.helpers.client.MinecraftHelper;
import bspkrs.helpers.entity.player.EntityPlayerHelper;
import bspkrs.util.BSConfiguration;
import bspkrs.util.CommonUtils;
import bspkrs.worldstatecheckpoints.CheckpointManager;
import bspkrs.worldstatecheckpoints.GuiCheckpointsMenu;
import bspkrs.worldstatecheckpoints.GuiLoadCheckpoint;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGameOver;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import org.lwjgl.input.Keyboard;

public class WSCSettings {
    public static final String VERSION_NUMBER = "1.7.2.r01";
    public static String autoSaveEnabledDefault = "off";
    public static int maxAutoSavesToKeepDefault = 10;
    public static int autoSavePeriodDefault = 20;
    public static String periodUnitDefault = "minutes";
    public static KeyBinding bindKey = new KeyBinding("worldstatecheckpoints.keybind.desc", 64, "key.categories.misc");
    public static boolean justLoadedCheckpoint = false;
    public static boolean justLoadedWorld = false;
    public static String loadMessage = "";
    public static CheckpointManager cpm;
    protected static int delayedLoaderTicks;
    protected static String delayedLoadCheckpointName;
    protected static boolean isDelayedLoadAutoSave;
    public static BSConfiguration config;
    public static boolean allowDebugLogging;
    public static final Minecraft mc;

    public static void loadConfig(File file) {
        String ctgyGen = "autosave_new_world_defaults";
        if (!CommonUtils.isObfuscatedEnv()) {
            // empty if block
        }
        config = new BSConfiguration(file);
        config.load();
        autoSaveEnabledDefault = config.getString("autoSaveEnabledDefault", "autosave_new_world_defaults", autoSaveEnabledDefault, "Default enabled state of auto-saving when starting a new world.  Valid values are on/off.");
        maxAutoSavesToKeepDefault = config.getInt("maxAutoSavesToKeepDefault", "autosave_new_world_defaults", maxAutoSavesToKeepDefault, 0, 100, "Default maximum number of auto-saves to keep per world. This value is used when starting a new world. Use 0 for no limit.");
        autoSavePeriodDefault = config.getInt("autoSavePeriodDefault", "autosave_new_world_defaults", autoSavePeriodDefault, 1, Integer.MAX_VALUE, "Default auto-save period to use in a new world's auto-save config.");
        periodUnitDefault = config.getString("periodUnitDefault", "autosave_new_world_defaults", periodUnitDefault, "Default auto-save period unit to use in a new world's auto-save config.  Valid values are hours/minutes/seconds.");
        config.save();
    }

    public static void delayedLoadCheckpoint(String checkpointName, boolean isAutoSave, int delayTicks) {
        delayedLoadCheckpointName = checkpointName;
        isDelayedLoadAutoSave = isAutoSave;
        delayedLoaderTicks = delayTicks;
    }

    public static boolean onGameTick() {
        if (WSCSettings.mc.field_71441_e != null && WSCSettings.mc.field_71439_g != null) {
            if (justLoadedWorld) {
                cpm = null;
                justLoadedWorld = false;
            }
            if (cpm == null) {
                cpm = new CheckpointManager(mc);
            }
            if (justLoadedCheckpoint) {
                EntityPlayerHelper.addChatMessage((EntityPlayer)WSCSettings.mc.field_71439_g, (IChatComponent)new ChatComponentText(loadMessage));
                loadMessage = "";
                if (WSCSettings.cpm.autoSaveEnabled) {
                    WSCSettings.cpm.tickCount = 0;
                }
                justLoadedCheckpoint = false;
            }
            if (WSCSettings.cpm.autoSaveEnabled && (WSCSettings.mc.field_71462_r == null || !(WSCSettings.mc.field_71462_r instanceof GuiGameOver) && !CommonUtils.isGamePaused((Minecraft)mc))) {
                cpm.incrementTickCount();
            }
            if (delayedLoaderTicks > 0 && --delayedLoaderTicks == 0) {
                cpm.loadCheckpoint(delayedLoadCheckpointName, isDelayedLoadAutoSave);
            }
        }
        return true;
    }

    public static void keyboardEvent(KeyBinding event) {
        if (event.equals(bindKey) && mc.func_71356_B() && !Keyboard.isKeyDown((int)56) && !Keyboard.isKeyDown((int)184)) {
            if (WSCSettings.mc.field_71462_r instanceof GuiGameOver && cpm.getHasCheckpoints(false)) {
                MinecraftHelper.displayGuiScreen((Minecraft)mc, (GuiScreen)new GuiLoadCheckpoint(cpm, true, false));
            } else if (WSCSettings.mc.field_71462_r instanceof GuiGameOver && cpm.getHasCheckpoints(true)) {
                MinecraftHelper.displayGuiScreen((Minecraft)mc, (GuiScreen)new GuiLoadCheckpoint(cpm, true, true));
            } else {
                MinecraftHelper.displayGuiScreen((Minecraft)mc, (GuiScreen)new GuiCheckpointsMenu(cpm));
            }
        } else if (event.equals(bindKey) && mc.func_71356_B() && !(WSCSettings.mc.field_71462_r instanceof GuiGameOver) && !(WSCSettings.mc.field_71462_r instanceof GuiIngameMenu) && (Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184))) {
            if (!WSCSettings.cpm.isSaving) {
                WSCSettings.cpm.tickCount = 0;
            }
            cpm.setCheckpoint("", true);
        }
    }

    static {
        delayedLoaderTicks = 0;
        delayedLoadCheckpointName = "";
        isDelayedLoadAutoSave = false;
        allowDebugLogging = false;
        mc = Minecraft.func_71410_x();
    }
}

