/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.managers;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.launcher.updater.LatestVersionSyncInfo;
import net.minecraft.launcher.updater.LocalVersionList;
import net.minecraft.launcher.updater.RemoteVersionList;
import net.minecraft.launcher.updater.VersionFilter;
import net.minecraft.launcher.updater.VersionList;
import net.minecraft.launcher.updater.VersionSyncInfo;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.ReleaseType;
import net.minecraft.launcher.versions.Version;
import org.tlauncher.modpack.domain.client.version.MetadataDTO;
import org.tlauncher.tlauncher.component.ComponentDependence;
import org.tlauncher.tlauncher.component.InterruptibleComponent;
import org.tlauncher.tlauncher.downloader.Downloadable;
import org.tlauncher.tlauncher.managers.AssetsManager;
import org.tlauncher.tlauncher.managers.ComponentManager;
import org.tlauncher.tlauncher.managers.TLauncherManager;
import org.tlauncher.tlauncher.managers.VersionLists;
import org.tlauncher.tlauncher.managers.VersionManagerListener;
import org.tlauncher.tlauncher.managers.VersionSyncInfoContainer;
import org.tlauncher.tlauncher.repository.ClientInstanceRepo;
import org.tlauncher.tlauncher.repository.Repo;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.util.FileUtil;
import org.tlauncher.util.Time;
import org.tlauncher.util.U;
import org.tlauncher.util.async.AsyncObject;
import org.tlauncher.util.async.AsyncObjectContainer;
import org.tlauncher.util.async.AsyncObjectGotErrorException;
import org.tlauncher.util.async.AsyncThread;

@ComponentDependence(value={AssetsManager.class, VersionLists.class, TLauncherManager.class})
public class VersionManager
extends InterruptibleComponent {
    private final LocalVersionList localList;
    private final RemoteVersionList[] remoteLists;
    private final List<VersionManagerListener> listeners;
    private final Object versionFlushLock;
    private Map<ReleaseType, Version> latestVersions;
    private boolean hadRemote;
    private boolean localRefresh;
    private final List<VersionSyncInfo> currentSyncVersions = new ArrayList<VersionSyncInfo>();

    public VersionManager(ComponentManager manager) throws Exception {
        super(manager);
        VersionLists list = manager.getComponent(VersionLists.class);
        this.localList = list.getLocal();
        this.remoteLists = list.getRemoteLists();
        this.latestVersions = new LinkedHashMap<ReleaseType, Version>();
        this.listeners = Collections.synchronizedList(new ArrayList());
        this.versionFlushLock = new Object();
    }

    public void addListener(VersionManagerListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalVersionList getLocalList() {
        Object object = this.versionFlushLock;
        synchronized (object) {
            return this.localList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ReleaseType, Version> getLatestVersions() {
        Object object = this.versionFlushLock;
        synchronized (object) {
            return Collections.unmodifiableMap(this.latestVersions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean refresh(int refreshID, boolean local) {
        this.refreshList[refreshID] = true;
        this.localRefresh = local;
        this.hadRemote |= !(local |= !this.manager.getLauncher().getConfiguration().getBoolean("minecraft.versions.sub.remote"));
        if (local) {
            this.log("Refreshing versions locally...");
        } else {
            this.log("Refreshing versions remotely...");
            this.latestVersions.clear();
            List<VersionManagerListener> list = this.listeners;
            synchronized (list) {
                for (VersionManagerListener listener : this.listeners) {
                    listener.onVersionsRefreshing(this);
                }
            }
        }
        Object lock = new Object();
        Time.start(lock);
        Map<AsyncObject<VersionList.RawVersionList>, VersionList.RawVersionList> result = null;
        Throwable e = null;
        try {
            result = this.refreshVersions(local);
        }
        catch (Throwable e0) {
            e = e0;
        }
        if (this.isCancelled(refreshID)) {
            this.log("Version refresh has been cancelled (" + Time.stop(lock) + " ms)");
            return false;
        }
        if (e != null) {
            List<VersionManagerListener> e0 = this.listeners;
            synchronized (e0) {
                for (VersionManagerListener listener : this.listeners) {
                    listener.onVersionsRefreshingFailed(this);
                }
            }
            this.log("Cannot refresh versions (" + Time.stop(lock) + " ms)", e);
            return true;
        }
        if (result != null) {
            Object e0 = this.versionFlushLock;
            synchronized (e0) {
                for (AsyncObject<VersionList.RawVersionList> object : result.keySet()) {
                    VersionList.RawVersionList rawList = result.get(object);
                    if (rawList == null) continue;
                    AsyncRawVersionListObject listObject = (AsyncRawVersionListObject)object;
                    RemoteVersionList versionList = listObject.getVersionList();
                    versionList.refreshVersions(rawList);
                    this.latestVersions.putAll(versionList.getLatestVersions());
                }
            }
        }
        this.latestVersions = U.sortMap(this.latestVersions, ReleaseType.values());
        List<VersionSyncInfo> l1 = this.getVersions0();
        this.currentSyncVersions.clear();
        this.currentSyncVersions.addAll(l1);
        this.log("Versions has been refreshed (" + Time.stop(lock) + " ms)");
        this.refreshList[refreshID] = false;
        List<VersionManagerListener> list = this.listeners;
        synchronized (list) {
            for (VersionManagerListener listener : this.listeners) {
                listener.onVersionsRefreshed(this);
            }
        }
        return true;
    }

    @Override
    protected boolean refresh(int queueID) {
        return this.refresh(queueID, false);
    }

    public void startRefresh(boolean local) {
        this.refresh(this.nextID(), local);
    }

    @Override
    public synchronized void stopRefresh() {
        super.stopRefresh();
        this.startRefresh(true);
    }

    public void asyncRefresh(boolean local) {
        AsyncThread.execute(() -> this.startRefresh(local));
    }

    @Override
    public void asyncRefresh() {
        this.asyncRefresh(false);
    }

    private Map<AsyncObject<VersionList.RawVersionList>, VersionList.RawVersionList> refreshVersions(boolean local) {
        this.localList.refreshVersions();
        if (local) {
            return null;
        }
        AsyncObjectContainer<VersionList.RawVersionList> container = new AsyncObjectContainer<VersionList.RawVersionList>();
        for (RemoteVersionList remoteList : this.remoteLists) {
            container.add(new AsyncRawVersionListObject(remoteList));
        }
        return container.execute();
    }

    public void updateVersionList() {
        if (!this.hadRemote) {
            this.asyncRefresh();
        } else {
            for (VersionManagerListener listener : this.listeners) {
                listener.onVersionsRefreshed(this);
            }
        }
    }

    public VersionSyncInfo getVersionSyncInfo(Version version) {
        return this.getVersionSyncInfo(version.getID());
    }

    public VersionSyncInfo getVersionSyncInfo(String name) {
        Version localVersion;
        if (name == null) {
            throw new NullPointerException("Cannot get sync info of NULL!");
        }
        if (name.startsWith("latest-")) {
            String realID = name.substring(7);
            name = null;
            for (Map.Entry<ReleaseType, Version> entry : this.latestVersions.entrySet()) {
                if (!entry.getKey().toString().equals(realID)) continue;
                name = entry.getValue().getID();
                break;
            }
            if (name == null) {
                return null;
            }
        }
        if ((localVersion = this.localList.getVersion(name)) instanceof CompleteVersion && ((CompleteVersion)localVersion).getInheritsFrom() != null) {
            try {
                localVersion = ((CompleteVersion)localVersion).resolve(this, false);
            }
            catch (IOException ioE) {
                U.log(ioE);
                localVersion = null;
            }
        }
        Version remoteVersion = null;
        for (RemoteVersionList list : this.remoteLists) {
            Version currentVersion = list.getVersion(name);
            if (currentVersion == null) continue;
            remoteVersion = currentVersion;
            break;
        }
        return localVersion == null && remoteVersion == null ? null : new VersionSyncInfo(localVersion, remoteVersion);
    }

    public LatestVersionSyncInfo getLatestVersionSyncInfo(Version version) {
        if (version == null) {
            throw new NullPointerException("Cannot get latest sync info of NULL!");
        }
        VersionSyncInfo syncInfo = this.getVersionSyncInfo(version);
        return new LatestVersionSyncInfo(version.getReleaseType(), syncInfo);
    }

    public List<VersionSyncInfo> getVersions(VersionFilter filter, boolean includeLatest) {
        return this.currentSyncVersions.stream().filter(v -> includeLatest || !(v instanceof LatestVersionSyncInfo)).filter(v -> {
            if (Objects.isNull(filter)) {
                return true;
            }
            return filter.satisfies(v.getAvailableVersion());
        }).collect(Collectors.toList());
    }

    public List<VersionSyncInfo> getVersions(boolean includeLatest) {
        return this.getVersions(TLauncher.getInstance() == null ? null : TLauncher.getInstance().getConfiguration().getVersionFilter(), includeLatest);
    }

    public synchronized List<VersionSyncInfo> getVersions() {
        return this.getVersions(true);
    }

    private synchronized List<VersionSyncInfo> getVersions0() {
        VersionSyncInfo syncInfo;
        ArrayList<LatestVersionSyncInfo> plainResult = new ArrayList<LatestVersionSyncInfo>();
        ArrayList<VersionSyncInfo> result = new ArrayList<VersionSyncInfo>();
        HashMap<String, LatestVersionSyncInfo> lookup = new HashMap<String, LatestVersionSyncInfo>();
        for (Version version2 : this.latestVersions.values()) {
            syncInfo = this.getLatestVersionSyncInfo(version2);
            if (result.contains(syncInfo)) continue;
            result.add(syncInfo);
        }
        for (Version v : Lists.newArrayList(this.localList.getVersions())) {
            syncInfo = this.getVersionSyncInfo(v);
            if (syncInfo == null) continue;
            lookup.put(v.getID(), (LatestVersionSyncInfo)syncInfo);
            plainResult.add((LatestVersionSyncInfo)syncInfo);
        }
        for (Iterator<Version> iterator : this.remoteLists) {
            ((VersionList)((Object)iterator)).getVersions().stream().filter(version -> !lookup.containsKey(version.getID())).forEach(version -> {
                VersionSyncInfo syncInfo = this.getVersionSyncInfo((Version)version);
                lookup.put(version.getID(), (LatestVersionSyncInfo)syncInfo);
                plainResult.add((LatestVersionSyncInfo)syncInfo);
            });
        }
        plainResult.sort((a, b) -> {
            Date aDate = a.getLatestVersion().getReleaseTime();
            Date bDate = b.getLatestVersion().getReleaseTime();
            if (aDate == null || bDate == null) {
                return 1;
            }
            return bDate.compareTo(aDate);
        });
        result.addAll(plainResult);
        return result;
    }

    public List<VersionSyncInfo> getInstalledVersions(VersionFilter filter) {
        ArrayList<VersionSyncInfo> result = new ArrayList<VersionSyncInfo>();
        for (Version version : this.localList.getVersions()) {
            result.add(this.getVersionSyncInfo(version));
        }
        return result;
    }

    public List<VersionSyncInfo> getInstalledVersions() {
        return this.getInstalledVersions(TLauncher.getInstance() == null ? null : TLauncher.getInstance().getConfiguration().getVersionFilter());
    }

    public VersionSyncInfoContainer downloadVersion(VersionSyncInfo syncInfo, boolean tlauncher, boolean force) throws IOException {
        VersionSyncInfoContainer container = new VersionSyncInfoContainer(syncInfo);
        CompleteVersion completeVersion = syncInfo.getCompleteVersion(force);
        File baseDirectory = this.localList.getBaseDirectory();
        Set<Downloadable> required = syncInfo.getRequiredDownloadables(baseDirectory, force, tlauncher);
        container.addAll(required);
        this.log("Required for version " + syncInfo.getID() + ':', required);
        String originalId = completeVersion.getJar();
        Repo repo = ClientInstanceRepo.OFFICIAL_VERSION_REPO;
        String id = completeVersion.getID();
        String jarFile = "versions/";
        String saveFile = "versions/";
        if (originalId == null) {
            if (Objects.nonNull(syncInfo.getRemote())) {
                repo = syncInfo.getRemote().getSource();
            }
            saveFile = jarFile = jarFile + id + "/" + id + ".jar";
        } else {
            repo = ClientInstanceRepo.OFFICIAL_VERSION_REPO;
            jarFile = jarFile + originalId + "/" + originalId + ".jar";
            saveFile = saveFile + id + "/" + id + ".jar";
        }
        File versionFile = new File(baseDirectory, saveFile);
        if (Objects.nonNull(completeVersion.getDownloads()) && Objects.nonNull(completeVersion.getDownloads().get("client"))) {
            String key = "client_tl_manager";
            CompleteVersion completeVersion1 = TLauncher.getInstance().getTLauncherManager().addFilesForDownloading(completeVersion, false);
            boolean containsKey = Objects.nonNull(completeVersion1.getDownloads().get(key));
            boolean tlAccount = TLauncher.getInstance().getTLauncherManager().applyTLauncherAccountLib(completeVersion);
            this.addedMinecraftClient(force, container, completeVersion.getDownloads().get("client"), baseDirectory, versionFile, !containsKey || !tlAccount, completeVersion.getModifiedVersion().isSkipHashsumValidation());
            if (containsKey) {
                this.addedMinecraftClient(force, container, completeVersion1.getDownloads().get(key), baseDirectory, versionFile, containsKey && tlAccount, completeVersion.getModifiedVersion().isSkipHashsumValidation());
            }
        } else if (!Files.exists(new File(baseDirectory, saveFile).toPath(), new LinkOption[0])) {
            String cacheRelatedFolder = "libraries/v1/" + jarFile;
            MetadataDTO client = new MetadataDTO();
            client.setPath(cacheRelatedFolder);
            client.setUrl(jarFile);
            client.setLocalDestination(new File(baseDirectory, cacheRelatedFolder));
            Downloadable d = new Downloadable(repo, client, force);
            d.addAdditionalDestination(new File(baseDirectory, saveFile));
            this.log("Jar for " + syncInfo.getID() + ':', d);
            container.add(d);
        }
        return container;
    }

    public boolean isLocalRefresh() {
        return this.localRefresh;
    }

    private VersionSyncInfoContainer addedMinecraftClient(boolean force, VersionSyncInfoContainer container, MetadataDTO client, File baseDirectory, File versionFile, boolean additionalCopy, boolean skipHashumValidation) throws IOException {
        Repo repo = ClientInstanceRepo.EMPTY_REPO;
        String cacheRelatedFolder = "libraries" + new URL(client.getUrl()).getPath();
        File cacheFile = new File(baseDirectory, cacheRelatedFolder);
        client.setLocalDestination(cacheFile);
        if (versionFile.exists() && (FileUtil.getChecksum(versionFile).equals(client.getSha1()) || skipHashumValidation)) {
            return container;
        }
        if (cacheFile.exists() && (FileUtil.getChecksum(cacheFile).equals(client.getSha1()) || skipHashumValidation)) {
            FileUtil.copyFile(cacheFile.getAbsoluteFile(), versionFile, true);
            return container;
        }
        Downloadable d = new Downloadable(repo, client, force);
        container.add(d);
        if (additionalCopy) {
            d.addAdditionalDestination(versionFile);
        }
        return container;
    }

    class AsyncRawVersionListObject
    extends AsyncObject<VersionList.RawVersionList> {
        private final RemoteVersionList remoteList;

        AsyncRawVersionListObject(RemoteVersionList remoteList) {
            this.remoteList = remoteList;
        }

        RemoteVersionList getVersionList() {
            return this.remoteList;
        }

        @Override
        protected VersionList.RawVersionList execute() throws AsyncObjectGotErrorException {
            try {
                return this.remoteList.getRawList();
            }
            catch (Exception e) {
                VersionManager.this.log(new Object[]{"Error refreshing version list:", e});
                throw new AsyncObjectGotErrorException(this, (Throwable)e);
            }
        }
    }
}

