/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.minecraft.user;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.tlauncher.tlauncher.minecraft.exceptions.ParseException;
import org.tlauncher.tlauncher.minecraft.user.InvalidResponseException;
import org.tlauncher.tlauncher.minecraft.user.Parser;
import org.tlauncher.tlauncher.minecraft.user.Requester;
import org.tlauncher.tlauncher.minecraft.user.preq.Validatable;

public abstract class RequestAndParseStrategy<A, V extends Validatable> {
    private final Logger logger;
    private final Requester<A> requester;
    private final Parser<V> parser;

    protected RequestAndParseStrategy(Logger logger, Requester<A> requester, Parser<V> parser) {
        this.logger = logger;
        this.requester = requester;
        this.parser = parser;
    }

    protected V requestAndParse(A argument) throws IOException, InvalidResponseException {
        String response = this.requester.makeRequest(this.logger, argument);
        try {
            return this.parser.parseResponse(this.logger, response);
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new InvalidResponseException(response, e);
        }
    }
}

