/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.minecraft.user.gos;

import java.util.List;
import java.util.Objects;
import org.tlauncher.tlauncher.minecraft.user.preq.Validatable;

public class MinecraftUserGameOwnershipResponse
implements Validatable {
    private List<Item> items;

    public MinecraftUserGameOwnershipResponse(List<Item> items) {
        this.items = items;
    }

    public MinecraftUserGameOwnershipResponse() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MinecraftUserGameOwnershipResponse that = (MinecraftUserGameOwnershipResponse)o;
        return Objects.equals(this.items, that.items);
    }

    public int hashCode() {
        return this.items != null ? this.items.hashCode() : 0;
    }

    public List<Item> getItems() {
        return this.items;
    }

    @Override
    public void validate() {
        Validatable.notNull(this.items, "items");
        for (Item item : this.items) {
            item.validate();
        }
    }

    public String toString() {
        return "MinecraftUserGameOwnershipResponse{items=" + this.items + '}';
    }

    public static class Item
    implements Validatable {
        private String name;
        private String signature;

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Item item = (Item)o;
            if (!this.name.equals(item.name)) {
                return false;
            }
            return this.signature.equals(item.signature);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            return 31 * result + this.signature.hashCode();
        }

        public String toString() {
            return "Item{name='" + this.name + '\'' + ", signature='" + this.signature + '\'' + '}';
        }

        @Override
        public void validate() {
            Validatable.notEmpty(this.name, "name");
            Validatable.notEmpty(this.signature, "signature");
        }
    }
}

