/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.explorer;

import java.awt.Component;
import java.awt.FileDialog;
import java.io.File;
import java.util.Objects;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.tlauncher.tlauncher.ui.explorer.FileChooser;
import org.tlauncher.tlauncher.ui.explorer.filters.CommonFilter;

public class FileWrapper
implements FileChooser {
    private CommonFilter filter;
    private FileDialog dialog;
    private File directory;
    private File selectedFile;
    private boolean multiSelectionMode = false;
    private String title;

    private FileDialog create(Component component) {
        this.dialog = component instanceof JFrame ? new FileDialog((JFrame)component) : (component instanceof JDialog ? new FileDialog((JDialog)component) : new FileDialog(new JFrame()));
        this.dialog.setAlwaysOnTop(true);
        this.dialog.setFilenameFilter(this.filter);
        if (Objects.nonNull(this.selectedFile)) {
            this.dialog.setFile(this.selectedFile.getAbsolutePath());
        }
        if (Objects.nonNull(this.directory)) {
            this.dialog.setDirectory(this.directory.getAbsolutePath());
        }
        this.dialog.setMultipleMode(this.multiSelectionMode);
        if (Objects.nonNull(this.title)) {
            this.dialog.setTitle(this.title);
        }
        return this.dialog;
    }

    @Override
    public int showSaveDialog(Component component) {
        this.dialog = this.create(component);
        this.dialog.setMode(1);
        this.dialog.show();
        if (Objects.nonNull(this.dialog.getFile())) {
            return 0;
        }
        return 1;
    }

    @Override
    public File getSelectedFile() {
        return new File(this.dialog.getDirectory(), this.dialog.getFile());
    }

    @Override
    public void setSelectedFile(File file) {
        this.selectedFile = file;
    }

    @Override
    public void setCurrentDirectory(File file) {
        this.directory = file;
    }

    @Override
    public int showDialog(Component parent) {
        this.dialog = this.create(parent);
        this.dialog.setMode(0);
        this.dialog.show();
        if (Objects.nonNull(this.dialog.getFile())) {
            return 0;
        }
        return 1;
    }

    @Override
    public File[] getSelectedFiles() {
        return this.dialog.getFiles();
    }

    @Override
    public void setFileFilter(CommonFilter filter) {
        this.filter = filter;
    }

    @Override
    public void setMultiSelectionEnabled(boolean b) {
        this.multiSelectionMode = b;
    }

    @Override
    public int showDialog(Component component, String s) {
        this.setDialogTitle(s);
        return this.showDialog(component);
    }

    @Override
    public void setDialogTitle(String s) {
        this.title = s;
    }

    @Override
    public void setFileSelectionMode(int mode) {
    }
}

