/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.loc;

import java.awt.event.ItemListener;
import javax.swing.JRadioButton;
import org.tlauncher.tlauncher.ui.images.ImageCache;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.loc.LocalizableComponent;

public class LocalizableRadioButton
extends JRadioButton
implements LocalizableComponent {
    private static final long serialVersionUID = 1L;
    private String path;

    public LocalizableRadioButton() {
        this.init();
    }

    public LocalizableRadioButton(String path) {
        this.init();
        this.setLabel(path);
    }

    @Override
    @Deprecated
    public void setLabel(String path) {
        this.setText(path);
    }

    @Override
    public void setText(String path) {
        this.path = path;
        super.setText(Localizable.get() == null ? path : Localizable.get().get(path));
    }

    public String getLangPath() {
        return this.path;
    }

    public void addListener(ItemListener l) {
        super.getModel().addItemListener(l);
    }

    public void removeListener(ItemListener l) {
        super.getModel().removeItemListener(l);
    }

    @Override
    public void updateLocale() {
        this.setLabel(this.path);
    }

    private void init() {
        this.setOpaque(false);
        this.setIcon(ImageCache.getNativeIcon((String)"radio-button-off.png"));
        this.setSelectedIcon(ImageCache.getNativeIcon((String)"radio-button-on.png"));
        this.setDisabledIcon(ImageCache.getNativeIcon((String)"radio-button-off.png"));
        this.setDisabledSelectedIcon(ImageCache.getNativeIcon((String)"radio-button-on.png"));
        this.setPressedIcon(ImageCache.getNativeIcon((String)"radio-button-on.png"));
    }
}

