/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.swing.box;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import net.minecraft.launcher.versions.CompleteVersion;
import org.tlauncher.modpack.domain.client.GameEntityDTO;
import org.tlauncher.modpack.domain.client.ModpackDTO;
import org.tlauncher.modpack.domain.client.share.GameType;
import org.tlauncher.modpack.domain.client.version.VersionDTO;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.listener.mods.GameEntityListener;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.loc.LocalizableComponent;
import org.tlauncher.tlauncher.ui.swing.box.LocalModapackBoxModel;
import org.tlauncher.tlauncher.ui.swing.extended.ExtendedComboBox;
import org.tlauncher.tlauncher.ui.swing.renderer.ModpackComboxRenderer;
import org.tlauncher.tlauncher.ui.ui.ModpackComboBoxUI;
import org.tlauncher.tlauncher.ui.ui.ModpackScrollBarUI;
import org.tlauncher.util.ColorUtil;
import org.tlauncher.util.U;

public class ModpackComboBox
extends ExtendedComboBox<CompleteVersion>
implements GameEntityListener,
LocalizableComponent {
    private static final long serialVersionUID = 7773875370848584863L;

    public ModpackComboBox() {
        this.setModel(new LocalModapackBoxModel());
        this.setRenderer(new ModpackComboxRenderer());
        this.setUI(new ModpackComboBoxUI(){

            @Override
            protected ComboPopup createPopup() {
                BasicComboPopup basic = new BasicComboPopup(this.comboBox){
                    private static final long serialVersionUID = -4987177491183525990L;

                    @Override
                    protected JScrollPane createScroller() {
                        ModpackScrollBarUI barUI = new ModpackScrollBarUI(){

                            @Override
                            protected Dimension getMinimumThumbSize() {
                                return new Dimension(10, 40);
                            }

                            @Override
                            public Dimension getPreferredSize(JComponent c) {
                                Dimension dim = super.getPreferredSize(c);
                                dim.setSize(8.0, dim.getHeight());
                                return dim;
                            }
                        };
                        barUI.setGapThubm(5);
                        JScrollPane scroller = new JScrollPane(this.list, 20, 31);
                        scroller.getVerticalScrollBar().setUI(barUI);
                        scroller.setBackground(ColorUtil.BACKGROUND_COMBO_BOX_POPUP);
                        return scroller;
                    }
                };
                basic.setMaximumSize(new Dimension(172, 149));
                basic.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, ModpackComboxRenderer.LINE));
                return basic;
            }
        });
        this.setBorder(BorderFactory.createLineBorder(ModpackComboxRenderer.LINE, 1));
        this.addItemListener(e -> TLauncher.getInstance().getConfiguration().set("modpack.combobox.index", (Object)this.getSelectedIndex()));
    }

    @Override
    public void activationStarted(GameEntityDTO e) {
    }

    @Override
    public void activation(GameEntityDTO e) {
    }

    @Override
    public void activationError(GameEntityDTO e, Throwable t) {
    }

    @Override
    public void processingStarted(GameEntityDTO e, VersionDTO version) {
    }

    @Override
    public void installEntity(GameEntityDTO e, GameType type) {
    }

    @Override
    public void installEntity(CompleteVersion e) {
        this.addItem(e);
        this.setSelectedItem(e);
    }

    @Override
    public void removeEntity(GameEntityDTO e) {
    }

    @Override
    public void installError(GameEntityDTO e, VersionDTO v, Throwable t) {
    }

    @Override
    public void populateStatus(GameEntityDTO status, GameType type, boolean state) {
    }

    @Override
    public void updateVersion(CompleteVersion v, CompleteVersion newVersion) {
        this.repaint();
    }

    @Override
    public void updateVersionStorageAndScene(CompleteVersion v, CompleteVersion newVersion) {
        this.removeItem(v);
        this.installEntity(newVersion);
        this.repaint();
    }

    public List<ModpackDTO> getModpacks() {
        int size = this.getModel().getSize();
        ArrayList<ModpackDTO> list = new ArrayList<ModpackDTO>();
        for (int i = 1; i < size; ++i) {
            list.add(((CompleteVersion)this.getModel().getElementAt(i)).getModpack());
        }
        return list;
    }

    public CompleteVersion findByModpack(ModpackDTO modpackDTO, VersionDTO versionDTO) {
        ModpackDTO m;
        int i;
        int size = this.getModel().getSize();
        for (i = 1; i < size; ++i) {
            m = ((CompleteVersion)this.getModel().getElementAt(i)).getModpack();
            if (!m.getId().equals(modpackDTO.getId()) || !m.getVersion().getId().equals(versionDTO.getId())) continue;
            return (CompleteVersion)this.getModel().getElementAt(i);
        }
        U.log("" + modpackDTO.getId() + " " + versionDTO.getId());
        for (i = 1; i < size; ++i) {
            m = ((CompleteVersion)this.getModel().getElementAt(i)).getModpack();
            U.log("m id =" + m.getId() + " v id =" + m.getVersion().getId());
        }
        return null;
    }

    @Override
    public void removeCompleteVersion(CompleteVersion e) {
        ComboBoxModel model = this.getModel();
        for (int i = 1; i < model.getSize(); ++i) {
            if (!((CompleteVersion)model.getElementAt(i)).getID().equals(e.getID())) continue;
            this.removeItemAt(i);
            break;
        }
    }

    @Override
    public void updateLocale() {
        ((CompleteVersion)this.getModel().getElementAt(0)).setID(Localizable.get("modpack.local.box.default"));
    }
}

